/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.inventory.slots;

import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DragonInventorySlot
extends Slot {
    private final Container enderChest;
    private final Container dragonInv;
    private final int origId;
    private boolean isEnderChest;

    public DragonInventorySlot(Container dragonInv, int index, int x, int y, Container enderChest) {
        super(dragonInv, index, x, y);
        this.origId = index;
        this.dragonInv = dragonInv;
        this.enderChest = enderChest;
        this.isEnderChest = false;
    }

    public void setChestTypeChanged(boolean isEnderChest) {
        this.isEnderChest = isEnderChest;
    }

    @NotNull
    public ItemStack getItem() {
        return this.isEnderChest ? this.enderChest.getItem(this.origId) : this.dragonInv.getItem(this.origId + 3);
    }

    public void set(@NotNull ItemStack stack) {
        if (this.isEnderChest) {
            this.enderChest.setItem(this.origId, stack);
        } else {
            this.dragonInv.setItem(this.origId + 3, stack);
        }
    }
}

