/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.item;

import com.bdc.bdd.api.entity.core_classes.BddBaseDragon;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RopeItem
extends Item {
    public RopeItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        BddBaseDragon dragon;
        if (entity instanceof BddBaseDragon && !(dragon = (BddBaseDragon)entity).isRoped()) {
            Level level;
            if (!player.level.isClientSide && (level = player.level) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                dragon.setRoped(true);
                player.displayClientMessage((Component)Component.literal((String)"Your Dragon is now roped"), false);
                if (!player.getAbilities().instabuild) {
                    stack.hurtAndBreak(1, serverLevel, null, context -> {});
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isSelected) {
        BddBaseDragon dragon;
        Player player;
        Entity vehicle;
        if (!level.isClientSide && entity instanceof Player && (vehicle = (player = (Player)entity).getVehicle()) instanceof BddBaseDragon && (dragon = (BddBaseDragon)vehicle).isRoped() && dragon.getControllingPassenger() == player && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.getGameTime() % 20L == 0L) {
                stack.hurtAndBreak(1, serverLevel, null, context -> {
                    dragon.setRoped(false);
                    player.displayClientMessage((Component)Component.literal((String)"The rope broke!"), false);
                });
            }
        }
    }

    public boolean isValidRepairItem(@NotNull ItemStack stack, @NotNull ItemStack repairIngredient) {
        return repairIngredient.is(Items.STRING);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        MutableComponent mutablecomponent = Component.literal((String)"Right Click Trusting Dragon To Ride.");
        mutablecomponent.withStyle(new ChatFormatting[]{ChatFormatting.BLUE});
        tooltipComponents.add((Component)mutablecomponent);
    }
}

