/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.mixin;

import com.bdc.bdd.api.entity.BddDragon;
import com.bdc.bdd.api.render.BddDragonRender;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class DragonRiderLayerMixin {
    @Inject(method={"render*"}, at={@At(value="HEAD")})
    private void onRenderPlayer(AbstractClientPlayer player, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        Entity entity;
        if (player == Minecraft.getInstance().player && (entity = player.getVehicle()) instanceof BddDragon) {
            EntityRenderer renderer;
            BddDragon dragon = (BddDragon)entity;
            if (dragon.riderMatrix != null && (renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)dragon)) instanceof BddDragonRender) {
                BddDragonRender dragonRenderer = (BddDragonRender)renderer;
                Vec3 rideOffset = dragon.getRiderOffset((Entity)player, partialTicks);
                poseStack.translate(-rideOffset.x(), -rideOffset.y(), -rideOffset.z());
                Matrix4f noScale = DragonRiderLayerMixin.noScale(dragon);
                poseStack.translate(dragon.riderMatrix.m30(), dragon.riderMatrix.m31(), dragon.riderMatrix.m32());
                Quaternionf rotation = new Quaternionf();
                noScale.getNormalizedRotation(rotation);
                poseStack.mulPose(rotation);
                float fallFlyingTicks = 1.0f;
                poseStack.translate(0.0, (rideOffset.y() - (double)dragon.getLayerYOffset()) * (double)fallFlyingTicks, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(Mth.rotLerp((float)partialTicks, (float)dragon.yBodyRotO, (float)dragon.yBodyRot) + 180.0f));
            }
        }
    }

    @Unique
    @NotNull
    private static Matrix4f noScale(BddDragon dragon) {
        Matrix4f noScale = new Matrix4f((Matrix4fc)dragon.riderMatrix);
        float scaleX = (float)Math.sqrt(noScale.m00() * noScale.m00() + noScale.m01() * noScale.m01() + noScale.m02() * noScale.m02());
        float scaleY = (float)Math.sqrt(noScale.m10() * noScale.m10() + noScale.m11() * noScale.m11() + noScale.m12() * noScale.m12());
        float scaleZ = (float)Math.sqrt(noScale.m20() * noScale.m20() + noScale.m21() * noScale.m21() + noScale.m22() * noScale.m22());
        noScale.m00(noScale.m00() / scaleX);
        noScale.m01(noScale.m01() / scaleX);
        noScale.m02(noScale.m02() / scaleX);
        noScale.m10(noScale.m10() / scaleY);
        noScale.m11(noScale.m11() / scaleY);
        noScale.m12(noScale.m12() / scaleY);
        noScale.m20(noScale.m20() / scaleZ);
        noScale.m21(noScale.m21() / scaleZ);
        noScale.m22(noScale.m22() / scaleZ);
        return noScale;
    }
}

