/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.mixin;

import com.bdc.bdd.api.ai_stuffs.IBrainedDragon;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void injectBehaviorExecution(CallbackInfo ci) {
        Entity entity = (Entity)this;
        if (entity instanceof IBrainedDragon) {
            IBrainedDragon brainedDragon = (IBrainedDragon)entity;
            if (!entity.level().isClientSide() && brainedDragon.canActivate()) {
                brainedDragon.getBehaviorManager().executeBehaviors(brainedDragon, entity.level());
            }
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void injectBehaviorRegistration(EntityType<?> entityType, Level level, CallbackInfo ci) {
        IBrainedDragon brainedDragon;
        Entity entity = (Entity)this;
        if (entity instanceof IBrainedDragon && (brainedDragon = (IBrainedDragon)entity).canActivate()) {
            brainedDragon.registerBehaviors();
        }
    }
}

