/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.platform;

import com.bdc.bdd.client.BddClient;
import com.bdc.bdd.inventory.DragonGui;
import com.bdc.bdd.platform.RegistryHelper;
import com.bdc.bdd.registry.BddContainers;
import com.bdc.bdd.registry.helpers.EntityAttributeRegistry;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NeoRegistryHelper
implements RegistryHelper {
    private static final DeferredRegister<Item> itemRegistry = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"bdd");
    private static final DeferredRegister<Block> blockRegistry = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"bdd");
    private static final DeferredRegister<EntityType<?>> entityRegistry = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"bdd");
    private static final DeferredRegister<CreativeModeTab> tabRegistry = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"bdd");
    public static final DeferredRegister<MenuType<?>> menuRegistry = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"bdd");
    private static final DeferredRegister<BlockEntityType<?>> blockEntityRegistry = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"bdd");
    private static final DeferredRegister<ParticleType<?>> particleRegistry = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"bdd");
    public static final DeferredRegister<MemoryModuleType<?>> memoryTypes = DeferredRegister.create((ResourceKey)Registries.MEMORY_MODULE_TYPE, (String)"bdd");
    public static final DeferredRegister<SensorType<?>> sensors = DeferredRegister.create((ResourceKey)Registries.SENSOR_TYPE, (String)"bdd");

    @Override
    public <T extends CreativeModeTab> Supplier<T> registerTab(String pId, Supplier<T> pTab) {
        return tabRegistry.register(pId, pTab);
    }

    @Override
    public <T extends Entity> Supplier<EntityType<T>> registerEntity(String pId, Supplier<EntityType<T>> pEntity) {
        return entityRegistry.register(pId, pEntity);
    }

    @Override
    public <T extends Item> Supplier<T> registerItem(String id, Supplier<T> item) {
        return itemRegistry.register(id, item);
    }

    @Override
    public <T extends Block> Supplier<T> registerBlock(String id, Supplier<T> block) {
        return blockRegistry.register(id, block);
    }

    @Override
    public Supplier<MenuType<?>> registerMenu(String pId, Supplier<MenuType<?>> pMenu) {
        menuRegistry.register(pId, pMenu);
        return pMenu;
    }

    @Override
    public <T extends BlockEntity> Supplier<BlockEntityType<T>> registerBlockEntity(String pId, Supplier<BlockEntityType<T>> pBlockEntity) {
        return blockEntityRegistry.register(pId, pBlockEntity);
    }

    @Override
    public <T extends ParticleOptions> Supplier<ParticleType<T>> registerParticles(String pId, Supplier<ParticleType<T>> pBlockEntity) {
        return particleRegistry.register(pId, pBlockEntity);
    }

    @Override
    public <T> Supplier<MemoryModuleType<T>> registerMemoryType(String id) {
        return this.registerMemoryType(id, Optional.empty());
    }

    @Override
    public <T> Supplier<MemoryModuleType<T>> registerMemoryType(String id, Optional<Codec<T>> codec) {
        return memoryTypes.register(id, () -> new MemoryModuleType(codec));
    }

    public static void register(IEventBus modEventBus) {
        entityRegistry.register(modEventBus);
        itemRegistry.register(modEventBus);
        blockRegistry.register(modEventBus);
        blockEntityRegistry.register(modEventBus);
        tabRegistry.register(modEventBus);
        menuRegistry.register(modEventBus);
        memoryTypes.register(modEventBus);
        sensors.register(modEventBus);
        modEventBus.addListener(pEvent -> EntityAttributeRegistry.registerAttributes((arg_0, arg_1) -> ((EntityAttributeCreationEvent)pEvent).put(arg_0, arg_1)));
        modEventBus.addListener(event -> BddClient.registerRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1), (arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerBlockEntityRenderer(arg_0, arg_1)));
        modEventBus.addListener(event -> event.register((MenuType)BddContainers.DRAGON_INV.get(), DragonGui::new));
    }
}

