/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.projectile;

import com.bdc.bdd.api.entity.core_classes.BddAbilityDragon;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseLinearFlightProjectile
extends AbstractHurtingProjectile {
    protected static final EntityDataAccessor<Integer> PROJECTILE_SIZE = SynchedEntityData.defineId(BaseLinearFlightProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public BddAbilityDragon dragon;
    public double ticksExisted;
    protected int strengthRadius;
    protected Vec3 start;
    protected Vec3 end;
    protected int damageTier;

    public BaseLinearFlightProjectile(EntityType type, Level level) {
        super(type, level);
    }

    protected BaseLinearFlightProjectile(EntityType type, BddAbilityDragon owner, Vec3 start, Vec3 end, Level level, int strengthRadius) {
        super(type, level);
        this.dragon = owner;
        this.strengthRadius = strengthRadius;
        this.setOwner((Entity)owner);
        this.start = start;
        this.end = end;
        this.moveTo(this.start.x(), this.start.y(), this.start.z(), this.getYRot(), this.getXRot());
        this.reapplyPosition();
        double d0 = Math.sqrt(end.x() * end.x() + end.y() * end.y() + end.z() * end.z());
        if (d0 != 0.0) {
            this.accelerationPower = end.z() / d0 * 0.2;
        }
    }

    public BaseLinearFlightProjectile(EntityType pEntityType, BddAbilityDragon owner, double pX, double pY, double pZ, double pOffsetX, double pOffsetY, double pOffsetZ, Level pLevel, int strengthRadius) {
        this(pEntityType, pLevel);
        this.dragon = owner;
        this.strengthRadius = strengthRadius;
        this.setOwner((Entity)owner);
        this.moveTo(pX, pY, pZ, this.getYRot(), this.getXRot());
        this.reapplyPosition();
        double d0 = Math.sqrt(pOffsetX * pOffsetX + pOffsetY * pOffsetY + pOffsetZ * pOffsetZ);
        if (d0 != 0.0) {
            this.accelerationPower = pOffsetZ / d0 * 0.1;
        }
    }

    public static HitResult getLargerHitResultForEntityCollisions(Entity pProjectile, Predicate pFilter) {
        EntityHitResult hitresult1;
        Vec3 vec32;
        Vec3 vec3 = pProjectile.getDeltaMovement();
        Level level = pProjectile.level;
        Vec3 vec31 = pProjectile.position();
        BlockHitResult hitresult = level.clip(new ClipContext(vec31, vec32 = vec31.add(vec3), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, pProjectile));
        if (hitresult.getType() != HitResult.Type.MISS) {
            vec32 = hitresult.getLocation();
        }
        if ((hitresult1 = ProjectileUtil.getEntityHitResult((Level)level, (Entity)pProjectile, (Vec3)vec31, (Vec3)vec32, (AABB)pProjectile.getBoundingBox().expandTowards(pProjectile.getDeltaMovement()).inflate(6.0).expandTowards(1.0, 3.0, 1.0), (Predicate)pFilter)) != null) {
            hitresult = hitresult1;
        }
        return hitresult;
    }

    public static void spawnParticles(BaseLinearFlightProjectile dragon) {
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder pBuilder) {
        pBuilder.define(PROJECTILE_SIZE, (Object)1);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setProjectileSize(pCompound.getInt("projectile_size"));
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("projectile_size", this.getProjectileSize());
    }

    public int getProjectileSize() {
        return (Integer)this.entityData.get(PROJECTILE_SIZE);
    }

    public void setProjectileSize(int sizeTier) {
        this.entityData.set(PROJECTILE_SIZE, (Object)sizeTier);
    }

    protected boolean needsTier2ToDamage() {
        return true;
    }

    @Nullable
    public BddAbilityDragon getOwner() {
        return this.dragon;
    }

    public void tick() {
        float damage;
        this.baseTick();
        this.ticksExisted += 1.0;
        if (this.level.isClientSide || this.dragon == null || !this.dragon.isRemoved()) {
            this.checkInsideBlocks();
            Vec3 vec3 = this.getDeltaMovement();
            double d0 = this.getX() + vec3.x;
            double d1 = this.getY() + vec3.y;
            double d2 = this.getZ() + vec3.z;
            damage = this.getInertia();
            if (this.isInWater()) {
                for (int i = 0; i < 4; ++i) {
                    this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, d0 - vec3.x * 0.25, d1 - vec3.y * 0.25, d2 - vec3.z * 0.25, vec3.x, vec3.y, vec3.z);
                }
                damage = 0.8f;
            }
            this.setDeltaMovement(vec3.add(this.accelerationPower, this.accelerationPower, this.accelerationPower).scale((double)damage));
            this.setPos(d0, d1, d2);
        }
        BddAbilityDragon owner = this.getOwner();
        ClipContext.Block blockContext = ClipContext.Block.COLLIDER;
        HitResult hitresult = ProjectileUtil.getHitResult((Vec3)this.getPosition(1.0f), (Entity)this, x$0 -> this.canHitEntity((Entity)x$0), (Vec3)this.getDeltaMovement(), (Level)this.level, (float)1.0f, (ClipContext.Block)blockContext);
        HitResult largerEntityHitResult = BaseLinearFlightProjectile.getLargerHitResultForEntityCollisions((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        if (!this.level.isClientSide || owner == null || !owner.isRemoved()) {
            HitResult.Type type;
            if (hitresult.getType() != HitResult.Type.MISS && hitresult.getType() != HitResult.Type.ENTITY) {
                this.end = hitresult.getLocation();
                if (this.dragon != null && (type = hitresult.getType()) == HitResult.Type.BLOCK && hitresult instanceof BlockHitResult) {
                    boolean flag = this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
                    if (flag) {
                        this.explode(this.dragon, this.getX(), this.getY(), this.getZ(), this.dragon.getExplosionStrength(), flag, flag ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP);
                        this.callExplosionEffects(flag, this.dragon);
                    }
                    this.discard();
                    this.gameEvent((Holder)GameEvent.PROJECTILE_LAND, (Entity)this.getOwner());
                }
            }
            if ((type = largerEntityHitResult.getType()) == HitResult.Type.ENTITY && largerEntityHitResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)largerEntityHitResult;
                if (largerEntityHitResult.getType() != HitResult.Type.MISS && largerEntityHitResult.getType() != HitResult.Type.BLOCK) {
                    this.end = largerEntityHitResult.getLocation();
                    Entity entity = entityHitResult.getEntity();
                    if (this.dragon != null && entity != this.dragon && entity != owner && !(entity instanceof BaseLinearFlightProjectile)) {
                        float damage1;
                        LivingEntity livingEntity;
                        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getEffect(MobEffects.FIRE_RESISTANCE) != null) {
                            return;
                        }
                        boolean mobGriefing = this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
                        damage = this.dragon.getProjectileDamage(this.dragon, entity, this);
                        float f = damage1 = !(entity instanceof Player) && !(entity instanceof BddAbilityDragon) ? damage : damage / 3.0f;
                        if (mobGriefing) {
                            entity.hurt(this.damageSources().mobAttack((LivingEntity)this.dragon), damage1);
                            entity.setRemainingFireTicks(7);
                            this.discard();
                            this.gameEvent((Holder)GameEvent.PROJECTILE_LAND, (Entity)this.getOwner());
                        } else if (!mobGriefing) {
                            TamableAnimal tamableAnimal;
                            LivingEntity livingEntity2;
                            if (entity instanceof LivingEntity && (livingEntity2 = (LivingEntity)entity).getMaxHealth() < 20.0f && livingEntity2.hasCustomName()) {
                                return;
                            }
                            if (entity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity).isTame()) {
                                return;
                            }
                            entity.hurt(this.damageSources().mobAttack((LivingEntity)this.dragon), damage1);
                            entity.setRemainingFireTicks(7);
                            this.discard();
                            this.gameEvent((Holder)GameEvent.PROJECTILE_LAND, (Entity)this.getOwner());
                        }
                        boolean flag = this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
                        this.explode(this.dragon, this.getX(), this.getY(), this.getZ(), this.dragon.getExplosionStrength(), flag, flag ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP);
                        this.callExplosionEffects(flag, this.dragon);
                    }
                }
            }
        }
        this.playParticles();
        if (this.ticksExisted > (double)this.threshHoldForDeletion()) {
            this.discard();
            this.ticksExisted = 0.0;
        }
    }

    protected void callExplosionEffects(boolean flag, BddAbilityDragon dragon) {
        if (this instanceof BaseLinearFlightProjectile) {
            if (this.getProjectileSize() == 3 || this.getProjectileSize() == 2 || this.getProjectileSize() == 1) {
                Level.ExplosionInteraction explosionInteraction = Level.ExplosionInteraction.BLOCK;
                this.level.explode((Entity)dragon, this.getX(), this.getY(), this.getZ(), (float)dragon.getExplosionStrength(), explosionInteraction);
            }
            if (this.getProjectileSize() == 0) {
                this.level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY(), this.getZ(), 1.0, 0.0, 0.0);
                this.playSound(SoundEvents.FIREWORK_ROCKET_BLAST_FAR, 4.0f, 1.0f);
            }
        }
    }

    protected void addParticlesAroundSelf(ParticleOptions p_36209_) {
        for (int i = 0; i < 4; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d = this.random.nextGaussian() * 0.02;
        }
    }

    public void shoot(Vec3 end, float partialTicks, float pInaccuracy, double pVelocity) {
        Vec3 endVec = new Vec3(end.x() * pVelocity, end.y() * pVelocity, end.z() * pVelocity);
        Vec3 vec3 = endVec.normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)pInaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)pInaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)pInaccuracy).scale(pVelocity);
        this.setDeltaMovement(vec3);
        double d0 = end.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)end.x, (double)end.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)end.y, (double)d0) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getYRot();
    }

    public void shootNoScaling(Vec3 end, float partialTicks, float pInaccuracy) {
        double pVelocity = 2.0;
        Vec3 endVec = new Vec3(end.x() * pVelocity, end.y() * pVelocity, end.z() * pVelocity);
        Vec3 vec3 = endVec.normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)pInaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)pInaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)pInaccuracy).scale(pVelocity);
        this.setDeltaMovement(vec3);
        double d0 = end.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)end.x, (double)end.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)end.y, (double)d0) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getYRot();
    }

    public void shoot(Vec3 end, float partialTicks) {
        this.shoot(end, partialTicks, 1.0f, 5.0);
    }

    public void shoot(Vec3 end, float partialTicks, double velocity) {
        this.shoot(end, partialTicks, 1.0f, velocity);
    }

    protected int threshHoldForDeletion() {
        return 300;
    }

    protected abstract Explosion explode(BddAbilityDragon var1, double var2, double var4, double var6, float var8, boolean var9, Explosion.BlockInteraction var10);

    public void playParticles() {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (this.getProjectileSize() != 0) break block4;
                        Vec3 vec3 = this.getDeltaMovement();
                        double deltaX = vec3.x;
                        double deltaY = vec3.y;
                        double deltaZ = vec3.z;
                        double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * (double)0.7f);
                        for (double j = 0.0; j < dist; j += 1.0) {
                            BaseLinearFlightProjectile.spawnParticles(this);
                        }
                        break block5;
                    }
                    if (this.getProjectileSize() != 1) break block6;
                    Vec3 vec3 = this.getDeltaMovement();
                    double deltaX = vec3.x;
                    double deltaY = vec3.y;
                    double deltaZ = vec3.z;
                    double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 4.0);
                    for (double j = 0.0; j < dist; j += 1.0) {
                        BaseLinearFlightProjectile.spawnParticles(this);
                    }
                    break block5;
                }
                if (this.getProjectileSize() != 2) break block7;
                Vec3 vec3 = this.getDeltaMovement();
                double deltaX = vec3.x;
                double deltaY = vec3.y;
                double deltaZ = vec3.z;
                double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 14.0);
                for (double j = 0.0; j < dist; j += 1.0) {
                    BaseLinearFlightProjectile.spawnParticles(this);
                }
                break block5;
            }
            if (this.getProjectileSize() != 3) break block5;
            Vec3 vec3 = this.getDeltaMovement();
            double deltaX = vec3.x;
            double deltaY = vec3.y;
            double deltaZ = vec3.z;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 32.0);
            for (double j = 0.0; j < dist; j += 1.0) {
                BaseLinearFlightProjectile.spawnParticles(this);
            }
        }
    }

    public boolean isOnFire() {
        return false;
    }

    public int getDamageTier() {
        return this.damageTier;
    }

    public void setDamageTier(int damageTier) {
        this.damageTier = damageTier;
    }
}

