/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.projectile.firebreath;

import com.bdc.bdd.api.entity.core_classes.BddAbilityDragon;
import com.bdc.bdd.projectile.BaseLinearFlightProjectile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FireBreathProjectile
extends BaseLinearFlightProjectile {
    public FireBreathProjectile(EntityType<? extends FireBreathProjectile> type, Level level) {
        super(type, level);
    }

    public FireBreathProjectile(BddAbilityDragon dragonOwner, Vec3 throat, Vec3 end, Level level) {
        super(EntityType.FIREBALL, dragonOwner, throat, end, level, 1);
    }

    @Override
    public void tick() {
        super.tick();
        Vec3 currentMotion = this.getDeltaMovement();
        double wobbleFactor = 0.05;
        this.setDeltaMovement(currentMotion.x + this.random.nextGaussian() * wobbleFactor, currentMotion.y + this.random.nextGaussian() * wobbleFactor, currentMotion.z + this.random.nextGaussian() * wobbleFactor);
    }

    @Override
    public void playParticles() {
        int i;
        float scale = (float)this.ticksExisted * 3.0f + 6.0f;
        double posX = this.xo + (this.random.nextDouble() - 0.5) * (this.ticksExisted / 1.5);
        double posY = this.yo + (this.random.nextDouble() - 0.5) * (this.ticksExisted / 1.5);
        double posZ = this.zo + (this.random.nextDouble() - 0.5) * (this.ticksExisted / 1.5);
        SimpleParticleType particleOptions = ParticleTypes.FLAME;
        for (i = 0; i < 3; ++i) {
            this.level.addParticle((ParticleOptions)particleOptions, true, posX + (this.random.nextDouble() - 0.5) * 0.5, posY + (this.random.nextDouble() - 0.5) * 0.5, posZ + (this.random.nextDouble() - 0.5) * 0.5, (double)scale * 6.0 + 0.2 * (double)(this.random.nextFloat() - 0.5f), (double)scale * 6.0 * 0.2 * (double)(this.random.nextFloat() - 0.5f), (double)scale * 6.0 + 0.2 * (double)(this.random.nextFloat() - 0.5f));
        }
        if (this.tickCount % 3 == 0) {
            for (i = 0; i < 2; ++i) {
                this.level.addParticle((ParticleOptions)ParticleTypes.LAVA, true, posX + (this.random.nextDouble() - 0.5) * 0.5, posY + (this.random.nextDouble() - 0.5) * 0.5, posZ + (this.random.nextDouble() - 0.5) * 0.5, (double)(0.3f * (this.random.nextFloat() - 0.5f)), (double)(0.3f * (this.random.nextFloat() - 0.5f)), (double)(0.3f * (this.random.nextFloat() - 0.5f)));
            }
        }
    }

    @NotNull
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.FLAME;
    }

    protected boolean shouldBurn() {
        return true;
    }

    @Override
    protected int threshHoldForDeletion() {
        return 20;
    }

    public boolean isNoGravity() {
        return false;
    }

    @Override
    public Explosion explode(BddAbilityDragon pEntity, double pX, double pY, double pZ, float pExplosionRadius, boolean pCausesFire, Explosion.BlockInteraction pMode) {
        return this.explode((Entity)pEntity, null, null, pX, pY, pZ, pExplosionRadius, pCausesFire, pMode);
    }

    private Explosion explode(@Nullable Entity pExploder, @Nullable DamageSource pDamageSource, @Nullable ExplosionDamageCalculator pContext, double pX, double pY, double pZ, float pSize, boolean pCausesFire, Explosion.BlockInteraction pMode) {
        Holder soundEventHolder = Holder.direct((Object)SoundEvents.CAMPFIRE_CRACKLE);
        FlameBreathExplosion explosion = new FlameBreathExplosion(this.level, pExploder, pX, pY, pZ, pSize, this.getAffectedBlocks(pX, pY, pZ, pSize), pMode, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION, (Holder<SoundEvent>)soundEventHolder);
        explosion.explode();
        explosion.finalizeExplosion(true);
        return explosion;
    }

    private List<BlockPos> getAffectedBlocks(double x, double y, double z, float size) {
        ArrayList<BlockPos> affectedBlocks = new ArrayList<BlockPos>();
        int minX = (int)Math.floor(x - (double)size);
        int maxX = (int)Math.ceil(x + (double)size);
        int minY = (int)Math.floor(y - (double)size);
        int maxY = (int)Math.ceil(y + (double)size);
        int minZ = (int)Math.floor(z - (double)size);
        int maxZ = (int)Math.ceil(z + (double)size);
        for (int ix = minX; ix <= maxX; ++ix) {
            for (int iy = minY; iy <= maxY; ++iy) {
                for (int iz = minZ; iz <= maxZ; ++iz) {
                    BlockPos pos = new BlockPos(ix, iy, iz);
                    BlockState blockState = this.level.getBlockState(pos);
                    Block block = blockState.getBlock();
                    if (block == Blocks.OBSIDIAN || block == Blocks.BEDROCK) continue;
                    affectedBlocks.add(pos);
                }
            }
        }
        return affectedBlocks;
    }

    public static class FlameBreathExplosion
    extends Explosion {
        public FlameBreathExplosion(Level level, @Nullable Entity source, double x, double y, double z, float radius, List<BlockPos> toBlow, Explosion.BlockInteraction blockInteraction, ParticleOptions smallExplosionParticles, ParticleOptions largeExplosionParticles, Holder<SoundEvent> explosionSound) {
            super(level, source, x, y, z, radius, toBlow, blockInteraction, smallExplosionParticles, largeExplosionParticles, explosionSound);
        }

        public void explode() {
            if (this.level.isClientSide) {
                return;
            }
            this.level.gameEvent(this.source, (Holder)GameEvent.EXPLODE, new BlockPos((int)this.x, (int)this.y, (int)this.z));
            int searchRadius = 20;
            Vec3 lookVec = this.source != null ? this.source.getLookAngle().normalize() : new Vec3(0.0, 0.0, 1.0);
            for (int dx = -searchRadius; dx <= searchRadius; ++dx) {
                for (int dy = -searchRadius; dy <= searchRadius; ++dy) {
                    for (int dz = -searchRadius; dz <= searchRadius; ++dz) {
                        BlockPos blockpos;
                        BlockState blockstate;
                        Vec3 dirToBlock;
                        double dot;
                        Vec3 offset = new Vec3((double)dx, (double)dy, (double)dz);
                        double distance = offset.length();
                        if (!(distance <= (double)this.radius) || !((dot = lookVec.dot(dirToBlock = offset.normalize())) > 0.7) || !(this.random.nextFloat() < 1.0f - (float)distance / this.radius) || (blockstate = this.level.getBlockState(blockpos = new BlockPos((int)(this.x + (double)dx), (int)(this.y + (double)dy), (int)(this.z + (double)dz)))).isAir() || !this.damageCalculator.shouldBlockExplode((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, this.radius)) continue;
                        if (blockstate.is(Blocks.COBBLESTONE)) {
                            this.level.setBlockAndUpdate(blockpos, Blocks.STONE.defaultBlockState());
                        } else if (blockstate.is(Blocks.DIRT) || blockstate.is(Blocks.GRASS_BLOCK)) {
                            this.level.setBlockAndUpdate(blockpos, Blocks.COARSE_DIRT.defaultBlockState());
                        } else if (blockstate.is(Blocks.SHORT_GRASS) || blockstate.is(Blocks.TALL_GRASS)) {
                            this.level.setBlockAndUpdate(blockpos, BaseFireBlock.getState((BlockGetter)this.level, (BlockPos)blockpos));
                        } else if (blockstate.is(Blocks.SAND)) {
                            this.level.setBlockAndUpdate(blockpos, Blocks.GLASS.defaultBlockState());
                        } else if (blockstate.is(Blocks.OBSIDIAN)) {
                            this.level.setBlockAndUpdate(blockpos, Blocks.LAVA.defaultBlockState());
                        } else if (blockstate.is(Blocks.ICE)) {
                            this.level.setBlockAndUpdate(blockpos, Blocks.WATER.defaultBlockState());
                        }
                        BlockPos firePos = blockpos.above();
                        if (!this.level.getBlockState(firePos).isAir()) continue;
                        this.level.setBlockAndUpdate(firePos, Blocks.FIRE.defaultBlockState());
                    }
                }
            }
            this.toBlow.clear();
        }

        public void finalizeExplosion(boolean pSpawnParticles) {
            boolean flag;
            boolean bl = flag = this.blockInteraction != Explosion.BlockInteraction.KEEP;
            if (pSpawnParticles) {
                if (!(this.radius < 2.0f) && flag) {
                    this.level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.x, this.y, this.z, 1.0, 0.0, 0.0);
                } else {
                    this.level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.x, this.y, this.z, 1.0, 0.0, 0.0);
                }
            }
            if (this.fire) {
                for (BlockPos blockpos2 : this.toBlow) {
                    if (this.random.nextInt(20) != 0 || !this.level.getBlockState(blockpos2).isAir() || !this.level.getBlockState(blockpos2.below()).isSolidRender((BlockGetter)this.level, blockpos2.below())) continue;
                    this.level.setBlockAndUpdate(blockpos2, BaseFireBlock.getState((BlockGetter)this.level, (BlockPos)blockpos2));
                }
            }
        }
    }
}

