/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.registry.builders.entity;

import com.bdc.bdd.BddConstants;
import com.bdc.bdd.client.BddClient;
import com.bdc.bdd.registry.helpers.EntityAttributeRegistry;
import com.bdc.bdd.registry.helpers.items.BddItemModelGenerator;
import com.bdc.bdd.registry.helpers.items.BddItemModelTemplates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;

public class BddEntityBuilder<T extends Mob> {
    public static String name;
    public final EntityType.EntityFactory<T> factory;
    public final MobCategory category;
    public float width = 0.6f;
    public float height = 1.8f;
    public static boolean hasSpawnEgg;
    public int primaryEggColor;
    public int secondaryEggColor;
    public Supplier<AttributeSupplier.Builder> attributeBuilder = null;
    public EntityRendererProvider<T> rendererProvider = null;
    public boolean hasVariants = false;
    public static final List<String> DRAGON_NAMES;
    public Supplier<CreativeModeTab> tabSupplier = null;
    public static final Map<Supplier<CreativeModeTab>, List<Supplier<Item>>> SPAWN_EGGS_BY_TAB;

    public BddEntityBuilder(String name, EntityType.EntityFactory<T> factory, MobCategory category) {
        BddEntityBuilder.name = name;
        this.factory = factory;
        this.category = category;
    }

    public BddEntityBuilder<T> sized(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public BddEntityBuilder<T> spawnEgg(int primaryColor, int secondaryColor) {
        hasSpawnEgg = true;
        this.primaryEggColor = primaryColor;
        this.secondaryEggColor = secondaryColor;
        return this;
    }

    public BddEntityBuilder<T> attributes(Supplier<AttributeSupplier.Builder> attributes) {
        this.attributeBuilder = attributes;
        return this;
    }

    public BddEntityBuilder<T> renderer(EntityRendererProvider<T> rendererProvider) {
        this.rendererProvider = rendererProvider;
        return this;
    }

    public BddEntityBuilder<T> loadVariants() {
        this.hasVariants = true;
        return this;
    }

    public BddEntityBuilder<T> tab(Supplier<CreativeModeTab> tabSupplier) {
        this.tabSupplier = tabSupplier;
        return this;
    }

    public static List<Supplier<Item>> getSpawnEggsForTab(CreativeModeTab tab) {
        ArrayList<Supplier<Item>> spawnEggs = new ArrayList<Supplier<Item>>();
        for (Map.Entry<Supplier<CreativeModeTab>, List<Supplier<Item>>> entry : SPAWN_EGGS_BY_TAB.entrySet()) {
            if (entry.getKey().get() != tab) continue;
            spawnEggs.addAll((Collection<Supplier<Item>>)entry.getValue());
        }
        return spawnEggs;
    }

    public Supplier<EntityType<T>> register() {
        Supplier entityTypeSupplier = BddConstants.PlatformHelper.REGISTRY.registerEntity(name, () -> EntityType.Builder.of(this.factory, (MobCategory)this.category).sized(this.width, this.height).build(name));
        if (hasSpawnEgg) {
            this.registerSpawnEgg(name, entityTypeSupplier, this.primaryEggColor, this.secondaryEggColor, this.tabSupplier);
        }
        if (this.attributeBuilder != null) {
            EntityAttributeRegistry.queueAttributes(entityTypeSupplier, this.attributeBuilder);
        }
        if (this.rendererProvider != null) {
            BddClient.queueRenderer((entityConsumer, blockConsumer) -> entityConsumer.accept((EntityType)entityTypeSupplier.get(), this.rendererProvider));
        }
        if (this.hasVariants) {
            DRAGON_NAMES.add(name);
        }
        return entityTypeSupplier;
    }

    public static void doSpawnEggDatagen() {
        if (hasSpawnEgg) {
            String spawnEggName = name + "_spawn_egg";
            BddItemModelGenerator.generateItemModel("bdd", spawnEggName, BddItemModelTemplates.SPAWN_EGG);
        }
    }

    public static List<String> getDragonNames() {
        return List.copyOf(DRAGON_NAMES);
    }

    public Supplier<Item> registerSpawnEgg(String name, Supplier<EntityType<T>> entityType, int primaryColor, int secondaryColor, Supplier<CreativeModeTab> tabSupplier) {
        Supplier<Item> spawnEggSupplier = BddConstants.PlatformHelper.REGISTRY.registerItem(name + "_spawn_egg", () -> new SpawnEggItem((EntityType)entityType.get(), primaryColor, secondaryColor, new Item.Properties()));
        if (tabSupplier != null) {
            SPAWN_EGGS_BY_TAB.computeIfAbsent(tabSupplier, k -> new ArrayList()).add(spawnEggSupplier);
        }
        return spawnEggSupplier;
    }

    static {
        hasSpawnEgg = false;
        DRAGON_NAMES = new ArrayList<String>();
        SPAWN_EGGS_BY_TAB = new HashMap<Supplier<CreativeModeTab>, List<Supplier<Item>>>();
    }
}

