/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.registry.builders.entity;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;

public class BddEntityTagBuilder {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final List<String> generatedTags = new ArrayList<String>();
    private static final Map<String, List<EntityType<?>>> tagEntityTypes = new HashMap();
    private final String name;
    private final List<EntityType<?>> entityTypes = new ArrayList();
    private final String modId = "bdd";

    private BddEntityTagBuilder(String name) {
        this.name = name;
    }

    public static BddEntityTagBuilder createEntityTag(String name) {
        return new BddEntityTagBuilder(name);
    }

    public BddEntityTagBuilder addEntries(EntityType<?> ... entityTypes) {
        for (EntityType<?> entityType : entityTypes) {
            this.entityTypes.add(entityType);
        }
        return this;
    }

    public TagKey<EntityType<?>> build() {
        generatedTags.add(this.name);
        tagEntityTypes.put(this.name, new ArrayList(this.entityTypes));
        return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bdd", (String)this.name));
    }

    public static void doTagJsonGen() {
        for (String tagName : generatedTags) {
            List entities = tagEntityTypes.getOrDefault(tagName, new ArrayList());
            BddEntityTagBuilder.generateTagJson(tagName, entities);
        }
    }

    private static void generateTagJson(String tagName, List<EntityType<?>> entityTypes) {
        Path tagPath = BddEntityTagBuilder.findProjectRoot().resolve("bdd/tags/entity_type/" + tagName + ".json");
        try {
            if (Files.exists(tagPath, new LinkOption[0])) {
                System.out.println("Entity tag for '" + tagName + "' already exists at: " + String.valueOf(tagPath) + ". Skipping creation.");
                return;
            }
            JsonObject tagJson = new JsonObject();
            JsonArray values = new JsonArray();
            for (EntityType<?> entityType : entityTypes) {
                ResourceLocation registryName = EntityType.getKey(entityType);
                if (registryName == null) continue;
                values.add(registryName.toString());
            }
            tagJson.add("values", (JsonElement)values);
            Files.createDirectories(tagPath.getParent(), new FileAttribute[0]);
            Files.write(tagPath, GSON.toJson((JsonElement)tagJson).getBytes(), StandardOpenOption.CREATE_NEW);
            System.out.println("Entity tag for '" + tagName + "' created at: " + String.valueOf(tagPath));
        }
        catch (IOException e) {
            System.err.println("Failed [ERROR]: Failed to create entity tag for '" + tagName + "' at " + String.valueOf(tagPath) + ": " + e.getMessage());
        }
    }

    public static Path findProjectRoot() {
        for (Path current = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath(); current != null; current = current.getParent()) {
            Path resources = BddEntityTagBuilder.findResourcesPath(current);
            if (resources == null) continue;
            return resources;
        }
        throw new IllegalStateException("Could not locate project root");
    }

    private static Path findResourcesPath(Path current) {
        String currentDirName;
        String[] potentialPaths;
        for (String path : potentialPaths = new String[]{"src/main/resources/data", "common/src/main/resources/data"}) {
            Path resources = current.resolve(path);
            if (!Files.exists(resources, new LinkOption[0]) || !Files.isDirectory(resources, new LinkOption[0])) continue;
            return resources;
        }
        String string = currentDirName = current.getFileName() != null ? current.getFileName().toString() : "";
        if (currentDirName.matches("fabric|forge|neoforge|quilt")) {
            for (String path : potentialPaths) {
                Path parentResources = current.getParent().resolve(path);
                if (!Files.exists(parentResources, new LinkOption[0]) || !Files.isDirectory(parentResources, new LinkOption[0])) continue;
                return parentResources;
            }
        }
        return null;
    }
}

