/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.registry.builders.tabs;

import com.bdc.bdd.BddConstants;
import com.bdc.bdd.registry.builders.entity.BddEntityBuilder;
import com.bdc.bdd.registry.builders.items.BddItemBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;

public class BddTabBuilder {
    private final String id;
    private static String modId;
    private Supplier<Item> iconSupplier;
    private CreativeModeTab.DisplayItemsGenerator displayItemsGenerator;
    private String backgroundSuffix = "item_search.png";
    private static final Map<Supplier<CreativeModeTab>, BddTabBuilder> TAB_BUILDERS;

    public BddTabBuilder(String id, String modId) {
        this.id = id;
        BddTabBuilder.modId = modId;
    }

    public BddTabBuilder icon(Supplier<Item> iconSupplier) {
        this.iconSupplier = iconSupplier;
        return this;
    }

    public BddTabBuilder icon(Item iconItem) {
        this.iconSupplier = () -> iconItem;
        return this;
    }

    public static Supplier<Item> useSpawnEgg(Supplier<? extends EntityType<?>> entityTypeSupplier) {
        return () -> {
            EntityType entityType = (EntityType)entityTypeSupplier.get();
            if (entityType != null) {
                String entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType).getPath();
                String spawnEggId = entityId + "_spawn_egg";
                return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)modId, (String)spawnEggId));
            }
            BaseLogger.log((Level)BaseLogLevel.ERROR, (String)("Spawn egg icon could not be found for entity: " + String.valueOf(entityType)));
            return Items.AIR;
        };
    }

    public BddTabBuilder displayItems(CreativeModeTab.DisplayItemsGenerator displayItemsGenerator) {
        this.displayItemsGenerator = displayItemsGenerator;
        return this;
    }

    public BddTabBuilder background(String backgroundSuffix) {
        this.backgroundSuffix = backgroundSuffix;
        return this;
    }

    public BddTabBuilder background() {
        this.backgroundSuffix = "item_search.png";
        return this;
    }

    public Supplier<CreativeModeTab> register() {
        CreativeModeTab.Builder tabBuilder = CreativeModeTab.builder((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).title((Component)Component.translatable((String)this.id)).icon(() -> {
            Item item = this.iconSupplier.get();
            return item != null ? new ItemStack((ItemLike)item) : ItemStack.EMPTY;
        }).displayItems((parameters, output) -> {
            Item item;
            HashSet<Item> addedItems = new HashSet<Item>();
            if (this.displayItemsGenerator != null) {
                this.displayItemsGenerator.accept(parameters, (stack, tabVisibility) -> {
                    Item item = stack.getItem();
                    if (item != null && addedItems.add(item)) {
                        output.accept(stack, tabVisibility);
                        BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Adding item from displayItemsGenerator: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item))));
                    }
                });
            }
            if ((item = this.iconSupplier.get()) != null) {
                List<Supplier<Item>> toolsetItems = BddItemBuilder.TOOLSETS.get(item.getDescriptionId());
                if (toolsetItems != null) {
                    for (Supplier<Item> tool : toolsetItems) {
                        Item toolItem = tool.get();
                        if (toolItem == null || !addedItems.add(toolItem)) continue;
                        output.accept(new ItemStack((ItemLike)toolItem), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                        BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Adding icon toolset item: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)toolItem))));
                    }
                } else if (addedItems.add(item)) {
                    output.accept(new ItemStack((ItemLike)item), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                    BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Adding icon item: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item))));
                }
            }
        });
        CreativeModeTab tab = tabBuilder.build();
        Supplier<CreativeModeTab> tabSupplier = () -> tab;
        TAB_BUILDERS.put(tabSupplier, this);
        BddConstants.PlatformHelper.REGISTRY.registerTab(this.id, tabSupplier);
        return tabSupplier;
    }

    public static void addToolset(Item item, CreativeModeTab.Output populator) {
        if (item != null) {
            List<Supplier<Item>> toolset;
            HashSet<Item> addedItems = new HashSet<Item>();
            String fullId = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
            String[] toolSuffixes = new String[]{"_sword", "_pickaxe", "_axe", "_shovel", "_hoe"};
            String baseId = fullId;
            for (String suffix : toolSuffixes) {
                if (!fullId.endsWith(suffix)) continue;
                baseId = fullId.substring(0, fullId.length() - suffix.length());
                break;
            }
            if ((toolset = BddItemBuilder.TOOLSETS.get(baseId)) != null) {
                for (Supplier<Item> tool : toolset) {
                    Item toolItem = tool.get();
                    if (toolItem == null || !addedItems.add(toolItem)) continue;
                    populator.accept(new ItemStack((ItemLike)toolItem), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                    BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Adding toolset item: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)toolItem))));
                }
                return;
            }
            if (addedItems.add(item)) {
                populator.accept(new ItemStack((ItemLike)item), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Adding single toolset item: " + fullId));
            }
        }
    }

    public static void addArmorSet(Item item, CreativeModeTab.Output populator) {
        if (item != null) {
            List<Supplier<Item>> armorSets;
            HashSet<Item> addedItems = new HashSet<Item>();
            String fullId = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
            String[] toolSuffixes = new String[]{"_helmet", "_chestplate", "_leggings", "_boots"};
            String baseId = fullId;
            for (String suffix : toolSuffixes) {
                if (!fullId.endsWith(suffix)) continue;
                baseId = fullId.substring(0, fullId.length() - suffix.length());
                break;
            }
            if ((armorSets = BddItemBuilder.ARMORSETS.get(baseId)) != null) {
                for (Supplier<Item> armor : armorSets) {
                    Item armorItem = armor.get();
                    if (armorItem == null || !addedItems.add(armorItem)) continue;
                    populator.accept(new ItemStack((ItemLike)armorItem), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                    BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Adding armor item: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)armorItem))));
                }
                return;
            }
            if (addedItems.add(item)) {
                populator.accept(new ItemStack((ItemLike)item), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Adding single armor item: " + fullId));
            }
        }
    }

    public static void addSpawnEgg(EntityType<?> entityType, CreativeModeTab.Output populator) {
        if (entityType != null) {
            String entityId = BuiltInRegistries.ENTITY_TYPE.getKey(entityType).getPath();
            String spawnEggId = entityId + "_spawn_egg";
            Item spawnEggItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)modId, (String)spawnEggId));
            populator.accept((ItemLike)spawnEggItem);
        }
    }

    public static void addAllSpawnEggs(CreativeModeTab.Output populator) {
        List<String> names = BddEntityBuilder.getDragonNames();
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String name;
            String entityId = name = iterator.next();
            String spawnEggId = entityId + "_spawn_egg";
            try {
                Item spawnEggItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)modId, (String)spawnEggId));
                populator.accept((ItemLike)spawnEggItem);
            }
            catch (Exception e) {
                BaseLogger.log((Level)BaseLogLevel.ERROR, (String)("Spawn egg for entity " + entityId + " not found!"));
            }
        }
    }

    static {
        TAB_BUILDERS = new HashMap<Supplier<CreativeModeTab>, BddTabBuilder>();
    }
}

