/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.registry.helpers.blocks;

import com.bdc.bdd.registry.helpers.blocks.BddBlockModelTemplates;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;

public class BddBlockModelGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void generateBlockModel(String modId, String name, BddBlockModelTemplates blockModelTemplate) {
        BddBlockModelGenerator.generateBlockModel(modId, name, blockModelTemplate, Collections.emptyMap());
    }

    public static void generateBlockModel(String modId, String name, BddBlockModelTemplates blockModelTemplate, Map<String, String> properties) {
        Map<String, JsonObject> blockModelJsons = blockModelTemplate.generateBlockModel(modId, name, properties);
        for (Map.Entry<String, JsonObject> entry : blockModelJsons.entrySet()) {
            String modelName = entry.getKey();
            JsonObject blockModelJson = entry.getValue();
            Path blockModelPath = BddBlockModelGenerator.findProjectRoot().resolve(modId + "/models/block/" + modelName + ".json");
            try {
                if (Files.exists(blockModelPath, new LinkOption[0])) {
                    System.out.println("Block model for '" + modelName + "' already exists at: " + String.valueOf(blockModelPath) + ". Skipping creation.");
                    continue;
                }
                Files.createDirectories(blockModelPath.getParent(), new FileAttribute[0]);
                Files.write(blockModelPath, GSON.toJson((JsonElement)blockModelJson).getBytes(), StandardOpenOption.CREATE_NEW);
                System.out.println("Block model for '" + modelName + "' created at: " + String.valueOf(blockModelPath));
                System.out.println("Generated JSON for '" + modId + ":models/block/" + modelName + "':\n" + GSON.toJson((JsonElement)blockModelJson));
            }
            catch (IOException e) {
                System.err.println("[ERROR]: Failed to create block model for '" + modelName + "' at " + String.valueOf(blockModelPath) + ": " + e.getMessage());
            }
        }
    }

    public static Path findProjectRoot() {
        for (Path current = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath(); current != null; current = current.getParent()) {
            Path resources = BddBlockModelGenerator.findResourcesPath(current);
            if (resources == null) continue;
            return resources;
        }
        throw new IllegalStateException("Could not locate project root");
    }

    private static Path findResourcesPath(Path current) {
        String currentDirName;
        String[] potentialPaths;
        for (String path : potentialPaths = new String[]{"src/main/resources/assets", "common/src/main/resources/assets"}) {
            Path resources = current.resolve(path);
            if (!Files.exists(resources, new LinkOption[0]) || !Files.isDirectory(resources, new LinkOption[0])) continue;
            return resources;
        }
        String string = currentDirName = current.getFileName() != null ? current.getFileName().toString() : "";
        if (currentDirName.matches("fabric|forge|neoforge|quilt")) {
            for (String path : potentialPaths) {
                Path parentResources = current.getParent().resolve(path);
                if (!Files.exists(parentResources, new LinkOption[0]) || !Files.isDirectory(parentResources, new LinkOption[0])) continue;
                return parentResources;
            }
        }
        return null;
    }
}

