/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.registry.helpers.items;

import com.bdc.bdd.registry.helpers.items.BddItemModelTemplates;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.resources.ResourceLocation;

public class BddItemModelGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void generateItemModel(String modId, String name, BddItemModelTemplates modelTemplate) {
        Path itemModelPath = BddItemModelGenerator.findProjectRoot().resolve(modId + "/models/item/" + name + ".json");
        try {
            if (Files.exists(itemModelPath, new LinkOption[0])) {
                System.out.println("Item model for '" + name + "' already exists at: " + String.valueOf(itemModelPath) + ". Skipping creation.");
                return;
            }
            JsonElement modelJson = BddItemModelGenerator.generateModelJson(modId, name, modelTemplate);
            Files.createDirectories(itemModelPath.getParent(), new FileAttribute[0]);
            Files.write(itemModelPath, GSON.toJson(modelJson).getBytes(), StandardOpenOption.CREATE_NEW);
            System.out.println("Item model for '" + name + "' created at: " + String.valueOf(itemModelPath));
        }
        catch (IOException e) {
            System.err.println("Failed [ERROR]: Failed to create item model for '" + name + "' at " + String.valueOf(itemModelPath) + ": " + e.getMessage());
        }
    }

    private static JsonElement generateModelJson(String modId, String name, BddItemModelTemplates modelTemplate) {
        ResourceLocation modelLocation = ResourceLocation.fromNamespaceAndPath((String)modId, (String)("item/" + name));
        ModelTemplate template = modelTemplate.getTemplate();
        JsonElement[] capturedJson = new JsonElement[1];
        BiConsumer<ResourceLocation, Supplier> tempConsumer = (location, jsonSupplier) -> {
            capturedJson[0] = (JsonElement)jsonSupplier.get();
            System.out.println("Generated JSON for '" + String.valueOf(location) + "':\n" + GSON.toJson(capturedJson[0]));
        };
        template.create(modelLocation, TextureMapping.layer0((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)("item/" + name))), tempConsumer);
        return capturedJson[0];
    }

    public static Path findProjectRoot() {
        for (Path current = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath(); current != null; current = current.getParent()) {
            Path resources = BddItemModelGenerator.findResourcesPath(current);
            if (resources == null) continue;
            return resources;
        }
        throw new IllegalStateException("Could not locate project root");
    }

    private static Path findResourcesPath(Path current) {
        String currentDirName;
        String[] potentialPaths;
        for (String path : potentialPaths = new String[]{"src/main/resources/assets", "common/src/main/resources/assets"}) {
            Path resources = current.resolve(path);
            if (!Files.exists(resources, new LinkOption[0]) || !Files.isDirectory(resources, new LinkOption[0])) continue;
            return resources;
        }
        String string = currentDirName = current.getFileName() != null ? current.getFileName().toString() : "";
        if (currentDirName.matches("fabric|forge|neoforge|quilt")) {
            for (String path : potentialPaths) {
                Path parentResources = current.getParent().resolve(path);
                if (!Files.exists(parentResources, new LinkOption[0]) || !Files.isDirectory(parentResources, new LinkOption[0])) continue;
                return parentResources;
            }
        }
        return null;
    }
}

