/*
 * Decompiled with CFR 0.152.
 */
package com.ashkiano.maintenancemode;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import org.yaml.snakeyaml.Yaml;

public class MaintenanceMode
extends Plugin
implements Listener {
    private String kickMessage;
    private String requiredPermission;

    public void onEnable() {
        File configFile;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        if (!(configFile = new File(this.getDataFolder(), "config.yml")).exists()) {
            try {
                Files.copy(this.getResourceAsStream("config.yml"), configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.loadConfig();
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this);
    }

    private void loadConfig() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        Yaml yaml = new Yaml();
        try (FileInputStream fis = new FileInputStream(configFile);){
            Map config = (Map)yaml.load(fis);
            this.kickMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getOrDefault("kick-message", "The server is currently in maintenance mode. Please try again later."));
            this.requiredPermission = config.getOrDefault("required-permission", "server.maintenance.bypass");
        }
        catch (IOException e) {
            e.printStackTrace();
            this.kickMessage = "The server is currently in maintenance mode. Please try again later.";
            this.requiredPermission = "server.maintenance.bypass";
        }
    }

    @EventHandler
    public void onPostLogin(PostLoginEvent event) {
        if (!event.getPlayer().hasPermission(this.requiredPermission)) {
            event.getPlayer().disconnect((BaseComponent)new TextComponent(this.kickMessage));
        }
    }
}

