/*
 * Decompiled with CFR 0.152.
 */
package net.countered.terrainslabs.callbacks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.countered.terrainslabs.block.ModBlocksRegistry;
import net.countered.terrainslabs.block.ModSlabsMap;
import net.countered.terrainslabs.block.customslabs.specialslabs.CustomSlab;
import net.countered.terrainslabs.config.MyModConfig;
import net.countered.terrainslabs.persistence.SlabChunkAttachment;
import net.countered.terrainslabs.worldgen.slabfeature.SlabFeatureLogic;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;

public class RegisterCallbacks {
    private static final Map<class_1792, class_2248> VEGETATION_ON_TOP_ITEMS = new HashMap<class_1792, class_2248>();
    private static final Set<class_2248> doubleTallPlants;

    public static void registerCallbacks() {
        RegisterCallbacks.registerPlaceOnTopCallback();
        RegisterCallbacks.registerSlabPlacementCallback();
    }

    private static void registerPlaceOnTopCallback() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_1799 item = player.method_5998(hand);
            if (item.method_7909() == class_1802.field_8749) {
                class_2338 blockPos = hitResult.method_17777().method_10093(hitResult.method_17780());
                if ((world.method_8320(blockPos).method_26215() || world.method_8320(blockPos).method_26204() == ModBlocksRegistry.SNOW_ON_TOP) && world.method_8320(blockPos.method_10074()).method_26204() instanceof class_2482 && ((class_2771)world.method_8320(blockPos.method_10074()).method_11654((class_2769)class_2741.field_12485)).equals((Object)class_2771.field_12681)) {
                    int currentLayers;
                    int n = currentLayers = world.method_8320(blockPos).method_26204() instanceof class_2488 ? (Integer)world.method_8320(blockPos).method_11654((class_2769)class_2488.field_11518) : 0;
                    if (currentLayers < 8) {
                        world.method_8501(blockPos, (class_2680)ModBlocksRegistry.SNOW_ON_TOP.method_9564().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(currentLayers + 1)));
                        world.method_8396(player, blockPos, class_3417.field_14945, class_3419.field_15245, 1.0f, 1.0f);
                        if (!player.method_7337()) {
                            item.method_7934(1);
                        }
                        return class_1269.field_5812;
                    }
                }
            } else if (VEGETATION_ON_TOP_ITEMS.containsKey(item.method_7909())) {
                class_2338 blockPos = hitResult.method_17777().method_10093(hitResult.method_17780());
                if (world.method_8320(blockPos).method_26215() && world.method_8320(blockPos.method_10074()).method_26204() instanceof class_2482 && ((class_2771)world.method_8320(blockPos.method_10074()).method_11654((class_2769)class_2741.field_12485)).equals((Object)class_2771.field_12681) && !item.method_31574(class_1802.field_8158)) {
                    world.method_8652(blockPos, VEGETATION_ON_TOP_ITEMS.get(item.method_7909()).method_9564(), 0);
                    world.method_8396(player, blockPos, class_3417.field_14653, class_3419.field_15245, 1.0f, 1.0f);
                    if (!player.method_7337()) {
                        item.method_7934(1);
                    }
                    return class_1269.field_5812;
                }
                if (world.method_8320(blockPos).method_27852(class_2246.field_10382) && world.method_8320(blockPos.method_10074()).method_26204() instanceof class_2482 && ((class_2771)world.method_8320(blockPos.method_10074()).method_11654((class_2769)class_2741.field_12485)).equals((Object)class_2771.field_12681) && item.method_7909().equals(class_1802.field_8158)) {
                    world.method_8652(blockPos, ModBlocksRegistry.SEAGRASS_ON_TOP.method_9564(), 0);
                    world.method_8396(player, blockPos, class_3417.field_15025, class_3419.field_15245, 1.0f, 1.0f);
                    if (!player.method_7337()) {
                        item.method_7934(1);
                    }
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5811;
        });
    }

    private static void registerSlabPlacementCallback() {
        ServerChunkEvents.CHUNK_LOAD.register((serverWorld, worldChunk) -> {
            List topAttachedSlabPositions;
            List botAttachedSlabPositions = (List)worldChunk.getAttached(SlabChunkAttachment.BOT_SLAB_POSITIONS);
            if (botAttachedSlabPositions != null && !botAttachedSlabPositions.isEmpty()) {
                for (class_2338 pos : botAttachedSlabPositions) {
                    RegisterCallbacks.placeBottomSlab(worldChunk, pos);
                }
                worldChunk.setAttached(SlabChunkAttachment.BOT_SLAB_POSITIONS, new ArrayList());
            }
            if ((topAttachedSlabPositions = (List)worldChunk.getAttached(SlabChunkAttachment.TOP_SLAB_POSITIONS)) != null && !topAttachedSlabPositions.isEmpty()) {
                for (class_2338 pos : topAttachedSlabPositions) {
                    RegisterCallbacks.placeTopSlab(worldChunk, pos);
                }
                worldChunk.setAttached(SlabChunkAttachment.TOP_SLAB_POSITIONS, new ArrayList());
            }
        });
    }

    private static void placeBottomSlab(class_2818 worldChunk, class_2338 placePos) {
        class_2338 blockBelowPos = placePos.method_10074();
        class_2338 blockAbovePos = placePos.method_10084();
        class_2680 blockAboveState = worldChunk.method_8320(blockAbovePos);
        class_2680 currentBlockState = worldChunk.method_8320(placePos);
        class_2680 blockBelowState = worldChunk.method_8320(blockBelowPos);
        if (!(currentBlockState.method_27852(class_2246.field_10124) || currentBlockState.method_27852(class_2246.field_10382) || currentBlockState.method_27852(class_2246.field_10543) || currentBlockState.method_27852(class_2246.field_10243) || currentBlockState.method_27852(class_2246.field_10164) || doubleTallPlants.contains(currentBlockState.method_26204()) || currentBlockState.method_26164(class_3481.field_20338) || ModSlabsMap.ON_TOP_VEGETATION_BLOCKS_MAP.containsKey(currentBlockState.method_26204()) || currentBlockState.method_27852(class_2246.field_10477))) {
            return;
        }
        class_2680 slabState = ModSlabsMap.getSlabForBlock(blockBelowState.method_26204()).method_9564();
        if (slabState.method_26204().equals(class_2246.field_10124)) {
            return;
        }
        int blockBelowY = blockBelowPos.method_10264();
        int blockAboveY = blockAbovePos.method_10264();
        int placeY = placePos.method_10264();
        int sectionIndex = worldChunk.method_31602(blockAboveY);
        if (sectionIndex < 0 || sectionIndex >= worldChunk.method_12006().length) {
            return;
        }
        class_2826 placePosSection = worldChunk.method_38259(worldChunk.method_31602(placeY));
        class_2826 belowPosSection = worldChunk.method_38259(worldChunk.method_31602(blockBelowY));
        class_2826 abovePosSection = worldChunk.method_38259(sectionIndex);
        if (doubleTallPlants.contains(currentBlockState.method_26204()) || currentBlockState.method_26164(class_3481.field_20338)) {
            if (currentBlockState.method_27852(class_2246.field_10238)) {
                abovePosSection.method_16675(blockAbovePos.method_10263() & 0xF, blockAbovePos.method_10264() & 0xF, blockAbovePos.method_10260() & 0xF, class_2246.field_10382.method_9564());
                blockAboveState = class_2246.field_10382.method_9564();
            } else {
                abovePosSection.method_16675(blockAbovePos.method_10263() & 0xF, blockAbovePos.method_10264() & 0xF, blockAbovePos.method_10260() & 0xF, class_2246.field_10124.method_9564());
            }
        }
        if (SlabFeatureLogic.SOIL_SLAB_BLOCKS.contains(slabState.method_26204())) {
            belowPosSection.method_16675(blockBelowPos.method_10263() & 0xF, blockBelowPos.method_10264() & 0xF, blockBelowPos.method_10260() & 0xF, class_2246.field_10566.method_9564());
        }
        if (slabState.method_27852(ModBlocksRegistry.WARPED_NYLIUM_SLAB) || slabState.method_27852(ModBlocksRegistry.CRIMSON_NYLIUM_SLAB)) {
            belowPosSection.method_16675(blockBelowPos.method_10263() & 0xF, blockBelowPos.method_10264() & 0xF, blockBelowPos.method_10260() & 0xF, class_2246.field_10515.method_9564());
        }
        slabState = RegisterCallbacks.updateBottomWaterloggedState(currentBlockState, blockAboveState, slabState);
        if (MyModConfig.enableVegetationOnSlabs) {
            RegisterCallbacks.placeVegetationOnTop(abovePosSection, currentBlockState, blockAboveState, blockAbovePos);
        }
        if (currentBlockState.method_27852(class_2246.field_10477)) {
            if (MyModConfig.enableSnowOnSlabs) {
                abovePosSection.method_16675(blockAbovePos.method_10263() & 0xF, blockAbovePos.method_10264() & 0xF, blockAbovePos.method_10260() & 0xF, ModBlocksRegistry.SNOW_ON_TOP.method_9564());
                if (SlabFeatureLogic.SOIL_SLAB_BLOCKS.contains(slabState.method_26204()) && !slabState.method_27852(ModBlocksRegistry.PATH_SLAB)) {
                    slabState = (class_2680)slabState.method_11657((class_2769)class_2741.field_12512, (Comparable)Boolean.valueOf(true));
                }
            } else {
                slabState = ModBlocksRegistry.SNOW_SLAB.method_9564();
            }
        }
        placePosSection.method_16675(placePos.method_10263() & 0xF, placePos.method_10264() & 0xF, placePos.method_10260() & 0xF, (class_2680)slabState.method_11657((class_2769)CustomSlab.GENERATED, (Comparable)Boolean.valueOf(true)));
    }

    private static void placeTopSlab(class_2818 worldChunk, class_2338 placePos) {
        class_2680 blockAboveState = worldChunk.method_8320(placePos.method_10084());
        class_2680 slabState = ModSlabsMap.getSlabForBlock(blockAboveState.method_26204()).method_9564();
        if (slabState.method_26204().equals(class_2246.field_10124)) {
            return;
        }
        if (SlabFeatureLogic.SOIL_SLAB_BLOCKS.contains(slabState.method_26204())) {
            slabState = ModBlocksRegistry.DIRT_SLAB.method_9564();
        }
        if (slabState.method_27852(ModBlocksRegistry.WARPED_NYLIUM_SLAB) || slabState.method_27852(ModBlocksRegistry.CRIMSON_NYLIUM_SLAB)) {
            slabState = ModBlocksRegistry.NETHERRACK_SLAB.method_9564();
        }
        slabState = RegisterCallbacks.updateTopWaterloggedState(worldChunk, placePos, slabState);
        class_2826 section = worldChunk.method_38259(worldChunk.method_31602(placePos.method_10264()));
        section.method_16675(placePos.method_10263() & 0xF, placePos.method_10264() & 0xF, placePos.method_10260() & 0xF, (class_2680)((class_2680)slabState.method_11657((class_2769)CustomSlab.GENERATED, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12485, (Comparable)class_2771.field_12679));
    }

    private static void placeVegetationOnTop(class_2826 abovePosSection, class_2680 currentBlockState, class_2680 blockAboveState, class_2338 blockAbovePos) {
        if (ModSlabsMap.ON_TOP_VEGETATION_BLOCKS_MAP.containsKey(currentBlockState.method_26204()) && (!currentBlockState.method_26204().equals(class_2246.field_10376) || blockAboveState.method_26204().equals(class_2246.field_10382))) {
            abovePosSection.method_16675(blockAbovePos.method_10263() & 0xF, blockAbovePos.method_10264() & 0xF, blockAbovePos.method_10260() & 0xF, ModSlabsMap.ON_TOP_VEGETATION_BLOCKS_MAP.get(currentBlockState.method_26204()).method_9564());
        }
    }

    private static class_2680 updateBottomWaterloggedState(class_2680 currentBlockState, class_2680 blockAboveState, class_2680 slabState) {
        if (slabState.method_28498((class_2769)class_2741.field_12508) && (currentBlockState.method_27852(class_2246.field_10382) || blockAboveState.method_27852(class_2246.field_10382) || currentBlockState.method_27852(class_2246.field_10376))) {
            return (class_2680)slabState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
        }
        return slabState;
    }

    private static class_2680 updateTopWaterloggedState(class_2818 worldChunk, class_2338 currentPos, class_2680 slabState) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            if (!worldChunk.method_8320(currentPos.method_10093(direction)).method_27852(class_2246.field_10382)) continue;
            return (class_2680)slabState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
        }
        return slabState;
    }

    static {
        VEGETATION_ON_TOP_ITEMS.put(class_1802.field_8880, ModBlocksRegistry.POPPY_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(class_1802.field_8491, ModBlocksRegistry.DANDELION_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(class_1802.field_17501, ModBlocksRegistry.AZURE_BLUET_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(class_1802.field_17513, ModBlocksRegistry.CORNFLOWER_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(class_1802.field_8602, ModBlocksRegistry.SHORT_GRASS_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(class_1802.field_8471, ModBlocksRegistry.FERN_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(class_1802.field_8689, ModBlocksRegistry.DEAD_BUSH_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(class_1802.field_17516, ModBlocksRegistry.BROWN_MUSHROOM_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(class_1802.field_17517, ModBlocksRegistry.RED_MUSHROOM_ON_TOP);
        VEGETATION_ON_TOP_ITEMS.put(class_1802.field_8158, ModBlocksRegistry.SEAGRASS_ON_TOP);
        doubleTallPlants = new HashSet<class_2248>();
        doubleTallPlants.add(class_2246.field_10214);
        doubleTallPlants.add(class_2246.field_10313);
        doubleTallPlants.add(class_2246.field_10238);
    }
}

