/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.experimentalist;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.pajic.experimentalist.Experimentalist;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagRegistry;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path FILE_PATH = Experimentalist.xplat().getConfigDir().resolve("experimentalist.json");
    public static Map<String, Boolean> FEATURES = new HashMap<String, Boolean>();

    public static void loadConfig() {
        ModConfig.readConfig();
        ModConfig.saveConfig();
    }

    public static void initializeConfig(FeatureFlagRegistry registry) {
        Set<String> names = registry.m_245829_(registry.m_247355_()).stream().map(ResourceLocation::m_135815_).filter(path -> !path.equals("vanilla")).collect(Collectors.toSet());
        if (FEATURES.isEmpty()) {
            Experimentalist.LOGGER.info("[Experimentalist] Initializing config with features.");
            names.forEach(name -> FEATURES.put((String)name, false));
            ModConfig.saveConfig();
        }
        if (!names.containsAll(FEATURES.keySet())) {
            Experimentalist.LOGGER.warn("[Experimentalist] Removing unknown features from config.");
            FEATURES.keySet().removeIf(name -> !names.contains(name));
            ModConfig.saveConfig();
        } else if (!FEATURES.keySet().containsAll(names)) {
            Experimentalist.LOGGER.warn("[Experimentalist] Adding missing features to config.");
            names.forEach(name -> {
                if (!FEATURES.containsKey(name)) {
                    FEATURES.put((String)name, false);
                }
            });
            ModConfig.saveConfig();
        }
    }

    private static void readConfig() {
        try (FileReader reader = new FileReader(FILE_PATH.toFile());){
            FEATURES = (Map)GSON.fromJson((Reader)reader, (TypeToken)new TypeToken<Map<String, Boolean>>(){});
        }
        catch (JsonSyntaxException | FileNotFoundException e) {
            Experimentalist.LOGGER.warn("[Experimentalist] Config doesn't exist or is malformed, initializing config file...");
            ModConfig.saveConfig();
        }
        catch (IOException e) {
            Experimentalist.LOGGER.error("[Experimentalist] Failed to read mod config", (Throwable)e);
        }
    }

    private static void saveConfig() {
        try (FileWriter writer = new FileWriter(FILE_PATH.toFile());){
            GSON.toJson(FEATURES, (Appendable)writer);
        }
        catch (IOException e) {
            Experimentalist.LOGGER.error("[Experimentalist] Failed to save mod config", (Throwable)e);
        }
    }
}

