/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.experimentalist;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_7697;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Experimentalist");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path FILE_PATH = FabricLoader.getInstance().getConfigDir().resolve("experimentalist.json");
    public static Map<String, Boolean> FEATURES = new HashMap<String, Boolean>();

    public static void loadConfig() {
        ModConfig.readConfig();
        ModConfig.saveConfig();
    }

    public static void initializeConfig(class_7697 registry) {
        Set<String> names = registry.method_45392(registry.method_45383()).stream().map(class_2960::method_12832).filter(path -> !path.equals("vanilla")).collect(Collectors.toSet());
        if (!names.containsAll(FEATURES.keySet())) {
            LOGGER.warn("[Experimentalist] Removing unknown features from config.");
            FEATURES.keySet().removeIf(name -> !names.contains(name));
            ModConfig.saveConfig();
        } else if (!FEATURES.keySet().containsAll(names)) {
            LOGGER.warn("[Experimentalist] Adding missing features to config.");
            names.forEach(name -> {
                if (!FEATURES.containsKey(name)) {
                    FEATURES.put((String)name, false);
                }
            });
            ModConfig.saveConfig();
        }
    }

    private static void readConfig() {
        try (FileReader reader = new FileReader(FILE_PATH.toFile());){
            FEATURES = (Map)GSON.fromJson((Reader)reader, (TypeToken)new TypeToken<Map<String, Boolean>>(){});
        }
        catch (JsonSyntaxException | FileNotFoundException e) {
            LOGGER.warn("Config doesn't exist or is malformed, initializing config file...");
            ModConfig.saveConfig();
        }
        catch (IOException e) {
            LOGGER.error("Failed to read mod config", (Throwable)e);
        }
    }

    private static void saveConfig() {
        try (FileWriter writer = new FileWriter(FILE_PATH.toFile());){
            GSON.toJson(FEATURES, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save mod config", (Throwable)e);
        }
    }
}

