/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.interfaces.IDataSyncer;
import fi.dy.masa.malilib.interfaces.IInventoryOverlayHandler;
import fi.dy.masa.malilib.mixin.entity.IMixinAbstractHorseEntity;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.test.TestDataSyncer;
import fi.dy.masa.malilib.test.TestRenderHandler;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.game.RayTraceUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class TestInventoryOverlayHandler
implements IInventoryOverlayHandler {
    private static final TestInventoryOverlayHandler INSTANCE = new TestInventoryOverlayHandler();
    IDataSyncer syncer = null;
    InventoryOverlay.Context context = null;
    InventoryOverlay.Refresher refresher = null;

    public static TestInventoryOverlayHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public String getModId() {
        return "malilib";
    }

    @Override
    public IDataSyncer getDataSyncer() {
        if (this.syncer == null) {
            this.syncer = TestDataSyncer.getInstance();
        }
        return this.syncer;
    }

    @Override
    public void setDataSyncer(IDataSyncer syncer) {
        this.syncer = syncer;
    }

    @Override
    public InventoryOverlay.Refresher getRefreshHandler() {
        if (this.refresher == null) {
            this.refresher = new Refresher();
        }
        return this.refresher;
    }

    @Override
    public boolean isEmpty() {
        return this.context == null;
    }

    @Override
    @Nullable
    public InventoryOverlay.Context getRenderContextNullable() {
        return this.context;
    }

    @Override
    @Nullable
    public InventoryOverlay.Context getRenderContext(GuiGraphics drawContext, ProfilerFiller profiler, Minecraft mc) {
        profiler.push(this.getClass().getName() + "_inventory_overlay");
        this.getTargetInventory(mc);
        if (!this.isEmpty()) {
            if (MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY_OG.getBooleanValue()) {
                TestRenderHandler.renderInventoryOverlayOG(drawContext, this.getRenderContextNullable(), mc);
            } else {
                this.renderInventoryOverlay(drawContext, this.getRenderContextNullable(), mc, true, true);
            }
        }
        profiler.pop();
        return this.getRenderContextNullable();
    }

    @Override
    @Nullable
    public InventoryOverlay.Context getTargetInventory(Minecraft mc) {
        Player serverPlayer;
        Level world = WorldUtils.getBestWorld(mc);
        Entity cameraEntity = EntityUtils.getCameraEntity();
        this.context = null;
        if (mc.player == null || world == null || mc.level == null) {
            return null;
        }
        if (cameraEntity == mc.player && world instanceof ServerLevel && (serverPlayer = world.getPlayerByUUID(mc.player.getUUID())) != null) {
            cameraEntity = serverPlayer;
        }
        if (cameraEntity == null) {
            return null;
        }
        HitResult trace = cameraEntity != mc.player ? RayTraceUtils.getRayTraceFromEntity((Level)mc.level, cameraEntity, ClipContext.Fluid.NONE) : mc.hitResult;
        CompoundTag nbt = new CompoundTag();
        if (trace == null || trace.getType() == HitResult.Type.MISS) {
            return null;
        }
        if (trace.getType() == HitResult.Type.BLOCK) {
            BlockPos pos = ((BlockHitResult)trace).getBlockPos();
            BlockState state = world.getBlockState(pos);
            Block blockTmp = state.getBlock();
            BlockEntity be = null;
            if (blockTmp instanceof EntityBlock) {
                if (world instanceof ServerLevel) {
                    be = world.getChunkAt(pos).getBlockEntity(pos);
                    if (be != null) {
                        nbt = be.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
                    }
                } else {
                    Pair<BlockEntity, CompoundTag> pair = this.getDataSyncer().requestBlockEntity(world, pos);
                    if (pair != null) {
                        nbt = (CompoundTag)pair.getRight();
                    }
                }
                return this.getTargetInventoryFromBlock(world, pos, be, nbt);
            }
            return null;
        }
        if (trace.getType() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)trace).getEntity();
            if (mc.crosshairPickEntity != null && entity.getId() != mc.crosshairPickEntity.getId()) {
                MaLiLib.LOGGER.error("getTargetInventory(): entityId Not Equal: [{} != {}]", (Object)entity.getId(), (Object)mc.crosshairPickEntity.getId());
            }
            MaLiLib.LOGGER.warn("getTargetInventory(): entityUUID [{}] vs targetedUUID [{}]", (Object)entity.getStringUUID(), (Object)(mc.crosshairPickEntity != null ? mc.crosshairPickEntity.getStringUUID() : "<NULL>"));
            if (world instanceof ServerLevel) {
                if ((entity = world.getEntity(entity.getId())) != null) {
                    return this.getTargetInventoryFromEntity(entity, NbtEntityUtils.invokeEntityNbtDataNoPassengers(entity, entity.getId()));
                }
            } else {
                Pair<Entity, CompoundTag> pair = this.getDataSyncer().requestEntity(world, entity.getId());
                if (pair != null) {
                    return this.getTargetInventoryFromEntity(world.getEntity(((Entity)pair.getLeft()).getId()), (CompoundTag)pair.getRight());
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public InventoryOverlay.Context getTargetInventoryFromBlock(Level world, BlockPos pos, @Nullable BlockEntity be, CompoundTag nbt) {
        Player player;
        BlockEntityType<?> beType;
        Container inv;
        if (be != null) {
            if (nbt.isEmpty()) {
                nbt = be.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
            }
            inv = InventoryUtils.getInventory(world, pos);
        } else {
            Pair<BlockEntity, CompoundTag> pair;
            if (nbt.isEmpty() && (pair = this.getDataSyncer().requestBlockEntity(world, pos)) != null) {
                nbt = (CompoundTag)pair.getRight();
            }
            inv = this.getDataSyncer().getBlockInventory(world, pos, false);
        }
        BlockEntityType<?> blockEntityType = beType = nbt != null ? NbtBlockUtils.getBlockEntityTypeFromNbt(nbt) : null;
        if ((beType != null && beType.equals((Object)BlockEntityType.ENDER_CHEST) || be instanceof EnderChestBlockEntity) && Minecraft.getInstance().player != null && (player = world.getPlayerByUUID(Minecraft.getInstance().player.getUUID())) != null) {
            Pair<Entity, CompoundTag> enderPair = this.getDataSyncer().requestEntity(world, player.getId());
            PlayerEnderChestContainer enderItems = null;
            if (enderPair != null && enderPair.getRight() != null && ((CompoundTag)enderPair.getRight()).contains("EnderItems")) {
                enderItems = InventoryUtils.getPlayerEnderItemsFromNbt((CompoundTag)enderPair.getRight(), world.registryAccess());
            } else if (world instanceof ServerLevel) {
                enderItems = player.getEnderChestInventory();
            }
            if (enderItems != null) {
                inv = enderItems;
            }
        }
        if (nbt != null && !nbt.isEmpty()) {
            Container inv2 = InventoryUtils.getNbtInventory(nbt, inv != null ? inv.getContainerSize() : -1, world.registryAccess());
            if (inv == null) {
                inv = inv2;
            }
        }
        MaLiLib.LOGGER.warn("getTarget():3: pos [{}], inv [{}], be [{}], nbt [{}]", (Object)pos.toShortString(), (Object)(inv != null ? 1 : 0), (Object)(be != null ? 1 : 0), (Object)(nbt != null ? nbt.getString("id") : new CompoundTag()));
        if (inv == null || nbt == null) {
            return null;
        }
        this.context = new InventoryOverlay.Context(InventoryOverlay.getBestInventoryType(inv, nbt), inv, be != null ? be : world.getBlockEntity(pos), null, nbt, this.getRefreshHandler());
        return this.context;
    }

    @Override
    @Nullable
    public InventoryOverlay.Context getTargetInventoryFromEntity(Entity entity, CompoundTag nbt) {
        Container inv = null;
        LivingEntity entityLivingBase = null;
        if (entity instanceof LivingEntity) {
            entityLivingBase = (LivingEntity)entity;
        }
        if (entity instanceof Container) {
            inv = (Container)entity;
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            inv = new SimpleContainer((ItemStack[])player.getInventory().getNonEquipmentItems().toArray((Object[])new ItemStack[36]));
        } else if (entity instanceof AbstractHorse) {
            inv = ((IMixinAbstractHorseEntity)entity).malilib_getHorseInventory();
        } else if (entity instanceof InventoryCarrier) {
            inv = ((InventoryCarrier)entity).getInventory();
        }
        if (!nbt.isEmpty()) {
            Container inv2;
            MaLiLib.LOGGER.warn("getTargetInventoryFromEntity(): rawNbt: [{}]", (Object)nbt.toString());
            if (inv != null && nbt.contains("Items") && nbt.getList("Items").orElse(new ListTag()).size() > 1) {
                MaLiLib.LOGGER.warn("getTargetInventoryFromEntity(): [Fix for horse inv] inv.size: [{}]", (Object)inv.getContainerSize());
                inv2 = entity instanceof AbstractHorse ? InventoryUtils.getNbtInventoryHorseFix(nbt, inv.getContainerSize(), entity.registryAccess()) : InventoryUtils.getNbtInventory(nbt, inv.getContainerSize(), entity.registryAccess());
                inv = null;
            } else if (inv != null && nbt.contains("equipment") && nbt.contains("EatingHaystack")) {
                MaLiLib.LOGGER.warn("getTargetInventoryFromEntity(): [Fix for saddled horse inv] inv.size: [{}]", (Object)inv.getContainerSize());
                inv2 = InventoryUtils.getNbtInventoryHorseFix(nbt, inv.getContainerSize(), entity.registryAccess());
                inv = null;
            } else if (inv != null && inv.getContainerSize() == 8 && nbt.contains("Inventory") && !nbt.getList("Inventory").orElse(new ListTag()).isEmpty()) {
                MaLiLib.LOGGER.warn("getTargetInventoryFromEntity(): [Fix for empty villager/piglin inv] inv.size: [{}]", (Object)inv.getContainerSize());
                inv2 = InventoryUtils.getNbtInventory(nbt, 8, entity.registryAccess());
                inv = null;
            } else {
                MaLiLib.LOGGER.warn("getTargetInventoryFromEntity(): [Default] inv.size: [{}]", (Object)(inv != null ? inv.getContainerSize() : -1));
                inv2 = InventoryUtils.getNbtInventory(nbt, inv != null ? inv.getContainerSize() : -1, entity.registryAccess());
                if (inv2 != null) {
                    inv = null;
                }
            }
            MaLiLib.LOGGER.error("getTargetInventoryFromEntity(): inv.size [{}], inv2.size [{}]", inv != null ? Integer.valueOf(inv.getContainerSize()) : "null", inv2 != null ? Integer.valueOf(inv2.getContainerSize()) : "null");
            if (inv2 != null) {
                inv = inv2;
            }
        }
        if (inv == null && entityLivingBase == null) {
            return null;
        }
        this.context = new InventoryOverlay.Context(inv != null ? InventoryOverlay.getBestInventoryType(inv, nbt) : InventoryOverlay.getInventoryType(nbt), inv, null, entityLivingBase, nbt, this.getRefreshHandler());
        return this.context;
    }

    public static class Refresher
    implements InventoryOverlay.Refresher {
        @Override
        public InventoryOverlay.Context onContextRefresh(InventoryOverlay.Context data, Level world) {
            if (data.be() != null) {
                TestInventoryOverlayHandler.getInstance().requestBlockEntityAt(world, data.be().getBlockPos());
                data = TestInventoryOverlayHandler.getInstance().getTargetInventoryFromBlock(data.be().getLevel(), data.be().getBlockPos(), data.be(), data.nbt());
            } else if (data.entity() != null) {
                TestInventoryOverlayHandler.getInstance().getDataSyncer().requestEntity(world, data.entity().getId());
                data = TestInventoryOverlayHandler.getInstance().getTargetInventoryFromEntity((Entity)data.entity(), data.nbt());
            }
            return data;
        }
    }
}

