/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.time;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.time.TimeFmtType;
import fi.dy.masa.malilib.util.time.formatter.TimeFmt;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public enum TimeFormat implements IConfigOptionListEntry,
StringRepresentable
{
    REGULAR("regular", TimeFmtType.REGULAR, "malilib.gui.label.time_format.regular"),
    ISO_LOCAL("iso_local", TimeFmtType.ISO_LOCAL, "malilib.gui.label.time_format.iso_local"),
    ISO_OFFSET("iso_offset", TimeFmtType.ISO_OFFSET, "malilib.gui.label.time_format.iso_offset"),
    FORMATTED("formatted", TimeFmtType.FORMATTED, "malilib.gui.label.time_format.formatted"),
    RFC1123("rfc1123", TimeFmtType.RFC1123, "malilib.gui.label.time_format.rfc1123"),
    TIME_ONLY("time_only", TimeFmtType.TIME_ONLY, "malilib.gui.label.time_format.time_only"),
    TIME_AM_PM("time_am_pm", TimeFmtType.TIME_AM_PM, "malilib.gui.label.time_format.time_am_pm"),
    DAY_AM_PM("day_am_pm", TimeFmtType.DAY_AM_PM, "malilib.gui.label.time_format.day_am_pm"),
    DATE_AM_PM("date_am_pm", TimeFmtType.DATE_AM_PM, "malilib.gui.label.time_format.date_am_pm"),
    DATE_ONLY("date_only", TimeFmtType.DATE_ONLY, "malilib.gui.label.time_format.date_only");

    public static final StringRepresentable.EnumCodec<TimeFormat> CODEC;
    public static final StreamCodec<ByteBuf, TimeFormat> PACKET_CODEC;
    public static final ImmutableList<TimeFormat> VALUES;
    private final String configString;
    private final TimeFmtType<?> type;
    private final String translationKey;

    private TimeFormat(String name, TimeFmtType<?> type, String translationKey) {
        this.configString = name;
        this.type = type;
        this.translationKey = translationKey;
    }

    public String getSerializedName() {
        return this.configString;
    }

    @Override
    public String getStringValue() {
        return this.configString;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.translate(this.translationKey, new Object[0]);
    }

    public TimeFmtType<?> getType() {
        return this.type;
    }

    @Nullable
    private TimeFmt init() {
        return this.type.init(this);
    }

    public String formatTo(long time) {
        return this.formatTo(time, null);
    }

    public String formatTo(long time, @Nullable String fmt) {
        TimeFmt formatter = this.init();
        if (formatter != null) {
            return formatter.formatTo(time, fmt);
        }
        return "";
    }

    public long formatFrom(@Nonnull String formattedTime) {
        return this.formatFrom(formattedTime, null);
    }

    public long formatFrom(@Nonnull String formattedTime, @Nullable String fmt) {
        TimeFmt formatter = this.init();
        if (formatter != null) {
            return formatter.formatFrom(formattedTime, fmt);
        }
        return 0L;
    }

    public String formatNow() {
        return this.formatNow(null);
    }

    public String formatNow(@Nullable String fmt) {
        TimeFmt formatter = this.init();
        if (formatter != null) {
            return formatter.formatNow(fmt);
        }
        return "";
    }

    public String getFormatString() {
        TimeFmt formatter = this.init();
        if (formatter != null) {
            return formatter.getFormatString();
        }
        return "";
    }

    @Override
    @Nullable
    public TimeFormat fromString(String value) {
        return TimeFormat.fromStringStatic(value);
    }

    @Nullable
    public static TimeFormat fromStringStatic(String value) {
        for (TimeFormat val : VALUES) {
            if (value.compareToIgnoreCase(val.getStringValue()) != 0) continue;
            return val;
        }
        return null;
    }

    @Override
    public IConfigOptionListEntry cycle(boolean forward) {
        int id = this.ordinal();
        if (forward) {
            if (++id >= TimeFormat.values().length) {
                id = 0;
            }
        } else if (--id < 0) {
            id = TimeFormat.values().length - 1;
        }
        return TimeFormat.values()[id % TimeFormat.values().length];
    }

    public String toString() {
        return this.getStringValue();
    }

    static {
        CODEC = StringRepresentable.fromEnum(TimeFormat::values);
        PACKET_CODEC = ByteBufCodecs.STRING_UTF8.map(TimeFormat::fromStringStatic, TimeFormat::getSerializedName);
        VALUES = ImmutableList.copyOf((Object[])TimeFormat.values());
    }
}

