/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.command;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.interfaces.IClientCommandListener;
import fi.dy.masa.malilib.interfaces.ICommandDispatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.ApiStatus;

public class ClientCommandHandler
implements ICommandDispatcher {
    public static final ClientCommandHandler INSTANCE = new ClientCommandHandler();
    private final List<IClientCommandListener> commands = new ArrayList<IClientCommandListener>();

    @Override
    public void registerCommand(IClientCommandListener command) {
        if (!this.commands.contains(command)) {
            if (this.checkIfAvailable(command.getCommand())) {
                this.commands.add(command);
            } else {
                MaLiLib.LOGGER.error("ClientCommandHandler: Tried to register a duplicate command '{}'.", (Object)command.getCommand());
            }
        }
    }

    private boolean checkIfAvailable(String command) {
        AtomicBoolean valid = new AtomicBoolean(true);
        this.commands.forEach(handler -> {
            if (handler.getCommand().equalsIgnoreCase(command)) {
                valid.set(false);
            }
        });
        return valid.get();
    }

    @ApiStatus.Internal
    public boolean onSendClientMessage(String message, Minecraft mc) {
        if (!this.commands.isEmpty()) {
            for (IClientCommandListener command : this.commands) {
                List<String> args;
                if (!message.startsWith(command.getCommand()) || !(args = Arrays.stream(message.split("\\s+")).toList()).getFirst().equalsIgnoreCase(command.getCommand())) continue;
                return command.execute(args, mc);
            }
        }
        return false;
    }
}

