/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public enum HudAlignment implements IConfigOptionListEntry,
StringRepresentable
{
    TOP_LEFT("top_left", "malilib.label.alignment.top_left"),
    TOP_RIGHT("top_right", "malilib.label.alignment.top_right"),
    BOTTOM_LEFT("bottom_left", "malilib.label.alignment.bottom_left"),
    BOTTOM_RIGHT("bottom_right", "malilib.label.alignment.bottom_right"),
    CENTER("center", "malilib.label.alignment.center");

    public static final StringRepresentable.EnumCodec<HudAlignment> CODEC;
    public static final StreamCodec<ByteBuf, HudAlignment> PACKET_CODEC;
    public static final ImmutableList<HudAlignment> VALUES;
    private final String configString;
    private final String unlocName;

    private HudAlignment(String configString, String unlocName) {
        this.configString = configString;
        this.unlocName = unlocName;
    }

    @Override
    public String getStringValue() {
        return this.configString;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.translate(this.unlocName, new Object[0]);
    }

    @Override
    public IConfigOptionListEntry cycle(boolean forward) {
        int id = this.ordinal();
        if (forward) {
            if (++id >= HudAlignment.values().length) {
                id = 0;
            }
        } else if (--id < 0) {
            id = HudAlignment.values().length - 1;
        }
        return HudAlignment.values()[id % HudAlignment.values().length];
    }

    @Override
    public HudAlignment fromString(String name) {
        return HudAlignment.fromStringStatic(name);
    }

    public static HudAlignment fromStringStatic(String name) {
        for (HudAlignment aligment : HudAlignment.values()) {
            if (!aligment.configString.equalsIgnoreCase(name)) continue;
            return aligment;
        }
        return TOP_LEFT;
    }

    public String getSerializedName() {
        return this.configString;
    }

    static {
        CODEC = StringRepresentable.fromEnum(HudAlignment::values);
        PACKET_CODEC = ByteBufCodecs.STRING_UTF8.map(HudAlignment::fromStringStatic, HudAlignment::getSerializedName);
        VALUES = ImmutableList.copyOf((Object[])HudAlignment.values());
    }
}

