/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.event;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.framegraph.FrameGraphBuilder;
import com.mojang.blaze3d.framegraph.FramePass;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.resource.ResourceHandle;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.interfaces.IRenderDispatcher;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.GuiRenderer;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.LevelTargetBundle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.network.chat.Component;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.gui.PictureInPictureRendererPool;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

public class RenderEventHandler
implements IRenderDispatcher {
    private static final RenderEventHandler INSTANCE = new RenderEventHandler();
    private final List<IRenderer> overlayRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> tooltipLastRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> worldPostDebugRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> worldPreWeatherRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> worldLastRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> specialGuiRenderers = new ArrayList<IRenderer>();

    public static IRenderDispatcher getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerGameOverlayRenderer(IRenderer renderer) {
        if (!this.overlayRenderers.contains(renderer)) {
            this.overlayRenderers.add(renderer);
        }
    }

    @Override
    public void registerTooltipLastRenderer(IRenderer renderer) {
        if (!this.tooltipLastRenderers.contains(renderer)) {
            this.tooltipLastRenderers.add(renderer);
        }
    }

    @Override
    public void registerWorldPostDebugRenderer(IRenderer renderer) {
        if (!this.worldPostDebugRenderers.contains(renderer)) {
            this.worldPostDebugRenderers.add(renderer);
        }
    }

    @Override
    public void registerWorldPreWeatherRenderer(IRenderer renderer) {
        if (!this.worldPreWeatherRenderers.contains(renderer)) {
            this.worldPreWeatherRenderers.add(renderer);
        }
    }

    @Override
    public void registerWorldLastRenderer(IRenderer renderer) {
        if (!this.worldLastRenderers.contains(renderer)) {
            this.worldLastRenderers.add(renderer);
        }
    }

    @Override
    public void registerSpecialGuiRenderer(IRenderer renderer) {
        if (!this.specialGuiRenderers.contains(renderer)) {
            this.specialGuiRenderers.add(renderer);
        }
    }

    @ApiStatus.Internal
    public void onRenderGameOverlayPost(GuiGraphics drawContext, Minecraft mc, float partialTicks) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("malilib_game_overlay");
        if (!this.overlayRenderers.isEmpty()) {
            for (IRenderer renderer : this.overlayRenderers) {
                profiler.push(renderer.getProfilerSectionSupplier());
                renderer.onRenderGameOverlayPostAdvanced(drawContext, partialTicks, profiler, mc);
                renderer.onRenderGameOverlayPost(drawContext);
                profiler.pop();
            }
        }
        profiler.popPush("malilib_game_messages");
        InfoUtils.renderInGameMessages(drawContext);
        profiler.pop();
    }

    @ApiStatus.Internal
    public void onRenderTooltipComponentInsertFirst(Item.TooltipContext context, ItemStack stack, Consumer<Component> list) {
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                renderer.onRenderTooltipComponentInsertFirst(context, stack, list);
            }
        }
    }

    @ApiStatus.Internal
    public void onRenderTooltipComponentInsertMiddle(Item.TooltipContext context, ItemStack stack, Consumer<Component> list) {
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                renderer.onRenderTooltipComponentInsertMiddle(context, stack, list);
            }
        }
    }

    @ApiStatus.Internal
    public void onRenderTooltipComponentInsertLast(Item.TooltipContext context, ItemStack stack, Consumer<Component> list) {
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                renderer.onRenderTooltipComponentInsertLast(context, stack, list);
            }
        }
    }

    @ApiStatus.Internal
    public void onRenderTooltipLast(GuiGraphics drawContext, ItemStack stack, int x, int y) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("malilib_tooltip");
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                profiler.popPush(renderer.getProfilerSectionSupplier());
                renderer.onRenderTooltipLast(drawContext, stack, x, y);
            }
        }
        profiler.pop();
    }

    @ApiStatus.Internal
    public void runRenderWorldPostDebug(PoseStack matrices, Frustum frustum, MultiBufferSource.BufferSource immediate, Vec3 camera) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("malilib_post_debug");
        if (!this.worldPostDebugRenderers.isEmpty()) {
            for (IRenderer renderer : this.worldPostDebugRenderers) {
                profiler.push(renderer.getProfilerSectionSupplier());
                renderer.onRenderWorldPostDebugRender(matrices, frustum, immediate, camera, profiler);
                profiler.pop();
            }
        }
        profiler.pop();
    }

    @ApiStatus.Internal
    public void runRenderWorldPreWeather(Matrix4f posMatrix, Matrix4f projMatrix, Minecraft mc, FrameGraphBuilder frameGraphBuilder, LevelTargetBundle fbSet, Frustum frustum, Camera camera, RenderBuffers buffers, ProfilerFiller profiler) {
        profiler.push("malilib_pre_weather");
        if (!this.worldPreWeatherRenderers.isEmpty()) {
            FramePass pass = frameGraphBuilder.addPass("malilib_pre_weather");
            ResourceHandle handleMain = fbSet.main = pass.readsAndWrites(fbSet.main);
            pass.executes(() -> {
                GpuBufferSlice fog = RenderSystem.getShaderFog();
                RenderTarget fb = (RenderTarget)handleMain.get();
                for (IRenderer renderer : this.worldPreWeatherRenderers) {
                    profiler.push(renderer.getProfilerSectionSupplier());
                    renderer.onRenderWorldPreWeather(fb, posMatrix, projMatrix, frustum, camera, buffers, profiler);
                    profiler.pop();
                }
                RenderSystem.setShaderFog((GpuBufferSlice)fog);
            });
            if (!this.worldPreWeatherRenderers.isEmpty()) {
                pass.disableCulling();
            }
        }
        profiler.pop();
    }

    @ApiStatus.Internal
    public void runRenderWorldLast(Matrix4f posMatrix, Matrix4f projMatrix, Minecraft mc, FrameGraphBuilder frameGraphBuilder, LevelTargetBundle fbSet, Frustum frustum, Camera camera, RenderBuffers buffers, ProfilerFiller profiler) {
        profiler.push("malilib_world_last");
        if (!this.worldLastRenderers.isEmpty()) {
            FramePass pass = frameGraphBuilder.addPass("malilib_world_last");
            ResourceHandle handleMain = fbSet.main = pass.readsAndWrites(fbSet.main);
            pass.executes(() -> {
                GpuBufferSlice fog = RenderSystem.getShaderFog();
                for (IRenderer renderer : this.worldLastRenderers) {
                    profiler.push(renderer.getProfilerSectionSupplier());
                    renderer.onRenderWorldLastAdvanced((RenderTarget)handleMain.get(), posMatrix, projMatrix, frustum, camera, buffers, profiler);
                    renderer.onRenderWorldLast(posMatrix, projMatrix);
                    profiler.pop();
                }
                RenderSystem.setShaderFog((GpuBufferSlice)fog);
            });
            if (!this.worldLastRenderers.isEmpty()) {
                pass.disableCulling();
            }
        }
        profiler.pop();
    }

    @ApiStatus.Internal
    public void onRegisterSpecialGuiRenderer(GuiRenderer guiRenderer, MultiBufferSource.BufferSource immediate, Minecraft mc, ImmutableMap.Builder<Class<? extends PictureInPictureRenderState>, PictureInPictureRendererPool<?>> builder) {
        MaLiLib.LOGGER.warn("onRegisterSpecialGuiRenderer():");
        if (!this.specialGuiRenderers.isEmpty()) {
            for (IRenderer renderer : this.specialGuiRenderers) {
                MaLiLib.LOGGER.warn("onRegisterSpecialGuiRenderer(): render for [{}]", (Object)renderer.getClass().getName());
                renderer.onRegisterSpecialGuiRenderer(guiRenderer, immediate, mc, builder);
            }
        }
    }
}

