/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListBase;
import fi.dy.masa.malilib.gui.widgets.WidgetListEntryBase;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;

public abstract class GuiListBase<TYPE, WIDGET extends WidgetListEntryBase<TYPE>, WIDGETLIST extends WidgetListBase<TYPE, WIDGET>>
extends GuiBase {
    private int listX;
    private int listY;
    private WIDGETLIST widget;

    protected GuiListBase(int listX, int listY) {
        this.setListPosition(listX, listY);
    }

    protected void setListPosition(int listX, int listY) {
        this.listX = listX;
        this.listY = listY;
    }

    protected int getListX() {
        return this.listX;
    }

    protected int getListY() {
        return this.listY;
    }

    protected abstract WIDGETLIST createListWidget(int var1, int var2);

    protected abstract int getBrowserWidth();

    protected abstract int getBrowserHeight();

    @Nullable
    protected ISelectionListener<TYPE> getSelectionListener() {
        return null;
    }

    @Nullable
    protected WIDGETLIST getListWidget() {
        if (this.widget == null) {
            this.reCreateListWidget();
        }
        return this.widget;
    }

    protected void reCreateListWidget() {
        this.widget = this.createListWidget(this.listX, this.listY);
    }

    @Override
    public void initGui() {
        super.initGui();
        if (this.getListWidget() != null) {
            ((WidgetListBase)this.getListWidget()).setSize(this.getBrowserWidth(), this.getBrowserHeight());
            ((WidgetListBase)this.getListWidget()).initGui();
        }
    }

    public void removed() {
        super.removed();
        if (this.getListWidget() != null) {
            this.getListWidget().removed();
        }
    }

    @Override
    public boolean onMouseClicked(MouseButtonEvent click, boolean doubleClick) {
        if (super.onMouseClicked(click, doubleClick)) {
            return true;
        }
        return this.getListWidget() != null && ((WidgetListBase)this.getListWidget()).onMouseClicked(click, doubleClick);
    }

    @Override
    public boolean onMouseReleased(MouseButtonEvent click) {
        if (super.onMouseReleased(click)) {
            return true;
        }
        return this.getListWidget() != null && ((WidgetListBase)this.getListWidget()).onMouseReleased(click);
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        return this.getListWidget() != null && ((WidgetListBase)this.getListWidget()).onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Override
    public boolean onKeyTyped(KeyEvent input) {
        if (input.key() != 256 && super.onKeyTyped(input)) {
            return true;
        }
        if (this.getListWidget() != null && ((WidgetListBase)this.getListWidget()).onKeyTyped(input)) {
            return true;
        }
        return input.key() == 256 && super.onKeyTyped(input);
    }

    @Override
    public boolean onCharTyped(CharacterEvent input) {
        if (super.onCharTyped(input)) {
            return true;
        }
        if (this.getListWidget() != null && ((WidgetListBase)this.getListWidget()).onCharTyped(input)) {
            return true;
        }
        return super.onCharTyped(input);
    }

    @Override
    public void resize(Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
        if (this.getListWidget() != null) {
            ((GuiBase)this.getListWidget()).resize(mc, width, height);
        }
    }

    @Override
    public void drawContents(GuiGraphics drawContext, int mouseX, int mouseY, float partialTicks) {
        if (this.getListWidget() != null) {
            ((WidgetListBase)this.getListWidget()).drawContents(drawContext, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void drawHoveredWidget(GuiGraphics drawContext, int mouseX, int mouseY) {
        super.drawHoveredWidget(drawContext, mouseX, mouseY);
        if (this.getListWidget() != null && this.shouldRenderHoverStuff()) {
            ((GuiBase)this.getListWidget()).drawHoveredWidget(drawContext, mouseX, mouseY);
            ((GuiBase)this.getListWidget()).drawButtonHoverTexts(drawContext, mouseX, mouseY, 0.0f);
        }
    }
}

