/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.hotkeys;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public enum KeyAction implements IConfigOptionListEntry,
StringRepresentable
{
    PRESS("press", "malilib.label.key_action.press"),
    RELEASE("release", "malilib.label.key_action.release"),
    BOTH("both", "malilib.label.key_action.both");

    public static final StringRepresentable.EnumCodec<KeyAction> CODEC;
    public static final StreamCodec<ByteBuf, KeyAction> PACKET_CODEC;
    public static final ImmutableList<KeyAction> VALUES;
    private final String configString;
    private final String translationKey;

    private KeyAction(String configString, String translationKey) {
        this.configString = configString;
        this.translationKey = translationKey;
    }

    public String getSerializedName() {
        return this.configString;
    }

    @Override
    public String getStringValue() {
        return this.configString;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.translate(this.translationKey, new Object[0]);
    }

    @Override
    public IConfigOptionListEntry cycle(boolean forward) {
        int id = this.ordinal();
        if (forward) {
            if (++id >= KeyAction.values().length) {
                id = 0;
            }
        } else if (--id < 0) {
            id = KeyAction.values().length - 1;
        }
        return KeyAction.values()[id % KeyAction.values().length];
    }

    @Override
    public KeyAction fromString(String name) {
        return KeyAction.fromStringStatic(name);
    }

    public static KeyAction fromStringStatic(String name) {
        for (KeyAction action : KeyAction.values()) {
            if (!action.configString.equalsIgnoreCase(name)) continue;
            return action;
        }
        return PRESS;
    }

    static {
        CODEC = StringRepresentable.fromEnum(KeyAction::values);
        PACKET_CODEC = ByteBufCodecs.STRING_UTF8.map(KeyAction::fromStringStatic, KeyAction::getSerializedName);
        VALUES = ImmutableList.copyOf((Object[])KeyAction.values());
    }
}

