/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.MaLiLibReference;
import fi.dy.masa.malilib.event.InitializationHandler;
import fi.dy.masa.malilib.event.TickHandler;
import fi.dy.masa.malilib.event.WorldLoadHandler;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.test.ConfigTestEnum;
import fi.dy.masa.malilib.test.TestSelector;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MixinMinecraftClient {
    @Shadow
    public ClientLevel level;
    @Unique
    private ClientLevel worldBefore;

    @Inject(method={"<init>(Lnet/minecraft/client/main/GameConfig;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/LevelStorageSource;parseValidator(Ljava/nio/file/Path;)Lnet/minecraft/world/level/validation/DirectoryValidator;")})
    private void malilib_onPreGameInit(GameConfig args, CallbackInfo ci, @Local Path runDir) {
        ((InitializationHandler)InitializationHandler.getInstance()).onPreGameInit(runDir);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/main/GameConfig;)V"}, at={@At(value="RETURN")})
    private void malilib_onInitComplete(GameConfig args, CallbackInfo ci) {
        ((InitializationHandler)InitializationHandler.getInstance()).onGameInitDone();
    }

    @Inject(method={"doWorldLoad(Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/server/packs/repository/PackRepository;Lnet/minecraft/server/WorldStem;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/progress/LevelLoadListener;compose(Lnet/minecraft/server/level/progress/LevelLoadListener;Lnet/minecraft/server/level/progress/LevelLoadListener;)Lnet/minecraft/server/level/progress/LevelLoadListener;", shift=At.Shift.BEFORE)})
    private void malilib_onStartIntegratedServer(LevelStorageSource.LevelStorageAccess session, PackRepository dataPackManager, WorldStem saveLoader, boolean newWorld, CallbackInfo ci) {
        MaLiLib.debugLog("malilib_onStartIntegratedServer(): Get DynamicRegistry from IntegratedServer", new Object[0]);
        ((WorldLoadHandler)WorldLoadHandler.getInstance()).onWorldLoadImmutable(saveLoader.registries().compositeAccess());
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void onPostKeyboardInput(CallbackInfo ci) {
        KeybindMulti.reCheckPressedKeys();
        TickHandler.getInstance().onClientTick((Minecraft)this);
    }

    @Inject(method={"setLevel(Lnet/minecraft/client/multiplayer/ClientLevel;)V"}, at={@At(value="HEAD")})
    private void onLoadWorldPre(ClientLevel worldClientIn, CallbackInfo ci) {
        if (this.level != null) {
            this.worldBefore = this.level;
            ((WorldLoadHandler)WorldLoadHandler.getInstance()).onWorldLoadPre(this.level, worldClientIn, (Minecraft)this);
        }
    }

    @Inject(method={"setLevel(Lnet/minecraft/client/multiplayer/ClientLevel;)V"}, at={@At(value="RETURN")})
    private void onLoadWorldPost(ClientLevel worldClientIn, CallbackInfo ci) {
        if (this.worldBefore != null) {
            ((WorldLoadHandler)WorldLoadHandler.getInstance()).onWorldLoadPost(this.worldBefore, worldClientIn, (Minecraft)this);
            this.worldBefore = null;
        }
    }

    @Inject(method={"clearClientLevel(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="HEAD")})
    private void onReconfigurationPre(Screen screen, CallbackInfo ci) {
        this.worldBefore = this.level;
        ((WorldLoadHandler)WorldLoadHandler.getInstance()).onWorldLoadPre(this.worldBefore, null, (Minecraft)this);
    }

    @Inject(method={"clearClientLevel(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="RETURN")})
    private void onReconfigurationPost(Screen screen, CallbackInfo ci) {
        ((WorldLoadHandler)WorldLoadHandler.getInstance()).onWorldLoadPost(this.worldBefore, null, (Minecraft)this);
        this.worldBefore = null;
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at={@At(value="HEAD")})
    private void onDisconnectPre(Screen screen, boolean bl, CallbackInfo ci) {
        this.worldBefore = this.level;
        ((WorldLoadHandler)WorldLoadHandler.getInstance()).onWorldLoadPre(this.worldBefore, null, (Minecraft)this);
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at={@At(value="RETURN")})
    private void onDisconnectPost(Screen screen, boolean bl, CallbackInfo ci) {
        ((WorldLoadHandler)WorldLoadHandler.getInstance()).onWorldLoadPost(this.worldBefore, null, (Minecraft)this);
        this.worldBefore = null;
    }

    @Inject(method={"startAttack()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onLeftClickMouse(CallbackInfoReturnable<Boolean> cir) {
        if (MaLiLibReference.DEBUG_MODE && MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && ConfigTestEnum.TEST_WALLS_HOTKEY.getBooleanValue()) {
            TestSelector.INSTANCE.select(false);
            cir.cancel();
            return;
        }
    }

    @Inject(method={"startUseItem()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRightClickMouse(CallbackInfo ci) {
        if (MaLiLibReference.DEBUG_MODE && MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && ConfigTestEnum.TEST_WALLS_HOTKEY.getBooleanValue()) {
            TestSelector.INSTANCE.select(true);
            ci.cancel();
            return;
        }
    }
}

