/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render.special;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.render.special.MaLiLibBlockStateModelGuiElement;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Deprecated
public class MaLiLibBlockModelGuiElementRenderer
extends PictureInPictureRenderer<MaLiLibBlockStateModelGuiElement> {
    BlockRenderDispatcher blockRenderManager;
    Minecraft mc = Minecraft.getInstance();

    public MaLiLibBlockModelGuiElementRenderer(MultiBufferSource.BufferSource immediate, BlockRenderDispatcher blockRenderManager) {
        super(immediate);
        this.blockRenderManager = blockRenderManager;
    }

    public Class<MaLiLibBlockStateModelGuiElement> getRenderStateClass() {
        return MaLiLibBlockStateModelGuiElement.class;
    }

    protected void render(MaLiLibBlockStateModelGuiElement state, PoseStack matrices) {
        if (state.state().getRenderShape() == RenderShape.MODEL) {
            BlockStateModel model = this.blockRenderManager.getBlockModel(state.state());
            ChunkSectionLayer layer = ItemBlockRenderTypes.getChunkRenderType((BlockState)state.state());
            RenderType renderLayer = layer == ChunkSectionLayer.TRANSLUCENT ? Sheets.translucentItemSheet() : Sheets.cutoutBlockSheet();
            BufferBuilder builder = (BufferBuilder)this.bufferSource.getBuffer(renderLayer);
            matrices.pushPose();
            this.setupTransforms(matrices, state.x0(), state.y0(), state.size(), state.zLevel(), state.scale());
            this.renderModel(model, matrices, state.state(), builder);
            try {
                MeshData meshData = builder.build();
                if (meshData != null) {
                    renderLayer.draw(meshData);
                    meshData.close();
                }
            }
            catch (Exception err) {
                MaLiLib.LOGGER.error("MaLiLibBlockModelGuiElementRenderer: Exception drawing block model; {}", (Object)err.getLocalizedMessage());
            }
            matrices.popPose();
        }
    }

    protected String getTextureLabel() {
        return "malilib:block_model";
    }

    private void setupTransforms(PoseStack matrices, int x, int y, int size, float zLevel, float scale) {
        matrices.translate((float)(x + size / 2), (float)(y + size / 2), (float)((double)zLevel + 100.0));
        matrices.scale((float)size, (float)(-size), (float)size);
        Quaternionf rot = new Quaternionf().rotationXYZ(0.5235988f, 3.9269907f, 0.0f);
        matrices.mulPose((Quaternionfc)rot);
        matrices.scale(scale, scale, scale);
    }

    private void renderModel(BlockStateModel model, PoseStack matrices, BlockState state, BufferBuilder builder) {
        SingleThreadedRandomSource random = new SingleThreadedRandomSource(0L);
        List parts = model.collectParts((RandomSource)random);
        int l = LightTexture.pack((int)15, (int)15);
        if (this.mc.level == null) {
            return;
        }
        this.blockRenderManager.renderBatched(state, BlockPos.ZERO, (BlockAndTintGetter)this.mc.level, matrices, (VertexConsumer)builder, false, parts);
    }

    private void renderQuads(List<BakedQuad> quads, float[] brightness, int[] light, PoseStack matrices, Level world, BlockPos pos, BlockState state, BufferBuilder builder) {
        for (BakedQuad quad : quads) {
            this.renderQuad(quad, brightness, light, matrices, world, pos, state, builder);
        }
    }

    private void renderQuad(BakedQuad quad, float[] brightness, int[] light, PoseStack matrices, Level world, BlockPos pos, BlockState state, BufferBuilder builder) {
        float b;
        float g;
        float r;
        if (quad.isTinted()) {
            int color = this.mc.getBlockColors().getColor(state, (BlockAndTintGetter)world, pos, quad.tintIndex());
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        } else {
            r = 1.0f;
            g = 1.0f;
            b = 1.0f;
        }
        float a = 1.0f;
        builder.putBulkData(matrices.last(), quad, brightness, r, g, b, a, light, OverlayTexture.NO_OVERLAY, false);
    }

    private boolean useMipMap(ChunkSectionLayer layer) {
        return switch (layer) {
            default -> throw new MatchException(null, null);
            case ChunkSectionLayer.SOLID, ChunkSectionLayer.CUTOUT_MIPPED, ChunkSectionLayer.TRANSLUCENT, ChunkSectionLayer.TRIPWIRE -> true;
            case ChunkSectionLayer.CUTOUT -> false;
        };
    }

    private RenderPipeline swapPipeline(ChunkSectionLayer layer) {
        return switch (layer) {
            default -> throw new MatchException(null, null);
            case ChunkSectionLayer.SOLID -> MaLiLibPipelines.SOLID_MASA;
            case ChunkSectionLayer.CUTOUT -> MaLiLibPipelines.CUTOUT_MASA;
            case ChunkSectionLayer.CUTOUT_MIPPED -> MaLiLibPipelines.CUTOUT_MIPPED_MASA;
            case ChunkSectionLayer.TRANSLUCENT -> MaLiLibPipelines.TRANSLUCENT_MASA;
            case ChunkSectionLayer.TRIPWIRE -> MaLiLibPipelines.TRIPWIRE_MASA;
        };
    }

    private AbstractTexture getTexture(ChunkSectionLayer layer) {
        AbstractTexture abstractTexture = RenderUtils.tex().getTexture(TextureAtlas.LOCATION_BLOCKS);
        abstractTexture.setUseMipmaps(this.useMipMap(layer));
        return abstractTexture;
    }
}

