/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.test.ConfigTestEnum;
import fi.dy.masa.malilib.test.TestDataSyncer;
import fi.dy.masa.malilib.test.TestInventoryOverlayHandler;
import fi.dy.masa.malilib.test.TestSelector;
import fi.dy.masa.malilib.test.TestWalls;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtInventory;
import fi.dy.masa.malilib.util.time.TickUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.HappyGhast;
import net.minecraft.world.entity.animal.coppergolem.CopperGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

@ApiStatus.Experimental
public class TestRenderHandler
implements IRenderer {
    private static final TestRenderHandler INSTANCE = new TestRenderHandler();

    public static TestRenderHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void onRenderGameOverlayPostAdvanced(GuiGraphics drawContext, float partialTicks, ProfilerFiller profiler, Minecraft mc) {
        if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue()) {
            if (MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY.getBooleanValue() && MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY.getKeybind().isKeybindHeld()) {
                if (TestInventoryOverlayHandler.getInstance().isNewCode()) {
                    TestInventoryOverlayHandler.getInstance().getRenderContextNew(drawContext, profiler, mc);
                } else {
                    TestInventoryOverlayHandler.getInstance().getRenderContext(drawContext, profiler, mc);
                }
            }
            if (ConfigTestEnum.TEST_TEXT_LINES.getBooleanValue()) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("Test Line 1");
                list.add("Test Line 2");
                list.add("Test Line 3");
                list.add("Test Line 4");
                list.add("Test Line 5");
                if (TickUtils.getInstance().isValid()) {
                    String result = TestRenderHandler.getMeasuredTPS();
                    list.addFirst(result);
                    list.removeLast();
                }
                RenderUtils.renderText(drawContext, 4, 4, MaLiLibConfigs.Test.TEST_CONFIG_FLOAT.getFloatValue(), -2039584, -1605349296, HudAlignment.TOP_LEFT, true, false, true, list);
            }
        }
    }

    @Nonnull
    private static String getMeasuredTPS() {
        String sprintStr;
        float tickRate = TickUtils.getTickRate();
        double clampedTps = TickUtils.getMeasuredTPS();
        double actualTps = TickUtils.getActualTPS();
        double avgMspt = TickUtils.getAvgMSPT();
        double avgTps = TickUtils.getAvgTPS();
        double mspt = TickUtils.getMeasuredMSPT();
        String rst = GuiBase.TXT_RST;
        String preTps = clampedTps >= (double)tickRate ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
        boolean isEstimated = TickUtils.isEstimated();
        boolean isSprinting = TickUtils.isSprinting();
        String string = sprintStr = isSprinting ? "- " + GuiBase.TXT_LIGHT_PURPLE + GuiBase.TXT_BOLD + "Sprinting" + rst : "";
        String preMspt = mspt <= 40.0 ? GuiBase.TXT_GREEN : (mspt <= 45.0 ? GuiBase.TXT_YELLOW : (mspt <= 50.0 ? GuiBase.TXT_GOLD : GuiBase.TXT_RED));
        return isEstimated ? String.format("Server TPS: %s%.1f%s (MSPT [est]: %s%.1f%s) (R: %s%.1f%s, avMS: %.2f, avTPS: %.2f, [actTPS: %.2f]) %s", preTps, clampedTps, rst, preMspt, mspt, rst, GuiBase.TXT_AQUA, Float.valueOf(tickRate), rst, avgMspt, avgTps, actualTps, sprintStr) : String.format("Server TPS: %s%.1f%s MSPT: %s%.1f%s (R: %s%.1f%s, avMS: %.2f, avTPS: %.2f, [actTPS: %.2f]) %s", preTps, clampedTps, rst, preMspt, mspt, rst, GuiBase.TXT_AQUA, Float.valueOf(tickRate), rst, avgMspt, avgTps, actualTps, sprintStr);
    }

    @Override
    public void onRenderWorldPostDebugRender(PoseStack matrices, Frustum frustum, MultiBufferSource.BufferSource immediate, Vec3 camera, ProfilerFiller profiler) {
    }

    @Override
    public void onRenderWorldPreWeather(RenderTarget fb, Matrix4f posMatrix, Matrix4f projMatrix, Frustum frustum, Camera camera, RenderBuffers buffers, ProfilerFiller profiler) {
    }

    @Override
    public void onRenderWorldLastAdvanced(RenderTarget fb, Matrix4f posMatrix, Matrix4f projMatrix, Frustum frustum, Camera camera, RenderBuffers buffers, ProfilerFiller profiler) {
        if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue()) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null) {
                profiler.push("malilib_selector");
                if (TestSelector.INSTANCE.shouldRender()) {
                    TestSelector.INSTANCE.render(posMatrix, projMatrix, profiler, mc);
                }
                profiler.popPush("malilib_targeting_overlay");
                this.renderTargetingOverlay(posMatrix, mc);
                profiler.popPush("malilib_test_walls");
                if (ConfigTestEnum.TEST_WALLS_HOTKEY.getBooleanValue()) {
                    if (TestWalls.INSTANCE.needsUpdate(mc.getCameraEntity(), mc)) {
                        TestWalls.INSTANCE.update(camera, mc.getCameraEntity(), mc);
                    }
                    TestWalls.INSTANCE.render(camera, posMatrix, projMatrix, mc, profiler);
                }
                profiler.pop();
            }
        }
    }

    @Override
    public void onRenderTooltipComponentInsertFirst(Item.TooltipContext context, ItemStack stack, Consumer<Component> list) {
        if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue()) {
            list.accept(StringUtils.translateAsText("malilib.gui.tooltip.test.first", new Object[0]));
        }
    }

    @Override
    public void onRenderTooltipComponentInsertMiddle(Item.TooltipContext context, ItemStack stack, Consumer<Component> list) {
        if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue()) {
            list.accept(StringUtils.translateAsText("malilib.gui.tooltip.test.middle", new Object[0]));
        }
    }

    @Override
    public void onRenderTooltipComponentInsertLast(Item.TooltipContext context, ItemStack stack, Consumer<Component> list) {
        if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue()) {
            list.accept(StringUtils.translateAsText("malilib.gui.tooltip.test.last", new Object[0]));
        }
    }

    @Override
    public void onRenderTooltipLast(GuiGraphics drawContext, ItemStack stack, int x, int y) {
        Item item = stack.getItem();
        ProfilerFiller profiler = Profiler.get();
        if (item instanceof MapItem) {
            if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && GuiBase.isShiftDown()) {
                profiler.push("malilib_map_preview");
                RenderUtils.renderMapPreview(drawContext, stack, x, y, 160, false);
                profiler.pop();
            }
        } else if (stack.getComponents().has(DataComponents.CONTAINER) && InventoryUtils.shulkerBoxHasItems(stack)) {
            if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && GuiBase.isShiftDown()) {
                profiler.push("malilib_shulker_preview");
                RenderUtils.renderShulkerBoxPreview(drawContext, stack, x, y, true);
                profiler.pop();
            }
        } else if (stack.getComponents().has(DataComponents.BUNDLE_CONTENTS) && InventoryUtils.bundleHasItems(stack)) {
            if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && GuiBase.isShiftDown()) {
                profiler.push("malilib_bundle_preview");
                RenderUtils.renderBundlePreview(drawContext, stack, x, y, MaLiLibConfigs.Test.TEST_BUNDLE_PREVIEW_WIDTH.getIntegerValue(), true);
                profiler.pop();
            }
        } else if (stack.is(Items.ENDER_CHEST) && MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && GuiBase.isShiftDown()) {
            Player pe;
            Object object;
            Pair<Entity, CompoundTag> pair;
            PlayerEnderChestContainer inv;
            Minecraft mc = Minecraft.getInstance();
            Level world = WorldUtils.getBestWorld(mc);
            if (mc.player == null || world == null) {
                return;
            }
            Player player = world.getPlayerByUUID(mc.player.getUUID());
            if (player != null && (inv = (pair = TestDataSyncer.getInstance().requestEntity(world, player.getId())) != null && pair.getRight() != null && ((CompoundTag)pair.getRight()).contains("EnderItems") ? InventoryUtils.getPlayerEnderItemsFromNbt((CompoundTag)pair.getRight(), world.registryAccess()) : (pair != null && (object = pair.getLeft()) instanceof Player && !(pe = (Player)object).getEnderChestInventory().isEmpty() ? pe.getEnderChestInventory() : player.getEnderChestInventory())) != null) {
                try (NbtInventory nbtInv = NbtInventory.fromInventory((Container)inv);){
                    ListTag list = nbtInv.toNbtList(world.registryAccess());
                    CompoundTag nbt = new CompoundTag();
                    nbt.put("EnderItems", (Tag)list);
                    RenderUtils.renderNbtItemsPreview(drawContext, stack, nbt, x, y, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Supplier<String> getProfilerSectionSupplier() {
        return () -> "malilib_test";
    }

    private void renderTargetingOverlay(Matrix4f posMatrix, Minecraft mc) {
        Entity entity = mc.getCameraEntity();
        if (entity != null && mc.hitResult != null && mc.hitResult.getType() == HitResult.Type.BLOCK && MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && GuiBase.isCtrlDown()) {
            BlockHitResult hitResult = (BlockHitResult)mc.hitResult;
            Color4f color = Color4f.fromColor(StringUtils.getColor("#C03030F0", 0));
            RenderUtils.renderBlockTargetingOverlay(entity, hitResult.getBlockPos(), hitResult.getDirection(), hitResult.getLocation(), color, posMatrix);
        }
    }

    public static void renderInventoryOverlayOG(GuiGraphics drawContext, InventoryOverlay.Context context, Minecraft mc) {
        LivingEntity entityLivingBase = null;
        BlockEntity be = null;
        Container inv = null;
        CompoundTag nbt = new CompoundTag();
        if (context == null) {
            return;
        }
        if (context.be() != null) {
            be = context.be();
        } else if (context.entity() != null && context.entity() instanceof LivingEntity) {
            entityLivingBase = context.entity();
        }
        if (context.inv() != null) {
            inv = context.inv();
        }
        if (context.nbt() != null) {
            nbt.merge(context.nbt());
        }
        boolean isWolf = entityLivingBase instanceof Wolf || entityLivingBase instanceof HappyGhast || entityLivingBase instanceof CopperGolem;
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int x = xCenter - 26;
        int y = yCenter - 92;
        MaLiLib.LOGGER.error("0: -> inv.type [{}] // nbt.type [{}]", (Object)(context.inv() != null ? InventoryOverlay.getInventoryType(context.inv()) : null), context.nbt() != null ? InventoryOverlay.getInventoryType(context.nbt()) : null);
        MaLiLib.LOGGER.error("1: -> inv.size [{}] // inv.isEmpty [{}]", (Object)(context.inv() != null ? context.inv().getContainerSize() : -1), (Object)(context.inv() != null ? (Comparable<Boolean>)Boolean.valueOf(context.inv().isEmpty()) : (Comparable<Boolean>)Integer.valueOf(-1)));
        if (inv != null && inv.getContainerSize() > 0) {
            Block block;
            boolean isHorse = entityLivingBase instanceof AbstractHorse;
            int totalSlots = isHorse ? inv.getContainerSize() - 1 : inv.getContainerSize();
            int firstSlot = isHorse ? 1 : 0;
            InventoryOverlay.InventoryRenderType type = entityLivingBase instanceof Villager ? InventoryOverlay.InventoryRenderType.VILLAGER : InventoryOverlay.getBestInventoryType(inv, nbt, context);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, totalSlots);
            int rows = (int)Math.ceil((double)totalSlots / (double)props.slotsPerRow);
            HashSet<Integer> lockedSlots = new HashSet();
            int xInv = xCenter - props.width / 2;
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            if (entityLivingBase != null) {
                x = xCenter - 55;
                xInv = xCenter + 2;
                yInv = Math.min(yInv, yCenter - 92);
            }
            if (be != null && type == InventoryOverlay.InventoryRenderType.CRAFTER) {
                if (be instanceof CrafterBlockEntity) {
                    CrafterBlockEntity cbe = (CrafterBlockEntity)be;
                    lockedSlots = BlockUtils.getDisabledSlots(cbe);
                } else if (context.nbt() != null) {
                    lockedSlots = NbtBlockUtils.getDisabledSlotsFromNbt(context.nbt());
                }
            }
            if (context.be() != null && (block = context.be().getBlockState().getBlock()) instanceof ShulkerBoxBlock) {
                ShulkerBoxBlock sbb = (ShulkerBoxBlock)block;
                RenderUtils.setShulkerboxBackgroundTintColor(sbb, true);
            }
            MaLiLib.LOGGER.warn("render():0: type [{}] // Nbt Type [{}]", (Object)type.toString(), context.nbt() != null ? InventoryOverlay.getInventoryType(context.nbt()) : "INVALID");
            if (isHorse) {
                SimpleContainer horseInv = new SimpleContainer(2);
                ItemStack horseArmor = ((AbstractHorse)entityLivingBase).getBodyArmorItem();
                horseInv.setItem(0, horseArmor != null && !horseArmor.isEmpty() ? horseArmor : ItemStack.EMPTY);
                horseInv.setItem(1, inv.getItem(0));
                InventoryOverlay.renderInventoryBackground(drawContext, type, xInv, yInv, 1, 2, mc);
                if (type == InventoryOverlay.InventoryRenderType.LLAMA) {
                    InventoryOverlay.renderLlamaArmorBackgroundSlots(drawContext, (Container)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY);
                } else {
                    InventoryOverlay.renderHorseArmorBackgroundSlots(drawContext, (Container)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY);
                }
                InventoryOverlay.renderInventoryStacks(drawContext, type, (Container)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, 1, 0, 2, mc);
                xInv += 36;
            }
            if (totalSlots > 0) {
                InventoryOverlay.renderInventoryBackground(drawContext, type, xInv, yInv, props.slotsPerRow, totalSlots, mc);
                if (type == InventoryOverlay.InventoryRenderType.BREWING_STAND) {
                    InventoryOverlay.renderBrewerBackgroundSlots(drawContext, inv, xInv, yInv);
                }
                InventoryOverlay.renderInventoryStacks(drawContext, type, inv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, props.slotsPerRow, firstSlot, totalSlots, lockedSlots, mc);
            }
        }
        if (isWolf) {
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.WOLF;
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, 2);
            int rows = (int)Math.ceil(2.0 / (double)props.slotsPerRow);
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            x = xCenter - 55;
            int xInv = xCenter + 2;
            yInv = Math.min(yInv, yCenter - 92);
            SimpleContainer wolfInv = new SimpleContainer(2);
            ItemStack wolfArmor = ((Wolf)entityLivingBase).getBodyArmorItem();
            wolfInv.setItem(0, wolfArmor != null && !wolfArmor.isEmpty() ? wolfArmor : ItemStack.EMPTY);
            InventoryOverlay.renderInventoryBackground(drawContext, type, xInv, yInv, 1, 2, mc);
            InventoryOverlay.renderWolfArmorBackgroundSlots(drawContext, (Container)wolfInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY);
            InventoryOverlay.renderInventoryStacks(drawContext, type, (Container)wolfInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, 1, 0, 2, mc);
        }
        if (entityLivingBase != null) {
            InventoryOverlay.renderEquipmentOverlayBackground(drawContext, x, y, entityLivingBase);
            InventoryOverlay.renderEquipmentStacks(drawContext, entityLivingBase, x, y, mc);
        }
    }
}

