/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.CatVariants;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.ChickenVariants;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.CowVariants;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.PigVariants;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.frog.FrogVariants;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariants;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariants;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.tuple.Pair;

public class EntityUtils {
    @Nullable
    public static Entity getCameraEntity() {
        Minecraft mc = Minecraft.getInstance();
        Entity entity = mc.getCameraEntity();
        if (entity == null) {
            entity = mc.player;
        }
        return entity;
    }

    public static boolean hasTurtleHelmetEquipped(Player player) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.getItemBySlot(EquipmentSlot.HEAD);
        return !stack.isEmpty() && stack.is(Items.TURTLE_HELMET);
    }

    @Nullable
    public static Axolotl.Variant getAxolotlVariantFromComponents(@Nonnull Axolotl entity) {
        return (Axolotl.Variant)entity.get(DataComponents.AXOLOTL_VARIANT);
    }

    public static Pair<ResourceKey<CatVariant>, DyeColor> getCatVariantFromComponents(@Nonnull Cat entity) {
        Holder entry = (Holder)entity.get(DataComponents.CAT_VARIANT);
        DyeColor collar = (DyeColor)entity.get(DataComponents.CAT_COLLAR);
        ResourceKey key = entry != null ? entry.unwrapKey().orElse(CatVariants.BLACK) : CatVariants.BLACK;
        return Pair.of((Object)key, (Object)collar);
    }

    @Nullable
    public static ResourceKey<ChickenVariant> getChickenVariantFromComponents(@Nonnull Chicken entity) {
        EitherHolder entry = (EitherHolder)entity.get(DataComponents.CHICKEN_VARIANT);
        return entry != null ? entry.key().orElse(ChickenVariants.DEFAULT) : ChickenVariants.DEFAULT;
    }

    @Nullable
    public static ResourceKey<CowVariant> getCowVariantFromComponents(@Nonnull Cow entity) {
        Holder entry = (Holder)entity.get(DataComponents.COW_VARIANT);
        return entry != null ? entry.unwrapKey().orElse(CowVariants.DEFAULT) : CowVariants.DEFAULT;
    }

    @Nullable
    public static MushroomCow.Variant getMooshroomVariantFromComponents(@Nonnull MushroomCow entity) {
        return (MushroomCow.Variant)entity.get(DataComponents.MOOSHROOM_VARIANT);
    }

    @Nullable
    public static Fox.Variant getFoxVariantFromComponents(@Nonnull Fox entity) {
        return (Fox.Variant)entity.get(DataComponents.FOX_VARIANT);
    }

    public static ResourceKey<FrogVariant> getFrogVariantFromComponents(@Nonnull Frog entity) {
        Holder entry = (Holder)entity.get(DataComponents.FROG_VARIANT);
        return entry != null ? entry.unwrapKey().orElse(FrogVariants.TEMPERATE) : FrogVariants.TEMPERATE;
    }

    public static Pair<Variant, Markings> getHorseVariantFromComponents(@Nonnull Horse entity) {
        Variant color = (Variant)entity.get(DataComponents.HORSE_VARIANT);
        if (color == null) {
            color = Variant.WHITE;
        }
        Markings marking = Markings.byId((int)((color.getId() & 0xFF00) >> 8));
        return Pair.of((Object)color, (Object)marking);
    }

    @Nullable
    public static Parrot.Variant getParrotVariantFromComponents(@Nonnull Parrot entity) {
        return (Parrot.Variant)entity.get(DataComponents.PARROT_VARIANT);
    }

    public static ResourceKey<PigVariant> getPigVariantFromComponents(@Nonnull Pig entity) {
        Holder entry = (Holder)entity.get(DataComponents.PIG_VARIANT);
        return entry != null ? entry.unwrapKey().orElse(PigVariants.DEFAULT) : PigVariants.DEFAULT;
    }

    @Nullable
    public static Rabbit.Variant getRabbitVariantFromComponents(@Nonnull Rabbit entity) {
        return (Rabbit.Variant)entity.get(DataComponents.RABBIT_VARIANT);
    }

    @Nullable
    public static Llama.Variant getLlamaVariantFromComponents(@Nonnull Llama entity) {
        return (Llama.Variant)entity.get(DataComponents.LLAMA_VARIANT);
    }

    @Nullable
    public static TropicalFish.Pattern getFishVariantFromComponents(@Nonnull TropicalFish entity) {
        return (TropicalFish.Pattern)entity.get(DataComponents.TROPICAL_FISH_PATTERN);
    }

    public static Pair<ResourceKey<WolfVariant>, DyeColor> getWolfVariantFromComponents(@Nonnull Wolf entity) {
        ResourceKey variantKey;
        Holder entry = (Holder)entity.get(DataComponents.WOLF_VARIANT);
        DyeColor collar = (DyeColor)entity.get(DataComponents.WOLF_COLLAR);
        ResourceKey resourceKey = variantKey = entry != null ? entry.unwrapKey().orElse(WolfVariants.DEFAULT) : WolfVariants.DEFAULT;
        if (collar == null) {
            collar = DyeColor.RED;
        }
        return Pair.of((Object)variantKey, (Object)collar);
    }

    public static ResourceKey<WolfSoundVariant> getWolfSoundTypeFromComponents(@Nonnull Wolf entity) {
        Holder entry = (Holder)entity.get(DataComponents.WOLF_SOUND_VARIANT);
        return entry != null ? entry.unwrapKey().orElse(WolfSoundVariants.CLASSIC) : WolfSoundVariants.CLASSIC;
    }

    @Nullable
    public static Salmon.Variant getSalmonVariantFromComponents(@Nonnull Salmon entity) {
        return (Salmon.Variant)entity.get(DataComponents.SALMON_SIZE);
    }

    @Nullable
    public static DyeColor getSheepVariantFromComponents(@Nonnull Sheep entity) {
        return (DyeColor)entity.get(DataComponents.SHEEP_COLOR);
    }
}

