/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data;

import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.data.tag.converter.DataConverterNbt;
import fi.dy.masa.malilib.util.data.tag.util.DataTypeUtils;
import fi.dy.masa.malilib.util.nbt.INbtEntityInvoker;
import fi.dy.masa.malilib.util.nbt.NbtView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.CatVariants;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.ChickenVariants;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.CowVariants;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.PigVariants;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.frog.FrogVariants;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariants;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.block.WeatheringCopper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class DataEntityUtils {
    public static CompoundData invokeEntityDataTagNoPassengers(Entity entity, int id) {
        return ((INbtEntityInvoker)entity).malilib$getDataTagWithId(id).orElseGet(CompoundData::new);
    }

    @Nullable
    public static EntityType<?> getEntityType(@Nonnull CompoundData data) {
        if (data.contains("id", 8)) {
            return BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.tryParse((String)data.getString("id"))).orElse(null);
        }
        return null;
    }

    public CompoundData setEntityType(EntityType<?> type, @Nullable CompoundData dataIn) {
        CompoundData data = new CompoundData();
        ResourceLocation id = EntityType.getKey(type);
        if (id != null) {
            if (dataIn != null) {
                dataIn.putString("id", id.toString());
                return dataIn;
            }
            data.putString("id", id.toString());
        }
        return data;
    }

    public static Holder.Reference<EntityType<?>> getEntityTypeEntry(ResourceLocation id, @Nonnull RegistryAccess registry) {
        try {
            return (Holder.Reference)registry.lookupOrThrow(BuiltInRegistries.ENTITY_TYPE.key()).get(id).orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static AttributeMap getAttributes(@Nonnull CompoundData data) {
        EntityType<?> type = DataEntityUtils.getEntityType(data);
        if (type != null && data.contains("attributes", 9)) {
            AttributeMap container = new AttributeMap(DefaultAttributes.getSupplier(type));
            ListData list = data.getList("attributes");
            container.apply((List)AttributeInstance.Packed.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)DataConverterNbt.toVanillaList(list)).getPartialOrThrow());
            return container;
        }
        return null;
    }

    public static double getAttributeBaseValue(@Nonnull CompoundData data, Holder<Attribute> attribute) {
        AttributeMap attributes = DataEntityUtils.getAttributes(data);
        if (attributes != null) {
            return attributes.getBaseValue(attribute);
        }
        return -1.0;
    }

    public static double getAttributeValue(@Nonnull CompoundData data, Holder<Attribute> attribute) {
        AttributeMap attributes = DataEntityUtils.getAttributes(data);
        if (attributes != null) {
            return attributes.getValue(attribute);
        }
        return -1.0;
    }

    public static Pair<Double, Double> getHealth(@Nonnull CompoundData data) {
        double maxHealth;
        double health = 0.0;
        if (data.contains("Health", 5)) {
            health = data.getFloat("Health");
        }
        if ((maxHealth = DataEntityUtils.getAttributeValue(data, (Holder<Attribute>)Attributes.MAX_HEALTH)) < 0.0) {
            maxHealth = 20.0;
        }
        return Pair.of((Object)health, (Object)maxHealth);
    }

    public static Pair<Double, Double> getSpeedAndJumpStrength(@Nonnull CompoundData data) {
        AttributeMap container = DataEntityUtils.getAttributes(data);
        double moveSpeed = 0.0;
        double jumpStrength = 0.0;
        if (container != null) {
            moveSpeed = container.getValue(Attributes.MOVEMENT_SPEED);
            jumpStrength = container.getValue(Attributes.JUMP_STRENGTH);
        }
        return Pair.of((Object)moveSpeed, (Object)jumpStrength);
    }

    @Nullable
    public static Component getCustomName(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        if (data.contains("CustomName", 10)) {
            return data.getCodec("CustomName", ComponentSerialization.CODEC, (DynamicOps<Tag>)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE)).orElse(null);
        }
        return null;
    }

    public static CompoundData setCustomNameToDataTag(@Nonnull Component name, @Nonnull RegistryAccess registry, @Nullable CompoundData dataIn, String key) {
        CompoundData data;
        CompoundData compoundData = data = dataIn != null ? dataIn.copy() : new CompoundData();
        if (key == null || key.isEmpty()) {
            key = "CustomName";
        }
        return data.putCodec(key, ComponentSerialization.CODEC, (DynamicOps<Tag>)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), name);
    }

    public static Map<Holder<MobEffect>, MobEffectInstance> getActiveStatusEffects(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        HashMap statusEffects = Maps.newHashMap();
        if (data.contains("active_effects", 9)) {
            List list = data.getCodec("active_effects", MobEffectInstance.CODEC.listOf(), (DynamicOps<Tag>)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE)).orElse(List.of());
            for (MobEffectInstance instance : list) {
                statusEffects.put(instance.getEffect(), instance);
            }
        }
        return statusEffects;
    }

    @Nullable
    public static EntityEquipment getEquipmentSlots(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        if (data.contains("equipment", 10)) {
            CompoundData comp = data.getCompound("equipment");
            Optional opt = EntityEquipment.CODEC.parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)DataConverterNbt.toVanillaCompound(comp)).result();
            if (opt.isPresent()) {
                return (EntityEquipment)opt.get();
            }
        }
        return null;
    }

    @Nullable
    public static BaseData setEquipmentSlotsToDataTag(@Nonnull EntityEquipment equipment, @Nonnull RegistryAccess registry) {
        try {
            return DataConverterNbt.fromVanillaNbt((Tag)EntityEquipment.CODEC.encodeStart((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)equipment).getOrThrow());
        }
        catch (Exception err) {
            MaLiLib.LOGGER.warn("setEquipmentSlotsToNbt(): Failed to parse Equipment Slots Object; {}", (Object)err.getMessage());
            return null;
        }
    }

    public static NonNullList<ItemStack> getHandItems(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        NonNullList list = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        EntityEquipment equipment = DataEntityUtils.getEquipmentSlots(data, registry);
        if (equipment != null) {
            ItemStack mainHand = equipment.get(EquipmentSlot.MAINHAND);
            ItemStack offHand = equipment.get(EquipmentSlot.OFFHAND);
            if (mainHand != null && !mainHand.isEmpty()) {
                list.set(0, (Object)mainHand.copy());
            }
            if (offHand != null && !offHand.isEmpty()) {
                list.set(1, (Object)offHand.copy());
            }
        }
        return list;
    }

    public static NonNullList<ItemStack> getHumanoidArmor(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        NonNullList list = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
        EntityEquipment equipment = DataEntityUtils.getEquipmentSlots(data, registry);
        if (equipment != null) {
            ItemStack head = equipment.get(EquipmentSlot.HEAD);
            ItemStack chest = equipment.get(EquipmentSlot.CHEST);
            ItemStack legs = equipment.get(EquipmentSlot.LEGS);
            ItemStack feet = equipment.get(EquipmentSlot.FEET);
            if (head != null && !head.isEmpty()) {
                list.set(0, (Object)head.copy());
            }
            if (chest != null && !chest.isEmpty()) {
                list.set(1, (Object)chest.copy());
            }
            if (legs != null && !legs.isEmpty()) {
                list.set(2, (Object)legs.copy());
            }
            if (feet != null && !feet.isEmpty()) {
                list.set(3, (Object)feet.copy());
            }
        }
        return list;
    }

    public static NonNullList<ItemStack> getHorseEquipment(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        NonNullList list = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        EntityEquipment equipment = DataEntityUtils.getEquipmentSlots(data, registry);
        if (equipment != null) {
            ItemStack bodyArmor = equipment.get(EquipmentSlot.BODY);
            ItemStack saddle = equipment.get(EquipmentSlot.SADDLE);
            if (bodyArmor != null && !bodyArmor.isEmpty()) {
                list.set(0, (Object)bodyArmor.copy());
            }
            if (saddle != null && !saddle.isEmpty()) {
                list.set(1, (Object)saddle.copy());
            }
        }
        return list;
    }

    public static NonNullList<ItemStack> getAllEquipment(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        NonNullList list = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
        EntityEquipment equipment = DataEntityUtils.getEquipmentSlots(data, registry);
        if (equipment != null) {
            ItemStack mainHand = equipment.get(EquipmentSlot.MAINHAND);
            ItemStack offHand = equipment.get(EquipmentSlot.OFFHAND);
            ItemStack head = equipment.get(EquipmentSlot.HEAD);
            ItemStack chest = equipment.get(EquipmentSlot.CHEST);
            ItemStack legs = equipment.get(EquipmentSlot.LEGS);
            ItemStack feet = equipment.get(EquipmentSlot.FEET);
            ItemStack bodyArmor = equipment.get(EquipmentSlot.BODY);
            ItemStack saddle = equipment.get(EquipmentSlot.SADDLE);
            if (mainHand != null && !mainHand.isEmpty()) {
                list.set(0, (Object)mainHand.copy());
            }
            if (offHand != null && !offHand.isEmpty()) {
                list.set(1, (Object)offHand.copy());
            }
            if (head != null && !head.isEmpty()) {
                list.set(2, (Object)head.copy());
            }
            if (chest != null && !chest.isEmpty()) {
                list.set(3, (Object)chest.copy());
            }
            if (legs != null && !legs.isEmpty()) {
                list.set(4, (Object)legs.copy());
            }
            if (feet != null && !feet.isEmpty()) {
                list.set(5, (Object)feet.copy());
            }
            if (bodyArmor != null && !bodyArmor.isEmpty()) {
                list.set(6, (Object)bodyArmor.copy());
            }
            if (saddle != null && !saddle.isEmpty()) {
                list.set(7, (Object)saddle.copy());
            }
        }
        return list;
    }

    public static Pair<UUID, Boolean> getTamableOwner(@Nonnull CompoundData data) {
        UUID owner = Util.NIL_UUID;
        boolean sitting = false;
        if (data.contains("Owner", 11)) {
            owner = DataTypeUtils.getUUIDCodec(data, "Owner");
        }
        if (data.contains("Sitting", 1)) {
            sitting = data.getBoolean("Sitting");
        }
        return Pair.of((Object)owner, (Object)sitting);
    }

    public static Pair<Integer, Integer> getAge(@Nonnull CompoundData data) {
        int breedingAge = 0;
        int forcedAge = 0;
        if (data.contains("Age", 3)) {
            breedingAge = data.getInt("Age");
        }
        if (data.contains("ForcedAge", 3)) {
            forcedAge = data.getInt("ForcedAge");
        }
        return Pair.of((Object)breedingAge, (Object)forcedAge);
    }

    @Nullable
    public static MerchantOffers getTradeOffers(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        if (data.contains("Offers", 9)) {
            return data.getCodec("Offers", MerchantOffers.CODEC, (DynamicOps<Tag>)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE)).orElse(null);
        }
        return null;
    }

    @Nullable
    public static VillagerData getVillagerData(@Nonnull CompoundData data) {
        if (data.contains("VillagerData", 10)) {
            return data.getCodec("VillagerData", VillagerData.CODEC).orElse(null);
        }
        return null;
    }

    public static Pair<Integer, UUID> getZombieConversionTimer(@Nonnull CompoundData data) {
        int timer = -1;
        UUID player = Util.NIL_UUID;
        if (data.contains("ConversionTime", 3)) {
            timer = data.getInt("ConversionTime");
        }
        if (data.contains("ConversionPlayer", 11)) {
            player = DataTypeUtils.getUUIDCodec(data, "ConversionPlayer");
        }
        return Pair.of((Object)timer, (Object)player);
    }

    public static Pair<Integer, Integer> getDrownedConversionTimer(@Nonnull CompoundData data) {
        int drowning = -1;
        int inWater = -1;
        if (data.contains("DrownedConversionTime", 3)) {
            drowning = data.getInt("DrownedConversionTime");
        }
        if (data.contains("InWaterTime", 3)) {
            inWater = data.getInt("InWaterTime");
        }
        return Pair.of((Object)drowning, (Object)inWater);
    }

    public static int getStrayConversionTime(@Nonnull CompoundData data) {
        if (data.contains("StrayConversionTime", 3)) {
            return data.getInt("StrayConversionTime");
        }
        return -1;
    }

    @Nullable
    public static Leashable.LeashData getLeashData(@Nonnull CompoundData data) {
        if (data.contains("leash", 10)) {
            return data.getCodec("leash", Leashable.LeashData.CODEC).orElse(null);
        }
        return null;
    }

    public static Pair<Panda.Gene, Panda.Gene> getPandaGenes(@Nonnull CompoundData data) {
        Panda.Gene mainGene = null;
        Panda.Gene hiddenGene = null;
        if (data.contains("MainGene", 8)) {
            mainGene = data.getCodec("MainGene", Panda.Gene.CODEC).orElse(Panda.Gene.NORMAL);
        }
        if (data.contains("HiddenGene", 8)) {
            hiddenGene = data.getCodec("HiddenGene", Panda.Gene.CODEC).orElse(Panda.Gene.NORMAL);
        }
        return Pair.of((Object)mainGene, hiddenGene);
    }

    public static Pair<Direction, Direction> getItemFrameDirections(@Nonnull CompoundData data) {
        Direction facing = DataTypeUtils.readDirectionFromTag(data, "Facing");
        Direction rotation = null;
        if (data.contains("ItemRotation", 1)) {
            rotation = Direction.from3DDataValue((int)data.getByte("ItemRotation"));
        }
        return Pair.of((Object)facing, rotation);
    }

    public static Pair<Direction, PaintingVariant> getPaintingData(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        Direction facing = DataTypeUtils.readDirectionFromTag(data, "facing");
        Holder variant = null;
        if (data.contains("variant", 8)) {
            variant = PaintingVariant.CODEC.fieldOf("variant").codec().parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)DataConverterNbt.toVanillaCompound(data)).resultOrPartial().orElse(null);
        }
        return Pair.of((Object)facing, variant != null ? (PaintingVariant)variant.value() : null);
    }

    @Nullable
    public static Axolotl.Variant getAxolotlVariant(@Nonnull CompoundData data) {
        if (data.contains("Variant", 3)) {
            return data.getCodec("Variant", Axolotl.Variant.LEGACY_CODEC).orElse(Axolotl.Variant.LUCY);
        }
        return null;
    }

    public static Pair<ResourceKey<CatVariant>, DyeColor> getCatVariant(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        ResourceKey variantKey = null;
        DyeColor collar = null;
        if (data.contains("variant", 8)) {
            Optional variant = CatVariant.CODEC.fieldOf("variant").codec().parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)DataConverterNbt.toVanillaCompound(data)).resultOrPartial();
            variantKey = variant.map(entry -> (ResourceKey)entry.unwrapKey().orElseThrow()).orElse(CatVariants.BLACK);
        }
        if (data.contains("CollarColor", 3)) {
            collar = data.getCodec("CollarColor", DyeColor.LEGACY_ID_CODEC).orElse(DyeColor.RED);
        }
        return Pair.of(variantKey, collar);
    }

    @Nullable
    public static ResourceKey<ChickenVariant> getChickenVariant(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        if (data.contains("variant", 8)) {
            Optional variant = ChickenVariant.CODEC.fieldOf("variant").codec().parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)DataConverterNbt.toVanillaCompound(data)).resultOrPartial();
            return variant.map(entry -> (ResourceKey)entry.unwrapKey().orElseThrow()).orElse(ChickenVariants.DEFAULT);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<CowVariant> getCowVariant(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        if (data.contains("variant", 8)) {
            Optional variant = CowVariant.CODEC.fieldOf("variant").codec().parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)DataConverterNbt.toVanillaCompound(data)).resultOrPartial();
            return variant.map(entry -> (ResourceKey)entry.unwrapKey().orElseThrow()).orElse(CowVariants.DEFAULT);
        }
        return null;
    }

    @Nullable
    public static MushroomCow.Variant getMooshroomVariant(@Nonnull CompoundData data) {
        if (data.contains("Type", 8)) {
            return data.getCodec("Type", MushroomCow.Variant.CODEC).orElse(MushroomCow.Variant.RED);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<FrogVariant> getFrogVariant(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        if (data.contains("variant", 8)) {
            Optional variant = FrogVariant.CODEC.fieldOf("variant").codec().parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)DataConverterNbt.toVanillaCompound(data)).resultOrPartial();
            return variant.map(entry -> (ResourceKey)entry.unwrapKey().orElseThrow()).orElse(FrogVariants.TEMPERATE);
        }
        return null;
    }

    public static Pair<Variant, Markings> getHorseVariant(@Nonnull CompoundData data) {
        Variant color = null;
        Markings marking = null;
        if (data.contains("Variant", 3)) {
            int variant = data.getInt("Variant");
            color = Variant.byId((int)(variant & 0xFF));
            marking = Markings.byId((int)((variant & 0xFF00) >> 8));
        }
        return Pair.of(color, marking);
    }

    @Nullable
    public static Parrot.Variant getParrotVariant(@Nonnull CompoundData data) {
        if (data.contains("Variant", 3)) {
            return data.getCodec("Variant", Parrot.Variant.LEGACY_CODEC).orElse(Parrot.Variant.RED_BLUE);
        }
        return null;
    }

    @Nullable
    public static TropicalFish.Variant getFishVariant(@Nonnull CompoundData data) {
        if (data.contains("Variant", 3)) {
            return data.getCodec("Variant", TropicalFish.Variant.CODEC).orElse(TropicalFish.DEFAULT_VARIANT);
        }
        return null;
    }

    @Nullable
    public static TropicalFish.Pattern getFishPattern(@Nonnull CompoundData data) {
        if (data.contains("Variant", 3)) {
            return data.getCodec("Variant", TropicalFish.Variant.CODEC).orElse(TropicalFish.DEFAULT_VARIANT).pattern();
        }
        if (data.contains("BucketVariantTag", 3)) {
            return TropicalFish.Pattern.byId((int)(data.getInt("BucketVariantTag") & 0xFFFF));
        }
        return null;
    }

    public static Pair<ResourceKey<WolfVariant>, DyeColor> getWolfVariant(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        ResourceKey variantKey = null;
        DyeColor collar = null;
        if (data.contains("variant", 8)) {
            Optional variant = WolfVariant.CODEC.fieldOf("variant").codec().parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)DataConverterNbt.toVanillaCompound(data)).resultOrPartial();
            variantKey = variant.map(entry -> (ResourceKey)entry.unwrapKey().orElseThrow()).orElse(WolfVariants.DEFAULT);
        }
        if (data.contains("CollarColor", 3)) {
            collar = data.getCodec("CollarColor", DyeColor.LEGACY_ID_CODEC).orElse(DyeColor.RED);
        }
        if (variantKey == null) {
            variantKey = WolfVariants.DEFAULT;
        }
        if (collar == null) {
            collar = DyeColor.RED;
        }
        return Pair.of((Object)variantKey, (Object)collar);
    }

    @Nullable
    public static ResourceKey<WolfSoundVariant> getWolfSoundType(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        Holder.Reference soundVariant;
        if (data.contains("sound_variant", 8) && (soundVariant = (Holder.Reference)registry.lookupOrThrow(Registries.WOLF_SOUND_VARIANT).get(ResourceLocation.tryParse((String)data.getString("sound_variant"))).orElse(null)) != null) {
            return soundVariant.key();
        }
        return null;
    }

    @Nullable
    public static DyeColor getSheepColor(@Nonnull CompoundData data) {
        if (data.contains("Color", 3)) {
            return data.getCodec("Color", DyeColor.LEGACY_ID_CODEC).orElse(DyeColor.WHITE);
        }
        return null;
    }

    @Nullable
    public static Rabbit.Variant getRabbitType(@Nonnull CompoundData data) {
        if (data.contains("RabbitType", 3)) {
            return data.getCodec("RabbitType", Rabbit.Variant.LEGACY_CODEC).orElse(Rabbit.Variant.BROWN);
        }
        return null;
    }

    public static Pair<Llama.Variant, Integer> getLlamaType(@Nonnull CompoundData data) {
        Llama.Variant variant = null;
        int strength = -1;
        if (data.contains("Variant", 3)) {
            variant = data.getCodec("Variant", Llama.Variant.LEGACY_CODEC).orElse(Llama.Variant.CREAMY);
        }
        if (data.contains("Strength", 3)) {
            strength = data.getInt("Strength");
        }
        return Pair.of((Object)variant, (Object)strength);
    }

    @Nullable
    public static ResourceKey<PigVariant> getPigVariant(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        if (data.contains("variant", 8)) {
            Optional opt = registry.lookupOrThrow(Registries.PIG_VARIANT).get(ResourceLocation.tryParse((String)data.getString("variant")));
            if (opt.isPresent()) {
                return ((Holder.Reference)opt.get()).key();
            }
            return PigVariants.DEFAULT;
        }
        return null;
    }

    @Nullable
    public static Fox.Variant getFoxVariant(@Nonnull CompoundData data) {
        if (data.contains("Type", 8)) {
            return data.getCodec("Type", Fox.Variant.CODEC).orElse(Fox.Variant.RED);
        }
        return null;
    }

    @Nullable
    public static Salmon.Variant getSalmonVariant(@Nonnull CompoundData data) {
        if (data.contains("type", 8)) {
            return data.getCodec("type", Salmon.Variant.CODEC).orElse(Salmon.Variant.MEDIUM);
        }
        return null;
    }

    public static Pair<Integer, Boolean> getDolphinData(@Nonnull CompoundData data) {
        boolean hasFish = false;
        int moist = -1;
        if (data.contains("Moistness", 3)) {
            moist = data.getInt("Moistness");
        }
        if (data.contains("GotFish", 1)) {
            hasFish = data.getBoolean("GotFish");
        }
        return Pair.of((Object)moist, (Object)hasFish);
    }

    public static Triple<Integer, Integer, Float> getPlayerExp(@Nonnull CompoundData data) {
        int level = -1;
        int total = -1;
        float progress = 0.0f;
        if (data.contains("XpLevel", 3)) {
            level = data.getInt("XpLevel");
        }
        if (data.contains("XpTotal", 3)) {
            total = data.getInt("XpTotal");
        }
        if (data.contains("XpP", 5)) {
            progress = data.getFloat("XpP");
        }
        return Triple.of((Object)level, (Object)total, (Object)Float.valueOf(progress));
    }

    @Nullable
    public static FoodData getPlayerHunger(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        FoodData hunger = null;
        if (data.containsLenient("foodLevel")) {
            hunger = new FoodData();
            NbtView view = NbtView.getReader(data, registry);
            hunger.readAdditionalSaveData(view.getReader());
        }
        return hunger;
    }

    @Nullable
    public static ServerRecipeBook getPlayerRecipeBook(@Nonnull CompoundData data, @Nonnull RecipeManager manager) {
        ServerRecipeBook book = null;
        if (data.contains("recipeBook", 10)) {
            book = new ServerRecipeBook((arg_0, arg_1) -> ((RecipeManager)manager).listDisplaysForRecipe(arg_0, arg_1));
            CompoundTag nbt = DataConverterNbt.toVanillaCompound(data.getCompoundOrDefault("recipeBook", new CompoundData()));
            book.loadUntrusted((ServerRecipeBook.Packed)ServerRecipeBook.Packed.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt).getOrThrow(), key -> manager.byKey(key).isPresent());
        }
        return book;
    }

    public static Pair<BlockPos, Integer> getHomePos(@Nonnull CompoundData data) {
        BlockPos pos = BlockPos.ZERO;
        int radius = -1;
        if (data.containsLenient("home_pos")) {
            pos = data.getCodec("home_pos", BlockPos.CODEC).orElse(BlockPos.ZERO);
        }
        if (data.contains("home_radius", 3)) {
            radius = data.getInt("home_radius");
        }
        return Pair.of((Object)pos, (Object)radius);
    }

    public static Pair<WeatheringCopper.WeatherState, Long> getWeatheringData(@Nonnull CompoundData data) {
        WeatheringCopper.WeatherState level = WeatheringCopper.WeatherState.UNAFFECTED;
        long age = -1L;
        if (data.contains("weather_state", 8)) {
            level = data.getCodec("weather_state", WeatheringCopper.WeatherState.CODEC).orElse(WeatheringCopper.WeatherState.UNAFFECTED);
        }
        if (data.contains("next_weather_age", 4)) {
            age = data.getLong("next_weather_age");
        }
        return Pair.of((Object)level, (Object)age);
    }
}

