/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class ResourceLocation {
    public static final Codec<ResourceLocation> CODEC = RecordCodecBuilder.create(resourceLocationInstance -> resourceLocationInstance.group((App)net.minecraft.resources.ResourceLocation.CODEC.fieldOf("id").forGetter(get -> get.id)).apply((Applicative)resourceLocationInstance, ResourceLocation::new));
    public static final StreamCodec<ByteBuf, ResourceLocation> PACKET_CODEC = ByteBufCodecs.STRING_UTF8.map(ResourceLocation::of, ResourceLocation::toString);
    private final net.minecraft.resources.ResourceLocation id;

    public ResourceLocation(String str) {
        this.id = net.minecraft.resources.ResourceLocation.parse((String)str);
    }

    public ResourceLocation(String name, String path) {
        this.id = net.minecraft.resources.ResourceLocation.fromNamespaceAndPath((String)name, (String)path);
    }

    public ResourceLocation(net.minecraft.resources.ResourceLocation id) {
        this.id = id;
    }

    public static ResourceLocation of(String str) {
        return new ResourceLocation(str);
    }

    public static ResourceLocation of(String name, String path) {
        return new ResourceLocation(name, path);
    }

    public static ResourceLocation ofVanilla(String path) {
        return new ResourceLocation("minecraft", path);
    }

    public static ResourceLocation of(net.minecraft.resources.ResourceLocation id) {
        return new ResourceLocation(id);
    }

    public static List<ResourceLocation> of(List<net.minecraft.resources.ResourceLocation> list) {
        ArrayList<ResourceLocation> newList = new ArrayList<ResourceLocation>();
        list.forEach(id -> newList.add(ResourceLocation.of(id)));
        return newList;
    }

    @Nullable
    public net.minecraft.resources.ResourceLocation getId() {
        return this.id;
    }

    public String getNamespace() {
        return this.id.getNamespace();
    }

    public String getPath() {
        return this.id.getPath();
    }

    public String toTranslationKey() {
        return this.id.getNamespace() + "." + this.id.getPath();
    }

    public String toString() {
        return this.id.toString();
    }
}

