/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.tag.util;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.DataView;
import fi.dy.masa.malilib.util.data.tag.DoubleData;
import fi.dy.masa.malilib.util.data.tag.IntData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.data.tag.converter.DataConverterNbt;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class DataTypeUtils {
    @Nullable
    public static UUID readUuidFromLongs(DataView tag) {
        return DataTypeUtils.readUuidFromLongs(tag, "UUIDM", "UUIDL");
    }

    @Nullable
    public static UUID readUuidFromLongs(DataView tag, String keyM, String keyL) {
        if (tag.contains(keyM, 4) && tag.contains(keyL, 4)) {
            return new UUID(tag.getLong(keyM), tag.getLong(keyL));
        }
        return null;
    }

    public static void writeUuidToLongs(CompoundData tag, UUID uuid) {
        DataTypeUtils.writeUuidToLongs(tag, uuid, "UUIDM", "UUIDL");
    }

    public static void writeUuidToLongs(CompoundData tag, UUID uuid, String keyM, String keyL) {
        tag.putLong(keyM, uuid.getMostSignificantBits());
        tag.putLong(keyL, uuid.getLeastSignificantBits());
    }

    @Nullable
    public static UUID getUUIDCodec(@Nonnull CompoundData data) {
        return DataTypeUtils.getUUIDCodec(data, "UUID");
    }

    @Nullable
    public static UUID getUUIDCodec(@Nonnull CompoundData data, String key) {
        if (data.contains(key, 11)) {
            return data.getCodec(key, UUIDUtil.CODEC).orElse(null);
        }
        return null;
    }

    public static CompoundData putUUIDCodec(@Nonnull CompoundData dataIn, @Nonnull UUID uuid, String key) {
        return dataIn.putCodec(key, UUIDUtil.CODEC, uuid);
    }

    public static CompoundData getOrCreateCompound(CompoundData tagIn, String tagName) {
        CompoundData tag;
        if (tagIn.contains(tagName, 10)) {
            tag = tagIn.getCompound(tagName);
        } else {
            tag = new CompoundData();
            tagIn.put(tagName, tag);
        }
        return tag;
    }

    public static <T> ListData asListTag(Collection<T> values, Function<T, BaseData> tagFactory) {
        ListData list = null;
        for (T val : values) {
            BaseData entry = tagFactory.apply(val);
            if (list == null) {
                list = new ListData();
            }
            list.add(entry);
        }
        return list;
    }

    @Nonnull
    public static CompoundData createBlockPos(@Nonnull BlockPos pos) {
        return DataTypeUtils.writeBlockPos(pos, new CompoundData());
    }

    @Nonnull
    public static CompoundData createBlockPosTag(@Nonnull Vec3i pos) {
        return DataTypeUtils.putVec3i(new CompoundData(), pos);
    }

    public static CompoundData createVec3iTag(Vec3i pos) {
        return DataTypeUtils.putVec3i(new CompoundData(), pos);
    }

    @Nonnull
    public static CompoundData createVec3iToArrayTag(@Nonnull Vec3i pos, String tagName) {
        return DataTypeUtils.writeVec3iToArrayTag(new CompoundData(), tagName, pos);
    }

    @Nonnull
    public static CompoundData createEntityPosition(@Nonnull Vec3 pos) {
        return DataTypeUtils.createEntityPositionToTag(pos);
    }

    @Nonnull
    public static CompoundData createEntityPositionToTag(@Nonnull Vec3 pos) {
        return DataTypeUtils.writeVec3dToListTag(new CompoundData(), "Pos", pos);
    }

    public static CompoundData putVec3i(CompoundData tag, Vec3i pos) {
        tag.putInt("x", pos.getX());
        tag.putInt("y", pos.getY());
        tag.putInt("z", pos.getZ());
        return tag;
    }

    @Nonnull
    public static CompoundData putVec2fCodec(@Nonnull CompoundData tag, @Nonnull Vec2 pos, String key) {
        tag.putCodec(key, Vec2.CODEC, pos);
        return tag;
    }

    @Nonnull
    public static CompoundData putVec3iCodec(@Nonnull CompoundData tag, @Nonnull Vec3i pos, String key) {
        tag.putCodec(key, Vec3i.CODEC, pos);
        return tag;
    }

    @Nonnull
    public static CompoundData putVec3dCodec(@Nonnull CompoundData tag, @Nonnull Vec3 pos, String key) {
        tag.putCodec(key, Vec3.CODEC, pos);
        return tag;
    }

    @Nonnull
    public static CompoundData putPosCodec(@Nonnull CompoundData tag, @Nonnull BlockPos pos, String key) {
        tag.putCodec(key, BlockPos.CODEC, pos);
        return tag;
    }

    public static Vec2 getVec2fCodec(@Nonnull CompoundData tag, String key) {
        return tag.getCodec(key, Vec2.CODEC).orElse(Vec2.ZERO);
    }

    public static Vec3i getVec3iCodec(@Nonnull CompoundData tag, String key) {
        return tag.getCodec(key, Vec3i.CODEC).orElse(Vec3i.ZERO);
    }

    public static Vec3 getVec3dCodec(@Nonnull CompoundData tag, String key) {
        return tag.getCodec(key, Vec3.CODEC).orElse(Vec3.ZERO);
    }

    public static BlockPos getPosCodec(@Nonnull CompoundData tag, String key) {
        return tag.getCodec(key, BlockPos.CODEC).orElse(BlockPos.ZERO);
    }

    @Nonnull
    public static CompoundData writeBlockPosToTag(@Nonnull BlockPos pos, @Nonnull CompoundData tag) {
        return DataTypeUtils.writeBlockPos(pos, tag);
    }

    @Nonnull
    public static CompoundData writeBlockPos(@Nonnull BlockPos pos, @Nonnull CompoundData tag) {
        tag.putInt("x", pos.getX());
        tag.putInt("y", pos.getY());
        tag.putInt("z", pos.getZ());
        return tag;
    }

    public static CompoundData writeVec3iToListTag(CompoundData tag, String tagName, Vec3i vec) {
        ListData list = new ListData();
        list.add(new IntData(vec.getX()));
        list.add(new IntData(vec.getY()));
        list.add(new IntData(vec.getZ()));
        tag.put(tagName, list);
        return tag;
    }

    public static CompoundData writeVec3iToArrayTag(CompoundData tag, String tagName, Vec3i vec) {
        int[] arr = new int[]{vec.getX(), vec.getY(), vec.getZ()};
        tag.putIntArray(tagName, arr);
        return tag;
    }

    public static Vec3i readVec3iOrDefault(DataView tag, String vecTagName, Vec3i defaultValue) {
        if (!tag.contains(vecTagName, 10)) {
            return defaultValue;
        }
        CompoundData vecTag = tag.getCompound(vecTagName);
        if (vecTag.contains("x", 3) && vecTag.contains("y", 3) && vecTag.contains("z", 3)) {
            return new Vec3i(vecTag.getInt("x"), vecTag.getInt("y"), vecTag.getInt("z"));
        }
        return defaultValue;
    }

    @Nullable
    public static BlockPos readBlockPos(DataView tag) {
        if (tag.contains("x", 3) && tag.contains("y", 3) && tag.contains("z", 3)) {
            return new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
        }
        return null;
    }

    @Nullable
    public static BlockPos readBlockPosFromListTag(DataView tag, String tagName) {
        ListData list;
        if (tag.containsList(tagName, 3) && (list = tag.getList(tagName)).size() == 3) {
            return new BlockPos(list.getIntAt(0), list.getIntAt(1), list.getIntAt(2));
        }
        return null;
    }

    public static BlockPos readBlockPosFromListTagOrDefault(DataView tag, String tagName, BlockPos defaultValue) {
        BlockPos pos = DataTypeUtils.readBlockPosFromListTag(tag, tagName);
        return pos != null ? pos : defaultValue;
    }

    @Nullable
    public static BlockPos readBlockPosFromArrayTag(DataView tag, String tagName) {
        int[] pos;
        if (tag.contains(tagName, 11) && (pos = tag.getIntArray(tagName)).length == 3) {
            return new BlockPos(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    @Nullable
    public static Vec3i readVec3iFromIntArray(@Nonnull DataView nbt, String key) {
        return DataTypeUtils.readVec3iFromIntArrayTag(nbt, key);
    }

    @Nullable
    public static Vec3i readVec3iFromIntArrayTag(@Nonnull DataView tag, String tagName) {
        int[] pos;
        if (tag.contains(tagName, 11) && (pos = tag.getIntArray(tagName)).length == 3) {
            return new Vec3i(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    public static BlockPos readBlockPosFromArrayTagOrDefault(DataView tag, String tagName, BlockPos defaultValue) {
        BlockPos pos = DataTypeUtils.readBlockPosFromArrayTag(tag, tagName);
        return pos != null ? pos : defaultValue;
    }

    public static CompoundData removeBlockPosFromTag(CompoundData tag) {
        tag.remove("x");
        tag.remove("y");
        tag.remove("z");
        return tag;
    }

    public static CompoundData writeVec3dToListTag(CompoundData tag, Vec3 pos) {
        return DataTypeUtils.writeVec3dToListTag(tag, "Pos", pos);
    }

    public static CompoundData writeVec3dToListTag(CompoundData tag, String tagName, Vec3 pos) {
        return DataTypeUtils.writeVec3dToListTag(tag, tagName, pos.x, pos.y, pos.z);
    }

    public static CompoundData writeVec3dToListTag(CompoundData tag, double x, double y, double z) {
        return DataTypeUtils.writeVec3dToListTag(tag, "Pos", x, y, z);
    }

    public static CompoundData writeVec3dToListTag(CompoundData tag, String tagName, double x, double y, double z) {
        ListData list = new ListData();
        list.add(new DoubleData(x));
        list.add(new DoubleData(y));
        list.add(new DoubleData(z));
        tag.put(tagName, list);
        return tag;
    }

    @Nullable
    public static Vec3 readVec3d(DataView data) {
        if (data.contains("dx", 6) && data.contains("dy", 6) && data.contains("dz", 6)) {
            return new Vec3(data.getDouble("dx"), data.getDouble("dy"), data.getDouble("dz"));
        }
        return null;
    }

    @Nullable
    public static Vec3 readVec3dFromListTag(DataView data) {
        return DataTypeUtils.readVec3dFromListTag(data, "Pos");
    }

    @Nullable
    public static Vec3 readVec3dFromListTag(DataView data, String tagName) {
        ListData list;
        if (data.containsList(tagName, 6) && (list = data.getList(tagName)).size() == 3) {
            return new Vec3(list.getDoubleAt(0), list.getDoubleAt(1), list.getDoubleAt(2));
        }
        return null;
    }

    @Nullable
    public static BlockPos readAttachedPosFromTag(@Nonnull DataView tag) {
        return DataTypeUtils.readPrefixedPosFromTag(tag, "Tile");
    }

    @Nonnull
    public static CompoundData writeAttachedPosToTag(@Nonnull BlockPos pos, @Nonnull CompoundData tag) {
        return DataTypeUtils.writePrefixedPosToTag(pos, tag, "Tile");
    }

    @Nullable
    public static BlockPos readPrefixedPosFromTag(@Nonnull DataView tag, String pre) {
        if (tag.contains(pre + "X", 3) && tag.contains(pre + "Y", 3) && tag.contains(pre + "Z", 3)) {
            return new BlockPos(tag.getInt(pre + "X"), tag.getInt(pre + "Y"), tag.getInt(pre + "Z"));
        }
        return null;
    }

    @Nonnull
    public static CompoundData writePrefixedPosToTag(@Nonnull BlockPos pos, @Nonnull CompoundData tag, String pre) {
        tag.putInt(pre + "X", pos.getX());
        tag.putInt(pre + "Y", pos.getY());
        tag.putInt(pre + "Z", pos.getZ());
        return tag;
    }

    public static Direction readDirectionFromTag(@Nonnull CompoundData tag, String key) {
        if (tag.contains(key, 3)) {
            return tag.getCodec(key, Direction.LEGACY_ID_CODEC).orElse(Direction.SOUTH);
        }
        if (tag.contains(key, 8)) {
            return tag.getCodec(key, Direction.CODEC).orElse(Direction.SOUTH);
        }
        return Direction.SOUTH;
    }

    public static CompoundData writeDirectionToTagAsInt(@Nonnull CompoundData tagIn, String key, Direction direction) {
        return tagIn.putCodec(key, Direction.LEGACY_ID_CODEC, direction);
    }

    public static CompoundData writeDirectionToTagAsString(@Nonnull CompoundData tagIn, String key, Direction direction) {
        return tagIn.putCodec(key, Direction.CODEC, direction);
    }

    public static <T> Optional<T> readFlatMap(@Nonnull CompoundData data, MapCodec<T> mapCodec) {
        NbtOps ops = NbtOps.INSTANCE;
        CompoundTag nbt = DataConverterNbt.toVanillaCompound(data);
        DataResult dataResult = ops.getMap((Object)nbt).flatMap(arg_0 -> DataTypeUtils.lambda$readFlatMap$0(mapCodec, (DynamicOps)ops, arg_0));
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            case 0 -> {
                DataResult.Success result = (DataResult.Success)dataResult2;
                yield Optional.of(result.value());
            }
            case 1 -> {
                DataResult.Error error = (DataResult.Error)dataResult2;
                yield error.partialValue();
            }
            default -> Optional.empty();
        };
    }

    public static <T> CompoundData writeFlatMap(MapCodec<T> mapCodec, T value) {
        NbtOps ops = NbtOps.INSTANCE;
        CompoundTag nbt = new CompoundTag();
        DataResult dataResult = mapCodec.encoder().encodeStart((DynamicOps)ops, value);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                DataResult.Success result = (DataResult.Success)dataResult2;
                nbt.merge((CompoundTag)result.value());
                break;
            }
            case 1: {
                DataResult.Error error = (DataResult.Error)dataResult2;
                error.partialValue().ifPresent(partial -> nbt.merge((CompoundTag)partial));
            }
        }
        return DataConverterNbt.fromVanillaCompound(nbt);
    }

    private static /* synthetic */ DataResult lambda$readFlatMap$0(MapCodec mapCodec, DynamicOps ops, MapLike map) {
        return mapCodec.decode(ops, map);
    }
}

