/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.game;

import com.google.common.base.Splitter;
import fi.dy.masa.malilib.data.CachedTagUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.data.ResourceLocation;
import fi.dy.masa.malilib.util.game.wrap.RegistryUtils;
import fi.dy.masa.malilib.util.nbt.NbtView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.TagValueOutput;
import org.apache.commons.lang3.tuple.Pair;

public class BlockUtils {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);

    public static Optional<BlockState> getBlockStateFromString(String str) {
        int index = str.indexOf("[");
        String blockName = index != -1 ? str.substring(0, index) : str;
        ResourceLocation id = ResourceLocation.of(blockName);
        if (RegistryUtils.getBlockById(id) != null) {
            Block block = RegistryUtils.getBlockById(id);
            BlockState state = block.defaultBlockState();
            StateDefinition stateManager = block.getStateDefinition();
            if (index != -1 && str.length() > index + 4 && str.charAt(str.length() - 1) == ']') {
                String propStr = str.substring(index + 1, str.length() - 1);
                for (String propAndVal : COMMA_SPLITTER.split((CharSequence)propStr)) {
                    Object val;
                    Property prop;
                    Iterator valIter = EQUAL_SPLITTER.split((CharSequence)propAndVal).iterator();
                    if (!valIter.hasNext() || (prop = stateManager.getProperty((String)valIter.next())) == null || !valIter.hasNext() || (val = BlockUtils.getPropertyValueByName(prop, (String)valIter.next())) == null) continue;
                    state = BlockUtils.getBlockStateWithProperty(state, prop, val);
                }
            }
            return Optional.of(state);
        }
        return Optional.empty();
    }

    public static CompoundTag getBlockStateTagFromString(String stateString) {
        int index = stateString.indexOf("[");
        String blockName = index != -1 ? stateString.substring(0, index) : stateString;
        CompoundTag tag = new CompoundTag();
        tag.putString("Name", blockName);
        if (index != -1 && stateString.length() > index + 4 && stateString.charAt(stateString.length() - 1) == ']') {
            CompoundTag propsTag = new CompoundTag();
            String propStr = stateString.substring(index + 1, stateString.length() - 1);
            for (String propAndVal : COMMA_SPLITTER.split((CharSequence)propStr)) {
                Iterator valIter = EQUAL_SPLITTER.split((CharSequence)propAndVal).iterator();
                if (!valIter.hasNext()) continue;
                String propName = (String)valIter.next();
                if (!valIter.hasNext()) continue;
                String valStr = (String)valIter.next();
                propsTag.putString(propName, valStr);
            }
            tag.put("Properties", (Tag)propsTag);
        }
        return tag;
    }

    public static String getBlockStateStringFromTag(CompoundTag stateTag) {
        String name = stateTag.getStringOr("Name", "");
        if (!stateTag.contains("Properties")) {
            return name;
        }
        CompoundTag propTag = stateTag.getCompoundOrEmpty("Properties");
        ArrayList<Pair> props = new ArrayList<Pair>();
        for (String key : propTag.keySet()) {
            props.add(Pair.of((Object)key, (Object)propTag.getStringOr(key, "")));
        }
        int size = props.size();
        if (size > 0) {
            props.sort(Comparator.comparing(Pair::getLeft));
            StringBuilder sb = new StringBuilder();
            sb.append(name).append('[');
            Pair pair = (Pair)props.get(0);
            sb.append((String)pair.getLeft()).append('=').append((String)pair.getRight());
            for (int i = 1; i < size; ++i) {
                pair = (Pair)props.get(i);
                sb.append(',').append((String)pair.getLeft()).append('=').append((String)pair.getRight());
            }
            sb.append(']');
            return sb.toString();
        }
        return name;
    }

    public static <T extends Comparable<T>> BlockState getBlockStateWithProperty(BlockState state, Property<T> prop, Comparable<?> value) {
        return (BlockState)state.setValue(prop, value);
    }

    @Nullable
    public static <T extends Comparable<T>> T getPropertyValueByName(Property<T> prop, String valStr) {
        return (T)((Comparable)prop.getValue(valStr).orElse(null));
    }

    public static Optional<Direction> getFirstPropertyFacingValue(BlockState state) {
        Optional<EnumProperty<Direction>> propOptional = BlockUtils.getFirstDirectionProperty(state);
        return propOptional.map(directionProperty -> Direction.byName((String)((Direction)state.getValue((Property)directionProperty)).getName()));
    }

    public static Optional<EnumProperty<Direction>> getFirstDirectionProperty(BlockState state) {
        for (Property prop : state.getProperties()) {
            EnumProperty ep;
            if (!(prop instanceof EnumProperty) || !(ep = (EnumProperty)prop).getValueClass().equals(Direction.class)) continue;
            return Optional.of(ep);
        }
        return Optional.empty();
    }

    public static List<String> getFormattedBlockStateProperties(BlockState state) {
        return BlockUtils.getFormattedBlockStateProperties(state, ": ");
    }

    public static List<String> getFormattedBlockStateProperties(BlockState state, String separator) {
        Collection properties = state.getProperties();
        if (properties.size() > 0) {
            ArrayList<String> lines = new ArrayList<String>();
            try {
                for (Property prop : properties) {
                    EnumProperty enumProperty;
                    Comparable val = state.getValue(prop);
                    String key = prop instanceof BooleanProperty ? (val.equals(Boolean.TRUE) ? "malilib.label.block_state_properties.boolean.true" : "malilib.label.block_state_properties.boolean.false") : (prop instanceof EnumProperty ? ((enumProperty = (EnumProperty)prop).getValueClass().equals(Direction.class) ? "malilib.label.block_state_properties.direction" : (enumProperty.getValueClass().equals(FrontAndTop.class) ? "malilib.label.block_state_properties.orientation" : "malilib.label.block_state_properties.enum")) : (prop instanceof IntegerProperty ? "malilib.label.block_state_properties.integer" : "malilib.label.block_state_properties.generic"));
                    lines.add(StringUtils.translate(key, prop.getName(), separator, val.toString().toLowerCase()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return lines;
        }
        return Collections.emptyList();
    }

    public static boolean isFluidBlock(BlockState state) {
        return !state.getFluidState().equals((Object)Fluids.EMPTY.defaultFluidState());
    }

    public static boolean isFluidSourceBlock(BlockState state) {
        return state.getBlock() instanceof LiquidBlock && state.getFluidState().getAmount() == 8;
    }

    @Nullable
    public static Direction getPropertyFacingValue(BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.FACING) ? (Direction)state.getValue((Property)BlockStateProperties.FACING) : null;
    }

    @Nullable
    public static Direction getPropertyHopperFacingValue(BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.FACING_HOPPER) ? (Direction)state.getValue((Property)BlockStateProperties.FACING_HOPPER) : null;
    }

    @Nullable
    public static Direction getPropertyHorizontalFacingValue(BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) ? (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) : null;
    }

    @Nullable
    public static FrontAndTop getPropertyOrientationValue(BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.ORIENTATION) ? (FrontAndTop)state.getValue((Property)BlockStateProperties.ORIENTATION) : null;
    }

    @Nullable
    public static Direction getPropertyOrientationFacing(BlockState state) {
        FrontAndTop o = BlockUtils.getPropertyOrientationValue(state);
        return o != null ? o.front() : null;
    }

    @Nullable
    public static Direction getPropertyOrientationRotation(BlockState state) {
        FrontAndTop o = BlockUtils.getPropertyOrientationValue(state);
        return o != null ? o.top() : null;
    }

    public static boolean isFacingValidForDirection(ItemStack stack, Direction facing) {
        Item item = stack.getItem();
        if (!stack.isEmpty() && item instanceof BlockItem) {
            Block block = ((BlockItem)item).getBlock();
            BlockState state = block.defaultBlockState();
            if (state.hasProperty((Property)BlockStateProperties.FACING)) {
                return true;
            }
            if (state.hasProperty((Property)BlockStateProperties.FACING_HOPPER) && !facing.equals((Object)Direction.UP)) {
                return true;
            }
            if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && !facing.equals((Object)Direction.UP) && !facing.equals((Object)Direction.DOWN)) {
                return true;
            }
        }
        return false;
    }

    public static int getDirectionFacingIndex(ItemStack stack, Direction facing) {
        if (BlockUtils.isFacingValidForDirection(stack, facing)) {
            return facing.get3DDataValue();
        }
        return -1;
    }

    public static boolean isFacingValidForOrientation(ItemStack stack, Direction facing) {
        Item item = stack.getItem();
        if (!stack.isEmpty() && item instanceof BlockItem) {
            Block block = ((BlockItem)item).getBlock();
            BlockState state = block.defaultBlockState();
            return state.hasProperty((Property)BlockStateProperties.ORIENTATION);
        }
        return false;
    }

    public static int getOrientationFacingIndex(ItemStack stack, Direction facing) {
        BlockItem blockItem;
        BlockState defaultState;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (defaultState = (blockItem = (BlockItem)item).getBlock().defaultBlockState()).hasProperty((Property)BlockStateProperties.ORIENTATION)) {
            List<FrontAndTop> list = Arrays.stream(FrontAndTop.values()).toList();
            for (int i = 0; i < list.size(); ++i) {
                FrontAndTop o = list.get(i);
                if (!o.front().equals((Object)facing)) continue;
                return i;
            }
        }
        return -1;
    }

    public static Set<Integer> getDisabledSlots(CrafterBlockEntity ce) {
        HashSet<Integer> list = new HashSet<Integer>();
        if (ce != null) {
            for (int i = 0; i < 9; ++i) {
                if (!ce.isSlotDisabled(i)) continue;
                list.add(i);
            }
        }
        return list;
    }

    public static void setStackNbt(@Nonnull ItemStack stack, @Nonnull BlockEntity be, @Nonnull RegistryAccess registry) {
        if (stack.isEmpty()) {
            return;
        }
        NbtView view = NbtView.getWriter(registry);
        be.saveCustomOnly(view.getWriter());
        BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)be.getType(), (TagValueOutput)((TagValueOutput)view.getWriter()));
        stack.applyComponents(be.collectComponents());
    }

    public static boolean isInSameGroup(BlockState left, BlockState right) {
        Pair<HolderSet<Block>, Holder<Block>> pairLeft = CachedTagUtils.matchReplaceableBlockTag(left);
        Pair<HolderSet<Block>, Holder<Block>> pairRight = CachedTagUtils.matchReplaceableBlockTag(right);
        return pairLeft.getLeft() != null && pairRight.getLeft() != null && ((HolderSet)pairLeft.getLeft()).unwrapKey().equals(((HolderSet)pairRight.getLeft()).unwrapKey());
    }

    public static boolean matchPropertiesOnly(BlockState left, BlockState right) {
        return BlockUtils.compareProperties(left, right) && BlockUtils.compareProperties(right, left);
    }

    public static <T extends Comparable<T>> boolean compareProperties(BlockState state, BlockState otherState) {
        Collection props = state.getProperties();
        for (Property entry : props) {
            Property p = entry;
            if (otherState.hasProperty(p)) {
                Comparable value = state.getValue(p);
                if (value.equals(otherState.getValue(p))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean matchSolidFullCubes(BlockState left, BlockState right) {
        if (left.isSolid() && right.isSolid()) {
            return left.isSolidRender() && right.isSolidRender();
        }
        return false;
    }

    public static boolean matchMapColors(Level world, BlockPos pos, BlockState left, BlockState right) {
        return left.getMapColor((BlockGetter)world, pos) == right.getMapColor((BlockGetter)world, pos);
    }
}

