/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import fi.dy.masa.malilib.util.StringUtils;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public abstract class BaseNbtStringifier {
    protected final String baseColor;
    protected final boolean colored;
    protected final boolean useNumberSuffix;
    protected String tagNameQuote = "\"";
    protected String keyColor;
    protected String numberColor;
    protected String numberTypeColor;
    protected String stringColor;

    public BaseNbtStringifier(boolean useNumberSuffix) {
        this(false, useNumberSuffix, "");
    }

    public BaseNbtStringifier(boolean colored, boolean useNumberSuffix, String baseColor) {
        this.colored = colored;
        this.useNumberSuffix = useNumberSuffix;
        this.baseColor = baseColor;
        this.keyColor = StringUtils.translate("malilib.label.nbt_tooltip.key_color", new Object[0]);
        this.numberColor = StringUtils.translate("malilib.label.nbt_tooltip.number_color", new Object[0]);
        this.numberTypeColor = StringUtils.translate("malilib.label.nbt_tooltip.number_type_color", new Object[0]);
        this.stringColor = StringUtils.translate("malilib.label.nbt_tooltip.string_color", new Object[0]);
    }

    protected String getFormattedTagName(String name) {
        if (name.length() == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.tagNameQuote);
        if (this.colored) {
            sb.append(this.keyColor);
            sb.append(name);
            sb.append(this.baseColor);
        } else {
            sb.append(name);
        }
        sb.append(this.tagNameQuote);
        return sb.toString();
    }

    @Nullable
    protected String getPrimitiveValue(Tag tag) {
        switch (tag.getId()) {
            case 1: {
                return String.valueOf(((ByteTag)tag).byteValue());
            }
            case 2: {
                return String.valueOf(((ShortTag)tag).shortValue());
            }
            case 3: {
                return String.valueOf(((IntTag)tag).intValue());
            }
            case 4: {
                return String.valueOf(((LongTag)tag).longValue());
            }
            case 5: {
                return String.valueOf(((FloatTag)tag).floatValue());
            }
            case 6: {
                return String.valueOf(((DoubleTag)tag).doubleValue());
            }
            case 8: {
                return ((StringTag)tag).value();
            }
        }
        return null;
    }

    @Nullable
    protected String getNumberSuffix(int tagId) {
        switch (tagId) {
            case 1: {
                return "b";
            }
            case 2: {
                return "s";
            }
            case 4: {
                return "L";
            }
            case 5: {
                return "f";
            }
            case 6: {
                return "d";
            }
        }
        return null;
    }

    @Nullable
    protected String getPrimitiveColorCode(int tagId) {
        switch (tagId) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this.numberColor;
            }
            case 8: {
                return this.stringColor;
            }
        }
        return null;
    }

    protected String getFormattedPrimitiveString(Tag tag) {
        byte typeId = tag.getId();
        String valueStr = this.getPrimitiveValue(tag);
        String valueColorStr = this.colored ? this.getPrimitiveColorCode(typeId) : null;
        String numberSuffixStr = this.useNumberSuffix ? this.getNumberSuffix(typeId) : null;
        boolean useQuotes = typeId == 8;
        return this.getFormattedPrimitiveString(valueStr, useQuotes, valueColorStr, numberSuffixStr);
    }

    protected String getFormattedPrimitiveString(String valueStr, boolean useQuotes, @Nullable String valueColorStr, @Nullable String numberSuffixStr) {
        StringBuilder sb = new StringBuilder();
        if (valueStr == null) {
            return "";
        }
        if (useQuotes) {
            sb.append('\"');
        }
        if (valueColorStr != null) {
            sb.append(valueColorStr);
        }
        sb.append(valueStr);
        if (numberSuffixStr != null) {
            if (this.colored) {
                sb.append(this.numberTypeColor);
            }
            sb.append(numberSuffixStr);
        }
        if (this.colored) {
            sb.append(this.baseColor);
        }
        if (useQuotes) {
            sb.append('\"');
        }
        return sb.toString();
    }

    protected void appendTag(String tagName, Tag tag) {
        switch (tag.getId()) {
            case 10: {
                this.appendCompound(tagName, (CompoundTag)tag);
                break;
            }
            case 9: {
                this.appendList(tagName, (ListTag)tag);
                break;
            }
            case 7: {
                this.appendByteArray(tagName, ((ByteArrayTag)tag).getAsByteArray());
                break;
            }
            case 11: {
                this.appendIntArray(tagName, ((IntArrayTag)tag).getAsIntArray());
                break;
            }
            case 12: {
                this.appendLongArray(tagName, ((LongArrayTag)tag).getAsLongArray());
                break;
            }
            default: {
                this.appendPrimitive(tagName, tag);
            }
        }
    }

    protected abstract void appendPrimitive(String var1, Tag var2);

    protected abstract void appendCompound(String var1, CompoundTag var2);

    protected abstract void appendList(String var1, ListTag var2);

    protected abstract void appendByteArray(String var1, byte[] var2);

    protected abstract void appendIntArray(String var1, int[] var2);

    protected abstract void appendLongArray(String var1, long[] var2);
}

