/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.data.tag.converter.DataConverterNbt;
import fi.dy.masa.malilib.util.log.AnsiLogger;
import fi.dy.masa.malilib.util.nbt.NbtView;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.ApiStatus;

public class NbtInventory
implements AutoCloseable {
    private static final AnsiLogger LOGGER = new AnsiLogger(NbtInventory.class, true, true);
    public static final int VILLAGER_SIZE = 8;
    public static final int DEFAULT_SIZE = 27;
    public static final int PLAYER_SIZE = 36;
    public static final int DOUBLE_SIZE = 54;
    public static final int MAX_SIZE = 256;
    private HashSet<ItemStackWithSlot> items;

    private NbtInventory() {
    }

    public static NbtInventory create(int size) {
        NbtInventory newInv = new NbtInventory();
        size = NbtInventory.getAdjustedSize(Mth.clamp((int)size, (int)1, (int)256));
        newInv.buildEmptyList(size);
        return newInv;
    }

    private void buildEmptyList(int size) throws RuntimeException {
        if (this.items != null) {
            throw new RuntimeException("List not empty!");
        }
        this.items = new HashSet();
        for (int i = 0; i < size; ++i) {
            this.items.add(new ItemStackWithSlot(i, ItemStack.EMPTY));
        }
    }

    public boolean isEmpty() {
        if (this.items == null || this.items.isEmpty()) {
            return true;
        }
        AtomicBoolean bool = new AtomicBoolean(true);
        this.items.forEach(slot -> {
            if (!slot.stack().isEmpty()) {
                bool.set(false);
            }
        });
        return bool.get();
    }

    public int size() {
        if (this.items == null) {
            return -1;
        }
        return this.items.size();
    }

    public NonNullList<ItemStack> toVanillaList(int size) {
        if (this.isEmpty()) {
            return NonNullList.create();
        }
        size = NbtInventory.getAdjustedSize(Math.clamp((long)size, this.size(), 256));
        NonNullList list = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        AtomicInteger i = new AtomicInteger(0);
        this.items.forEach(slot -> {
            list.set(slot.slot(), (Object)slot.stack());
            i.getAndIncrement();
        });
        return list;
    }

    @Nullable
    public static NbtInventory fromVanillaList(@Nonnull NonNullList<ItemStack> list) {
        int size = list.size();
        if (size < 1) {
            return null;
        }
        size = NbtInventory.getAdjustedSize(Mth.clamp((int)size, (int)1, (int)256));
        NbtInventory newInv = new NbtInventory();
        newInv.items = new HashSet();
        for (int i = 0; i < size; ++i) {
            ItemStackWithSlot slot = new ItemStackWithSlot(i, (ItemStack)list.get(i));
            newInv.items.add(slot);
        }
        return newInv;
    }

    @Nullable
    public Container toInventory(int size) {
        if (this.isEmpty()) {
            return null;
        }
        int sizeAdj = NbtInventory.getAdjustedSize(Math.clamp((long)size, this.size(), 256));
        SimpleContainer inv = new SimpleContainer(sizeAdj);
        AtomicInteger i = new AtomicInteger(0);
        this.items.forEach(arg_0 -> NbtInventory.lambda$toInventory$2((Container)inv, i, arg_0));
        return inv;
    }

    public static NbtInventory fromInventory(@Nonnull Container inv) {
        NbtInventory newInv = new NbtInventory();
        ArrayList<Integer> slotsUsed = new ArrayList<Integer>();
        int size = inv.getContainerSize();
        int maxSlot = 0;
        size = NbtInventory.getAdjustedSize(Mth.clamp((int)size, (int)1, (int)256));
        newInv.items = new HashSet();
        for (int i = 0; i < size; ++i) {
            ItemStackWithSlot slot = new ItemStackWithSlot(i, inv.getItem(i));
            newInv.items.add(slot);
            slotsUsed.add(slot.slot());
            if (slot.slot() <= maxSlot) continue;
            maxSlot = slot.slot();
        }
        newInv.verifySize(slotsUsed, maxSlot);
        return newInv;
    }

    @Nullable
    public NbtView toNbtWriterView(@Nonnull RegistryAccess registry) {
        if (this.isEmpty()) {
            return null;
        }
        int size = NbtInventory.getAdjustedSize(this.size());
        NbtView view = NbtView.getWriter(registry);
        NonNullList<ItemStack> list = this.toVanillaList(size);
        ContainerHelper.saveAllItems((ValueOutput)Objects.requireNonNull(view.getWriter()), list);
        return view;
    }

    @Nullable
    public static NbtInventory fromNbtReaderView(@Nonnull NbtView view, int size) {
        if (size < 1) {
            return null;
        }
        size = NbtInventory.getAdjustedSize(Mth.clamp((int)size, (int)1, (int)256));
        NonNullList list = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)Objects.requireNonNull(view.getReader()), (NonNullList)list);
        return NbtInventory.fromVanillaList((NonNullList<ItemStack>)list);
    }

    public CompoundTag toNbtSingle(@Nonnull RegistryAccess registry) throws RuntimeException {
        if (this.size() > 1) {
            throw new RuntimeException("Inventory is too large for a single entry!");
        }
        ItemStackWithSlot slot = (ItemStackWithSlot)this.items.stream().findFirst().orElseThrow();
        if (!slot.stack().isEmpty()) {
            Tag element = (Tag)ItemStackWithSlot.CODEC.encodeStart((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)slot).getPartialOrThrow();
            return (CompoundTag)element;
        }
        return new CompoundTag();
    }

    @ApiStatus.Experimental
    public CompoundData toDataSingle(@Nonnull RegistryAccess registry) {
        return DataConverterNbt.fromVanillaCompound(this.toNbtSingle(registry));
    }

    public ListTag toNbtList(@Nonnull RegistryAccess registry) throws RuntimeException {
        ListTag nbt = new ListTag();
        if (this.isEmpty()) {
            return nbt;
        }
        this.items.forEach(slot -> {
            if (!slot.stack().isEmpty()) {
                Tag element = (Tag)ItemStackWithSlot.CODEC.encodeStart((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), slot).getPartialOrThrow();
                nbt.add((Object)element);
            }
        });
        return nbt;
    }

    @ApiStatus.Experimental
    public ListData toDataList(@Nonnull RegistryAccess registry) {
        return DataConverterNbt.fromVanillaList(this.toNbtList(registry));
    }

    public CompoundTag toNbt(TagType<?> type, String key, @Nonnull RegistryAccess registry) throws RuntimeException {
        CompoundTag nbt = new CompoundTag();
        if (type == ListTag.TYPE) {
            ListTag list = this.toNbtList(registry);
            if (list.isEmpty()) {
                return nbt;
            }
            nbt.put(key, (Tag)list);
            return nbt;
        }
        if (type == CompoundTag.TYPE) {
            nbt.put(key, (Tag)this.toNbtSingle(registry));
            return nbt;
        }
        throw new RuntimeException("Unsupported Nbt Type!");
    }

    @ApiStatus.Experimental
    public CompoundData toData(int type, String key, @Nonnull RegistryAccess registry) throws RuntimeException {
        CompoundData data = new CompoundData();
        if (type == 9) {
            ListData list = this.toDataList(registry);
            if (list.isEmpty()) {
                return data;
            }
            return data.put(key, list);
        }
        if (type == 10) {
            return data.put(key, this.toDataSingle(registry));
        }
        throw new RuntimeException("Unsupported Data Type!");
    }

    @Nullable
    public static NbtInventory fromNbt(@Nonnull CompoundTag nbtIn, String key, boolean noSlotId, @Nonnull RegistryAccess registry) throws RuntimeException {
        if (nbtIn.isEmpty() || !nbtIn.contains(key)) {
            return null;
        }
        if (Objects.requireNonNull(nbtIn.get(key)).getType() == ListTag.TYPE) {
            return NbtInventory.fromNbtList(nbtIn.getListOrEmpty(key), noSlotId, registry);
        }
        if (Objects.requireNonNull(nbtIn.get(key)).getType() == CompoundTag.TYPE) {
            return NbtInventory.fromNbtSingle(nbtIn.getCompoundOrEmpty(key), registry);
        }
        throw new RuntimeException("Invalid Nbt Type!");
    }

    @Nullable
    @ApiStatus.Experimental
    public static NbtInventory fromData(@Nonnull CompoundData data, String key, boolean noSlotId, @Nonnull RegistryAccess registry) throws RuntimeException {
        if (data.isEmpty() || !data.containsLenient(key)) {
            return null;
        }
        if (data.contains(key, 9)) {
            return NbtInventory.fromDataList(data.getList(key), noSlotId, registry);
        }
        if (data.contains(key, 10)) {
            return NbtInventory.fromDataSingle(data.getCompound(key), registry);
        }
        throw new RuntimeException("Invalid Data Type!");
    }

    @Nullable
    public static NbtInventory fromNbtSingle(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) throws RuntimeException {
        if (nbt.isEmpty()) {
            return null;
        }
        NbtInventory newInv = new NbtInventory();
        newInv.items = new HashSet();
        ItemStackWithSlot slot = (ItemStackWithSlot)ItemStackWithSlot.CODEC.parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).getPartialOrThrow();
        newInv.items.add(slot);
        return newInv;
    }

    @Nullable
    @ApiStatus.Experimental
    public static NbtInventory fromDataSingle(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) throws RuntimeException {
        CompoundTag nbt = DataConverterNbt.toVanillaCompound(data);
        if (nbt != null) {
            return NbtInventory.fromNbtSingle(nbt, registry);
        }
        return null;
    }

    @Nullable
    public static NbtInventory fromNbtList(@Nonnull ListTag list, boolean noSlotId, @Nonnull RegistryAccess registry) throws RuntimeException {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 256) {
            throw new RuntimeException("Nbt List is too large!");
        }
        int size = list.size();
        size = NbtInventory.getAdjustedSize(Mth.clamp((int)size, (int)1, (int)256));
        NbtInventory newInv = new NbtInventory();
        ArrayList<Integer> slotsUsed = new ArrayList<Integer>();
        int maxSlot = 0;
        newInv.items = new HashSet();
        for (int i = 0; i < list.size(); ++i) {
            ItemStackWithSlot slot = noSlotId ? new ItemStackWithSlot(i, (ItemStack)ItemStack.CODEC.parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)((Tag)list.get(i))).getPartialOrThrow()) : (ItemStackWithSlot)ItemStackWithSlot.CODEC.parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)((Tag)list.get(i))).getPartialOrThrow();
            newInv.items.add(slot);
            slotsUsed.add(slot.slot());
            if (slot.slot() <= maxSlot) continue;
            maxSlot = slot.slot();
        }
        newInv.verifySize(slotsUsed, maxSlot);
        return newInv;
    }

    @Nullable
    @ApiStatus.Experimental
    public static NbtInventory fromDataList(@Nonnull ListData list, boolean noSlotId, @Nonnull RegistryAccess registry) throws RuntimeException {
        ListTag nbt = DataConverterNbt.toVanillaList(list);
        if (nbt != null) {
            return NbtInventory.fromNbtList(nbt, noSlotId, registry);
        }
        return null;
    }

    private void verifySize(List<Integer> slotsUsed, int maxSlot) {
        int size = Math.max(this.size(), maxSlot);
        size = NbtInventory.getAdjustedSize(size);
        for (int i = 0; i < size; ++i) {
            if (slotsUsed.contains(i)) continue;
            this.items.add(new ItemStackWithSlot(i, ItemStack.EMPTY));
        }
    }

    public static int getAdjustedSize(int size) {
        if (size <= 8) {
            return size;
        }
        if (size <= 27) {
            return 27;
        }
        if (size <= 36) {
            return 36;
        }
        if (size <= 54) {
            return 54;
        }
        return Math.min(size, 256);
    }

    public void dumpInv() {
        AtomicInteger i = new AtomicInteger(0);
        LOGGER.info("dumpInv() --> START", new Object[0]);
        this.items.forEach(slot -> {
            LOGGER.info("[{}]: slot [{}], stack: [{}]", i, slot.slot(), slot.stack().toString());
            i.getAndIncrement();
        });
        LOGGER.info("dumpInv() --> END", new Object[0]);
    }

    @Override
    public void close() throws Exception {
        this.items.clear();
    }

    private static /* synthetic */ void lambda$toInventory$2(Container inv, AtomicInteger i, ItemStackWithSlot slot) {
        inv.setItem(slot.slot(), slot.stack());
        i.getAndIncrement();
    }
}

