/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.data;

import fi.dy.masa.malilib.data.CachedBlockTags;
import fi.dy.masa.malilib.data.CachedTagKey;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Blocks;

public class CachedTagManager {
    public static final CachedTagKey CORAL_FANS_KEY = new CachedTagKey("malilib", "coral_fans_fix");
    public static final CachedTagKey CONCRETE_BLOCKS_KEY = new CachedTagKey("malilib", "concrete_blocks");
    public static final CachedTagKey GLASS_PANES_KEY = new CachedTagKey("malilib", "glass_panes");
    public static final CachedTagKey GLAZED_TERRACOTTA_BLOCKS_KEY = new CachedTagKey("malilib", "glazed_terracotta_blocks");
    public static final CachedTagKey SCULK_BLOCKS_KEY = new CachedTagKey("malilib", "sculk_blocks");
    public static final CachedTagKey REPLACEABLE_BLOCKS_KEY = new CachedTagKey("malilib", "replaceable_blocks");

    public static List<CachedTagKey> getKeys() {
        ArrayList<CachedTagKey> list = new ArrayList<CachedTagKey>();
        list.add(CORAL_FANS_KEY);
        list.add(CONCRETE_BLOCKS_KEY);
        list.add(GLASS_PANES_KEY);
        list.add(GLAZED_TERRACOTTA_BLOCKS_KEY);
        list.add(SCULK_BLOCKS_KEY);
        list.add(REPLACEABLE_BLOCKS_KEY);
        return list;
    }

    public static void startCache() {
        CachedTagManager.clearCache();
        CachedBlockTags.getInstance().build(CORAL_FANS_KEY, CachedTagManager.buildAllCoralFansCache());
        CachedBlockTags.getInstance().build(CONCRETE_BLOCKS_KEY, CachedTagManager.buildConcreteCache());
        CachedBlockTags.getInstance().build(GLASS_PANES_KEY, CachedTagManager.buildGlassPanesCache());
        CachedBlockTags.getInstance().build(GLAZED_TERRACOTTA_BLOCKS_KEY, CachedTagManager.buildGlazedTerracottaCache());
        CachedBlockTags.getInstance().build(SCULK_BLOCKS_KEY, CachedTagManager.buildSculkCache());
        CachedBlockTags.getInstance().build(REPLACEABLE_BLOCKS_KEY, CachedTagManager.buildReplaceableCache());
    }

    private static void clearCache() {
        CachedBlockTags.getInstance().clearEntry(CORAL_FANS_KEY);
        CachedBlockTags.getInstance().clearEntry(CONCRETE_BLOCKS_KEY);
        CachedBlockTags.getInstance().clearEntry(GLASS_PANES_KEY);
        CachedBlockTags.getInstance().clearEntry(GLAZED_TERRACOTTA_BLOCKS_KEY);
        CachedBlockTags.getInstance().clearEntry(SCULK_BLOCKS_KEY);
        CachedBlockTags.getInstance().clearEntry(REPLACEABLE_BLOCKS_KEY);
    }

    private static List<String> buildAllCoralFansCache() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#" + BlockTags.WALL_CORALS.location().toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BRAIN_CORAL_FAN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.FIRE_CORAL_FAN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BUBBLE_CORAL_FAN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.TUBE_CORAL_FAN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.HORN_CORAL_FAN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEAD_BRAIN_CORAL_FAN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEAD_FIRE_CORAL_FAN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEAD_BUBBLE_CORAL_FAN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEAD_TUBE_CORAL_FAN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEAD_HORN_CORAL_FAN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEAD_BRAIN_CORAL_WALL_FAN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEAD_FIRE_CORAL_WALL_FAN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEAD_BUBBLE_CORAL_WALL_FAN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEAD_TUBE_CORAL_WALL_FAN).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEAD_HORN_CORAL_WALL_FAN).toString());
        return list;
    }

    private static List<String> buildConcreteCache() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BLACK_CONCRETE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BLUE_CONCRETE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BROWN_CONCRETE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.CYAN_CONCRETE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.GRAY_CONCRETE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.GREEN_CONCRETE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.LIGHT_BLUE_CONCRETE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.LIGHT_GRAY_CONCRETE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.LIME_CONCRETE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.MAGENTA_CONCRETE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.ORANGE_CONCRETE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.PINK_CONCRETE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.PURPLE_CONCRETE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.RED_CONCRETE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.YELLOW_CONCRETE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.WHITE_CONCRETE).toString());
        return list;
    }

    private static List<String> buildGlassPanesCache() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BLACK_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BLUE_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BROWN_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.CYAN_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.GRAY_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.GREEN_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.LIGHT_BLUE_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.LIGHT_GRAY_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.LIME_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.MAGENTA_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.ORANGE_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.PINK_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.PURPLE_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.RED_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.YELLOW_STAINED_GLASS_PANE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.WHITE_STAINED_GLASS_PANE).toString());
        return list;
    }

    private static List<String> buildGlazedTerracottaCache() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BLACK_GLAZED_TERRACOTTA).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BLUE_GLAZED_TERRACOTTA).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.BROWN_GLAZED_TERRACOTTA).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.CYAN_GLAZED_TERRACOTTA).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.GRAY_GLAZED_TERRACOTTA).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.GREEN_GLAZED_TERRACOTTA).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.LIGHT_GRAY_GLAZED_TERRACOTTA).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.LIME_GLAZED_TERRACOTTA).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.MAGENTA_GLAZED_TERRACOTTA).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.ORANGE_GLAZED_TERRACOTTA).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.PINK_GLAZED_TERRACOTTA).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.PURPLE_GLAZED_TERRACOTTA).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.RED_GLAZED_TERRACOTTA).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.YELLOW_GLAZED_TERRACOTTA).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.WHITE_GLAZED_TERRACOTTA).toString());
        return list;
    }

    private static List<String> buildSculkCache() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.CALIBRATED_SCULK_SENSOR).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.SCULK).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.SCULK_CATALYST).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.SCULK_SENSOR).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.SCULK_SHRIEKER).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.SCULK_VEIN).toString());
        return list;
    }

    private static List<String> buildReplaceableCache() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#" + BlockTags.ANVIL.location().toString());
        list.add("#" + BlockTags.BEDS.location().toString());
        list.add("#" + BlockTags.BUTTONS.location().toString());
        list.add("#" + BlockTags.CANDLE_CAKES.location().toString());
        list.add("#" + BlockTags.CANDLES.location().toString());
        list.add("#" + BlockTags.CEILING_HANGING_SIGNS.location().toString());
        list.add("#" + BlockTags.CONCRETE_POWDER.location().toString());
        list.add("#" + BlockTags.CORAL_PLANTS.location().toString());
        list.add("#" + BlockTags.DOORS.location().toString());
        list.add("#" + BlockTags.FENCE_GATES.location().toString());
        list.add("#" + BlockTags.FENCES.location().toString());
        list.add("#" + BlockTags.FLOWER_POTS.location().toString());
        list.add("#" + BlockTags.FLOWERS.location().toString());
        list.add("#" + BlockTags.LEAVES.location().toString());
        list.add("#" + BlockTags.LOGS.location().toString());
        list.add("#" + BlockTags.PLANKS.location().toString());
        list.add("#" + BlockTags.PRESSURE_PLATES.location().toString());
        list.add("#" + BlockTags.SAPLINGS.location().toString());
        list.add("#" + BlockTags.SHULKER_BOXES.location().toString());
        list.add("#" + BlockTags.SLABS.location().toString());
        list.add("#" + BlockTags.STAIRS.location().toString());
        list.add("#" + BlockTags.STANDING_SIGNS.location().toString());
        list.add("#" + BlockTags.TERRACOTTA.location().toString());
        list.add("#" + BlockTags.TRAPDOORS.location().toString());
        list.add("#" + BlockTags.WALL_HANGING_SIGNS.location().toString());
        list.add("#" + BlockTags.WALL_SIGNS.location().toString());
        list.add("#" + BlockTags.WALLS.location().toString());
        list.add("#" + BlockTags.WOOL.location().toString());
        list.add("#" + BlockTags.WOOL_CARPETS.location().toString());
        list.add("#" + BlockTags.IMPERMEABLE.location().toString());
        return list;
    }

    private static List<String> buildOreCache() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.COAL_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.COPPER_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEEPSLATE_COAL_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEEPSLATE_COPPER_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEEPSLATE_DIAMOND_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEEPSLATE_EMERALD_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEEPSLATE_GOLD_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEEPSLATE_IRON_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEEPSLATE_LAPIS_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DEEPSLATE_REDSTONE_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.DIAMOND_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.EMERALD_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.GOLD_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.IRON_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.LAPIS_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.NETHER_GOLD_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.NETHER_QUARTZ_ORE).toString());
        list.add(BuiltInRegistries.BLOCK.getKey((Object)Blocks.REDSTONE_ORE).toString());
        return list;
    }
}

