/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.event;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IInputManager;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.IKeyboardInputHandler;
import fi.dy.masa.malilib.hotkeys.IMouseInputHandler;
import fi.dy.masa.malilib.hotkeys.KeybindCategory;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import org.jetbrains.annotations.ApiStatus;

public class InputEventHandler
implements IKeybindManager,
IInputManager {
    private static final InputEventHandler INSTANCE = new InputEventHandler();
    private final Multimap<Integer, IKeybind> hotkeyMap = ArrayListMultimap.create();
    private final List<KeybindCategory> allKeybinds = new ArrayList<KeybindCategory>();
    private final List<IKeybindProvider> keybindProviders = new ArrayList<IKeybindProvider>();
    private final List<IKeyboardInputHandler> keyboardHandlers = new ArrayList<IKeyboardInputHandler>();
    private final List<IMouseInputHandler> mouseHandlers = new ArrayList<IMouseInputHandler>();
    private double mouseWheelDeltaSum;

    private InputEventHandler() {
    }

    public static IKeybindManager getKeybindManager() {
        return INSTANCE;
    }

    public static IInputManager getInputManager() {
        return INSTANCE;
    }

    @Override
    public void registerKeybindProvider(IKeybindProvider provider) {
        if (!this.keybindProviders.contains(provider)) {
            this.keybindProviders.add(provider);
        }
        provider.addHotkeys(this);
    }

    @Override
    public void unregisterKeybindProvider(IKeybindProvider provider) {
        this.keybindProviders.remove(provider);
    }

    @Override
    public List<KeybindCategory> getKeybindCategories() {
        return this.allKeybinds;
    }

    @Override
    public void updateUsedKeys() {
        this.hotkeyMap.clear();
        for (IKeybindProvider handler : this.keybindProviders) {
            handler.addKeysToMap(this);
        }
    }

    @Override
    public void addKeybindToMap(IKeybind keybind) {
        List<Integer> keys = keybind.getKeys();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            this.hotkeyMap.put((Object)key, (Object)keybind);
        }
    }

    @Override
    public void addHotkeysForCategory(String modName, String keyCategory, List<? extends IHotkey> hotkeys) {
        KeybindCategory cat = new KeybindCategory(modName, keyCategory, hotkeys);
        this.allKeybinds.remove(cat);
        this.allKeybinds.add(cat);
    }

    @Override
    public void registerKeyboardInputHandler(IKeyboardInputHandler handler) {
        if (!this.keyboardHandlers.contains(handler)) {
            this.keyboardHandlers.add(handler);
        }
    }

    @Override
    public void unregisterKeyboardInputHandler(IKeyboardInputHandler handler) {
        this.keyboardHandlers.remove(handler);
    }

    @Override
    public void registerMouseInputHandler(IMouseInputHandler handler) {
        if (!this.mouseHandlers.contains(handler)) {
            this.mouseHandlers.add(handler);
        }
    }

    @Override
    public void unregisterMouseInputHandler(IMouseInputHandler handler) {
        this.mouseHandlers.remove(handler);
    }

    @ApiStatus.Internal
    public boolean onKeyInput(KeyEvent input, int action, @Nonnull Minecraft mc) {
        boolean eventKeyState = action != 0;
        KeybindMulti.onKeyInputPre(input, action);
        boolean cancel = this.checkKeyBindsForChanges(input.key());
        if (!this.keyboardHandlers.isEmpty()) {
            for (IKeyboardInputHandler handler : this.keyboardHandlers) {
                if (!handler.onKeyInput(input, eventKeyState)) continue;
                this.printInputCancellationDebugMessage(handler);
                return true;
            }
        }
        return cancel;
    }

    @ApiStatus.Internal
    public boolean onMouseClick(MouseButtonEvent click, int action, @Nonnull Minecraft mc) {
        boolean cancel = false;
        if (click.input() != -1) {
            boolean eventButtonState = action == 1;
            KeybindMulti.onKeyInputPre(new KeyEvent(click.input() - 100, 0, 0), action);
            cancel = this.checkKeyBindsForChanges(click.input() - 100);
            if (!this.mouseHandlers.isEmpty()) {
                for (IMouseInputHandler handler : this.mouseHandlers) {
                    if (!handler.onMouseClick(click, eventButtonState)) continue;
                    this.printInputCancellationDebugMessage(handler);
                    return true;
                }
            }
        }
        return cancel;
    }

    private void printInputCancellationDebugMessage(Object handler) {
        if (MaLiLibConfigs.Debug.INPUT_CANCELLATION_DEBUG.getBooleanValue()) {
            String msg = String.format("Cancel requested by input handler '%s'", handler.getClass().getName());
            InfoUtils.showInGameMessage(Message.MessageType.INFO, msg, new Object[0]);
            MaLiLib.LOGGER.info(msg);
        }
    }

    @ApiStatus.Internal
    public boolean onMouseScroll(double mouseX, double mouseY, double xOffset, double yOffset, @Nonnull Minecraft mc) {
        boolean discrete = (Boolean)mc.options.discreteMouseScroll().get();
        double sensitivity = (Double)mc.options.mouseWheelSensitivity().get();
        double amount = (discrete ? Math.signum(yOffset) : yOffset) * sensitivity;
        if (MaLiLibConfigs.Debug.MOUSE_SCROLL_DEBUG.getBooleanValue()) {
            int time = (int)(System.currentTimeMillis() & 0xFFFFL);
            int tick = mc.level != null ? (int)(mc.level.getGameTime() & 0xFFFFL) : 0;
            String timeStr = String.format("time: %04X, tick: %04X", time, tick);
            MaLiLib.LOGGER.info("{} - xOffset: {}, yOffset: {}, discrete: {}, sensitivity: {}, amount: {}", (Object)timeStr, (Object)xOffset, (Object)yOffset, (Object)discrete, (Object)sensitivity, (Object)amount);
        }
        if (amount != 0.0 && !this.mouseHandlers.isEmpty()) {
            if (this.mouseWheelDeltaSum != 0.0 && Math.signum(amount) != Math.signum(this.mouseWheelDeltaSum)) {
                this.mouseWheelDeltaSum = 0.0;
            }
            this.mouseWheelDeltaSum += amount;
            amount = (int)this.mouseWheelDeltaSum;
            if (amount != 0.0) {
                this.mouseWheelDeltaSum -= amount;
                for (IMouseInputHandler handler : this.mouseHandlers) {
                    if (!handler.onMouseScroll(mouseX, mouseY, amount)) continue;
                    this.printInputCancellationDebugMessage(handler);
                    return true;
                }
            }
        }
        return false;
    }

    @ApiStatus.Internal
    public void onMouseMove(double mouseX, double mouseY, @Nonnull Minecraft mc) {
        if (!this.mouseHandlers.isEmpty()) {
            for (IMouseInputHandler handler : this.mouseHandlers) {
                handler.onMouseMove(mouseX, mouseY);
            }
        }
    }

    private boolean checkKeyBindsForChanges(int eventKey) {
        boolean cancel = false;
        Collection keybinds = this.hotkeyMap.get((Object)eventKey);
        if (!keybinds.isEmpty()) {
            for (IKeybind keybind : keybinds) {
                cancel |= keybind.updateIsPressed();
            }
        }
        return cancel;
    }
}

