/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiDialogBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import org.joml.Matrix3x2fStack;

public abstract class GuiTextInputBase
extends GuiDialogBase {
    protected final GuiTextFieldGeneric textField;
    protected final String originalText;

    public GuiTextInputBase(int maxTextLength, String titleKey, String defaultText, @Nullable Screen parent) {
        this.setParent(parent);
        this.title = StringUtils.translate(titleKey, new Object[0]);
        this.useTitleHierarchy = false;
        this.originalText = defaultText;
        this.setWidthAndHeight(260, 100);
        this.centerOnScreen();
        int width = Math.min(maxTextLength * 10, 240);
        this.textField = new GuiTextFieldGeneric(this.dialogLeft + 12, this.dialogTop + 40, width, 20, this.textRenderer);
        this.textField.setMaxLength(maxTextLength);
        this.textField.setFocused(true);
        this.textField.setValue(this.originalText);
    }

    @Override
    public void initGui() {
        int x = this.dialogLeft + 10;
        int y = this.dialogTop + 70;
        x += this.createButton(x, y, ButtonType.OK) + 2;
        x += this.createButton(x, y, ButtonType.RESET) + 2;
        this.createButton(x, y, ButtonType.CANCEL);
    }

    protected int createButton(int x, int y, ButtonType type) {
        ButtonGeneric button = new ButtonGeneric(x, y, -1, 20, type.getDisplayName(), new String[0]);
        button.setWidth(Math.max(40, button.getWidth()));
        return this.addButton(button, this.createActionListener(type)).getWidth();
    }

    @Override
    public boolean isPauseScreen() {
        return this.getParent() != null && this.getParent().isPauseScreen();
    }

    @Override
    public void drawContents(GuiGraphics drawContext, int mouseX, int mouseY, float partialTicks) {
        if (this.getParent() != null) {
            this.getParent().render(drawContext, mouseX, mouseY, partialTicks);
        }
        Matrix3x2fStack matrixStack = drawContext.pose();
        matrixStack.pushMatrix();
        matrixStack.translate(0.0f, 0.0f);
        RenderUtils.drawOutlinedBox(drawContext, this.dialogLeft, this.dialogTop, this.dialogWidth, this.dialogHeight, -536870912, -6710887);
        this.drawStringWithShadow(drawContext, this.getTitleString(), this.dialogLeft + 10, this.dialogTop + 4, -1);
        this.textField.render(drawContext, mouseX, mouseY, partialTicks);
        this.drawButtons(drawContext, mouseX, mouseY, partialTicks);
        matrixStack.popMatrix();
    }

    @Override
    public boolean onKeyTyped(KeyEvent input) {
        if (input.key() == 257) {
            if (this.applyValue(this.textField.getValue())) {
                GuiBase.openGui(this.getParent());
            }
            return true;
        }
        if (input.key() == 256) {
            GuiBase.openGui(this.getParent());
            return true;
        }
        if (this.textField.isFocused()) {
            return this.textField.keyPressed(input);
        }
        return super.onKeyTyped(input);
    }

    @Override
    public boolean onCharTyped(CharacterEvent input) {
        if (this.textField.isFocused()) {
            return this.textField.charTyped(input);
        }
        return super.onCharTyped(input);
    }

    @Override
    public boolean onMouseClicked(MouseButtonEvent click, boolean doubleClick) {
        if (this.textField.mouseClicked(click, doubleClick)) {
            return true;
        }
        return super.onMouseClicked(click, doubleClick);
    }

    protected ButtonListener createActionListener(ButtonType type) {
        return new ButtonListener(type, this);
    }

    protected abstract boolean applyValue(String var1);

    protected static enum ButtonType {
        OK("malilib.gui.button.ok"),
        CANCEL("malilib.gui.button.cancel"),
        RESET("malilib.gui.button.reset");

        private final String labelKey;

        private ButtonType(String labelKey) {
            this.labelKey = labelKey;
        }

        public String getDisplayName() {
            return StringUtils.translate(this.labelKey, new Object[0]);
        }
    }

    protected static class ButtonListener
    implements IButtonActionListener {
        private final GuiTextInputBase gui;
        private final ButtonType type;

        public ButtonListener(ButtonType type, GuiTextInputBase gui) {
            this.type = type;
            this.gui = gui;
        }

        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == ButtonType.OK) {
                if (this.gui.applyValue(this.gui.textField.getValue())) {
                    GuiBase.openGui(this.gui.getParent());
                }
            } else if (this.type == ButtonType.CANCEL) {
                GuiBase.openGui(this.gui.getParent());
            } else if (this.type == ButtonType.RESET) {
                this.gui.textField.setValue(this.gui.originalText);
                this.gui.textField.setFocused(true);
            }
        }
    }
}

