/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.interfaces;

import fi.dy.masa.malilib.mixin.entity.IMixinAbstractHorseEntity;
import fi.dy.masa.malilib.mixin.entity.IMixinPiglinEntity;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.data.DataEntityUtils;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.converter.DataConverterNbt;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

public interface IDataSyncer {
    @Nullable
    default public Level getWorld() {
        if (Minecraft.getInstance() == null) {
            return null;
        }
        return WorldUtils.getBestWorld(Minecraft.getInstance());
    }

    @Nullable
    default public ClientLevel getClientWorld() {
        if (Minecraft.getInstance().level == null) {
            return null;
        }
        return Minecraft.getInstance().level;
    }

    default public void reset(boolean isLogout) {
    }

    default public void onGameInit() {
    }

    default public void onWorldPre() {
    }

    default public void onWorldJoin() {
    }

    @Nullable
    default public CompoundTag getFromBlockEntityCacheNbt(BlockPos pos) {
        return null;
    }

    @Nullable
    default public CompoundData getFromBlockEntityCacheData(BlockPos pos) {
        return null;
    }

    @Nullable
    default public BlockEntity getFromBlockEntityCache(BlockPos pos) {
        return null;
    }

    @Nullable
    default public CompoundTag getFromEntityCacheNbt(int entityId) {
        return null;
    }

    @Nullable
    default public CompoundData getFromEntityCacheData(int entityId) {
        return null;
    }

    @Nullable
    default public Entity getFromEntityCache(int entityId) {
        return null;
    }

    @Nullable
    default public Pair<BlockEntity, CompoundTag> requestBlockEntity(Level world, BlockPos pos) {
        BlockEntity be;
        if (world == null) {
            world = this.getWorld();
        }
        if (world == null) {
            return null;
        }
        if (world.getBlockState(pos).getBlock() instanceof EntityBlock && (be = world.getChunkAt(pos).getBlockEntity(pos)) != null) {
            CompoundTag nbt = be.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
            return Pair.of((Object)be, (Object)nbt);
        }
        return null;
    }

    @Nullable
    default public Pair<BlockEntity, CompoundData> requestBlockEntityNew(Level world, BlockPos pos) {
        BlockEntity be;
        if (world == null) {
            world = this.getWorld();
        }
        if (world == null) {
            return null;
        }
        if (world.getBlockState(pos).getBlock() instanceof EntityBlock && (be = world.getChunkAt(pos).getBlockEntity(pos)) != null) {
            return Pair.of((Object)be, (Object)DataConverterNbt.fromVanillaCompound(be.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess())));
        }
        return null;
    }

    @Nullable
    default public Pair<Entity, CompoundTag> requestEntity(Level world, int entityId) {
        if (world == null) {
            world = this.getWorld();
        }
        if (world == null) {
            return null;
        }
        Entity entity = world.getEntity(entityId);
        if (entity != null) {
            return Pair.of((Object)entity, (Object)NbtEntityUtils.invokeEntityNbtDataNoPassengers(entity, entityId));
        }
        return null;
    }

    @Nullable
    default public Pair<Entity, CompoundData> requestEntityNew(Level world, int entityId) {
        if (world == null) {
            world = this.getWorld();
        }
        if (world == null) {
            return null;
        }
        Entity entity = world.getEntity(entityId);
        if (entity != null) {
            return Pair.of((Object)entity, (Object)DataEntityUtils.invokeEntityDataTagNoPassengers(entity, entityId));
        }
        return null;
    }

    @Nullable
    default public Container getBlockInventory(Level world, BlockPos pos, boolean useNbt) {
        if (world == null) {
            world = this.getWorld();
        }
        if (world == null) {
            return null;
        }
        Pair<BlockEntity, CompoundTag> pair = this.requestBlockEntity(world, pos);
        Container inv = null;
        if (pair == null) {
            return null;
        }
        if (useNbt) {
            inv = InventoryUtils.getNbtInventory((CompoundTag)pair.getRight(), -1, world.registryAccess());
        } else {
            BlockEntity be = (BlockEntity)pair.getLeft();
            BlockState state = world.getBlockState(pos);
            if (state.is(BlockTags.AIR) || !state.hasBlockEntity()) {
                return null;
            }
            if (be instanceof Container) {
                Container inv1 = (Container)be;
                if (be instanceof ChestBlockEntity && state.hasProperty((Property)ChestBlock.TYPE)) {
                    ChestType type = (ChestType)state.getValue((Property)ChestBlock.TYPE);
                    if (type != ChestType.SINGLE) {
                        Object object;
                        BlockPos posAdj = pos.relative(ChestBlock.getConnectedDirection((BlockState)state));
                        if (!world.hasChunkAt(posAdj)) {
                            return null;
                        }
                        BlockState stateAdj = world.getBlockState(posAdj);
                        Pair<BlockEntity, CompoundTag> pairAdj = this.requestBlockEntity(world, posAdj);
                        if (pairAdj == null) {
                            return inv1;
                        }
                        if (stateAdj.getBlock() == state.getBlock() && (object = pairAdj.getLeft()) instanceof ChestBlockEntity) {
                            ChestBlockEntity inv2 = (ChestBlockEntity)object;
                            if (stateAdj.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE && stateAdj.getValue((Property)ChestBlock.FACING) == state.getValue((Property)ChestBlock.FACING)) {
                                Container invRight = type == ChestType.RIGHT ? inv1 : inv2;
                                ChestBlockEntity invLeft = type == ChestType.RIGHT ? inv2 : inv1;
                                inv = new CompoundContainer(invRight, (Container)invLeft);
                            }
                        }
                    } else {
                        inv = inv1;
                    }
                } else {
                    inv = inv1;
                }
            }
        }
        return inv;
    }

    @Nullable
    default public Container getBlockInventoryNew(Level world, BlockPos pos, boolean useNbt) {
        if (world == null) {
            world = this.getWorld();
        }
        if (world == null) {
            return null;
        }
        Pair<BlockEntity, CompoundData> pair = this.requestBlockEntityNew(world, pos);
        Container inv = null;
        if (pair == null) {
            return null;
        }
        if (useNbt) {
            inv = InventoryUtils.getDataInventory((CompoundData)pair.getRight(), -1, world.registryAccess());
        } else {
            BlockEntity be = (BlockEntity)pair.getLeft();
            BlockState state = world.getBlockState(pos);
            if (state.is(BlockTags.AIR) || !state.hasBlockEntity()) {
                return null;
            }
            if (be instanceof Container) {
                Container inv1 = (Container)be;
                if (be instanceof ChestBlockEntity && state.hasProperty((Property)ChestBlock.TYPE)) {
                    ChestType type = (ChestType)state.getValue((Property)ChestBlock.TYPE);
                    if (type != ChestType.SINGLE) {
                        Object object;
                        BlockPos posAdj = pos.relative(ChestBlock.getConnectedDirection((BlockState)state));
                        if (!world.hasChunkAt(posAdj)) {
                            return null;
                        }
                        BlockState stateAdj = world.getBlockState(posAdj);
                        Pair<BlockEntity, CompoundData> pairAdj = this.requestBlockEntityNew(world, posAdj);
                        if (pairAdj == null) {
                            return inv1;
                        }
                        if (stateAdj.getBlock() == state.getBlock() && (object = pairAdj.getLeft()) instanceof ChestBlockEntity) {
                            ChestBlockEntity inv2 = (ChestBlockEntity)object;
                            if (stateAdj.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE && stateAdj.getValue((Property)ChestBlock.FACING) == state.getValue((Property)ChestBlock.FACING)) {
                                Container invRight = type == ChestType.RIGHT ? inv1 : inv2;
                                ChestBlockEntity invLeft = type == ChestType.RIGHT ? inv2 : inv1;
                                inv = new CompoundContainer(invRight, (Container)invLeft);
                            }
                        }
                    } else {
                        inv = inv1;
                    }
                } else {
                    inv = inv1;
                }
            }
        }
        return inv;
    }

    @Nullable
    default public Container getEntityInventory(Level world, int entityId, boolean useNbt) {
        if (world == null) {
            world = this.getWorld();
        }
        if (world == null) {
            return null;
        }
        Pair<Entity, CompoundTag> pair = this.requestEntity(world, entityId);
        Container inv = null;
        if (pair == null) {
            return null;
        }
        if (!useNbt) {
            Entity entity = (Entity)pair.getLeft();
            if (entity instanceof Container) {
                inv = (Container)entity;
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                inv = new SimpleContainer((ItemStack[])player.getInventory().getNonEquipmentItems().toArray((Object[])new ItemStack[36]));
            } else if (entity instanceof Villager) {
                inv = ((Villager)entity).getInventory();
            } else if (entity instanceof AbstractHorse) {
                inv = ((IMixinAbstractHorseEntity)entity).malilib_getHorseInventory();
            } else if (entity instanceof Piglin) {
                inv = ((IMixinPiglinEntity)entity).malilib_getInventory();
            }
            return inv;
        }
        inv = InventoryUtils.getNbtInventory((CompoundTag)pair.getRight(), -1, world.registryAccess());
        return inv;
    }

    @Nullable
    default public Container getEntityInventoryNew(Level world, int entityId, boolean useData) {
        if (world == null) {
            world = this.getWorld();
        }
        if (world == null) {
            return null;
        }
        Pair<Entity, CompoundData> pair = this.requestEntityNew(world, entityId);
        Container inv = null;
        if (pair == null) {
            return null;
        }
        if (!useData) {
            Entity entity = (Entity)pair.getLeft();
            if (entity instanceof Container) {
                inv = (Container)entity;
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                inv = new SimpleContainer((ItemStack[])player.getInventory().getNonEquipmentItems().toArray((Object[])new ItemStack[36]));
            } else if (entity instanceof Villager) {
                inv = ((Villager)entity).getInventory();
            } else if (entity instanceof AbstractHorse) {
                inv = ((IMixinAbstractHorseEntity)entity).malilib_getHorseInventory();
            } else if (entity instanceof Piglin) {
                inv = ((IMixinPiglinEntity)entity).malilib_getInventory();
            }
            return inv;
        }
        inv = InventoryUtils.getDataInventory((CompoundData)pair.getRight(), -1, world.registryAccess());
        return inv;
    }

    default public BlockEntity handleBlockEntityData(BlockPos pos, CompoundTag nbt, @Nullable ResourceLocation type) {
        return null;
    }

    default public Entity handleEntityData(int entityId, CompoundTag nbt) {
        return null;
    }

    default public void handleBulkEntityData(int transactionId, CompoundTag nbt) {
    }

    default public void handleVanillaQueryNbt(int transactionId, CompoundTag nbt) {
    }

    @ApiStatus.Experimental
    default public BlockEntity handleBlockEntityData(BlockPos pos, CompoundData data, @Nullable ResourceLocation type) {
        return null;
    }

    @ApiStatus.Experimental
    default public Entity handleEntityData(int entityId, CompoundData data) {
        return null;
    }

    @ApiStatus.Experimental
    default public void handleBulkEntityData(int transactionId, CompoundData data) {
    }

    @ApiStatus.Experimental
    default public void handleVanillaQueryNbt(int transactionId, CompoundData data) {
    }
}

