/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.event.RenderEventHandler;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.mixin.item.IMixinContainerComponent;
import fi.dy.masa.malilib.render.InventoryOverlayContext;
import fi.dy.masa.malilib.render.InventoryOverlayType;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.MathUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.data.DataBlockUtils;
import fi.dy.masa.malilib.util.data.DataEntityUtils;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.game.IEntityOwnedInventory;
import fi.dy.masa.malilib.util.log.AnsiLogger;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.coppergolem.CopperGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractChestBoat;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.CrafterBlock;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.ShelfBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.ShelfBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix3x2fStack;

public class InventoryOverlay {
    private static final AnsiLogger LOGGER = new AnsiLogger(InventoryOverlay.class);
    public static final ResourceLocation TEXTURE_BREWING_STAND = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/brewing_stand.png");
    public static final ResourceLocation TEXTURE_CRAFTER = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/crafter.png");
    public static final ResourceLocation TEXTURE_DISPENSER = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/dispenser.png");
    public static final ResourceLocation TEXTURE_DOUBLE_CHEST = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/generic_54.png");
    public static final ResourceLocation TEXTURE_FURNACE = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/furnace.png");
    public static final ResourceLocation TEXTURE_HOPPER = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/hopper.png");
    public static final ResourceLocation TEXTURE_PLAYER_INV = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/inventory.png");
    public static final ResourceLocation TEXTURE_SINGLE_CHEST = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/shulker_box.png");
    public static final ResourceLocation TEXTURE_EMPTY_SHIELD = ResourceLocation.withDefaultNamespace((String)"container/slot/shield");
    public static final ResourceLocation TEXTURE_LOCKED_SLOT = ResourceLocation.withDefaultNamespace((String)"container/crafter/disabled_slot");
    public static final ResourceLocation TEXTURE_EMPTY_HORSE_ARMOR = ResourceLocation.withDefaultNamespace((String)"container/slot/horse_armor");
    public static final ResourceLocation TEXTURE_EMPTY_LLAMA_ARMOR = ResourceLocation.withDefaultNamespace((String)"container/slot/llama_armor");
    public static final ResourceLocation TEXTURE_EMPTY_SADDLE = ResourceLocation.withDefaultNamespace((String)"container/slot/saddle");
    public static final ResourceLocation TEXTURE_EMPTY_BREWER_FUEL = ResourceLocation.withDefaultNamespace((String)"container/slot/brewing_fuel");
    public static final ResourceLocation TEXTURE_EMPTY_POTION = ResourceLocation.withDefaultNamespace((String)"container/slot/potion");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_AMETHYST = ResourceLocation.withDefaultNamespace((String)"container/slot/amethyst_shard");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_AXE = ResourceLocation.withDefaultNamespace((String)"container/slot/axe");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_BANNER = ResourceLocation.withDefaultNamespace((String)"container/slot/banner");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_PATTERN = ResourceLocation.withDefaultNamespace((String)"container/slot/banner_pattern");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_DIAMOND = ResourceLocation.withDefaultNamespace((String)"container/slot/diamond");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_DYE = ResourceLocation.withDefaultNamespace((String)"container/slot/dye");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_EMERALD = ResourceLocation.withDefaultNamespace((String)"container/slot/emerald");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_HOE = ResourceLocation.withDefaultNamespace((String)"container/slot/hoe");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_INGOT = ResourceLocation.withDefaultNamespace((String)"container/slot/ingot");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_LAPIS = ResourceLocation.withDefaultNamespace((String)"container/slot/lapis_lazuli");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_PICKAXE = ResourceLocation.withDefaultNamespace((String)"container/slot/pickaxe");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_QUARTZ = ResourceLocation.withDefaultNamespace((String)"container/slot/quartz");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_REDSTONE = ResourceLocation.withDefaultNamespace((String)"container/slot/redstone_dust");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_SHOVEL = ResourceLocation.withDefaultNamespace((String)"container/slot/shovel");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_ARMOR_TRIM = ResourceLocation.withDefaultNamespace((String)"container/slot/smithing_template_armor_trim");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_UPGRADE = ResourceLocation.withDefaultNamespace((String)"container/slot/smithing_template_netherite_upgrade");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT_SWORD = ResourceLocation.withDefaultNamespace((String)"container/slot/sword");
    public static final ResourceLocation TEXTURE_EMPTY_SLOT = ResourceLocation.withDefaultNamespace((String)"container/slot");
    public static final ResourceLocation TEXTURE_HIGHLIGHT_BACK = ResourceLocation.withDefaultNamespace((String)"container/slot_highlight_back");
    public static final ResourceLocation TEXTURE_HIGHLIGHT_FRONT = ResourceLocation.withDefaultNamespace((String)"container/slot_highlight_front");
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final InventoryProperties INV_PROPS_TEMP = new InventoryProperties();
    private static final ResourceLocation[] EMPTY_SLOT_TEXTURES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"container/slot/boots"), ResourceLocation.withDefaultNamespace((String)"container/slot/leggings"), ResourceLocation.withDefaultNamespace((String)"container/slot/chestplate"), ResourceLocation.withDefaultNamespace((String)"container/slot/helmet")};
    private static ItemStack hoveredStack = null;

    public static void renderInventoryBackground(GuiGraphics context, InventoryRenderType type, int x, int y, int slotsPerRow, int totalSlots, Minecraft mc) {
        InventoryOverlay.renderInventoryBackground(context, type, x, y, slotsPerRow, totalSlots, -1, mc);
    }

    public static void renderInventoryBackground(GuiGraphics context, InventoryRenderType type, int x, int y, int slotsPerRow, int totalSlots, int color, Minecraft mc) {
        if (type == InventoryRenderType.FURNACE) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_FURNACE);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 4, 64, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 4, y, 84, 0, 92, 4, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 64, 0, 162, 92, 4, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 92, y + 4, 172, 102, 4, 64, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 4, y + 4, 52, 13, 88, 60, color);
        } else if (type == InventoryRenderType.BREWING_STAND) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_BREWING_STAND);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 4, 68, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 4, y, 63, 0, 113, 4, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 68, 0, 162, 113, 4, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 113, y + 4, 172, 98, 4, 68, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 4, y + 4, 13, 13, 109, 64, color);
        } else if (type == InventoryRenderType.CRAFTER) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_DISPENSER);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, 61, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 115, 0, 61, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 61, 0, 159, 61, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 61, y + 7, 169, 105, 7, 61, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 61, 16, 54, 54, color);
        } else if (type == InventoryRenderType.DISPENSER) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_DISPENSER);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, 61, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 115, 0, 61, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 61, 0, 159, 61, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 61, y + 7, 169, 105, 7, 61, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 61, 16, 54, 54, color);
        } else if (type == InventoryRenderType.HOPPER) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_HOPPER);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, 25, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 79, 0, 97, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 25, 0, 126, 97, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 97, y + 7, 169, 108, 7, 25, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 43, 19, 90, 18, color);
        } else if (type == InventoryRenderType.VILLAGER) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_DOUBLE_CHEST);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, 79, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 133, 0, 43, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 79, 0, 215, 43, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 43, y + 7, 169, 143, 7, 79, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 7, 17, 36, 72, color);
        } else if (type == InventoryRenderType.FIXED_27) {
            InventoryOverlay.renderInventoryBackground27(x, y, color, mc, context);
        } else if (type == InventoryRenderType.FIXED_54) {
            InventoryOverlay.renderInventoryBackground54(x, y, color, mc, context);
        } else {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_DOUBLE_CHEST);
            if (gpuTextureView == null) {
                return;
            }
            int rows = (int)Math.ceil((double)totalSlots / (double)slotsPerRow);
            int bgw = Math.min(totalSlots, slotsPerRow) * 18 + 7;
            int bgh = rows * 18 + 7;
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, bgh, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 176 - bgw, 0, bgw, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + bgh, 0, 215, bgw, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + bgw, y + 7, 169, 222 - bgh, 7, bgh, color);
            for (int row = 0; row < rows; ++row) {
                int rowLen = Mth.clamp((int)(totalSlots - row * slotsPerRow), (int)1, (int)slotsPerRow);
                RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + row * 18 + 7, 7, 17, rowLen * 18, 18, color);
                if (rows <= 1 || rowLen >= slotsPerRow) continue;
                RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + rowLen * 18 + 7, y + row * 18 + 7, 7, 3, (slotsPerRow - rowLen) * 18, 9, color);
                RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + rowLen * 18 + 7, y + row * 18 + 16, 7, 3, (slotsPerRow - rowLen) * 18, 9, color);
            }
        }
    }

    @ApiStatus.Experimental
    public static void renderInventoryBackgroundNew(GuiGraphics context, InventoryOverlayType type, int x, int y, int slotsPerRow, int totalSlots, Minecraft mc) {
        InventoryOverlay.renderInventoryBackgroundNew(context, type, x, y, slotsPerRow, totalSlots, -1, mc);
    }

    @ApiStatus.Experimental
    public static void renderInventoryBackgroundNew(GuiGraphics context, InventoryOverlayType type, int x, int y, int slotsPerRow, int totalSlots, int color, Minecraft mc) {
        if (type == InventoryOverlayType.FURNACE) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_FURNACE);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 4, 64, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 4, y, 84, 0, 92, 4, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 64, 0, 162, 92, 4, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 92, y + 4, 172, 102, 4, 64, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 4, y + 4, 52, 13, 88, 60, color);
        } else if (type == InventoryOverlayType.BREWING_STAND) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_BREWING_STAND);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 4, 68, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 4, y, 63, 0, 113, 4, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 68, 0, 162, 113, 4, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 113, y + 4, 172, 98, 4, 68, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 4, y + 4, 13, 13, 109, 64, color);
        } else if (type == InventoryOverlayType.CRAFTER) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_DISPENSER);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, 61, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 115, 0, 61, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 61, 0, 159, 61, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 61, y + 7, 169, 105, 7, 61, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 61, 16, 54, 54, color);
        } else if (type == InventoryOverlayType.DISPENSER) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_DISPENSER);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, 61, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 115, 0, 61, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 61, 0, 159, 61, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 61, y + 7, 169, 105, 7, 61, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 61, 16, 54, 54, color);
        } else if (type == InventoryOverlayType.HOPPER) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_HOPPER);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, 25, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 79, 0, 97, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 25, 0, 126, 97, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 97, y + 7, 169, 108, 7, 25, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 43, 19, 90, 18, color);
        } else if (type == InventoryOverlayType.VILLAGER) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_DOUBLE_CHEST);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, 79, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 133, 0, 43, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 79, 0, 215, 43, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 43, y + 7, 169, 143, 7, 79, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 7, 17, 36, 72, color);
        } else if (type == InventoryOverlayType.FIXED_27) {
            InventoryOverlay.renderInventoryBackground27(x, y, color, mc, context);
        } else if (type == InventoryOverlayType.FIXED_54) {
            InventoryOverlay.renderInventoryBackground54(x, y, color, mc, context);
        } else {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_DOUBLE_CHEST);
            if (gpuTextureView == null) {
                return;
            }
            int rows = (int)Math.ceil((double)totalSlots / (double)slotsPerRow);
            int bgw = Math.min(totalSlots, slotsPerRow) * 18 + 7;
            int bgh = rows * 18 + 7;
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, bgh, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 176 - bgw, 0, bgw, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + bgh, 0, 215, bgw, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + bgw, y + 7, 169, 222 - bgh, 7, bgh, color);
            for (int row = 0; row < rows; ++row) {
                int rowLen = Mth.clamp((int)(totalSlots - row * slotsPerRow), (int)1, (int)slotsPerRow);
                RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + row * 18 + 7, 7, 17, rowLen * 18, 18, color);
                if (rows <= 1 || rowLen >= slotsPerRow) continue;
                RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + rowLen * 18 + 7, y + row * 18 + 7, 7, 3, (slotsPerRow - rowLen) * 18, 9, color);
                RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + rowLen * 18 + 7, y + row * 18 + 16, 7, 3, (slotsPerRow - rowLen) * 18, 9, color);
            }
        }
    }

    public static void renderInventoryBackground27(int x, int y, int color, Minecraft mc, GuiGraphics context) {
        GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_SINGLE_CHEST);
        if (gpuTextureView == null) {
            return;
        }
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, 61, color);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 7, 0, 169, 7, color);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 61, 0, 159, 169, 7, color);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 169, y + 7, 169, 105, 7, 61, color);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 7, 17, 162, 54, color);
    }

    public static void renderInventoryBackground54(int x, int y, int color, Minecraft mc, GuiGraphics context) {
        GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_DOUBLE_CHEST);
        if (gpuTextureView == null) {
            return;
        }
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, 115, color);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 7, 0, 169, 7, color);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 115, 0, 215, 169, 7, color);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 169, y + 7, 169, 107, 7, 115, color);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 7, 17, 162, 108, color);
    }

    public static void renderInventoryBackgroundSlots(GuiGraphics drawContext, InventoryRenderType type, Container inv, int x, int y) {
        if (type == InventoryRenderType.BREWING_STAND) {
            InventoryOverlay.renderBrewerBackgroundSlots(drawContext, inv, x, y);
        } else if (type == InventoryRenderType.HORSE) {
            InventoryOverlay.renderHorseArmorBackgroundSlots(drawContext, inv, x, y);
        } else if (type == InventoryRenderType.LLAMA) {
            InventoryOverlay.renderLlamaArmorBackgroundSlots(drawContext, inv, x, y);
        } else if (type == InventoryRenderType.WOLF || type == InventoryRenderType.HAPPY_GHAST || type == InventoryRenderType.COPPER_GOLEM) {
            InventoryOverlay.renderWolfArmorBackgroundSlots(drawContext, inv, x, y);
        }
    }

    @ApiStatus.Experimental
    public static void renderInventoryBackgroundSlotsNew(GuiGraphics drawContext, InventoryOverlayType type, Container inv, int x, int y) {
        if (type == InventoryOverlayType.BREWING_STAND) {
            InventoryOverlay.renderBrewerBackgroundSlots(drawContext, inv, x, y);
        } else if (type == InventoryOverlayType.HORSE) {
            InventoryOverlay.renderHorseArmorBackgroundSlots(drawContext, inv, x, y);
        } else if (type == InventoryOverlayType.LLAMA) {
            InventoryOverlay.renderLlamaArmorBackgroundSlots(drawContext, inv, x, y);
        } else if (type == InventoryOverlayType.WOLF || type == InventoryOverlayType.HAPPY_GHAST || type == InventoryOverlayType.COPPER_GOLEM) {
            InventoryOverlay.renderWolfArmorBackgroundSlots(drawContext, inv, x, y);
        }
    }

    public static void renderBrewerBackgroundSlots(GuiGraphics drawContext, Container inv, int x, int y) {
        InventoryOverlay.renderBrewerBackgroundSlots(drawContext, inv, x, y, 0.9f, 0.0, 0.0);
    }

    public static void renderBrewerBackgroundSlots(GuiGraphics drawContext, Container inv, int x, int y, float scale, double mouseX, double mouseY) {
        if (inv.getItem(0).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(drawContext, TEXTURE_EMPTY_POTION, x + 47, y + 42, scale, mouseX, mouseY);
        }
        if (inv.getItem(1).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(drawContext, TEXTURE_EMPTY_POTION, x + 70, y + 49, scale, mouseX, mouseY);
        }
        if (inv.getItem(2).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(drawContext, TEXTURE_EMPTY_POTION, x + 93, y + 42, scale, mouseX, mouseY);
        }
        if (inv.getItem(4).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(drawContext, TEXTURE_EMPTY_BREWER_FUEL, x + 8, y + 8, scale, mouseX, mouseY);
        }
    }

    public static void renderHorseArmorBackgroundSlots(GuiGraphics drawContext, Container inv, int x, int y) {
        InventoryOverlay.renderHorseArmorBackgroundSlots(drawContext, inv, x, y, 0.9f, 0.0, 0.0);
    }

    public static void renderHorseArmorBackgroundSlots(GuiGraphics drawContext, Container inv, int x, int y, float scale, double mouseX, double mouseY) {
        if (inv.getItem(0).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(drawContext, TEXTURE_EMPTY_HORSE_ARMOR, x, y, scale, mouseX, mouseY);
        }
        if (inv.getItem(1).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(drawContext, TEXTURE_EMPTY_SADDLE, x, y + 18, scale, mouseX, mouseY);
        }
    }

    public static void renderLlamaArmorBackgroundSlots(GuiGraphics drawContext, Container inv, int x, int y) {
        InventoryOverlay.renderLlamaArmorBackgroundSlots(drawContext, inv, x, y, 0.9f, 0.0, 0.0);
    }

    public static void renderLlamaArmorBackgroundSlots(GuiGraphics drawContext, Container inv, int x, int y, float scale, double mouseX, double mouseY) {
        if (inv.getItem(0).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(drawContext, TEXTURE_EMPTY_LLAMA_ARMOR, x, y, scale, mouseX, mouseY);
        }
    }

    public static void renderWolfArmorBackgroundSlots(GuiGraphics drawContext, Container inv, int x, int y) {
        InventoryOverlay.renderWolfArmorBackgroundSlots(drawContext, inv, x, y, 0.9f, 0.0, 0.0);
    }

    public static void renderWolfArmorBackgroundSlots(GuiGraphics drawContext, Container inv, int x, int y, float scale, double mouseX, double mouseY) {
        if (inv.getItem(0).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(drawContext, TEXTURE_EMPTY_HORSE_ARMOR, x, y, scale, mouseX, mouseY);
        }
    }

    public static void renderEquipmentOverlayBackground(GuiGraphics context, int x, int y, LivingEntity entity) {
        GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_DISPENSER);
        if (gpuTextureView == null) {
            return;
        }
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 50, 83);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 50, y, 173, 0, 3, 83);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 83, 0, 163, 50, 3);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 50, y + 83, 173, 163, 3, 3);
        int i = 0;
        int xOff = 7;
        int yOff = 7;
        while (i < 4) {
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + xOff, y + yOff, 61, 16, 18, 18);
            ++i;
            yOff += 18;
        }
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 28, y + 36 + 7, 61, 16, 18, 18);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 28, y + 54 + 7, 61, 16, 18, 18);
        if (entity.getItemBySlot(EquipmentSlot.OFFHAND).isEmpty()) {
            InventoryOverlay.renderBackgroundSlotAt(context, TEXTURE_EMPTY_SHIELD, x + 28 + 1, y + 54 + 7 + 1);
        }
        i = 0;
        xOff = 7;
        yOff = 7;
        while (i < 4) {
            EquipmentSlot eqSlot = VALID_EQUIPMENT_SLOTS[i];
            if (entity.getItemBySlot(eqSlot).isEmpty()) {
                ResourceLocation texture = EMPTY_SLOT_TEXTURES[eqSlot.getIndex()];
                InventoryOverlay.renderBackgroundSlotAt(context, texture, x + xOff + 1, y + yOff + 1);
            }
            ++i;
            yOff += 18;
        }
    }

    public static InventoryRenderType getInventoryType(@Nullable Container inv) {
        if (inv == null) {
            return InventoryRenderType.GENERIC;
        }
        if (inv instanceof ShulkerBoxBlockEntity) {
            return InventoryRenderType.FIXED_27;
        }
        if (inv instanceof CompoundContainer) {
            return InventoryRenderType.FIXED_54;
        }
        if (inv instanceof AbstractChestBoat) {
            return InventoryRenderType.FIXED_27;
        }
        if (inv instanceof MinecartChest) {
            return InventoryRenderType.FIXED_27;
        }
        if (inv instanceof AbstractFurnaceBlockEntity) {
            return InventoryRenderType.FURNACE;
        }
        if (inv instanceof BrewingStandBlockEntity) {
            return InventoryRenderType.BREWING_STAND;
        }
        if (inv instanceof CrafterBlockEntity) {
            return InventoryRenderType.CRAFTER;
        }
        if (inv instanceof DispenserBlockEntity) {
            return InventoryRenderType.DISPENSER;
        }
        if (inv instanceof HopperBlockEntity) {
            return InventoryRenderType.HOPPER;
        }
        if (inv instanceof MinecartHopper) {
            return InventoryRenderType.HOPPER;
        }
        if (inv instanceof ChiseledBookShelfBlockEntity) {
            return InventoryRenderType.BOOKSHELF;
        }
        if (inv instanceof ShelfBlockEntity) {
            return InventoryRenderType.WALL_SHELF;
        }
        if (inv instanceof Inventory) {
            return InventoryRenderType.PLAYER;
        }
        if (inv instanceof IEntityOwnedInventory) {
            IEntityOwnedInventory inventory = (IEntityOwnedInventory)inv;
            if (inventory.malilib$getEntityOwner() instanceof Llama) {
                return InventoryRenderType.LLAMA;
            }
            if (inventory.malilib$getEntityOwner() instanceof Wolf) {
                return InventoryRenderType.WOLF;
            }
            if (inventory.malilib$getEntityOwner() instanceof CopperGolem) {
                return InventoryRenderType.COPPER_GOLEM;
            }
            if (inventory.malilib$getEntityOwner() instanceof AbstractHorse) {
                return InventoryRenderType.HORSE;
            }
            if (inventory.malilib$getEntityOwner() instanceof Piglin) {
                return InventoryRenderType.VILLAGER;
            }
        }
        return InventoryRenderType.GENERIC;
    }

    @ApiStatus.Experimental
    public static InventoryOverlayType getInventoryTypeNew(@Nullable Container inv) {
        if (inv == null) {
            return InventoryOverlayType.GENERIC;
        }
        if (inv instanceof ShulkerBoxBlockEntity) {
            return InventoryOverlayType.FIXED_27;
        }
        if (inv instanceof CompoundContainer) {
            return InventoryOverlayType.FIXED_54;
        }
        if (inv instanceof AbstractChestBoat) {
            return InventoryOverlayType.FIXED_27;
        }
        if (inv instanceof MinecartChest) {
            return InventoryOverlayType.FIXED_27;
        }
        if (inv instanceof AbstractFurnaceBlockEntity) {
            return InventoryOverlayType.FURNACE;
        }
        if (inv instanceof BrewingStandBlockEntity) {
            return InventoryOverlayType.BREWING_STAND;
        }
        if (inv instanceof CrafterBlockEntity) {
            return InventoryOverlayType.CRAFTER;
        }
        if (inv instanceof DispenserBlockEntity) {
            return InventoryOverlayType.DISPENSER;
        }
        if (inv instanceof HopperBlockEntity) {
            return InventoryOverlayType.HOPPER;
        }
        if (inv instanceof MinecartHopper) {
            return InventoryOverlayType.HOPPER;
        }
        if (inv instanceof ChiseledBookShelfBlockEntity) {
            return InventoryOverlayType.BOOKSHELF;
        }
        if (inv instanceof ShelfBlockEntity) {
            return InventoryOverlayType.WALL_SHELF;
        }
        if (inv instanceof Inventory) {
            return InventoryOverlayType.PLAYER;
        }
        if (inv instanceof IEntityOwnedInventory) {
            IEntityOwnedInventory inventory = (IEntityOwnedInventory)inv;
            if (inventory.malilib$getEntityOwner() instanceof Llama) {
                return InventoryOverlayType.LLAMA;
            }
            if (inventory.malilib$getEntityOwner() instanceof Wolf) {
                return InventoryOverlayType.WOLF;
            }
            if (inventory.malilib$getEntityOwner() instanceof CopperGolem) {
                return InventoryOverlayType.COPPER_GOLEM;
            }
            if (inventory.malilib$getEntityOwner() instanceof AbstractHorse) {
                return InventoryOverlayType.HORSE;
            }
            if (inventory.malilib$getEntityOwner() instanceof Piglin) {
                return InventoryOverlayType.VILLAGER;
            }
        }
        return InventoryOverlayType.GENERIC;
    }

    public static InventoryRenderType getInventoryType(ItemStack stack) {
        Item item = stack.getItem();
        ItemContainerContents container = (ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).getBlock();
            if (block instanceof ShulkerBoxBlock || block instanceof ChestBlock || block instanceof BarrelBlock) {
                int size = ((IMixinContainerComponent)container).malilib_getStacks().size();
                if (size >= 0 && size <= 27) {
                    return InventoryRenderType.FIXED_27;
                }
                if (size > 27 && size <= 54) {
                    return InventoryRenderType.FIXED_54;
                }
                if (size > 54 && size < 256) {
                    return InventoryRenderType.GENERIC;
                }
            } else {
                if (block instanceof AbstractFurnaceBlock) {
                    return InventoryRenderType.FURNACE;
                }
                if (block instanceof DispenserBlock) {
                    return InventoryRenderType.DISPENSER;
                }
                if (block instanceof HopperBlock) {
                    return InventoryRenderType.HOPPER;
                }
                if (block instanceof BrewingStandBlock) {
                    return InventoryRenderType.BREWING_STAND;
                }
                if (block instanceof CrafterBlock) {
                    return InventoryRenderType.CRAFTER;
                }
                if (block instanceof DecoratedPotBlock || block instanceof JukeboxBlock || block instanceof LecternBlock) {
                    return InventoryRenderType.SINGLE_ITEM;
                }
                if (block instanceof ChiseledBookShelfBlock) {
                    return InventoryRenderType.BOOKSHELF;
                }
                if (block instanceof ShelfBlock) {
                    return InventoryRenderType.WALL_SHELF;
                }
                if (block instanceof EnderChestBlock) {
                    return InventoryRenderType.ENDER_CHEST;
                }
            }
        } else if (item instanceof BundleItem) {
            return InventoryRenderType.BUNDLE;
        }
        return InventoryRenderType.GENERIC;
    }

    @ApiStatus.Experimental
    public static InventoryOverlayType getInventoryTypeNew(ItemStack stack) {
        Item item = stack.getItem();
        ItemContainerContents container = (ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).getBlock();
            if (block instanceof ShulkerBoxBlock || block instanceof ChestBlock || block instanceof BarrelBlock) {
                int size = ((IMixinContainerComponent)container).malilib_getStacks().size();
                if (size >= 0 && size <= 27) {
                    return InventoryOverlayType.FIXED_27;
                }
                if (size > 27 && size <= 54) {
                    return InventoryOverlayType.FIXED_54;
                }
                if (size > 54 && size < 256) {
                    return InventoryOverlayType.GENERIC;
                }
            } else {
                if (block instanceof AbstractFurnaceBlock) {
                    return InventoryOverlayType.FURNACE;
                }
                if (block instanceof DispenserBlock) {
                    return InventoryOverlayType.DISPENSER;
                }
                if (block instanceof HopperBlock) {
                    return InventoryOverlayType.HOPPER;
                }
                if (block instanceof BrewingStandBlock) {
                    return InventoryOverlayType.BREWING_STAND;
                }
                if (block instanceof CrafterBlock) {
                    return InventoryOverlayType.CRAFTER;
                }
                if (block instanceof DecoratedPotBlock || block instanceof JukeboxBlock || block instanceof LecternBlock) {
                    return InventoryOverlayType.SINGLE_ITEM;
                }
                if (block instanceof ChiseledBookShelfBlock) {
                    return InventoryOverlayType.BOOKSHELF;
                }
                if (block instanceof ShelfBlock) {
                    return InventoryOverlayType.WALL_SHELF;
                }
                if (block instanceof EnderChestBlock) {
                    return InventoryOverlayType.ENDER_CHEST;
                }
            }
        } else if (item instanceof BundleItem) {
            return InventoryOverlayType.BUNDLE;
        }
        return InventoryOverlayType.GENERIC;
    }

    public static InventoryRenderType getInventoryType(@Nonnull CompoundTag nbt) {
        EntityType<?> entityType;
        BlockEntityType<?> blockType = NbtBlockUtils.getBlockEntityTypeFromNbt(nbt);
        if (blockType != null) {
            if (blockType.equals((Object)BlockEntityType.SHULKER_BOX) || blockType.equals((Object)BlockEntityType.BARREL) || blockType.equals((Object)BlockEntityType.CHEST) || blockType.equals((Object)BlockEntityType.TRAPPED_CHEST)) {
                ListTag list;
                if (nbt.contains("Items") && (list = nbt.getList("Items").orElse(new ListTag())).size() > 27) {
                    return InventoryRenderType.FIXED_54;
                }
                return InventoryRenderType.FIXED_27;
            }
            if (blockType.equals((Object)BlockEntityType.FURNACE) || blockType.equals((Object)BlockEntityType.BLAST_FURNACE) || blockType.equals((Object)BlockEntityType.SMOKER)) {
                return InventoryRenderType.FURNACE;
            }
            if (blockType.equals((Object)BlockEntityType.DISPENSER) || blockType.equals((Object)BlockEntityType.DROPPER)) {
                return InventoryRenderType.DISPENSER;
            }
            if (blockType.equals((Object)BlockEntityType.HOPPER)) {
                return InventoryRenderType.HOPPER;
            }
            if (blockType.equals((Object)BlockEntityType.BREWING_STAND)) {
                return InventoryRenderType.BREWING_STAND;
            }
            if (blockType.equals((Object)BlockEntityType.CRAFTER)) {
                return InventoryRenderType.CRAFTER;
            }
            if (blockType.equals((Object)BlockEntityType.DECORATED_POT) || blockType.equals((Object)BlockEntityType.JUKEBOX) || blockType.equals((Object)BlockEntityType.LECTERN)) {
                return InventoryRenderType.SINGLE_ITEM;
            }
            if (blockType.equals((Object)BlockEntityType.CHISELED_BOOKSHELF)) {
                return InventoryRenderType.BOOKSHELF;
            }
            if (blockType.equals((Object)BlockEntityType.SHELF)) {
                return InventoryRenderType.WALL_SHELF;
            }
            if (blockType.equals((Object)BlockEntityType.ENDER_CHEST)) {
                return InventoryRenderType.ENDER_CHEST;
            }
        }
        if ((entityType = NbtEntityUtils.getEntityTypeFromNbt(nbt)) != null) {
            if (entityType.equals((Object)EntityType.CHEST_MINECART) || entityType.equals((Object)EntityType.ACACIA_CHEST_BOAT) || entityType.equals((Object)EntityType.BAMBOO_CHEST_RAFT) || entityType.equals((Object)EntityType.BIRCH_CHEST_BOAT) || entityType.equals((Object)EntityType.CHERRY_CHEST_BOAT) || entityType.equals((Object)EntityType.DARK_OAK_CHEST_BOAT) || entityType.equals((Object)EntityType.JUNGLE_CHEST_BOAT) || entityType.equals((Object)EntityType.MANGROVE_CHEST_BOAT) || entityType.equals((Object)EntityType.OAK_CHEST_BOAT) || entityType.equals((Object)EntityType.PALE_OAK_CHEST_BOAT) || entityType.equals((Object)EntityType.SPRUCE_CHEST_BOAT)) {
                return InventoryRenderType.FIXED_27;
            }
            if (entityType.equals((Object)EntityType.HOPPER_MINECART)) {
                return InventoryRenderType.HOPPER;
            }
            if (entityType.equals((Object)EntityType.HORSE) || entityType.equals((Object)EntityType.DONKEY) || entityType.equals((Object)EntityType.MULE) || entityType.equals((Object)EntityType.CAMEL) || entityType.equals((Object)EntityType.SKELETON_HORSE) || entityType.equals((Object)EntityType.ZOMBIE_HORSE)) {
                return InventoryRenderType.HORSE;
            }
            if (entityType.equals((Object)EntityType.LLAMA) || entityType.equals((Object)EntityType.TRADER_LLAMA)) {
                return InventoryRenderType.LLAMA;
            }
            if (entityType.equals((Object)EntityType.WOLF)) {
                return InventoryRenderType.WOLF;
            }
            if (entityType.equals((Object)EntityType.HAPPY_GHAST)) {
                return InventoryRenderType.HAPPY_GHAST;
            }
            if (entityType.equals((Object)EntityType.COPPER_GOLEM)) {
                return InventoryRenderType.COPPER_GOLEM;
            }
            if (entityType.equals((Object)EntityType.VILLAGER) || entityType.equals((Object)EntityType.ALLAY) || entityType.equals((Object)EntityType.PILLAGER) || entityType.equals((Object)EntityType.PIGLIN) || entityType.equals((Object)EntityType.WANDERING_TRADER) || entityType.equals((Object)EntityType.ZOMBIE_VILLAGER)) {
                return InventoryRenderType.VILLAGER;
            }
            if (entityType.equals((Object)EntityType.PLAYER)) {
                return InventoryRenderType.PLAYER;
            }
            if (entityType.equals((Object)EntityType.ARMOR_STAND)) {
                return InventoryRenderType.ARMOR_STAND;
            }
            if (nbt.contains("attributes") || nbt.contains("active_effects") || nbt.contains("FallFlying")) {
                return InventoryRenderType.LIVING_ENTITY;
            }
        }
        return InventoryRenderType.GENERIC;
    }

    @ApiStatus.Experimental
    public static InventoryOverlayType getInventoryTypeNew(@Nonnull CompoundData data) {
        EntityType<?> entityType;
        BlockEntityType<?> blockType = DataBlockUtils.getBlockEntityType(data);
        if (blockType != null) {
            if (blockType.equals((Object)BlockEntityType.SHULKER_BOX) || blockType.equals((Object)BlockEntityType.BARREL) || blockType.equals((Object)BlockEntityType.CHEST) || blockType.equals((Object)BlockEntityType.TRAPPED_CHEST)) {
                ListData list;
                if (data.contains("Items", 9) && (list = data.getList("Items")).size() > 27) {
                    return InventoryOverlayType.FIXED_54;
                }
                return InventoryOverlayType.FIXED_27;
            }
            if (blockType.equals((Object)BlockEntityType.FURNACE) || blockType.equals((Object)BlockEntityType.BLAST_FURNACE) || blockType.equals((Object)BlockEntityType.SMOKER)) {
                return InventoryOverlayType.FURNACE;
            }
            if (blockType.equals((Object)BlockEntityType.DISPENSER) || blockType.equals((Object)BlockEntityType.DROPPER)) {
                return InventoryOverlayType.DISPENSER;
            }
            if (blockType.equals((Object)BlockEntityType.HOPPER)) {
                return InventoryOverlayType.HOPPER;
            }
            if (blockType.equals((Object)BlockEntityType.BREWING_STAND)) {
                return InventoryOverlayType.BREWING_STAND;
            }
            if (blockType.equals((Object)BlockEntityType.CRAFTER)) {
                return InventoryOverlayType.CRAFTER;
            }
            if (blockType.equals((Object)BlockEntityType.DECORATED_POT) || blockType.equals((Object)BlockEntityType.JUKEBOX) || blockType.equals((Object)BlockEntityType.LECTERN)) {
                return InventoryOverlayType.SINGLE_ITEM;
            }
            if (blockType.equals((Object)BlockEntityType.CHISELED_BOOKSHELF)) {
                return InventoryOverlayType.BOOKSHELF;
            }
            if (blockType.equals((Object)BlockEntityType.SHELF)) {
                return InventoryOverlayType.WALL_SHELF;
            }
            if (blockType.equals((Object)BlockEntityType.ENDER_CHEST)) {
                return InventoryOverlayType.ENDER_CHEST;
            }
        }
        if ((entityType = DataEntityUtils.getEntityType(data)) != null) {
            if (entityType.equals((Object)EntityType.CHEST_MINECART) || entityType.equals((Object)EntityType.ACACIA_CHEST_BOAT) || entityType.equals((Object)EntityType.BAMBOO_CHEST_RAFT) || entityType.equals((Object)EntityType.BIRCH_CHEST_BOAT) || entityType.equals((Object)EntityType.CHERRY_CHEST_BOAT) || entityType.equals((Object)EntityType.DARK_OAK_CHEST_BOAT) || entityType.equals((Object)EntityType.JUNGLE_CHEST_BOAT) || entityType.equals((Object)EntityType.MANGROVE_CHEST_BOAT) || entityType.equals((Object)EntityType.OAK_CHEST_BOAT) || entityType.equals((Object)EntityType.PALE_OAK_CHEST_BOAT) || entityType.equals((Object)EntityType.SPRUCE_CHEST_BOAT)) {
                return InventoryOverlayType.FIXED_27;
            }
            if (entityType.equals((Object)EntityType.HOPPER_MINECART)) {
                return InventoryOverlayType.HOPPER;
            }
            if (entityType.equals((Object)EntityType.HORSE) || entityType.equals((Object)EntityType.DONKEY) || entityType.equals((Object)EntityType.MULE) || entityType.equals((Object)EntityType.CAMEL) || entityType.equals((Object)EntityType.SKELETON_HORSE) || entityType.equals((Object)EntityType.ZOMBIE_HORSE)) {
                return InventoryOverlayType.HORSE;
            }
            if (entityType.equals((Object)EntityType.LLAMA) || entityType.equals((Object)EntityType.TRADER_LLAMA)) {
                return InventoryOverlayType.LLAMA;
            }
            if (entityType.equals((Object)EntityType.WOLF)) {
                return InventoryOverlayType.WOLF;
            }
            if (entityType.equals((Object)EntityType.HAPPY_GHAST)) {
                return InventoryOverlayType.HAPPY_GHAST;
            }
            if (entityType.equals((Object)EntityType.COPPER_GOLEM)) {
                return InventoryOverlayType.COPPER_GOLEM;
            }
            if (entityType.equals((Object)EntityType.VILLAGER) || entityType.equals((Object)EntityType.ALLAY) || entityType.equals((Object)EntityType.PILLAGER) || entityType.equals((Object)EntityType.PIGLIN) || entityType.equals((Object)EntityType.WANDERING_TRADER) || entityType.equals((Object)EntityType.ZOMBIE_VILLAGER)) {
                return InventoryOverlayType.VILLAGER;
            }
            if (entityType.equals((Object)EntityType.PLAYER)) {
                return InventoryOverlayType.PLAYER;
            }
            if (entityType.equals((Object)EntityType.ARMOR_STAND)) {
                return InventoryOverlayType.ARMOR_STAND;
            }
            if (data.containsLenient("attributes") || data.containsLenient("active_effects") || data.containsLenient("FallFlying")) {
                return InventoryOverlayType.LIVING_ENTITY;
            }
        }
        return InventoryOverlayType.GENERIC;
    }

    public static InventoryRenderType getBestInventoryType(@Nonnull Container inv, @Nonnull CompoundTag nbt) {
        InventoryRenderType n;
        InventoryRenderType i = InventoryOverlay.getInventoryType(inv);
        if (i != (n = InventoryOverlay.getInventoryType(nbt)) && i == InventoryRenderType.GENERIC) {
            return n;
        }
        return i;
    }

    public static InventoryRenderType getBestInventoryType(@Nullable Container inv, @Nonnull CompoundTag nbt, Context ctx) {
        InventoryRenderType n;
        InventoryRenderType i = InventoryOverlay.getInventoryType(inv);
        if (i != (n = InventoryOverlay.getInventoryType(nbt)) && i == InventoryRenderType.GENERIC) {
            if (n != ctx.type() && ctx.type() != InventoryRenderType.GENERIC) {
                return ctx.type();
            }
            return n;
        }
        return i;
    }

    @ApiStatus.Experimental
    public static InventoryOverlayType getBestInventoryTypeNew(@Nonnull Container inv, @Nonnull CompoundData data) {
        InventoryOverlayType n;
        InventoryOverlayType i = InventoryOverlay.getInventoryTypeNew(inv);
        if (i != (n = InventoryOverlay.getInventoryTypeNew(data)) && i == InventoryOverlayType.GENERIC) {
            return n;
        }
        return i;
    }

    @ApiStatus.Experimental
    public static InventoryOverlayType getBestInventoryTypeNew(@Nullable Container inv, @Nonnull CompoundData data, InventoryOverlayContext ctx) {
        InventoryOverlayType n;
        InventoryOverlayType i = InventoryOverlay.getInventoryTypeNew(inv);
        if (i != (n = InventoryOverlay.getInventoryTypeNew(data)) && i == InventoryOverlayType.GENERIC) {
            if (n != ctx.type() && ctx.type() != InventoryOverlayType.GENERIC) {
                return ctx.type();
            }
            return n;
        }
        return i;
    }

    public static InventoryProperties getInventoryPropsTemp(InventoryRenderType type, int totalSlots) {
        return InventoryOverlay.getInventoryPropsTemp(type, totalSlots, 9);
    }

    public static InventoryProperties getInventoryPropsTemp(InventoryRenderType type, int totalSlots, int slotsPerARow) {
        InventoryOverlay.INV_PROPS_TEMP.totalSlots = totalSlots;
        if (type == InventoryRenderType.FURNACE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 1;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 96;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.BREWING_STAND) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 109;
            InventoryOverlay.INV_PROPS_TEMP.height = 72;
        } else if (type == InventoryRenderType.CRAFTER || type == InventoryRenderType.DISPENSER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.HORSE || type == InventoryRenderType.LLAMA || type == InventoryRenderType.WOLF || type == InventoryRenderType.COPPER_GOLEM) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = Math.max(1, totalSlots / 3);
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = totalSlots * 18 / 3 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.HOPPER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 5;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 105;
            InventoryOverlay.INV_PROPS_TEMP.height = 32;
        } else if (type == InventoryRenderType.VILLAGER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 2;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 50;
            InventoryOverlay.INV_PROPS_TEMP.height = 86;
        } else if (type == InventoryRenderType.SINGLE_ITEM) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 1;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 32;
            InventoryOverlay.INV_PROPS_TEMP.height = 32;
        } else if (type == InventoryRenderType.BOOKSHELF) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 50;
            InventoryOverlay.INV_PROPS_TEMP.totalSlots = 6;
        } else if (type == InventoryRenderType.WALL_SHELF) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 50;
            InventoryOverlay.INV_PROPS_TEMP.totalSlots = 3;
        } else if (type == InventoryRenderType.BUNDLE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = slotsPerARow != 9 ? MathUtils.clamp(slotsPerARow, 6, 9) : 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            int rows = (int)Math.ceil((double)totalSlots / (double)InventoryOverlay.INV_PROPS_TEMP.slotsPerRow);
            InventoryOverlay.INV_PROPS_TEMP.width = Math.min(InventoryOverlay.INV_PROPS_TEMP.slotsPerRow, totalSlots) * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = rows * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.totalSlots = rows * InventoryOverlay.INV_PROPS_TEMP.slotsPerRow;
        } else {
            if (type == InventoryRenderType.FIXED_27 || type == InventoryRenderType.PLAYER || type == InventoryRenderType.ENDER_CHEST) {
                totalSlots = 27;
            } else if (type == InventoryRenderType.FIXED_54) {
                totalSlots = 54;
            }
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            int rows = (int)Math.ceil((double)totalSlots / (double)InventoryOverlay.INV_PROPS_TEMP.slotsPerRow);
            InventoryOverlay.INV_PROPS_TEMP.width = Math.min(InventoryOverlay.INV_PROPS_TEMP.slotsPerRow, totalSlots) * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = rows * 18 + 14;
        }
        return INV_PROPS_TEMP;
    }

    @ApiStatus.Experimental
    public static InventoryProperties getInventoryPropsTempNew(InventoryOverlayType type, int totalSlots) {
        return InventoryOverlay.getInventoryPropsTempNew(type, totalSlots, 9);
    }

    @ApiStatus.Experimental
    public static InventoryProperties getInventoryPropsTempNew(InventoryOverlayType type, int totalSlots, int slotsPerARow) {
        InventoryOverlay.INV_PROPS_TEMP.totalSlots = totalSlots;
        if (type == InventoryOverlayType.FURNACE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 1;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 96;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryOverlayType.BREWING_STAND) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 109;
            InventoryOverlay.INV_PROPS_TEMP.height = 72;
        } else if (type == InventoryOverlayType.CRAFTER || type == InventoryOverlayType.DISPENSER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryOverlayType.HORSE || type == InventoryOverlayType.LLAMA || type == InventoryOverlayType.WOLF || type == InventoryOverlayType.COPPER_GOLEM) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = Math.max(1, totalSlots / 3);
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = totalSlots * 18 / 3 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryOverlayType.HOPPER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 5;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 105;
            InventoryOverlay.INV_PROPS_TEMP.height = 32;
        } else if (type == InventoryOverlayType.VILLAGER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 2;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 50;
            InventoryOverlay.INV_PROPS_TEMP.height = 86;
        } else if (type == InventoryOverlayType.SINGLE_ITEM) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 1;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 32;
            InventoryOverlay.INV_PROPS_TEMP.height = 32;
        } else if (type == InventoryOverlayType.BOOKSHELF) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 50;
            InventoryOverlay.INV_PROPS_TEMP.totalSlots = 6;
        } else if (type == InventoryOverlayType.WALL_SHELF) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 50;
            InventoryOverlay.INV_PROPS_TEMP.totalSlots = 3;
        } else if (type == InventoryOverlayType.BUNDLE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = slotsPerARow != 9 ? MathUtils.clamp(slotsPerARow, 6, 9) : 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            int rows = (int)Math.ceil((double)totalSlots / (double)InventoryOverlay.INV_PROPS_TEMP.slotsPerRow);
            InventoryOverlay.INV_PROPS_TEMP.width = Math.min(InventoryOverlay.INV_PROPS_TEMP.slotsPerRow, totalSlots) * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = rows * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.totalSlots = rows * InventoryOverlay.INV_PROPS_TEMP.slotsPerRow;
        } else {
            if (type == InventoryOverlayType.FIXED_27 || type == InventoryOverlayType.PLAYER || type == InventoryOverlayType.ENDER_CHEST) {
                totalSlots = 27;
            } else if (type == InventoryOverlayType.FIXED_54) {
                totalSlots = 54;
            }
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            int rows = (int)Math.ceil((double)totalSlots / (double)InventoryOverlay.INV_PROPS_TEMP.slotsPerRow);
            InventoryOverlay.INV_PROPS_TEMP.width = Math.min(InventoryOverlay.INV_PROPS_TEMP.slotsPerRow, totalSlots) * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = rows * 18 + 14;
        }
        return INV_PROPS_TEMP;
    }

    public static void renderInventoryStacks(GuiGraphics drawContext, InventoryRenderType type, Container inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Minecraft mc) {
        InventoryOverlay.renderInventoryStacks(drawContext, type, inv, startX, startY, slotsPerRow, startSlot, maxSlots, Set.of(), mc, 0.0, 0.0);
    }

    public static void renderInventoryStacks(GuiGraphics drawContext, InventoryRenderType type, Container inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Set<Integer> disabledSlots, Minecraft mc) {
        InventoryOverlay.renderInventoryStacks(drawContext, type, inv, startX, startY, slotsPerRow, startSlot, maxSlots, disabledSlots, mc, 0.0, 0.0);
    }

    public static void renderInventoryStacks(GuiGraphics drawContext, InventoryRenderType type, Container inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Minecraft mc, double mouseX, double mouseY) {
        InventoryOverlay.renderInventoryStacks(drawContext, type, inv, startX, startY, slotsPerRow, startSlot, maxSlots, Set.of(), mc, mouseX, mouseY);
    }

    @ApiStatus.Experimental
    public static void renderInventoryStacksNew(GuiGraphics drawContext, InventoryOverlayType type, Container inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Minecraft mc) {
        InventoryOverlay.renderInventoryStacksNew(drawContext, type, inv, startX, startY, slotsPerRow, startSlot, maxSlots, Set.of(), mc, 0.0, 0.0);
    }

    @ApiStatus.Experimental
    public static void renderInventoryStacksNew(GuiGraphics drawContext, InventoryOverlayType type, Container inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Set<Integer> disabledSlots, Minecraft mc) {
        InventoryOverlay.renderInventoryStacksNew(drawContext, type, inv, startX, startY, slotsPerRow, startSlot, maxSlots, disabledSlots, mc, 0.0, 0.0);
    }

    @ApiStatus.Experimental
    public static void renderInventoryStacksNew(GuiGraphics drawContext, InventoryOverlayType type, Container inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Minecraft mc, double mouseX, double mouseY) {
        InventoryOverlay.renderInventoryStacksNew(drawContext, type, inv, startX, startY, slotsPerRow, startSlot, maxSlots, Set.of(), mc, mouseX, mouseY);
    }

    public static void renderInventoryStacks(GuiGraphics drawContext, InventoryRenderType type, Container inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Set<Integer> disabledSlots, Minecraft mc, double mouseX, double mouseY) {
        if (inv == null) {
            inv = new SimpleContainer(maxSlots > 0 ? maxSlots : InventoryOverlay.INV_PROPS_TEMP.totalSlots);
        }
        if (type == InventoryRenderType.FURNACE) {
            InventoryOverlay.renderStackAt(drawContext, inv.getItem(0), startX + 8, startY + 8, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.getItem(1), startX + 8, startY + 44, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.getItem(2), startX + 68, startY + 26, 1.0f, mc, mouseX, mouseY);
        } else if (type == InventoryRenderType.BREWING_STAND) {
            InventoryOverlay.renderStackAt(drawContext, inv.getItem(0), startX + 47, startY + 42, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.getItem(1), startX + 70, startY + 49, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.getItem(2), startX + 93, startY + 42, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.getItem(3), startX + 70, startY + 8, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.getItem(4), startX + 8, startY + 8, 1.0f, mc, mouseX, mouseY);
        } else {
            int slots = inv.getContainerSize();
            int x = startX;
            int y = startY;
            if (maxSlots < 0) {
                maxSlots = slots;
            }
            int slot = startSlot;
            int i = 0;
            while (slot < slots && i < maxSlots) {
                for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                    ItemStack stack = inv.getItem(slot).copy();
                    if (disabledSlots.contains(slot)) {
                        InventoryOverlay.renderLockedSlotAt(drawContext, x - 1, y - 1, 1.0f, mouseX, mouseY);
                    } else if (!stack.isEmpty()) {
                        InventoryOverlay.renderStackAt(drawContext, stack, x, y, 1.0f, mc, mouseX, mouseY);
                    }
                    x += 18;
                }
                x = startX;
                y += 18;
            }
        }
        if (hoveredStack != null) {
            ItemStack stack = hoveredStack.copy();
            hoveredStack = null;
            InventoryOverlay.renderStackToolTipStyled(drawContext, (int)mouseX, (int)mouseY, stack, mc);
        }
    }

    @ApiStatus.Experimental
    public static void renderInventoryStacksNew(GuiGraphics drawContext, InventoryOverlayType type, Container inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Set<Integer> disabledSlots, Minecraft mc, double mouseX, double mouseY) {
        if (inv == null) {
            inv = new SimpleContainer(maxSlots > 0 ? maxSlots : InventoryOverlay.INV_PROPS_TEMP.totalSlots);
        }
        if (type == InventoryOverlayType.FURNACE) {
            InventoryOverlay.renderStackAt(drawContext, inv.getItem(0), startX + 8, startY + 8, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.getItem(1), startX + 8, startY + 44, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.getItem(2), startX + 68, startY + 26, 1.0f, mc, mouseX, mouseY);
        } else if (type == InventoryOverlayType.BREWING_STAND) {
            InventoryOverlay.renderStackAt(drawContext, inv.getItem(0), startX + 47, startY + 42, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.getItem(1), startX + 70, startY + 49, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.getItem(2), startX + 93, startY + 42, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.getItem(3), startX + 70, startY + 8, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.getItem(4), startX + 8, startY + 8, 1.0f, mc, mouseX, mouseY);
        } else {
            int slots = inv.getContainerSize();
            int x = startX;
            int y = startY;
            if (maxSlots < 0) {
                maxSlots = slots;
            }
            int slot = startSlot;
            int i = 0;
            while (slot < slots && i < maxSlots) {
                for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                    ItemStack stack = inv.getItem(slot).copy();
                    if (disabledSlots.contains(slot)) {
                        InventoryOverlay.renderLockedSlotAt(drawContext, x - 1, y - 1, 1.0f, mouseX, mouseY);
                    } else if (!stack.isEmpty()) {
                        InventoryOverlay.renderStackAt(drawContext, stack, x, y, 1.0f, mc, mouseX, mouseY);
                    }
                    x += 18;
                }
                x = startX;
                y += 18;
            }
        }
        if (hoveredStack != null) {
            ItemStack stack = hoveredStack.copy();
            hoveredStack = null;
            InventoryOverlay.renderStackToolTipStyled(drawContext, (int)mouseX, (int)mouseY, stack, mc);
        }
    }

    public static void renderEquipmentStacks(GuiGraphics drawContext, LivingEntity entity, int x, int y, Minecraft mc) {
        InventoryOverlay.renderEquipmentStacks(drawContext, entity, x, y, mc, 0.0, 0.0);
    }

    public static void renderEquipmentStacks(GuiGraphics drawContext, LivingEntity entity, int x, int y, Minecraft mc, double mouseX, double mouseY) {
        int i = 0;
        int xOff = 7;
        int yOff = 7;
        while (i < 4) {
            EquipmentSlot eqSlot = VALID_EQUIPMENT_SLOTS[i];
            ItemStack stack = entity.getItemBySlot(eqSlot);
            if (!stack.isEmpty()) {
                InventoryOverlay.renderStackAt(drawContext, stack.copy(), x + xOff + 1, y + yOff + 1, 1.0f, mc, mouseX, mouseY);
            }
            ++i;
            yOff += 18;
        }
        ItemStack stack = entity.getItemBySlot(EquipmentSlot.MAINHAND);
        if (!stack.isEmpty()) {
            InventoryOverlay.renderStackAt(drawContext, stack.copy(), x + 28, y + 36 + 7 + 1, 1.0f, mc, mouseX, mouseY);
        }
        if (!(stack = entity.getItemBySlot(EquipmentSlot.OFFHAND)).isEmpty()) {
            InventoryOverlay.renderStackAt(drawContext, stack.copy(), x + 28, y + 54 + 7 + 1, 1.0f, mc, mouseX, mouseY);
        }
        if (hoveredStack != null) {
            stack = hoveredStack.copy();
            hoveredStack = null;
            InventoryOverlay.renderStackToolTipStyled(drawContext, (int)mouseX, (int)mouseY, stack, mc);
        }
    }

    public static void renderItemStacks(GuiGraphics drawContext, NonNullList<ItemStack> items, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Minecraft mc) {
        InventoryOverlay.renderItemStacks(drawContext, items, startX, startY, slotsPerRow, startSlot, maxSlots, Set.of(), mc);
    }

    public static void renderItemStacks(GuiGraphics drawContext, NonNullList<ItemStack> items, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Set<Integer> disabledSlots, Minecraft mc) {
        int slots = items.size();
        int x = startX;
        int y = startY;
        if (maxSlots < 0) {
            maxSlots = slots;
        }
        int slot = startSlot;
        int i = 0;
        while (slot < slots && i < maxSlots) {
            for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                ItemStack stack = ((ItemStack)items.get(slot)).copy();
                if (disabledSlots.contains(slot)) {
                    InventoryOverlay.renderLockedSlotAt(drawContext, x - 1, y - 1, 1.0f, 0.0, 0.0);
                } else if (!stack.isEmpty()) {
                    InventoryOverlay.renderStackAt(drawContext, stack, x, y, 1.0f, mc);
                }
                x += 18;
            }
            x = startX;
            y += 18;
        }
    }

    public static void renderStackAt(GuiGraphics drawContext, ItemStack stack, float x, float y, float scale, Minecraft mc) {
        InventoryOverlay.renderStackAt(drawContext, stack, x, y, scale, mc, 0.0, 0.0);
    }

    public static void renderStackAt(GuiGraphics drawContext, ItemStack stack, float x, float y, float scale, Minecraft mc, double mouseX, double mouseY) {
        Matrix3x2fStack matrixStack = drawContext.pose();
        matrixStack.pushMatrix();
        matrixStack.translate(x, y);
        matrixStack.scale(scale, scale);
        drawContext.renderItem(stack.copy(), 0, 0);
        drawContext.renderItemDecorations(mc.font, stack.copy(), 0, 0);
        matrixStack.popMatrix();
        if (mouseX >= (double)x && mouseX < (double)(x + 16.0f * scale) && mouseY >= (double)y && mouseY < (double)(y + 16.0f * scale)) {
            hoveredStack = stack.copy();
        }
    }

    public static void renderLockedSlotAt(GuiGraphics drawContext, float x, float y, float scale, double mouseX, double mouseY) {
        Matrix3x2fStack matrixStack = drawContext.pose();
        int color = -1;
        matrixStack.pushMatrix();
        matrixStack.translate(x, y);
        matrixStack.scale(scale, scale);
        color = -1;
        drawContext.blitSprite(RenderPipelines.GUI_TEXTURED, TEXTURE_LOCKED_SLOT, 0, 0, 18, 18, color);
        matrixStack.popMatrix();
        if (mouseX >= (double)x && mouseX < (double)(x + 16.0f * scale) && mouseY >= (double)y && mouseY < (double)(y + 16.0f * scale)) {
            hoveredStack = null;
        }
    }

    public static void renderBackgroundSlotAt(GuiGraphics drawContext, ResourceLocation texture, float x, float y) {
        InventoryOverlay.renderBackgroundSlotAt(drawContext, texture, x, y, 0.9f, 0.0, 0.0);
    }

    public static void renderBackgroundSlotAt(GuiGraphics drawContext, ResourceLocation texture, float x, float y, float scale, double mouseX, double mouseY) {
        Matrix3x2fStack matrixStack = drawContext.pose();
        int color = -1;
        matrixStack.pushMatrix();
        matrixStack.translate(x, y);
        matrixStack.scale(scale, scale);
        color = -1;
        drawContext.blitSprite(RenderPipelines.GUI_TEXTURED, texture, 0, 0, 18, 18, color);
        matrixStack.popMatrix();
        if (mouseX >= (double)x && mouseX < (double)(x + 16.0f * scale) && mouseY >= (double)y && mouseY < (double)(y + 16.0f * scale)) {
            hoveredStack = null;
        }
    }

    public static void renderStackToolTip(GuiGraphics drawContext, int x, int y, ItemStack stack, Minecraft mc) {
        List list = stack.getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL));
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                lines.add(String.valueOf(stack.getRarity().color()) + ((Component)list.get(i)).getString());
                continue;
            }
            lines.add(GuiBase.TXT_DARK_GRAY + ((Component)list.get(i)).getString());
        }
        RenderUtils.drawHoverText(drawContext, x, y, lines);
    }

    public static void renderStackToolTipStyled(GuiGraphics drawContext, int x, int y, ItemStack stack, Minecraft mc) {
        if (!stack.isEmpty() && mc.level != null && mc.player != null) {
            List toolTips = stack.getTooltipLines(Item.TooltipContext.of((Level)WorldUtils.getBestWorld(mc)), (Player)mc.player, (TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL));
            drawContext.setTooltipForNextFrame(mc.font, toolTips, stack.getTooltipImage(), x, y, (ResourceLocation)stack.get(DataComponents.TOOLTIP_STYLE));
            ((RenderEventHandler)RenderEventHandler.getInstance()).onRenderTooltipLast(drawContext, stack, x, y);
        }
    }

    private static void dumpStack(ItemStack stack, @Nullable List<Component> list) {
        if (stack.isEmpty()) {
            LOGGER.info("dumpStack(): [{}]", ItemStack.EMPTY.toString());
            return;
        }
        LOGGER.info("dumpStack(): [{}}]", ItemStack.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)stack).getPartialOrThrow());
        if (list != null && !list.isEmpty()) {
            int i = 0;
            for (Component entry : list) {
                LOGGER.info("ToolTip[{}]: {}", i, entry.getString());
                ++i;
            }
        }
    }

    @Deprecated
    public static enum InventoryRenderType {
        BREWING_STAND,
        CRAFTER,
        DISPENSER,
        FURNACE,
        HOPPER,
        HORSE,
        LLAMA,
        WOLF,
        HAPPY_GHAST,
        COPPER_GOLEM,
        FIXED_27,
        FIXED_54,
        VILLAGER,
        PLAYER,
        ENDER_CHEST,
        BOOKSHELF,
        WALL_SHELF,
        SINGLE_ITEM,
        BUNDLE,
        ARMOR_STAND,
        LIVING_ENTITY,
        GENERIC;

    }

    @Deprecated
    public record Context(InventoryRenderType type, @Nullable Container inv, @Nullable BlockEntity be, @Nullable LivingEntity entity, @Nullable CompoundTag nbt, Refresher handler) {
    }

    public static class InventoryProperties {
        public int totalSlots = 1;
        public int width = 176;
        public int height = 83;
        public int slotsPerRow = 9;
        public int slotOffsetX = 8;
        public int slotOffsetY = 8;
    }

    @Deprecated
    public static interface Refresher {
        public Context onContextRefresh(Context var1, Level var2);
    }
}

