/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class EquipmentUtils {
    public static boolean isAnyWeapon(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        return EquipmentUtils.isMeleeWeapon(stack) || EquipmentUtils.isRangedWeapon(stack);
    }

    public static boolean isMeleeWeapon(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof MaceItem || item instanceof AxeItem) {
            return true;
        }
        if (item instanceof ProjectileWeaponItem) {
            return false;
        }
        return (stack.is(ItemTags.WEAPON_ENCHANTABLE) || EquipmentUtils.isSword(stack) || EquipmentUtils.isAxe(stack)) && stack.has(DataComponents.WEAPON);
    }

    public static boolean isSword(ItemStack stack) {
        String itemType = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
        return itemType.contains("_sword");
    }

    public static boolean isAxe(ItemStack stack) {
        String itemType = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
        return itemType.contains("_axe");
    }

    public static boolean isRangedWeapon(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof MaceItem || item instanceof AxeItem) {
            return false;
        }
        return item instanceof ProjectileWeaponItem;
    }

    public static boolean isAnyTool(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        return EquipmentUtils.isRegularTool(stack) || EquipmentUtils.isMiscTool(stack);
    }

    public static boolean isRegularTool(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        return (stack.is(ItemTags.MINING_ENCHANTABLE) || EquipmentUtils.isPickAxe(stack) || EquipmentUtils.isAxe(stack) || EquipmentUtils.isHoe(stack) || EquipmentUtils.isShovel(stack)) && stack.has(DataComponents.TOOL);
    }

    public static boolean isPickAxe(ItemStack stack) {
        String itemType = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
        return itemType.contains("_pickaxe");
    }

    public static boolean isShovel(ItemStack stack) {
        String itemType = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
        return itemType.contains("_shovel");
    }

    public static boolean isHoe(ItemStack stack) {
        String itemType = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
        return itemType.contains("_hoe");
    }

    public static boolean isMiscTool(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        return item instanceof ShearsItem || item instanceof FlintAndSteelItem || item instanceof BrushItem || item instanceof FishingRodItem;
    }

    public static Pair<Integer, Float> getWeaponData(ItemStack stack) {
        Weapon weaponComponent;
        if (stack == null || stack.isEmpty()) {
            return Pair.of((Object)-1, (Object)Float.valueOf(0.0f));
        }
        if (stack.has(DataComponents.WEAPON) && (weaponComponent = (Weapon)stack.get(DataComponents.WEAPON)) != null) {
            return Pair.of((Object)weaponComponent.itemDamagePerAttack(), (Object)Float.valueOf(weaponComponent.disableBlockingForSeconds()));
        }
        return Pair.of((Object)-1, (Object)Float.valueOf(0.0f));
    }

    public static Pair<Double, Double> getDamageAndSpeedAttributes(ItemStack stack) {
        ItemAttributeModifiers attrib;
        double speed = -1.0;
        double damage = -1.0;
        if (stack == null || stack.isEmpty()) {
            return Pair.of((Object)damage, (Object)speed);
        }
        if (stack.has(DataComponents.ATTRIBUTE_MODIFIERS) && (attrib = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS)) != null) {
            for (ItemAttributeModifiers.Entry entry : attrib.modifiers()) {
                if (entry.attribute().equals((Object)Attributes.ATTACK_DAMAGE)) {
                    damage = entry.modifier().amount();
                    continue;
                }
                if (!entry.attribute().equals((Object)Attributes.ATTACK_SPEED)) continue;
                speed = entry.modifier().amount();
            }
        }
        return Pair.of((Object)damage, (Object)speed);
    }

    public static boolean isCorrectTool(ItemStack stack, @Nonnull BlockState state) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        if (stack.has(DataComponents.TOOL)) {
            Tool toolComponent = (Tool)stack.get(DataComponents.TOOL);
            return toolComponent != null && toolComponent.isCorrectForDrops(state);
        }
        return false;
    }

    public static float getMiningSpeed(ItemStack stack, @Nullable BlockState state) {
        Tool toolComponent;
        if (stack == null || stack.isEmpty()) {
            return -1.0f;
        }
        if (stack.has(DataComponents.TOOL) && (toolComponent = (Tool)stack.get(DataComponents.TOOL)) != null) {
            if (state != null) {
                return toolComponent.getMiningSpeed(state);
            }
            return toolComponent.defaultMiningSpeed();
        }
        return -1.0f;
    }

    public static boolean isAnyArmor(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        return EquipmentUtils.isHumanoidArmor(stack) || EquipmentUtils.isAnyAnimalArmor(stack);
    }

    public static boolean isHumanoidArmor(ItemStack stack) {
        ItemAttributeModifiers attrib;
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        if (stack.has(DataComponents.EQUIPPABLE) && stack.has(DataComponents.ATTRIBUTE_MODIFIERS) && (attrib = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS)) != null) {
            for (ItemAttributeModifiers.Entry entry : attrib.modifiers()) {
                if (!entry.attribute().equals((Object)Attributes.ARMOR) || entry.slot() == EquipmentSlotGroup.MAINHAND || entry.slot() == EquipmentSlotGroup.OFFHAND) continue;
                return true;
            }
        }
        return stack.is(ItemTags.EQUIPPABLE_ENCHANTABLE);
    }

    public static boolean matchArmorSlot(ItemStack stack, @Nonnull EquipmentSlot slot) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        if (stack.has(DataComponents.EQUIPPABLE) && stack.has(DataComponents.ATTRIBUTE_MODIFIERS)) {
            ItemAttributeModifiers attrib = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS);
            EquipmentSlotGroup attributeSlot = EquipmentSlotGroup.bySlot((EquipmentSlot)slot);
            if (attrib != null) {
                for (ItemAttributeModifiers.Entry entry : attrib.modifiers()) {
                    if (!entry.attribute().equals((Object)Attributes.ARMOR) || entry.slot() != attributeSlot) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isAnyAnimalArmor(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        return Objects.equals(EquipmentUtils.getEquipmentSlot(stack), EquipmentSlotGroup.BODY);
    }

    public static boolean isHorseArmor(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        if (stack.has(DataComponents.EQUIPPABLE) && stack.has(DataComponents.ATTRIBUTE_MODIFIERS)) {
            ItemAttributeModifiers attrib = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS);
            Equippable equip = (Equippable)stack.get(DataComponents.EQUIPPABLE);
            if (attrib != null && equip != null) {
                boolean bodySlot = false;
                for (ItemAttributeModifiers.Entry entry : attrib.modifiers()) {
                    if (!entry.attribute().equals((Object)Attributes.ARMOR) || !entry.slot().equals((Object)EquipmentSlotGroup.BODY)) continue;
                    bodySlot = true;
                    break;
                }
                return bodySlot && equip.canBeEquippedBy(EntityType.HORSE);
            }
        }
        return false;
    }

    public static boolean isWolfArmor(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        if (stack.has(DataComponents.EQUIPPABLE) && stack.has(DataComponents.ATTRIBUTE_MODIFIERS)) {
            ItemAttributeModifiers attrib = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS);
            Equippable equip = (Equippable)stack.get(DataComponents.EQUIPPABLE);
            if (attrib != null && equip != null) {
                boolean bodySlot = false;
                for (ItemAttributeModifiers.Entry entry : attrib.modifiers()) {
                    if (!entry.attribute().equals((Object)Attributes.ARMOR) || !entry.slot().equals((Object)EquipmentSlotGroup.BODY)) continue;
                    bodySlot = true;
                    break;
                }
                return bodySlot && equip.canBeEquippedBy(EntityType.WOLF);
            }
        }
        return false;
    }

    @Nullable
    public static EquipmentSlotGroup getEquipmentSlot(ItemStack stack) {
        ItemAttributeModifiers attrib;
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        if (stack.has(DataComponents.EQUIPPABLE) && stack.has(DataComponents.ATTRIBUTE_MODIFIERS) && (attrib = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS)) != null) {
            for (ItemAttributeModifiers.Entry entry : attrib.modifiers()) {
                if (!entry.attribute().equals((Object)Attributes.ARMOR)) continue;
                return entry.slot();
            }
        }
        return null;
    }

    public static int getEnchantmentLevel(ItemStack stack, @Nonnull ResourceKey<Enchantment> enchantment) {
        ItemEnchantments enchants = stack.getEnchantments();
        if (!enchants.equals((Object)ItemEnchantments.EMPTY)) {
            Set enchantList = enchants.keySet();
            for (Holder entry : enchantList) {
                if (!entry.is(enchantment)) continue;
                return enchants.getLevel(entry);
            }
        }
        return -1;
    }

    public static int hasSameOrBetterEnchantment(ItemStack testedStack, ItemStack previous, ResourceKey<Enchantment> enchantment) {
        return EquipmentUtils.getEnchantmentLevel(testedStack, enchantment) - EquipmentUtils.getEnchantmentLevel(previous, enchantment);
    }

    public static boolean hasSilkTouch(ItemStack stack) {
        return EquipmentUtils.getEnchantmentLevel(stack, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH) > 0;
    }
}

