/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.Vec3;

public enum Quadrant implements IConfigOptionListEntry,
StringRepresentable
{
    NORTH_WEST("north_west"),
    NORTH_EAST("north_east"),
    SOUTH_WEST("south_west"),
    SOUTH_EAST("south_east");

    public static final StringRepresentable.EnumCodec<Quadrant> CODEC;
    public static final StreamCodec<ByteBuf, Quadrant> PACKET_CODEC;
    public static final ImmutableList<Quadrant> VALUES;
    private final String configString;

    private Quadrant(String name) {
        this.configString = name;
    }

    @Nonnull
    public String getSerializedName() {
        return this.configString;
    }

    @Override
    public String getStringValue() {
        return this.configString;
    }

    @Override
    public String getDisplayName() {
        return this.configString;
    }

    @Override
    public IConfigOptionListEntry cycle(boolean forward) {
        int id = this.ordinal();
        if (forward) {
            if (++id >= Quadrant.values().length) {
                id = 0;
            }
        } else if (--id < 0) {
            id = Quadrant.values().length - 1;
        }
        return Quadrant.values()[id % Quadrant.values().length];
    }

    @Override
    public Quadrant fromString(String name) {
        return Quadrant.fromStringStatic(name);
    }

    public static Quadrant fromStringStatic(String name) {
        for (Quadrant val : VALUES) {
            if (!val.configString.equalsIgnoreCase(name)) continue;
            return val;
        }
        return NORTH_WEST;
    }

    public static Quadrant getQuadrant(BlockPos pos, Vec3 center) {
        return Quadrant.getQuadrant(pos.getX(), pos.getZ(), center);
    }

    public static Quadrant getQuadrant(int x, int z, Vec3 center) {
        if ((double)x <= center.x) {
            if ((double)z <= center.z) {
                return NORTH_WEST;
            }
            return SOUTH_WEST;
        }
        if ((double)z <= center.z) {
            return NORTH_EAST;
        }
        return SOUTH_EAST;
    }

    public static Quadrant getQuadrant(double x, double z, Vec3 center) {
        if (x <= center.x) {
            if (z <= center.z) {
                return NORTH_WEST;
            }
            return SOUTH_WEST;
        }
        if (z <= center.z) {
            return NORTH_EAST;
        }
        return SOUTH_EAST;
    }

    static {
        CODEC = StringRepresentable.fromEnum(Quadrant::values);
        PACKET_CODEC = ByteBufCodecs.STRING_UTF8.map(Quadrant::fromStringStatic, Quadrant::getSerializedName);
        VALUES = ImmutableList.copyOf((Object[])Quadrant.values());
    }
}

