/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.converter.DataConverterNbt;
import fi.dy.masa.malilib.util.data.tag.util.DataTypeUtils;
import fi.dy.masa.malilib.util.nbt.NbtView;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerStateData;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.storage.ValueInput;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class DataBlockUtils {
    @Nullable
    public static BlockEntityType<?> getBlockEntityType(@Nonnull CompoundData data) {
        if (data.contains("id", 8)) {
            return BuiltInRegistries.BLOCK_ENTITY_TYPE.getOptional(ResourceLocation.tryParse((String)data.getString("id"))).orElse(null);
        }
        return null;
    }

    @Nullable
    public static Component getCustomName(@Nonnull CompoundData data, @Nonnull RegistryAccess registry, String key) {
        NbtView view = NbtView.getReader(data, registry);
        return BlockEntity.parseCustomNameSafe((ValueInput)Objects.requireNonNull(view.getReader()), (String)key);
    }

    public static CompoundData setBlockEntityType(BlockEntityType<?> type, @Nullable CompoundData dataIn) {
        CompoundData data = new CompoundData();
        ResourceLocation id = BlockEntityType.getKey(type);
        if (id != null) {
            return Objects.requireNonNullElse(dataIn, data).putString("id", id.toString());
        }
        return data;
    }

    public static Set<Integer> getDisabledSlots(@Nonnull CompoundData data) {
        HashSet<Integer> list = new HashSet<Integer>();
        if (data.contains("disabled_slots", 11)) {
            int[] is;
            for (int j : is = data.getIntArray("disabled_slots")) {
                list.add(j);
            }
        }
        return list;
    }

    public static Pair<Holder<MobEffect>, Holder<MobEffect>> getBeaconEffects(@Nonnull CompoundData data) {
        Set effects = BeaconBlockEntity.BEACON_EFFECTS.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Holder primary = null;
        Holder secondary = null;
        if (data.contains("primary_effect", 8)) {
            primary = data.getCodec("primary_effect", BuiltInRegistries.MOB_EFFECT.holderByNameCodec()).filter(effects::contains).orElse(null);
        }
        if (data.contains("secondary_effect", 8)) {
            secondary = data.getCodec("secondary_effect", BuiltInRegistries.MOB_EFFECT.holderByNameCodec()).filter(effects::contains).orElse(null);
        }
        return Pair.of(primary, secondary);
    }

    public static Pair<List<BeehiveBlockEntity.Occupant>, BlockPos> getBeesData(@Nonnull CompoundData data) {
        List bees = new ArrayList();
        BlockPos flower = BlockPos.ZERO;
        if (data.contains("bees", 9)) {
            bees = data.getCodec("bees", BeehiveBlockEntity.Occupant.LIST_CODEC).orElse(List.of());
        }
        if (data.containsLenient("flower_pos")) {
            flower = DataTypeUtils.getPosCodec(data, "flower_pos");
        }
        return Pair.of(bees, (Object)flower);
    }

    public static Pair<Integer, VibrationSystem.Data> getSkulkSensorVibrations(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        VibrationSystem.Data listener = null;
        int lastFreq = -1;
        if (data.contains("last_vibration_frequency", 3)) {
            lastFreq = data.getInt("last_vibration_frequency");
        }
        if (data.contains("listener", 10)) {
            listener = data.getCodec("listener", VibrationSystem.Data.CODEC, (DynamicOps<Tag>)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE)).orElseGet(VibrationSystem.Data::new);
        }
        return Pair.of((Object)lastFreq, listener);
    }

    public static Pair<Long, BlockPos> getExitPortal(@Nonnull CompoundData data) {
        long age = -1L;
        BlockPos pos = BlockPos.ZERO;
        if (data.contains("Age", 4)) {
            age = data.getLong("Age");
        }
        if (data.containsLenient("exit_portal")) {
            pos = DataTypeUtils.getPosCodec(data, "exit_portal");
        }
        return Pair.of((Object)age, (Object)pos);
    }

    public static Pair<Pair<SignText, SignText>, Boolean> getSignText(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        CompoundData comp;
        AtomicReference<Object> front = new AtomicReference<Object>(null);
        AtomicReference<Object> back = new AtomicReference<Object>(null);
        boolean waxed = false;
        if (data.contains("front_text", 10)) {
            comp = data.getCompound("front_text");
            SignText.DIRECT_CODEC.parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)DataConverterNbt.toVanillaCompound(comp)).resultOrPartial().ifPresent(front::set);
        }
        if (data.contains("back_text", 10)) {
            comp = data.getCompound("back_text");
            SignText.DIRECT_CODEC.parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)DataConverterNbt.toVanillaCompound(comp)).resultOrPartial().ifPresent(back::set);
        }
        if (data.contains("is_waxed", 1)) {
            waxed = data.getBoolean("is_waxed");
        }
        return Pair.of((Object)Pair.of((Object)front.get(), (Object)back.get()), (Object)waxed);
    }

    public static Pair<ItemStack, Integer> getBook(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        ItemStack book = ItemStack.EMPTY;
        int current = -1;
        if (data.contains("Book", 10)) {
            book = data.getCodec("Book", ItemStack.CODEC, (DynamicOps<Tag>)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE)).orElse(ItemStack.EMPTY);
        }
        if (data.contains("Page", 3)) {
            current = data.getInt("Page");
        }
        return Pair.of((Object)book, (Object)current);
    }

    public static Pair<ResolvableProfile, Pair<ResourceLocation, Component>> getSkullData(@Nonnull CompoundData data, @Nonnull RegistryAccess registry) {
        ResolvableProfile profile = null;
        ResourceLocation note = null;
        Component name = null;
        if (data.contains("note_block_sound", 8)) {
            note = data.getCodec("note_block_sound", ResourceLocation.CODEC).orElse(null);
        }
        if (data.contains("custom_name", 10)) {
            name = DataBlockUtils.getCustomName(data, registry, "custom_name");
        }
        if (data.contains("profile", 10)) {
            profile = data.getCodec("profile", ResolvableProfile.CODEC).orElse(null);
        }
        return Pair.of(profile, (Object)Pair.of((Object)note, (Object)name));
    }

    public static Reference2IntOpenHashMap<ResourceKey<Recipe<?>>> getRecipesUsed(@Nonnull CompoundData data) {
        UnboundedMapCodec CODEC = Codec.unboundedMap((Codec)Recipe.KEY_CODEC, (Codec)Codec.INT);
        Reference2IntOpenHashMap list = new Reference2IntOpenHashMap();
        if (data.containsLenient("RecipesUsed")) {
            list.putAll(data.getCodec("RecipesUsed", CODEC).orElse(Map.of()));
        }
        return list;
    }

    public static int getOutputSignal(@Nonnull CompoundData data) {
        if (data.contains("OutputSignal", 3)) {
            return data.getInt("OutputSignal");
        }
        return 0;
    }

    public static Optional<TrialSpawnerStateData.Packed> getTrialSpawnerData(@Nonnull CompoundData data) {
        return DataTypeUtils.readFlatMap(data, TrialSpawnerStateData.Packed.MAP_CODEC);
    }
}

