/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import fi.dy.masa.malilib.util.nbt.NbtUtils;
import fi.dy.masa.malilib.util.nbt.NbtView;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerStateData;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.storage.ValueInput;
import org.apache.commons.lang3.tuple.Pair;

public class NbtBlockUtils {
    @Nullable
    public static BlockEntityType<?> getBlockEntityTypeFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("id")) {
            return BuiltInRegistries.BLOCK_ENTITY_TYPE.getOptional(ResourceLocation.tryParse((String)nbt.getStringOr("id", ""))).orElse(null);
        }
        return null;
    }

    @Nullable
    public static Component getCustomNameFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry, String key) {
        NbtView view = NbtView.getReader(nbt, registry);
        return BlockEntity.parseCustomNameSafe((ValueInput)Objects.requireNonNull(view.getReader()), (String)key);
    }

    public static CompoundTag setBlockEntityTypeToNbt(BlockEntityType<?> type, @Nullable CompoundTag nbtIn) {
        CompoundTag nbt = new CompoundTag();
        ResourceLocation id = BlockEntityType.getKey(type);
        if (id != null) {
            if (nbtIn != null) {
                nbtIn.putString("id", id.toString());
                return nbtIn;
            }
            nbt.putString("id", id.toString());
        }
        return nbt;
    }

    public static Set<Integer> getDisabledSlotsFromNbt(@Nonnull CompoundTag nbt) {
        HashSet<Integer> list = new HashSet<Integer>();
        if (nbt.contains("disabled_slots")) {
            int[] is;
            for (int j : is = nbt.getIntArray("disabled_slots").orElse(new int[0])) {
                list.add(j);
            }
        }
        return list;
    }

    public static Pair<Holder<MobEffect>, Holder<MobEffect>> getBeaconEffectsFromNbt(@Nonnull CompoundTag nbt) {
        Set effects = BeaconBlockEntity.BEACON_EFFECTS.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Holder primary = null;
        Holder secondary = null;
        if (nbt.contains("primary_effect")) {
            primary = nbt.read("primary_effect", BuiltInRegistries.MOB_EFFECT.holderByNameCodec()).filter(effects::contains).orElse(null);
        }
        if (nbt.contains("secondary_effect")) {
            secondary = nbt.read("secondary_effect", BuiltInRegistries.MOB_EFFECT.holderByNameCodec()).filter(effects::contains).orElse(null);
        }
        return Pair.of(primary, secondary);
    }

    public static Pair<List<BeehiveBlockEntity.Occupant>, BlockPos> getBeesDataFromNbt(@Nonnull CompoundTag nbt) {
        List bees = new ArrayList();
        BlockPos flower = BlockPos.ZERO;
        if (nbt.contains("bees")) {
            bees = nbt.read("bees", BeehiveBlockEntity.Occupant.LIST_CODEC).orElse(List.of());
        }
        if (nbt.contains("flower_pos")) {
            flower = NbtUtils.getPosCodec(nbt, "flower_pos");
        }
        return Pair.of(bees, (Object)flower);
    }

    public static Pair<Integer, VibrationSystem.Data> getSkulkSensorVibrationsFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        VibrationSystem.Data data = null;
        int lastFreq = -1;
        if (nbt.contains("last_vibration_frequency")) {
            lastFreq = nbt.getIntOr("last_vibration_frequency", 0);
        }
        if (nbt.contains("listener")) {
            data = nbt.read("listener", VibrationSystem.Data.CODEC, (DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE)).orElseGet(VibrationSystem.Data::new);
        }
        return Pair.of((Object)lastFreq, data);
    }

    public static Pair<Long, BlockPos> getExitPortalFromNbt(@Nonnull CompoundTag nbt) {
        long age = -1L;
        BlockPos pos = BlockPos.ZERO;
        if (nbt.contains("Age")) {
            age = nbt.getLongOr("Age", -1L);
        }
        if (nbt.contains("exit_portal")) {
            pos = NbtUtils.getPosCodec(nbt, "exit_portal");
        }
        return Pair.of((Object)age, (Object)pos);
    }

    public static Pair<Pair<SignText, SignText>, Boolean> getSignTextFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        AtomicReference<Object> front = new AtomicReference<Object>(null);
        AtomicReference<Object> back = new AtomicReference<Object>(null);
        boolean waxed = false;
        if (nbt.contains("front_text")) {
            SignText.DIRECT_CODEC.parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt.get("front_text")).resultOrPartial().ifPresent(front::set);
        }
        if (nbt.contains("back_text")) {
            SignText.DIRECT_CODEC.parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt.get("back_text")).resultOrPartial().ifPresent(back::set);
        }
        if (nbt.contains("is_waxed")) {
            waxed = nbt.getBoolean("is_waxed").orElse(false);
        }
        return Pair.of((Object)Pair.of((Object)front.get(), (Object)back.get()), (Object)waxed);
    }

    public static Pair<ItemStack, Integer> getBookFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        ItemStack book = ItemStack.EMPTY;
        int current = -1;
        if (nbt.contains("Book")) {
            book = nbt.read("Book", ItemStack.CODEC, (DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE)).orElse(ItemStack.EMPTY);
        }
        if (nbt.contains("Page")) {
            current = nbt.getIntOr("Page", -1);
        }
        return Pair.of((Object)book, (Object)current);
    }

    public static Pair<ResolvableProfile, Pair<ResourceLocation, Component>> getSkullDataFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        ResolvableProfile profile = null;
        ResourceLocation note = null;
        Component name = null;
        if (nbt.contains("note_block_sound")) {
            note = nbt.read("note_block_sound", ResourceLocation.CODEC).orElse(null);
        }
        if (nbt.contains("custom_name")) {
            name = NbtBlockUtils.getCustomNameFromNbt(nbt, registry, "custom_name");
        }
        if (nbt.contains("profile")) {
            profile = nbt.read("profile", ResolvableProfile.CODEC).orElse(null);
        }
        return Pair.of(profile, (Object)Pair.of((Object)note, (Object)name));
    }

    public static Reference2IntOpenHashMap<ResourceKey<Recipe<?>>> getRecipesUsedFromNbt(@Nonnull CompoundTag nbt) {
        UnboundedMapCodec CODEC = Codec.unboundedMap((Codec)Recipe.KEY_CODEC, (Codec)Codec.INT);
        Reference2IntOpenHashMap list = new Reference2IntOpenHashMap();
        if (nbt.contains("RecipesUsed")) {
            list.putAll(nbt.read("RecipesUsed", (Codec)CODEC).orElse(Map.of()));
        }
        return list;
    }

    public static int getOutputSignalFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("OutputSignal")) {
            return nbt.getIntOr("OutputSignal", 0);
        }
        return 0;
    }

    public static Optional<TrialSpawnerStateData.Packed> getTrialSpawnerDataFromNbt(@Nonnull CompoundTag nbt) {
        return NbtUtils.readFlatMap(nbt, TrialSpawnerStateData.Packed.MAP_CODEC);
    }
}

