/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.nbt.INbtEntityInvoker;
import fi.dy.masa.malilib.util.nbt.NbtUtils;
import fi.dy.masa.malilib.util.nbt.NbtView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.CatVariants;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.ChickenVariants;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.CowVariants;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.PigVariants;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.frog.FrogVariants;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariants;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.block.WeatheringCopper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class NbtEntityUtils {
    public static CompoundTag invokeEntityNbtDataNoPassengers(Entity entity, int id) {
        return ((INbtEntityInvoker)entity).malilib$getNbtDataWithId(id).orElseGet(CompoundTag::new);
    }

    @Nullable
    public static EntityType<?> getEntityTypeFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("id")) {
            return BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.tryParse((String)nbt.getStringOr("id", ""))).orElse(null);
        }
        return null;
    }

    public CompoundTag setEntityTypeToNbt(EntityType<?> type, @Nullable CompoundTag nbtIn) {
        CompoundTag nbt = new CompoundTag();
        ResourceLocation id = EntityType.getKey(type);
        if (id != null) {
            if (nbtIn != null) {
                nbtIn.putString("id", id.toString());
                return nbtIn;
            }
            nbt.putString("id", id.toString());
        }
        return nbt;
    }

    @Nullable
    public static AttributeMap getAttributesFromNbt(@Nonnull CompoundTag nbt) {
        EntityType<?> type = NbtEntityUtils.getEntityTypeFromNbt(nbt);
        if (type != null && nbt.contains("attributes")) {
            AttributeMap container = new AttributeMap(DefaultAttributes.getSupplier(type));
            container.apply((List)AttributeInstance.Packed.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.getListOrEmpty("attributes")).getPartialOrThrow());
            return container;
        }
        return null;
    }

    public static double getAttributeBaseValueFromNbt(@Nonnull CompoundTag nbt, Holder<Attribute> attribute) {
        AttributeMap attributes = NbtEntityUtils.getAttributesFromNbt(nbt);
        if (attributes != null) {
            return attributes.getBaseValue(attribute);
        }
        return -1.0;
    }

    public static double getAttributeValueFromNbt(@Nonnull CompoundTag nbt, Holder<Attribute> attribute) {
        AttributeMap attributes = NbtEntityUtils.getAttributesFromNbt(nbt);
        if (attributes != null) {
            return attributes.getValue(attribute);
        }
        return -1.0;
    }

    public static Pair<Double, Double> getHealthFromNbt(@Nonnull CompoundTag nbt) {
        double maxHealth;
        double health = 0.0;
        if (nbt.contains("Health")) {
            health = nbt.getFloatOr("Health", 0.0f);
        }
        if ((maxHealth = NbtEntityUtils.getAttributeValueFromNbt(nbt, (Holder<Attribute>)Attributes.MAX_HEALTH)) < 0.0) {
            maxHealth = 20.0;
        }
        return Pair.of((Object)health, (Object)maxHealth);
    }

    public static Pair<Double, Double> getSpeedAndJumpStrengthFromNbt(@Nonnull CompoundTag nbt) {
        AttributeMap container = NbtEntityUtils.getAttributesFromNbt(nbt);
        double moveSpeed = 0.0;
        double jumpStrength = 0.0;
        if (container != null) {
            moveSpeed = container.getValue(Attributes.MOVEMENT_SPEED);
            jumpStrength = container.getValue(Attributes.JUMP_STRENGTH);
        }
        return Pair.of((Object)moveSpeed, (Object)jumpStrength);
    }

    @Nullable
    public static Component getCustomNameFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        if (nbt.contains("CustomName")) {
            return nbt.read("CustomName", ComponentSerialization.CODEC, (DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE)).orElse(null);
        }
        return null;
    }

    public static CompoundTag setCustomNameToNbt(@Nonnull Component name, @Nonnull RegistryAccess registry, @Nullable CompoundTag nbtIn, String key) {
        CompoundTag nbt;
        CompoundTag compoundTag = nbt = nbtIn != null ? nbtIn.copy() : new CompoundTag();
        if (key == null || key.isEmpty()) {
            key = "CustomName";
        }
        nbt.store(key, ComponentSerialization.CODEC, (DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)name);
        return nbt;
    }

    public static Map<Holder<MobEffect>, MobEffectInstance> getActiveStatusEffectsFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        HashMap statusEffects = Maps.newHashMap();
        if (nbt.contains("active_effects")) {
            List list = nbt.read("active_effects", MobEffectInstance.CODEC.listOf(), (DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE)).orElse(List.of());
            for (MobEffectInstance instance : list) {
                statusEffects.put(instance.getEffect(), instance);
            }
        }
        return statusEffects;
    }

    public static NonNullList<ItemStack> getHandItemsFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        NonNullList list = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        EntityEquipment equipment = NbtEntityUtils.getEquipmentSlotsFromNbt(nbt, registry);
        if (equipment != null) {
            ItemStack mainHand = equipment.get(EquipmentSlot.MAINHAND);
            ItemStack offHand = equipment.get(EquipmentSlot.OFFHAND);
            if (mainHand != null && !mainHand.isEmpty()) {
                list.set(0, (Object)mainHand.copy());
            }
            if (offHand != null && !offHand.isEmpty()) {
                list.set(1, (Object)offHand.copy());
            }
        }
        return list;
    }

    public static NonNullList<ItemStack> getHumanoidArmorFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        NonNullList list = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
        EntityEquipment equipment = NbtEntityUtils.getEquipmentSlotsFromNbt(nbt, registry);
        if (equipment != null) {
            ItemStack head = equipment.get(EquipmentSlot.HEAD);
            ItemStack chest = equipment.get(EquipmentSlot.CHEST);
            ItemStack legs = equipment.get(EquipmentSlot.LEGS);
            ItemStack feet = equipment.get(EquipmentSlot.FEET);
            if (head != null && !head.isEmpty()) {
                list.set(0, (Object)head.copy());
            }
            if (chest != null && !chest.isEmpty()) {
                list.set(1, (Object)chest.copy());
            }
            if (legs != null && !legs.isEmpty()) {
                list.set(2, (Object)legs.copy());
            }
            if (feet != null && !feet.isEmpty()) {
                list.set(3, (Object)feet.copy());
            }
        }
        return list;
    }

    public static NonNullList<ItemStack> getHorseEquipmentFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        NonNullList list = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        EntityEquipment equipment = NbtEntityUtils.getEquipmentSlotsFromNbt(nbt, registry);
        if (equipment != null) {
            ItemStack bodyArmor = equipment.get(EquipmentSlot.BODY);
            ItemStack saddle = equipment.get(EquipmentSlot.SADDLE);
            if (bodyArmor != null && !bodyArmor.isEmpty()) {
                list.set(0, (Object)bodyArmor.copy());
            }
            if (saddle != null && !saddle.isEmpty()) {
                list.set(1, (Object)saddle.copy());
            }
        }
        return list;
    }

    public static NonNullList<ItemStack> getAllEquipmentFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        NonNullList list = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
        EntityEquipment equipment = NbtEntityUtils.getEquipmentSlotsFromNbt(nbt, registry);
        if (equipment != null) {
            ItemStack mainHand = equipment.get(EquipmentSlot.MAINHAND);
            ItemStack offHand = equipment.get(EquipmentSlot.OFFHAND);
            ItemStack head = equipment.get(EquipmentSlot.HEAD);
            ItemStack chest = equipment.get(EquipmentSlot.CHEST);
            ItemStack legs = equipment.get(EquipmentSlot.LEGS);
            ItemStack feet = equipment.get(EquipmentSlot.FEET);
            ItemStack bodyArmor = equipment.get(EquipmentSlot.BODY);
            ItemStack saddle = equipment.get(EquipmentSlot.SADDLE);
            if (mainHand != null && !mainHand.isEmpty()) {
                list.set(0, (Object)mainHand.copy());
            }
            if (offHand != null && !offHand.isEmpty()) {
                list.set(1, (Object)offHand.copy());
            }
            if (head != null && !head.isEmpty()) {
                list.set(2, (Object)head.copy());
            }
            if (chest != null && !chest.isEmpty()) {
                list.set(3, (Object)chest.copy());
            }
            if (legs != null && !legs.isEmpty()) {
                list.set(4, (Object)legs.copy());
            }
            if (feet != null && !feet.isEmpty()) {
                list.set(5, (Object)feet.copy());
            }
            if (bodyArmor != null && !bodyArmor.isEmpty()) {
                list.set(6, (Object)bodyArmor.copy());
            }
            if (saddle != null && !saddle.isEmpty()) {
                list.set(7, (Object)saddle.copy());
            }
        }
        return list;
    }

    public static Pair<UUID, Boolean> getTamableOwner(@Nonnull CompoundTag nbt) {
        UUID owner = Util.NIL_UUID;
        boolean sitting = false;
        if (nbt.contains("Owner")) {
            owner = NbtUtils.getUUIDCodec(nbt, "Owner");
        }
        if (nbt.contains("Sitting")) {
            sitting = nbt.getBoolean("Sitting").orElse(false);
        }
        return Pair.of((Object)owner, (Object)sitting);
    }

    public static Pair<Integer, Integer> getAgeFromNbt(@Nonnull CompoundTag nbt) {
        int breedingAge = 0;
        int forcedAge = 0;
        if (nbt.contains("Age")) {
            breedingAge = nbt.getIntOr("Age", 0);
        }
        if (nbt.contains("ForcedAge")) {
            forcedAge = nbt.getIntOr("ForcedAge", 0);
        }
        return Pair.of((Object)breedingAge, (Object)forcedAge);
    }

    @Nullable
    public static MerchantOffers getTradeOffersFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        if (nbt.contains("Offers")) {
            return nbt.read("Offers", MerchantOffers.CODEC, (DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE)).orElse(null);
        }
        return null;
    }

    @Nullable
    public static VillagerData getVillagerDataFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("VillagerData")) {
            return nbt.read("VillagerData", VillagerData.CODEC).orElse(null);
        }
        return null;
    }

    public static Pair<Integer, UUID> getZombieConversionTimerFromNbt(@Nonnull CompoundTag nbt) {
        int timer = -1;
        UUID player = Util.NIL_UUID;
        if (nbt.contains("ConversionTime")) {
            timer = nbt.getIntOr("ConversionTime", -1);
        }
        if (nbt.contains("ConversionPlayer")) {
            player = NbtUtils.getUUIDCodec(nbt, "ConversionPlayer");
        }
        return Pair.of((Object)timer, (Object)player);
    }

    public static Pair<Integer, Integer> getDrownedConversionTimerFromNbt(@Nonnull CompoundTag nbt) {
        int drowning = -1;
        int inWater = -1;
        if (nbt.contains("DrownedConversionTime")) {
            drowning = nbt.getIntOr("DrownedConversionTime", -1);
        }
        if (nbt.contains("InWaterTime")) {
            inWater = nbt.getIntOr("InWaterTime", -1);
        }
        return Pair.of((Object)drowning, (Object)inWater);
    }

    public static int getStrayConversionTimeFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("StrayConversionTime")) {
            return nbt.getIntOr("StrayConversionTime", -1);
        }
        return -1;
    }

    public static Holder.Reference<EntityType<?>> getEntityTypeEntry(ResourceLocation id, @Nonnull RegistryAccess registry) {
        try {
            return (Holder.Reference)registry.lookupOrThrow(BuiltInRegistries.ENTITY_TYPE.key()).get(id).orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Leashable.LeashData getLeashDataFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("leash")) {
            return nbt.read("leash", Leashable.LeashData.CODEC).orElse(null);
        }
        return null;
    }

    public static Pair<Panda.Gene, Panda.Gene> getPandaGenesFromNbt(@Nonnull CompoundTag nbt) {
        Panda.Gene mainGene = null;
        Panda.Gene hiddenGene = null;
        if (nbt.contains("MainGene")) {
            mainGene = nbt.read("MainGene", Panda.Gene.CODEC).orElse(Panda.Gene.NORMAL);
        }
        if (nbt.contains("HiddenGene")) {
            hiddenGene = nbt.read("HiddenGene", Panda.Gene.CODEC).orElse(Panda.Gene.NORMAL);
        }
        return Pair.of(mainGene, hiddenGene);
    }

    public static Pair<Direction, Direction> getItemFrameDirectionsFromNbt(@Nonnull CompoundTag nbt) {
        Direction facing = null;
        Direction rotation = null;
        if (nbt.contains("Facing")) {
            facing = nbt.read("Facing", Direction.LEGACY_ID_CODEC).orElse(Direction.DOWN);
        }
        if (nbt.contains("ItemRotation")) {
            rotation = Direction.from3DDataValue((int)nbt.getByteOr("ItemRotation", (byte)0));
        }
        return Pair.of(facing, rotation);
    }

    public static Pair<Direction, PaintingVariant> getPaintingDataFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        Direction facing = null;
        Holder variant = null;
        if (nbt.contains("facing")) {
            facing = nbt.read("facing", Direction.LEGACY_ID_CODEC).orElse(Direction.SOUTH);
        }
        if (nbt.contains("variant")) {
            variant = PaintingVariant.CODEC.fieldOf("variant").codec().parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial().orElse(null);
        }
        return Pair.of((Object)facing, variant != null ? (PaintingVariant)variant.value() : null);
    }

    @Nullable
    public static Axolotl.Variant getAxolotlVariantFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("Variant")) {
            return nbt.read("Variant", Axolotl.Variant.LEGACY_CODEC).orElse(Axolotl.Variant.LUCY);
        }
        return null;
    }

    public static Pair<ResourceKey<CatVariant>, DyeColor> getCatVariantFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        ResourceKey variantKey = null;
        DyeColor collar = null;
        if (nbt.contains("variant")) {
            Optional variant = CatVariant.CODEC.fieldOf("variant").codec().parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial();
            variantKey = variant.map(entry -> (ResourceKey)entry.unwrapKey().orElseThrow()).orElse(CatVariants.BLACK);
        }
        if (nbt.contains("CollarColor")) {
            collar = nbt.read("CollarColor", DyeColor.LEGACY_ID_CODEC).orElse(DyeColor.RED);
        }
        return Pair.of(variantKey, collar);
    }

    @Nullable
    public static ResourceKey<ChickenVariant> getChickenVariantFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        if (nbt.contains("variant")) {
            Optional variant = ChickenVariant.CODEC.fieldOf("variant").codec().parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial();
            return variant.map(entry -> (ResourceKey)entry.unwrapKey().orElseThrow()).orElse(ChickenVariants.DEFAULT);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<CowVariant> getCowVariantFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        if (nbt.contains("variant")) {
            Optional variant = CowVariant.CODEC.fieldOf("variant").codec().parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial();
            return variant.map(entry -> (ResourceKey)entry.unwrapKey().orElseThrow()).orElse(CowVariants.DEFAULT);
        }
        return null;
    }

    @Nullable
    public static MushroomCow.Variant getMooshroomVariantFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("Type")) {
            return nbt.read("Type", MushroomCow.Variant.CODEC).orElse(MushroomCow.Variant.RED);
        }
        return null;
    }

    @Nullable
    public static ResourceKey<FrogVariant> getFrogVariantFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        if (nbt.contains("variant")) {
            Optional variant = FrogVariant.CODEC.fieldOf("variant").codec().parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial();
            return variant.map(entry -> (ResourceKey)entry.unwrapKey().orElseThrow()).orElse(FrogVariants.TEMPERATE);
        }
        return null;
    }

    public static Pair<Variant, Markings> getHorseVariantFromNbt(@Nonnull CompoundTag nbt) {
        Variant color = null;
        Markings marking = null;
        if (nbt.contains("Variant")) {
            int variant = nbt.getIntOr("Variant", 0);
            color = Variant.byId((int)(variant & 0xFF));
            marking = Markings.byId((int)((variant & 0xFF00) >> 8));
        }
        return Pair.of(color, marking);
    }

    @Nullable
    public static Parrot.Variant getParrotVariantFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("Variant")) {
            return nbt.read("Variant", Parrot.Variant.LEGACY_CODEC).orElse(Parrot.Variant.RED_BLUE);
        }
        return null;
    }

    @Nullable
    public static TropicalFish.Pattern getFishVariantFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("Variant")) {
            TropicalFish.Variant variant = nbt.read("Variant", TropicalFish.Variant.CODEC).orElse(TropicalFish.DEFAULT_VARIANT);
        } else if (nbt.contains("BucketVariantTag")) {
            return TropicalFish.Pattern.byId((int)(nbt.getIntOr("BucketVariantTag", 0) & 0xFFFF));
        }
        return null;
    }

    public static Pair<ResourceKey<WolfVariant>, DyeColor> getWolfVariantFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        ResourceKey variantKey = null;
        DyeColor collar = null;
        if (nbt.contains("variant")) {
            Optional variant = WolfVariant.CODEC.fieldOf("variant").codec().parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial();
            variantKey = variant.map(entry -> (ResourceKey)entry.unwrapKey().orElseThrow()).orElse(WolfVariants.DEFAULT);
        }
        if (nbt.contains("CollarColor")) {
            collar = nbt.read("CollarColor", DyeColor.LEGACY_ID_CODEC).orElse(DyeColor.RED);
        }
        if (variantKey == null) {
            variantKey = WolfVariants.DEFAULT;
        }
        if (collar == null) {
            collar = DyeColor.RED;
        }
        return Pair.of((Object)variantKey, (Object)collar);
    }

    @Nullable
    public static ResourceKey<WolfSoundVariant> getWolfSoundTypeFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        Holder.Reference soundVariant;
        if (nbt.contains("sound_variant") && (soundVariant = (Holder.Reference)registry.lookupOrThrow(Registries.WOLF_SOUND_VARIANT).get(ResourceLocation.tryParse((String)nbt.getStringOr("sound_variant", ""))).orElse(null)) != null) {
            return soundVariant.key();
        }
        return null;
    }

    @Nullable
    public static DyeColor getSheepColorFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("Color")) {
            return nbt.read("Color", DyeColor.LEGACY_ID_CODEC).orElse(DyeColor.WHITE);
        }
        return null;
    }

    @Nullable
    public static Rabbit.Variant getRabbitTypeFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("RabbitType")) {
            return nbt.read("RabbitType", Rabbit.Variant.LEGACY_CODEC).orElse(Rabbit.Variant.BROWN);
        }
        return null;
    }

    public static Pair<Llama.Variant, Integer> getLlamaTypeFromNbt(@Nonnull CompoundTag nbt) {
        Llama.Variant variant = null;
        int strength = -1;
        if (nbt.contains("Variant")) {
            variant = nbt.read("Variant", Llama.Variant.LEGACY_CODEC).orElse(Llama.Variant.CREAMY);
        }
        if (nbt.contains("Strength")) {
            strength = nbt.getIntOr("Strength", -1);
        }
        return Pair.of((Object)variant, (Object)strength);
    }

    @Nullable
    public static ResourceKey<PigVariant> getPigVariantFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        if (nbt.contains("variant")) {
            Optional opt = registry.lookupOrThrow(Registries.PIG_VARIANT).get(ResourceLocation.tryParse((String)nbt.getStringOr("variant", "")));
            if (opt.isPresent()) {
                return ((Holder.Reference)opt.get()).key();
            }
            return PigVariants.DEFAULT;
        }
        return null;
    }

    @Nullable
    public static Fox.Variant getFoxVariantFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("Type")) {
            return nbt.read("Type", (Codec)Fox.Variant.CODEC).orElse(Fox.Variant.RED);
        }
        return null;
    }

    @Nullable
    public static Salmon.Variant getSalmonVariantFromNbt(@Nonnull CompoundTag nbt) {
        if (nbt.contains("type")) {
            return nbt.read("type", (Codec)Salmon.Variant.CODEC).orElse(Salmon.Variant.MEDIUM);
        }
        return null;
    }

    public static Pair<Integer, Boolean> getDolphinDataFromNbt(@Nonnull CompoundTag nbt) {
        boolean hasFish = false;
        int moist = -1;
        if (nbt.contains("Moistness")) {
            moist = nbt.getIntOr("Moistness", -1);
        }
        if (nbt.contains("GotFish")) {
            hasFish = nbt.getBoolean("GotFish").orElse(false);
        }
        return Pair.of((Object)moist, (Object)hasFish);
    }

    public static Triple<Integer, Integer, Float> getPlayerExpFromNbt(@Nonnull CompoundTag nbt) {
        int level = -1;
        int total = -1;
        float progress = 0.0f;
        if (nbt.contains("XpLevel")) {
            level = nbt.getIntOr("XpLevel", -1);
        }
        if (nbt.contains("XpTotal")) {
            total = nbt.getIntOr("XpTotal", -1);
        }
        if (nbt.contains("XpP")) {
            progress = nbt.getFloatOr("XpP", 0.0f);
        }
        return Triple.of((Object)level, (Object)total, (Object)Float.valueOf(progress));
    }

    @Nullable
    public static FoodData getPlayerHungerFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        FoodData hunger = null;
        if (nbt.contains("foodLevel")) {
            hunger = new FoodData();
            NbtView view = NbtView.getReader(nbt, registry);
            hunger.readAdditionalSaveData(view.getReader());
        }
        return hunger;
    }

    @Nullable
    public static ServerRecipeBook getPlayerRecipeBookFromNbt(@Nonnull CompoundTag nbt, @Nonnull RecipeManager manager) {
        ServerRecipeBook book = null;
        if (nbt.contains("recipeBook")) {
            book = new ServerRecipeBook((arg_0, arg_1) -> ((RecipeManager)manager).listDisplaysForRecipe(arg_0, arg_1));
            book.loadUntrusted((ServerRecipeBook.Packed)ServerRecipeBook.Packed.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.getCompoundOrEmpty("recipeBook")).getOrThrow(), key -> manager.byKey(key).isPresent());
        }
        return book;
    }

    @Nullable
    public static EntityEquipment getEquipmentSlotsFromNbt(@Nonnull CompoundTag nbt, @Nonnull RegistryAccess registry) {
        Optional opt;
        if (nbt.contains("equipment") && (opt = EntityEquipment.CODEC.parse((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt.get("equipment")).result()).isPresent()) {
            return (EntityEquipment)opt.get();
        }
        return null;
    }

    @Nullable
    public static Tag setEquipmentSlotsToNbt(@Nonnull EntityEquipment equipment, @Nonnull RegistryAccess registry) {
        try {
            return (Tag)EntityEquipment.CODEC.encodeStart((DynamicOps)registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)equipment).getOrThrow();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.warn("setEquipmentSlotsToNbt(): Failed to parse Equipment Slots Object; {}", (Object)err.getMessage());
            return null;
        }
    }

    public static Pair<BlockPos, Integer> getHomePosFromNbt(@Nonnull CompoundTag nbt) {
        BlockPos pos = BlockPos.ZERO;
        int radius = -1;
        if (nbt.contains("home_pos")) {
            pos = nbt.read("home_pos", BlockPos.CODEC).orElse(BlockPos.ZERO);
        }
        if (nbt.contains("home_radius")) {
            radius = nbt.getIntOr("home_radius", -1);
        }
        return Pair.of((Object)pos, (Object)radius);
    }

    public static Pair<WeatheringCopper.WeatherState, Long> getWeatheringDataFromNbt(@Nonnull CompoundTag nbt) {
        WeatheringCopper.WeatherState level = WeatheringCopper.WeatherState.UNAFFECTED;
        long age = -1L;
        if (nbt.contains("weather_state")) {
            level = nbt.read("weather_state", WeatheringCopper.WeatherState.CODEC).orElse(WeatheringCopper.WeatherState.UNAFFECTED);
        }
        if (nbt.contains("next_weather_age")) {
            age = nbt.getLongOr("next_weather_age", -1L);
        }
        return Pair.of((Object)level, (Object)age);
    }
}

