/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.data.CachedTagKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class CachedBlockTags {
    private static final CachedBlockTags INSTANCE = new CachedBlockTags();
    private final HashMap<CachedTagKey, Entry> entries = new HashMap();

    public static CachedBlockTags getInstance() {
        return INSTANCE;
    }

    private CachedBlockTags() {
    }

    public void build(CachedTagKey key, @Nonnull List<String> list) {
        if (list.isEmpty()) {
            MaLiLib.LOGGER.warn("CachedBlockTags#build: list for '{}' is empty.", (Object)key.toString());
            return;
        }
        Entry entry = new Entry(list);
        Entry oldEntry = this.entries.put(key, entry);
        if (oldEntry != null) {
            oldEntry.clear();
        }
        MaLiLib.debugLog("CachedBlockTags#build: New tag list: '{}'", key.toString());
    }

    @Nullable
    public Entry get(CachedTagKey key) {
        if (this.entries.containsKey(key)) {
            return this.entries.get(key);
        }
        return null;
    }

    public void clearEntry(CachedTagKey key) {
        if (this.entries.containsKey(key)) {
            this.entries.get(key).clear();
            MaLiLib.debugLog("CachedBlockTags#clearEntry: Clear tag list Entry: '{}'", key.toString());
        }
    }

    public void clear() {
        this.entries.forEach((name, entry) -> entry.clear());
        MaLiLib.debugLog("CachedBlockTags#clear: Clear all", new Object[0]);
    }

    public List<CachedTagKey> matchAny(Holder<Block> block) {
        ArrayList<CachedTagKey> list = new ArrayList<CachedTagKey>();
        this.entries.forEach((key, entry) -> {
            if (entry.contains(block)) {
                list.add((CachedTagKey)key);
            }
        });
        return list;
    }

    public List<CachedTagKey> matchAny(Block block) {
        ArrayList<CachedTagKey> list = new ArrayList<CachedTagKey>();
        this.entries.forEach((key, entry) -> {
            if (entry.contains(block)) {
                list.add((CachedTagKey)key);
            }
        });
        return list;
    }

    public List<CachedTagKey> matchAny(BlockState state) {
        ArrayList<CachedTagKey> list = new ArrayList<CachedTagKey>();
        this.entries.forEach((key, entry) -> {
            if (entry.contains(state)) {
                list.add((CachedTagKey)key);
            }
        });
        return list;
    }

    public boolean match(CachedTagKey key, Holder<Block> block) {
        Entry entry = this.get(key);
        if (entry != null) {
            return entry.contains(block);
        }
        MaLiLib.LOGGER.warn("CachedBlockTags#match(BlockEntry): Invalid tag list '{}'", (Object)key.toString());
        return false;
    }

    public boolean match(CachedTagKey key, Block block) {
        Entry entry = this.get(key);
        if (entry != null) {
            return entry.contains(block);
        }
        MaLiLib.LOGGER.warn("CachedBlockTags#match(Block): Invalid tag list '{}'", (Object)key.toString());
        return false;
    }

    public boolean match(CachedTagKey key, BlockState state) {
        Entry entry = this.get(key);
        if (entry != null) {
            return entry.contains(state);
        }
        MaLiLib.LOGGER.warn("CachedBlockTags#match(State): Invalid tag list '{}'", (Object)key.toString());
        return false;
    }

    public Optional<Pair<HolderSet<Block>, Holder<Block>>> matchPair(CachedTagKey key, Holder<Block> block) {
        Entry entry = this.get(key);
        if (entry != null) {
            Pair<HolderSet<Block>, Holder<Block>> pair = entry.matchPair(block);
            if (pair.getLeft() == null && pair.getRight() == null) {
                return Optional.empty();
            }
            return Optional.of(pair);
        }
        MaLiLib.LOGGER.warn("CachedBlockTags#matchPair(BlockEntry): Invalid tag list '{}'", (Object)key.toString());
        return Optional.empty();
    }

    public Optional<Pair<HolderSet<Block>, Holder<Block>>> matchPair(CachedTagKey key, Block block) {
        Entry entry = this.get(key);
        if (entry != null) {
            Pair<HolderSet<Block>, Holder<Block>> pair = entry.matchPair(block);
            if (pair.getLeft() == null && pair.getRight() == null) {
                return Optional.empty();
            }
            return Optional.of(pair);
        }
        MaLiLib.LOGGER.warn("CachedBlockTags#matchPair(Block): Invalid tag list '{}'", (Object)key.toString());
        return Optional.empty();
    }

    public Optional<Pair<HolderSet<Block>, Holder<Block>>> matchPair(CachedTagKey key, BlockState state) {
        Entry entry = this.get(key);
        if (entry != null) {
            Pair<HolderSet<Block>, Holder<Block>> pair = entry.matchPair(state);
            if (pair.getLeft() == null && pair.getRight() == null) {
                return Optional.empty();
            }
            return Optional.of(pair);
        }
        MaLiLib.LOGGER.warn("CachedBlockTags#matchPair(State): Invalid tag list '{}'", (Object)key.toString());
        return Optional.empty();
    }

    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        this.entries.forEach((key, entry) -> obj.add(key.toString(), entry.toJson()));
        return obj;
    }

    public void fromJson(JsonObject obj) {
        this.entries.clear();
        for (String key : obj.keySet()) {
            if (!obj.isJsonArray()) continue;
            Entry entry = Entry.fromJson(obj.get(key));
            CachedTagKey tagKey = CachedTagKey.fromString(key);
            if (entry == null) continue;
            this.entries.put(tagKey, entry);
        }
    }

    public static class Entry {
        private final HashSet<Holder<Block>> blocks = new HashSet();
        private final HashSet<HolderSet<Block>> tags = new HashSet();

        public Entry() {
        }

        public Entry(List<String> list) {
            this();
            this.insertFromList(list);
        }

        public void insertBlock(Holder<Block> block) {
            this.blocks.add(block);
        }

        public void insertBlock(Block block) {
            this.insertBlock((Holder<Block>)BuiltInRegistries.BLOCK.wrapAsHolder((Object)block));
        }

        public void insertTag(TagKey<Block> tag) {
            if (Minecraft.getInstance().level != null) {
                Registry wrapper = Minecraft.getInstance().level.registryAccess().lookupOrThrow(BuiltInRegistries.BLOCK.key());
                wrapper.get(tag).ifPresent(this.tags::add);
            }
        }

        public void insertFromString(String entry) {
            if (entry.startsWith("#")) {
                ResourceLocation id = ResourceLocation.tryParse((String)entry.substring(1));
                if (id != null) {
                    TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id);
                    if (tag != null) {
                        this.insertTag((TagKey<Block>)tag);
                    } else {
                        MaLiLib.LOGGER.warn("CachedBlockTags.Entry#insertFromString: Invalid block tag '{}'", (Object)entry);
                    }
                } else {
                    MaLiLib.LOGGER.warn("CachedBlockTags.Entry#insertFromString: Invalid block tag id '{}'", (Object)entry);
                }
            } else {
                ResourceLocation id = ResourceLocation.tryParse((String)entry);
                if (id != null) {
                    Block block = (Block)BuiltInRegistries.BLOCK.getValue(id);
                    if (block != null) {
                        this.insertBlock(block);
                    } else {
                        MaLiLib.LOGGER.warn("CachedBlockTags.Entry#insertFromString: Invalid block '{}'", (Object)entry);
                    }
                } else {
                    MaLiLib.LOGGER.warn("CachedBlockTags.Entry#insertFromString: Invalid block id '{}'", (Object)entry);
                }
            }
        }

        public void insertFromList(List<String> list) {
            if (list.isEmpty()) {
                MaLiLib.LOGGER.warn("CachedBlockTags.Entry#insertFromList: List is empty.");
                return;
            }
            for (String entry : list) {
                this.insertFromString(entry);
            }
        }

        public boolean contains(Holder<Block> entry) {
            for (HolderSet<Block> listEntry : this.tags) {
                if (!listEntry.contains(entry)) continue;
                return true;
            }
            return this.blocks.contains(entry);
        }

        public boolean contains(Block block) {
            return this.contains((Holder<Block>)BuiltInRegistries.BLOCK.wrapAsHolder((Object)block));
        }

        public boolean contains(BlockState state) {
            return this.contains(state.getBlock());
        }

        public Pair<HolderSet<Block>, Holder<Block>> matchPair(Holder<Block> entry) {
            for (HolderSet<Block> listEntry : this.tags) {
                if (!listEntry.contains(entry)) continue;
                return Pair.of(listEntry, null);
            }
            if (this.blocks.contains(entry)) {
                return Pair.of(null, entry);
            }
            return Pair.of(null, null);
        }

        public Pair<HolderSet<Block>, Holder<Block>> matchPair(Block block) {
            return this.matchPair((Holder<Block>)BuiltInRegistries.BLOCK.wrapAsHolder((Object)block));
        }

        public Pair<HolderSet<Block>, Holder<Block>> matchPair(BlockState state) {
            return this.matchPair(state.getBlock());
        }

        public List<String> toList() {
            ArrayList<String> list = new ArrayList<String>();
            this.blocks.forEach(entry -> list.add(entry.getRegisteredName()));
            this.tags.forEach(entry -> list.add("#" + entry.unwrapKey().toString()));
            return list;
        }

        public JsonElement toJson() {
            JsonArray arr = new JsonArray();
            this.blocks.forEach(entry -> arr.add((JsonElement)new JsonPrimitive(entry.getRegisteredName())));
            this.tags.forEach(entry -> arr.add((JsonElement)new JsonPrimitive("#" + entry.unwrapKey().toString())));
            return arr;
        }

        @Nullable
        public static Entry fromJson(JsonElement element) {
            if (element.isJsonArray()) {
                JsonArray arr = element.getAsJsonArray();
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < arr.size(); ++i) {
                    list.add(arr.get(i).getAsString());
                }
                Entry entry = new Entry();
                entry.insertFromList(list);
                return entry;
            }
            return null;
        }

        public void clear() {
            this.blocks.clear();
            this.tags.clear();
        }
    }
}

