/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.mixin.render;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.PolygonMode;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.malilib.compat.iris.IrisCompat;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import java.util.Map;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderPipelines.class})
public abstract class MixinRenderPipelines {
    @Shadow
    @Final
    public static Map<ResourceLocation, RenderPipeline> PIPELINES_BY_LOCATION;
    @Shadow
    @Final
    public static RenderPipeline.Snippet MATRICES_PROJECTION_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet FOG_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet GLOBALS_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet MATRICES_FOG_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet MATRICES_FOG_LIGHT_DIR_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet TERRAIN_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet ENTITY_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet ENTITY_EMISSIVE_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet BEACON_BEAM_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet TEXT_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet END_PORTAL_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet CLOUDS_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet LINES_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet DEBUG_FILLED_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet PARTICLE_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet WEATHER_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet GUI_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet GUI_TEXTURED_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet GUI_TEXT_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet OUTLINE_SNIPPET;
    @Shadow
    @Final
    public static RenderPipeline.Snippet POST_PROCESSING_SNIPPET;
    @Unique
    private static final BlendFunction MASA_BLEND;
    @Unique
    private static final BlendFunction MASA_BLEND_SIMPLE;

    @Shadow
    public static RenderPipeline register(RenderPipeline renderPipeline) {
        PIPELINES_BY_LOCATION.put(renderPipeline.getLocation(), renderPipeline);
        return renderPipeline;
    }

    @Inject(method={"<clinit>()V"}, at={@At(value="TAIL")})
    private static void malilib_onRegisterPipelines(CallbackInfo ci) {
        MaLiLibPipelines.POSITION_TRANSLUCENT_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET}).withVertexShader("core/position").withFragmentShader("core/position").withBlend(BlendFunction.TRANSLUCENT).withVertexFormat(DefaultVertexFormat.POSITION, VertexFormat.Mode.QUADS).buildSnippet();
        MaLiLibPipelines.POSITION_MASA_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET}).withVertexShader("core/position").withFragmentShader("core/position").withBlend(MASA_BLEND).withVertexFormat(DefaultVertexFormat.POSITION, VertexFormat.Mode.QUADS).buildSnippet();
        MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_PROJECTION_SNIPPET}).withVertexShader("core/position_color").withFragmentShader("core/position_color").withBlend(BlendFunction.TRANSLUCENT).withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS).buildSnippet();
        MaLiLibPipelines.POSITION_COLOR_MASA_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_PROJECTION_SNIPPET}).withVertexShader("core/position_color").withFragmentShader("core/position_color").withBlend(MASA_BLEND).withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS).buildSnippet();
        MaLiLibPipelines.POSITION_TEX_TRANSLUCENT_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_PROJECTION_SNIPPET}).withVertexShader("core/position_tex").withFragmentShader("core/position_tex").withSampler("Sampler0").withBlend(BlendFunction.TRANSLUCENT).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).buildSnippet();
        MaLiLibPipelines.POSITION_TEX_OVERLAY_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_PROJECTION_SNIPPET}).withVertexShader("core/position_tex").withFragmentShader("core/position_tex").withSampler("Sampler0").withBlend(BlendFunction.OVERLAY).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).buildSnippet();
        MaLiLibPipelines.POSITION_TEX_MASA_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_PROJECTION_SNIPPET}).withVertexShader("core/position_tex").withFragmentShader("core/position_tex").withSampler("Sampler0").withBlend(MASA_BLEND).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).buildSnippet();
        MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_PROJECTION_SNIPPET}).withVertexShader("core/position_tex_color").withFragmentShader("core/position_tex_color").withSampler("Sampler0").withBlend(BlendFunction.TRANSLUCENT).withVertexFormat(DefaultVertexFormat.POSITION_TEX_COLOR, VertexFormat.Mode.QUADS).buildSnippet();
        MaLiLibPipelines.POSITION_TEX_COLOR_OVERLAY_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_PROJECTION_SNIPPET}).withVertexShader("core/position_tex_color").withFragmentShader("core/position_tex_color").withSampler("Sampler0").withBlend(BlendFunction.OVERLAY).withVertexFormat(DefaultVertexFormat.POSITION_TEX_COLOR, VertexFormat.Mode.QUADS).buildSnippet();
        MaLiLibPipelines.POSITION_TEX_COLOR_MASA_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_PROJECTION_SNIPPET}).withVertexShader("core/position_tex_color").withFragmentShader("core/position_tex_color").withSampler("Sampler0").withBlend(MASA_BLEND).withVertexFormat(DefaultVertexFormat.POSITION_TEX_COLOR, VertexFormat.Mode.QUADS).buildSnippet();
        MaLiLibPipelines.LINES_TRANSLUCENT_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET, GLOBALS_SNIPPET}).withVertexShader("core/rendertype_lines").withFragmentShader("core/rendertype_lines").withBlend(BlendFunction.TRANSLUCENT).withVertexFormat(DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES).buildSnippet();
        MaLiLibPipelines.LINES_MASA_SIMPLE_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET, GLOBALS_SNIPPET}).withVertexShader("core/rendertype_lines").withFragmentShader("core/rendertype_lines").withBlend(MASA_BLEND_SIMPLE).withVertexFormat(DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES).buildSnippet();
        MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_PROJECTION_SNIPPET}).withVertexShader("core/position_color").withFragmentShader("core/position_color").withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.DEBUG_LINES).withBlend(BlendFunction.TRANSLUCENT).buildSnippet();
        MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_PROJECTION_SNIPPET}).withVertexShader("core/position_color").withFragmentShader("core/position_color").withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.DEBUG_LINES).withBlend(MASA_BLEND_SIMPLE).buildSnippet();
        MaLiLibPipelines.DEBUG_LINE_STRIP_TRANSLUCENT_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_PROJECTION_SNIPPET}).withVertexShader("core/position_color").withFragmentShader("core/position_color").withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.DEBUG_LINE_STRIP).withBlend(BlendFunction.TRANSLUCENT).buildSnippet();
        MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_PROJECTION_SNIPPET}).withVertexShader("core/position_color").withFragmentShader("core/position_color").withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.DEBUG_LINE_STRIP).withBlend(MASA_BLEND_SIMPLE).buildSnippet();
        MaLiLibPipelines.TERRAIN_TRANSLUCENT_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET}).withVertexShader("core/terrain").withFragmentShader("core/terrain").withSampler("Sampler0").withSampler("Sampler2").withVertexFormat(DefaultVertexFormat.BLOCK, VertexFormat.Mode.QUADS).withBlend(BlendFunction.TRANSLUCENT).buildSnippet();
        MaLiLibPipelines.TERRAIN_MASA_STAGE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET}).withVertexShader("core/terrain").withFragmentShader("core/terrain").withSampler("Sampler0").withSampler("Sampler2").withVertexFormat(DefaultVertexFormat.BLOCK, VertexFormat.Mode.QUADS).withBlend(MASA_BLEND).buildSnippet();
        MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_NO_DEPTH_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/translucent/no_depth/no_cull")).withCull(false).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/translucent/no_depth")).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_LEQUAL_DEPTH_OFFSET_1 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/translucent/lequal_depth/offset_1")).withCull(false).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withDepthBias(-0.3f, -0.6f).build();
        MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_LEQUAL_DEPTH_OFFSET_2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/translucent/lequal_depth/offset_2")).withCull(false).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withDepthBias(-0.4f, -0.8f).build();
        MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_LEQUAL_DEPTH_OFFSET_3 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/translucent/lequal_depth/offset_3")).withCull(false).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withDepthBias(-3.0f, -3.0f).build();
        MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_LEQUAL_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/translucent/lequal_depth")).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_GREATER_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/translucent/greater_depth")).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.GREATER_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_DEPTH_MASK = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/translucent/depth_mask")).withDepthWrite(true).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/translucent")).build();
        MaLiLibPipelines.POSITION_COLOR_MASA_NO_DEPTH_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/masa/no_depth/no_cull")).withCull(false).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_COLOR_MASA_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/masa/no_depth")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_COLOR_MASA_LEQUAL_DEPTH_OFFSET_1 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/masa/lequal_depth/offset_1")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withDepthBias(-0.3f, -0.6f).build();
        MaLiLibPipelines.POSITION_COLOR_MASA_LEQUAL_DEPTH_OFFSET_2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/masa/lequal_depth/offset_2")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withDepthBias(-0.4f, -0.8f).build();
        MaLiLibPipelines.POSITION_COLOR_MASA_LEQUAL_DEPTH_OFFSET_3 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/masa/lequal_depth/offset_3")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withDepthBias(-3.0f, -3.0f).build();
        MaLiLibPipelines.POSITION_COLOR_MASA_LEQUAL_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/masa/lequal_depth")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_COLOR_MASA_GREATER_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/masa/greater_depth")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.GREATER_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_COLOR_MASA_DEPTH_MASK = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/masa/depth_mask")).withDepthWrite(true).withColorWrite(true).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_COLOR_MASA = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_color/masa")).withDepthWrite(false).withColorWrite(true).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_NO_DEPTH_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/translucent/no_depth/no_cull")).withCull(false).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/translucent/no_depth")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_LEQUAL_DEPTH_OFFSET_1 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/translucent/lequal_depth/offset_1")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withDepthBias(-0.3f, -0.6f).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_LEQUAL_DEPTH_OFFSET_2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/translucent/lequal_depth/offset_2")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withDepthBias(-0.4f, -0.8f).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_LEQUAL_DEPTH_OFFSET_3 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/translucent/lequal_depth/offset_3")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withDepthBias(-3.0f, -3.0f).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_LEQUAL_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/translucent/lequal_depth")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_GREATER_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/translucent/greater_depth")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.GREATER_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_DEPTH_MASK = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/translucent/depth_mask")).withDepthWrite(true).withColorWrite(true).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/translucent")).withDepthWrite(false).withColorWrite(true).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_MASA_NO_DEPTH_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/masa/no_depth/no_cull")).withCull(false).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_MASA_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/masa/no_depth")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_MASA_LEQUAL_DEPTH_OFFSET_1 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/masa/lequal_depth/offset_1")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withDepthBias(-0.3f, -0.6f).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_MASA_LEQUAL_DEPTH_OFFSET_2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/masa/lequal_depth/offset_2")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withDepthBias(-0.4f, -0.8f).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_MASA_LEQUAL_DEPTH_OFFSET_3 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/masa/lequal_depth/offset_3")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).withDepthBias(-3.0f, -3.0f).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_MASA_LEQUAL_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/masa/lequal_depth")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_MASA_GREATER_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/masa/greater_depth")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.GREATER_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_MASA_DEPTH_MASK = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/masa/depth_mask")).withDepthWrite(true).withColorWrite(true).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.POSITION_TEX_COLOR_MASA = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_TEX_COLOR_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/position_tex_color/masa")).withDepthWrite(false).withColorWrite(true).build();
        MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT_NO_DEPTH_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_lines/translucent/no_depth/no_cull")).withCull(false).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_lines/translucent/no_depth")).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_lines/translucent/no_cull")).withCull(false).build();
        MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT_LEQUAL_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_lines/translucent/lequal_depth")).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build();
        MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT_OFFSET_1 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_lines/translucent/offset_1")).withDepthBias(-0.8f, -1.8f).build();
        MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT_OFFSET_2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_lines/translucent/offset_2")).withDepthBias(-1.2f, -0.2f).build();
        MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT_OFFSET_3 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_lines/translucent/offset_3")).withDepthBias(-3.0f, -3.0f).build();
        MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINES_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_lines/translucent")).build();
        MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_NO_DEPTH_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_lines/masa_simple/no_depth/no_cull")).withCull(false).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_lines/masa_simple/no_depth")).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_lines/masa_simple/no_cull")).withCull(false).withDepthWrite(false).build();
        MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_lines/masa_simple/lequal_depth")).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build();
        MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_OFFSET_1 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_lines/masa_simple/offset_1")).withDepthBias(-0.8f, -1.8f).withDepthWrite(false).build();
        MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_OFFSET_2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_lines/masa_simple/offset_2")).withDepthBias(-1.2f, -0.2f).withDepthWrite(false).build();
        MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_OFFSET_3 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_lines/masa_simple/offset_3")).withDepthBias(-3.0f, -3.0f).withDepthWrite(false).build();
        MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_lines/masa_simple")).withDepthWrite(false).build();
        MaLiLibPipelines.DEBUG_LINE_STRIP_TRANSLUCENT_NO_DEPTH_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINE_STRIP_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_line_strip/translucent/no_depth/no_cull")).withCull(false).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.DEBUG_LINE_STRIP_TRANSLUCENT_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINE_STRIP_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_line_strip/translucent/no_depth")).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.DEBUG_LINE_STRIP_TRANSLUCENT_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINE_STRIP_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_line_strip/translucent/no_cull")).withCull(false).build();
        MaLiLibPipelines.DEBUG_LINE_STRIP_TRANSLUCENT_OFFSET_1 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINE_STRIP_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_line_strip/translucent/offset_1")).withDepthBias(-0.8f, -1.8f).build();
        MaLiLibPipelines.DEBUG_LINE_STRIP_TRANSLUCENT_OFFSET_2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINE_STRIP_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_line_strip/translucent/offset_2")).withDepthBias(-1.2f, -0.2f).build();
        MaLiLibPipelines.DEBUG_LINE_STRIP_TRANSLUCENT_OFFSET_3 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINE_STRIP_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_line_strip/translucent/offset_3")).withDepthBias(-3.0f, -3.0f).build();
        MaLiLibPipelines.DEBUG_LINE_STRIP_TRANSLUCENT = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINE_STRIP_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_line_strip/translucent")).build();
        MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE_NO_DEPTH_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_line_strip/masa_simple/no_depth/no_cull")).withCull(false).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_line_strip/masa_simple/no_depth")).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_line_strip/masa_simple/no_cull")).withCull(false).withDepthWrite(false).build();
        MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE_OFFSET_1 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_line_strip/masa_simple/offset_1")).withDepthBias(-0.8f, -1.8f).withDepthWrite(false).build();
        MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE_OFFSET_2 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_line_strip/masa_simple/offset_2")).withDepthBias(-1.2f, -0.2f).withDepthWrite(false).build();
        MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE_OFFSET_3 = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_line_strip/masa_simple/offset_3")).withDepthBias(-3.0f, -3.0f).withDepthWrite(false).build();
        MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/debug_line_strip/masa_simple")).withDepthWrite(false).build();
        MaLiLibPipelines.SOLID_MASA_OFFSET = MixinRenderPipelines.register(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.TERRAIN_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/solid/masa/offset")).withDepthBias(-0.3f, -0.6f).build());
        MaLiLibPipelines.WIREFRAME_MASA_OFFSET = MixinRenderPipelines.register(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.TERRAIN_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/wireframe/masa/offset")).withPolygonMode(PolygonMode.WIREFRAME).withDepthBias(-0.3f, -0.6f).build());
        MaLiLibPipelines.CUTOUT_MIPPED_MASA_OFFSET = MixinRenderPipelines.register(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.TERRAIN_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/cutout_mipped/masa/offset")).withShaderDefine("ALPHA_CUTOUT", 0.5f).withDepthBias(-0.3f, -0.6f).build());
        MaLiLibPipelines.CUTOUT_MASA_OFFSET = MixinRenderPipelines.register(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.TERRAIN_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/cutout/masa/offset")).withShaderDefine("ALPHA_CUTOUT", 0.1f).withDepthBias(-0.3f, -0.6f).build());
        MaLiLibPipelines.TRANSLUCENT_MASA_OFFSET = MixinRenderPipelines.register(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.TERRAIN_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/translucent/masa/offset")).withDepthBias(-0.3f, -0.6f).build());
        MaLiLibPipelines.TRIPWIRE_MASA_OFFSET = MixinRenderPipelines.register(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.TERRAIN_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/tripwire/masa/offset")).withShaderDefine("ALPHA_CUTOUT", 0.1f).withDepthBias(-0.3f, -0.6f).build());
        MaLiLibPipelines.SOLID_MASA = MixinRenderPipelines.register(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.TERRAIN_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/solid/masa")).build());
        MaLiLibPipelines.WIREFRAME_MASA = MixinRenderPipelines.register(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.TERRAIN_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/wireframe/masa")).withPolygonMode(PolygonMode.WIREFRAME).build());
        MaLiLibPipelines.CUTOUT_MIPPED_MASA = MixinRenderPipelines.register(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.TERRAIN_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/cutout_mipped/masa")).withShaderDefine("ALPHA_CUTOUT", 0.5f).build());
        MaLiLibPipelines.CUTOUT_MASA = MixinRenderPipelines.register(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.TERRAIN_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/cutout/masa")).withShaderDefine("ALPHA_CUTOUT", 0.1f).build());
        MaLiLibPipelines.TRANSLUCENT_MASA = MixinRenderPipelines.register(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.TERRAIN_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/translucent/masa")).build());
        MaLiLibPipelines.TRIPWIRE_MASA = MixinRenderPipelines.register(RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.TERRAIN_MASA_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/tripwire/masa")).withShaderDefine("ALPHA_CUTOUT", 0.1f).build());
        MaLiLibPipelines.MINIHUD_SHAPE_NO_DEPTH_OFFSET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/minihud/shape/no_depth/offset")).withDepthBias(-3.0f, -3.0f).withCull(false).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.MINIHUD_SHAPE_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/minihud/shape/no_depth")).withCull(false).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.MINIHUD_SHAPE_OFFSET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/minihud/shape/offset")).withDepthBias(-3.0f, -3.0f).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build();
        MaLiLibPipelines.MINIHUD_SHAPE_DEPTH_MASK = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/minihud/shape/depth_mask")).withDepthWrite(true).withColorWrite(true).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        MaLiLibPipelines.MINIHUD_SHAPE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_STAGE}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/minihud/shape")).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build();
        MaLiLibPipelines.GUI_OVERLAY = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{GUI_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/gui_overlay")).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withBlend(BlendFunction.OVERLAY).build();
        MaLiLibPipelines.GUI_TEXTURED_OVERLAY = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{GUI_TEXTURED_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"malilib", (String)"pipeline/gui_textured_overlay")).withDepthWrite(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withBlend(BlendFunction.OVERLAY).build();
        IrisCompat.registerPipelines();
    }

    static {
        MASA_BLEND = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ZERO);
        MASA_BLEND_SIMPLE = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA);
    }
}

