package fi.dy.masa.malilib.datagen;

import java.util.concurrent.CompletableFuture;

import fi.dy.masa.malilib.MaLiLibReference;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataOutput;
import net.minecraft.registry.RegistryWrapper;
import net.neoforged.neoforge.common.data.BlockTagsProvider;

import fi.dy.masa.malilib.data.MaLiLibTag;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockTagDataGenerator extends BlockTagsProvider
{
    public BlockTagDataGenerator(DataOutput output, CompletableFuture<RegistryWrapper.WrapperLookup> registriesFuture, ExistingFileHelper existingFileHelper)
    {
        super(output, registriesFuture, MaLiLibReference.MOD_ID, existingFileHelper);
    }

    @Override
    protected void configure(RegistryWrapper.WrapperLookup wrapper)
    {
        getOrCreateTagBuilder(MaLiLibTag.Blocks.GLASS_BLOCKS)
                .add(Blocks.GLASS)
                .add(Blocks.BLACK_STAINED_GLASS)
                .add(Blocks.BLUE_STAINED_GLASS)
                .add(Blocks.BROWN_STAINED_GLASS)
                .add(Blocks.CYAN_STAINED_GLASS)
                .add(Blocks.GRAY_STAINED_GLASS)
                .add(Blocks.GREEN_STAINED_GLASS)
                .add(Blocks.LIGHT_BLUE_STAINED_GLASS)
                .add(Blocks.LIGHT_GRAY_STAINED_GLASS)
                .add(Blocks.LIME_STAINED_GLASS)
                .add(Blocks.MAGENTA_STAINED_GLASS)
                .add(Blocks.ORANGE_STAINED_GLASS)
                .add(Blocks.PINK_STAINED_GLASS)
                .add(Blocks.PURPLE_STAINED_GLASS)
                .add(Blocks.RED_STAINED_GLASS)
                .add(Blocks.YELLOW_STAINED_GLASS)
                .add(Blocks.WHITE_STAINED_GLASS)
                .add(Blocks.TINTED_GLASS)
        ;

        getOrCreateTagBuilder(MaLiLibTag.Blocks.GLASS_PANES)
                .add(Blocks.GLASS_PANE)
                .add(Blocks.BLACK_STAINED_GLASS_PANE)
                .add(Blocks.BLUE_STAINED_GLASS_PANE)
                .add(Blocks.BROWN_STAINED_GLASS_PANE)
                .add(Blocks.CYAN_STAINED_GLASS_PANE)
                .add(Blocks.GRAY_STAINED_GLASS_PANE)
                .add(Blocks.GREEN_STAINED_GLASS_PANE)
                .add(Blocks.LIGHT_BLUE_STAINED_GLASS_PANE)
                .add(Blocks.LIGHT_GRAY_STAINED_GLASS_PANE)
                .add(Blocks.LIME_STAINED_GLASS_PANE)
                .add(Blocks.MAGENTA_STAINED_GLASS_PANE)
                .add(Blocks.ORANGE_STAINED_GLASS_PANE)
                .add(Blocks.PINK_STAINED_GLASS_PANE)
                .add(Blocks.PURPLE_STAINED_GLASS_PANE)
                .add(Blocks.RED_STAINED_GLASS_PANE)
                .add(Blocks.YELLOW_STAINED_GLASS_PANE)
                .add(Blocks.WHITE_STAINED_GLASS_PANE)
        ;

        getOrCreateTagBuilder(MaLiLibTag.Blocks.CONCRETE_BLOCKS)
                .add(Blocks.BLACK_CONCRETE)
                .add(Blocks.BLUE_CONCRETE)
                .add(Blocks.BROWN_CONCRETE)
                .add(Blocks.CYAN_CONCRETE)
                .add(Blocks.GRAY_CONCRETE)
                .add(Blocks.GREEN_CONCRETE)
                .add(Blocks.LIGHT_BLUE_CONCRETE)
                .add(Blocks.LIGHT_GRAY_CONCRETE)
                .add(Blocks.LIME_CONCRETE)
                .add(Blocks.MAGENTA_CONCRETE)
                .add(Blocks.ORANGE_CONCRETE)
                .add(Blocks.PINK_CONCRETE)
                .add(Blocks.PURPLE_CONCRETE)
                .add(Blocks.RED_CONCRETE)
                .add(Blocks.YELLOW_CONCRETE)
                .add(Blocks.WHITE_CONCRETE)
        ;

        getOrCreateTagBuilder(MaLiLibTag.Blocks.CONCRETE_POWDER_FIX)
                .add(Blocks.BLACK_CONCRETE_POWDER)
                .add(Blocks.BLUE_CONCRETE_POWDER)
                .add(Blocks.BROWN_CONCRETE_POWDER)
                .add(Blocks.CYAN_CONCRETE_POWDER)
                .add(Blocks.GRAY_CONCRETE_POWDER)
                .add(Blocks.GREEN_CONCRETE_POWDER)
                .add(Blocks.LIGHT_BLUE_CONCRETE_POWDER)
                .add(Blocks.LIGHT_GRAY_CONCRETE_POWDER)
                .add(Blocks.LIME_CONCRETE_POWDER)
                .add(Blocks.MAGENTA_CONCRETE_POWDER)
                .add(Blocks.ORANGE_CONCRETE_POWDER)
                .add(Blocks.PINK_CONCRETE_POWDER)
                .add(Blocks.PURPLE_CONCRETE_POWDER)
                .add(Blocks.RED_CONCRETE_POWDER)
                .add(Blocks.YELLOW_CONCRETE_POWDER)
                .add(Blocks.WHITE_CONCRETE_POWDER)
        ;

        getOrCreateTagBuilder(MaLiLibTag.Blocks.GLAZED_TERRACOTTA_BLOCKS)
                .add(Blocks.BLACK_GLAZED_TERRACOTTA)
                .add(Blocks.BLUE_GLAZED_TERRACOTTA)
                .add(Blocks.BROWN_GLAZED_TERRACOTTA)
                .add(Blocks.CYAN_GLAZED_TERRACOTTA)
                .add(Blocks.GRAY_GLAZED_TERRACOTTA)
                .add(Blocks.GREEN_GLAZED_TERRACOTTA)
                .add(Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA)
                .add(Blocks.LIGHT_GRAY_GLAZED_TERRACOTTA)
                .add(Blocks.LIME_GLAZED_TERRACOTTA)
                .add(Blocks.MAGENTA_GLAZED_TERRACOTTA)
                .add(Blocks.ORANGE_GLAZED_TERRACOTTA)
                .add(Blocks.PINK_GLAZED_TERRACOTTA)
                .add(Blocks.PURPLE_GLAZED_TERRACOTTA)
                .add(Blocks.RED_GLAZED_TERRACOTTA)
                .add(Blocks.YELLOW_GLAZED_TERRACOTTA)
                .add(Blocks.WHITE_GLAZED_TERRACOTTA)
        ;

        getOrCreateTagBuilder(MaLiLibTag.Blocks.ALL_SIGNS_FIX)
                .add(Blocks.ACACIA_SIGN)
                .add(Blocks.BAMBOO_SIGN)
                .add(Blocks.BIRCH_SIGN)
                .add(Blocks.CHERRY_SIGN)
                .add(Blocks.CRIMSON_SIGN)
                .add(Blocks.DARK_OAK_SIGN)
                .add(Blocks.JUNGLE_SIGN)
                .add(Blocks.MANGROVE_SIGN)
                .add(Blocks.OAK_SIGN)
                .add(Blocks.PALE_OAK_SIGN)
                .add(Blocks.SPRUCE_SIGN)
                .add(Blocks.WARPED_SIGN)
                .add(Blocks.ACACIA_WALL_SIGN)
                .add(Blocks.BAMBOO_WALL_SIGN)
                .add(Blocks.BIRCH_WALL_SIGN)
                .add(Blocks.CHERRY_WALL_SIGN)
                .add(Blocks.CRIMSON_WALL_SIGN)
                .add(Blocks.DARK_OAK_WALL_SIGN)
                .add(Blocks.JUNGLE_WALL_SIGN)
                .add(Blocks.MANGROVE_WALL_SIGN)
                .add(Blocks.OAK_WALL_SIGN)
                .add(Blocks.PALE_OAK_WALL_SIGN)
                .add(Blocks.SPRUCE_WALL_SIGN)
                .add(Blocks.WARPED_WALL_SIGN)
                .add(Blocks.ACACIA_HANGING_SIGN)
                .add(Blocks.BAMBOO_HANGING_SIGN)
                .add(Blocks.BIRCH_HANGING_SIGN)
                .add(Blocks.CHERRY_HANGING_SIGN)
                .add(Blocks.CRIMSON_HANGING_SIGN)
                .add(Blocks.DARK_OAK_HANGING_SIGN)
                .add(Blocks.JUNGLE_HANGING_SIGN)
                .add(Blocks.MANGROVE_HANGING_SIGN)
                .add(Blocks.OAK_HANGING_SIGN)
                .add(Blocks.PALE_OAK_HANGING_SIGN)
                .add(Blocks.SPRUCE_HANGING_SIGN)
                .add(Blocks.WARPED_HANGING_SIGN)
                .add(Blocks.ACACIA_WALL_HANGING_SIGN)
                .add(Blocks.BAMBOO_WALL_HANGING_SIGN)
                .add(Blocks.BIRCH_WALL_HANGING_SIGN)
                .add(Blocks.CHERRY_WALL_HANGING_SIGN)
                .add(Blocks.CRIMSON_WALL_HANGING_SIGN)
                .add(Blocks.DARK_OAK_WALL_HANGING_SIGN)
                .add(Blocks.JUNGLE_WALL_HANGING_SIGN)
                .add(Blocks.MANGROVE_WALL_HANGING_SIGN)
                .add(Blocks.OAK_WALL_HANGING_SIGN)
                .add(Blocks.PALE_OAK_WALL_HANGING_SIGN)
                .add(Blocks.SPRUCE_WALL_HANGING_SIGN)
                .add(Blocks.WARPED_WALL_HANGING_SIGN)
        ;

        getOrCreateTagBuilder(MaLiLibTag.Blocks.ALL_BANNERS_FIX)
                .add(Blocks.BLACK_BANNER)
                .add(Blocks.BLUE_BANNER)
                .add(Blocks.BROWN_BANNER)
                .add(Blocks.CYAN_BANNER)
                .add(Blocks.GRAY_BANNER)
                .add(Blocks.GREEN_BANNER)
                .add(Blocks.LIGHT_BLUE_BANNER)
                .add(Blocks.LIGHT_GRAY_BANNER)
                .add(Blocks.LIME_BANNER)
                .add(Blocks.MAGENTA_BANNER)
                .add(Blocks.ORANGE_BANNER)
                .add(Blocks.PINK_BANNER)
                .add(Blocks.PURPLE_BANNER)
                .add(Blocks.RED_BANNER)
                .add(Blocks.YELLOW_BANNER)
                .add(Blocks.WHITE_BANNER)
                .add(Blocks.BLACK_WALL_BANNER)
                .add(Blocks.BLUE_WALL_BANNER)
                .add(Blocks.BROWN_WALL_BANNER)
                .add(Blocks.CYAN_WALL_BANNER)
                .add(Blocks.GRAY_WALL_BANNER)
                .add(Blocks.GREEN_WALL_BANNER)
                .add(Blocks.LIGHT_BLUE_WALL_BANNER)
                .add(Blocks.LIGHT_GRAY_WALL_BANNER)
                .add(Blocks.LIME_WALL_BANNER)
                .add(Blocks.MAGENTA_WALL_BANNER)
                .add(Blocks.ORANGE_WALL_BANNER)
                .add(Blocks.PINK_WALL_BANNER)
                .add(Blocks.PURPLE_WALL_BANNER)
                .add(Blocks.RED_WALL_BANNER)
                .add(Blocks.YELLOW_WALL_BANNER)
                .add(Blocks.WHITE_WALL_BANNER)
        ;

        getOrCreateTagBuilder(MaLiLibTag.Blocks.CORAL_FANS_FIX)
                .add(Blocks.BRAIN_CORAL_FAN)
                .add(Blocks.FIRE_CORAL_FAN)
                .add(Blocks.BUBBLE_CORAL_FAN)
                .add(Blocks.TUBE_CORAL_FAN)
                .add(Blocks.HORN_CORAL_FAN)
                .add(Blocks.BRAIN_CORAL_WALL_FAN)
                .add(Blocks.FIRE_CORAL_WALL_FAN)
                .add(Blocks.BUBBLE_CORAL_WALL_FAN)
                .add(Blocks.TUBE_CORAL_WALL_FAN)
                .add(Blocks.HORN_CORAL_WALL_FAN)
                .add(Blocks.DEAD_BRAIN_CORAL_FAN)
                .add(Blocks.DEAD_FIRE_CORAL_FAN)
                .add(Blocks.DEAD_BUBBLE_CORAL_FAN)
                .add(Blocks.DEAD_TUBE_CORAL_FAN)
                .add(Blocks.DEAD_HORN_CORAL_FAN)
                .add(Blocks.DEAD_BRAIN_CORAL_WALL_FAN)
                .add(Blocks.DEAD_FIRE_CORAL_WALL_FAN)
                .add(Blocks.DEAD_BUBBLE_CORAL_WALL_FAN)
                .add(Blocks.DEAD_TUBE_CORAL_WALL_FAN)
                .add(Blocks.DEAD_HORN_CORAL_WALL_FAN)
        ;

        getOrCreateTagBuilder(MaLiLibTag.Blocks.LEAVES_FIX)
                .add(Blocks.ACACIA_LEAVES)
                .add(Blocks.BIRCH_LEAVES)
                .add(Blocks.CHERRY_LEAVES)
                .add(Blocks.DARK_OAK_LEAVES)
                .add(Blocks.JUNGLE_LEAVES)
                .add(Blocks.MANGROVE_LEAVES)
                .add(Blocks.OAK_LEAVES)
                .add(Blocks.PALE_OAK_LEAVES)
                .add(Blocks.SPRUCE_LEAVES)
        ;

        getOrCreateTagBuilder(MaLiLibTag.Blocks.WOOL_BLOCKS_FIX)
                .add(Blocks.BLACK_WOOL)
                .add(Blocks.BLUE_WOOL)
                .add(Blocks.BROWN_WOOL)
                .add(Blocks.CYAN_WOOL)
                .add(Blocks.GRAY_WOOL)
                .add(Blocks.GREEN_WOOL)
                .add(Blocks.LIGHT_BLUE_WOOL)
                .add(Blocks.LIGHT_GRAY_WOOL)
                .add(Blocks.LIME_WOOL)
                .add(Blocks.MAGENTA_WOOL)
                .add(Blocks.ORANGE_WOOL)
                .add(Blocks.PINK_WOOL)
                .add(Blocks.PURPLE_WOOL)
                .add(Blocks.RED_WOOL)
                .add(Blocks.YELLOW_WOOL)
                .add(Blocks.WHITE_WOOL)
        ;

        getOrCreateTagBuilder(MaLiLibTag.Blocks.NEEDS_SILK_TOUCH)
                .addTag(MaLiLibTag.Blocks.GLASS_BLOCKS)
                .addTag(MaLiLibTag.Blocks.GLASS_PANES)
                .addTag(MaLiLibTag.Blocks.CORAL_FANS_FIX)
                .addTag(MaLiLibTag.Blocks.LEAVES_FIX)
                .add(Blocks.ENDER_CHEST)
                // todo 1.21.5+
                //.add(Blocks.BUSH)
        ;

        getOrCreateTagBuilder(MaLiLibTag.Blocks.NEEDS_SHEARS)
                .addTag(MaLiLibTag.Blocks.LEAVES_FIX)
                .addTag(MaLiLibTag.Blocks.WOOL_BLOCKS_FIX)
                .add(Blocks.CAVE_VINES)
                .add(Blocks.CAVE_VINES_PLANT)
                .add(Blocks.COBWEB)
                .add(Blocks.DEAD_BUSH)
                .add(Blocks.FERN)
                .add(Blocks.GLOW_LICHEN)
                .add(Blocks.HANGING_ROOTS)
                .add(Blocks.LARGE_FERN)
                .add(Blocks.NETHER_SPROUTS)
                .add(Blocks.PALE_HANGING_MOSS)
                .add(Blocks.SHORT_GRASS)
                // todo 1.21.5+
                //.add(Blocks.SHORT_DRY_GRASS)
                .add(Blocks.SEAGRASS)
                .add(Blocks.TALL_GRASS)
                // todo 1.21.5+
                //.add(Blocks.TALL_DRY_GRASS)
                .add(Blocks.TALL_SEAGRASS)
                .add(Blocks.TRIPWIRE)
                .add(Blocks.TWISTING_VINES)
                .add(Blocks.TWISTING_VINES_PLANT)
                .add(Blocks.WEEPING_VINES)
                .add(Blocks.WEEPING_VINES_PLANT)
                .add(Blocks.VINE)
        ;

        getOrCreateTagBuilder(MaLiLibTag.Blocks.GRAVITY_BLOCKS)
                .addTag(MaLiLibTag.Blocks.CONCRETE_POWDER_FIX)
                .add(Blocks.ANVIL)
                .add(Blocks.CHIPPED_ANVIL)
                .add(Blocks.DAMAGED_ANVIL)
                .add(Blocks.SAND)
                .add(Blocks.RED_SAND)
                .add(Blocks.GRAVEL)
                .add(Blocks.SUSPICIOUS_GRAVEL)
                .add(Blocks.SUSPICIOUS_SAND)
                .add(Blocks.POINTED_DRIPSTONE)
                .add(Blocks.SCAFFOLDING)
                .add(Blocks.DRAGON_EGG)
        ;

        getOrCreateTagBuilder(MaLiLibTag.Blocks.IMMOVABLE_BLOCKS)
                .addTag(MaLiLibTag.Blocks.ALL_SIGNS_FIX)
                .addTag(MaLiLibTag.Blocks.ALL_BANNERS_FIX)
                .add(Blocks.BARRIER)
                .add(Blocks.BARREL)
                .add(Blocks.BEACON)
                .add(Blocks.BEDROCK)
                .add(Blocks.BEEHIVE)
                .add(Blocks.BEE_NEST)
                .add(Blocks.BLAST_FURNACE)
                .add(Blocks.BREWING_STAND)
                .add(Blocks.CALIBRATED_SCULK_SENSOR)
                .add(Blocks.CAMPFIRE)
                .add(Blocks.CHEST)
                .add(Blocks.CHISELED_BOOKSHELF)
                .add(Blocks.COMMAND_BLOCK)
                .add(Blocks.CONDUIT)
                .add(Blocks.CRAFTER)
                .add(Blocks.CRYING_OBSIDIAN)
                .add(Blocks.DAYLIGHT_DETECTOR)
                .add(Blocks.DISPENSER)
                .add(Blocks.DROPPER)
                .add(Blocks.ENCHANTING_TABLE)
                .add(Blocks.END_GATEWAY)
                .add(Blocks.END_PORTAL)
                .add(Blocks.END_PORTAL_FRAME)
                .add(Blocks.ENDER_CHEST)
                .add(Blocks.FURNACE)
                .add(Blocks.GRINDSTONE)
                .add(Blocks.HOPPER)
                .add(Blocks.JIGSAW)
                .add(Blocks.JUKEBOX)
                .add(Blocks.LECTERN)
                .add(Blocks.LIGHT)
                .add(Blocks.LODESTONE)
                .add(Blocks.MOVING_PISTON)
                .add(Blocks.NETHER_PORTAL)
                .add(Blocks.OBSIDIAN)
                .add(Blocks.PISTON_HEAD)
                .add(Blocks.REINFORCED_DEEPSLATE)
                .add(Blocks.RESPAWN_ANCHOR)
                .add(Blocks.SCULK_CATALYST)
                .add(Blocks.SCULK_SENSOR)
                .add(Blocks.SCULK_SHRIEKER)
                .add(Blocks.SMOKER)
                .add(Blocks.SOUL_CAMPFIRE)
                .add(Blocks.SPAWNER)
                .add(Blocks.STRUCTURE_BLOCK)
                .add(Blocks.STRUCTURE_VOID)
                .add(Blocks.TRAPPED_CHEST)
                .add(Blocks.TRIAL_SPAWNER)
                .add(Blocks.VAULT)
        ;
    }
}
