/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config;

import com.mojang.serialization.Codec;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.config.options.ConfigColorList;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigFloat;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigString;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public enum ConfigType implements StringRepresentable
{
    BOOLEAN("boolean", ConfigBoolean.CODEC),
    INTEGER("integer", ConfigInteger.CODEC),
    DOUBLE("double", ConfigDouble.CODEC),
    FLOAT("float", ConfigFloat.CODEC),
    COLOR("color", ConfigColor.CODEC),
    STRING("string", ConfigString.CODEC),
    STRING_LIST("string_list", ConfigString.CODEC),
    LOCKED_LIST("locked_list", null),
    COLOR_LIST("color_list", ConfigColorList.CODEC),
    OPTION_LIST("option_list", null),
    HOTKEY("hotkey", ConfigHotkey.CODEC);

    public static final StringRepresentable.EnumCodec<ConfigType> CODEC;
    public static final StreamCodec<ByteBuf, ConfigType> PACKET_CODEC;
    private final String name;
    private final Codec<? extends IConfigBase> codec;

    private ConfigType(String name, Codec<? extends IConfigBase> codec) {
        this.name = name;
        this.codec = codec;
    }

    @Nonnull
    public String getSerializedName() {
        return this.name;
    }

    @Nullable
    public Codec<? extends IConfigBase> codec() {
        return this.codec;
    }

    public static ConfigType fromString(String entry) {
        for (ConfigType type : ConfigType.values()) {
            if (!type.name().equalsIgnoreCase(entry)) continue;
            return type;
        }
        return null;
    }

    static {
        CODEC = StringRepresentable.fromEnum(ConfigType::values);
        PACKET_CODEC = ByteBufCodecs.STRING_UTF8.map(ConfigType::fromString, ConfigType::getSerializedName);
    }
}

