/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.data.CachedTagKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.tuple.Pair;

public class CachedItemTags {
    private static final CachedItemTags INSTANCE = new CachedItemTags();
    private final HashMap<CachedTagKey, Entry> entries = new HashMap();

    public static CachedItemTags getInstance() {
        return INSTANCE;
    }

    private CachedItemTags() {
    }

    public void build(CachedTagKey key, @Nonnull List<String> list) {
        if (list.isEmpty()) {
            MaLiLib.LOGGER.warn("CachedItemTags#build: list '{}' is empty.", (Object)key.toString());
            return;
        }
        Entry entry = new Entry(list);
        Entry oldEntry = this.entries.put(key, entry);
        if (oldEntry != null) {
            oldEntry.clear();
        }
        MaLiLib.debugLog("CachedItemTags#build: New tag list: '{}'", key.toString());
    }

    @Nullable
    public Entry get(CachedTagKey key) {
        if (this.entries.containsKey(key)) {
            return this.entries.get(key);
        }
        return null;
    }

    public void clearEntry(CachedTagKey key) {
        if (this.entries.containsKey(key)) {
            this.entries.get(key).clear();
            MaLiLib.debugLog("CachedItemTags#clearEntry: Clear tag list Entry: '{}'", key.toString());
        }
    }

    public void clear() {
        this.entries.forEach((key, entry) -> entry.clear());
        MaLiLib.debugLog("CachedItemTags#clear: Clear all", new Object[0]);
    }

    public List<CachedTagKey> matchAny(Item item) {
        ArrayList<CachedTagKey> list = new ArrayList<CachedTagKey>();
        this.entries.forEach((key, entry) -> {
            if (entry.contains(item)) {
                list.add((CachedTagKey)key);
            }
        });
        return list;
    }

    public List<CachedTagKey> matchAny(Holder<Item> item) {
        ArrayList<CachedTagKey> list = new ArrayList<CachedTagKey>();
        this.entries.forEach((key, entry) -> {
            if (entry.contains(item)) {
                list.add((CachedTagKey)key);
            }
        });
        return list;
    }

    public boolean match(CachedTagKey key, Item item) {
        Entry entry = this.get(key);
        if (entry != null) {
            return entry.contains(item);
        }
        MaLiLib.LOGGER.warn("CachedItemTags#match(Item): Invalid tag list '{}'", (Object)key.toString());
        return false;
    }

    public boolean match(CachedTagKey key, Holder<Item> item) {
        Entry entry = this.get(key);
        if (entry != null) {
            return entry.contains(item);
        }
        MaLiLib.LOGGER.warn("CachedItemTags#match(RegistryEntry): Invalid tag list '{}'", (Object)key.toString());
        return false;
    }

    public Optional<Pair<HolderSet<Item>, Holder<Item>>> matchPair(CachedTagKey key, Item item) {
        Entry entry = this.get(key);
        if (entry != null) {
            Pair<HolderSet<Item>, Holder<Item>> pair = entry.matchPair(item);
            if (pair.getLeft() == null && pair.getRight() == null) {
                return Optional.empty();
            }
            return Optional.of(pair);
        }
        MaLiLib.LOGGER.warn("CachedItemTags#matchPair(Item): Invalid tag list '{}'", (Object)key.toString());
        return Optional.empty();
    }

    public Optional<Pair<HolderSet<Item>, Holder<Item>>> matchPair(CachedTagKey key, Holder<Item> item) {
        Entry entry = this.get(key);
        if (entry != null) {
            Pair<HolderSet<Item>, Holder<Item>> pair = entry.matchPair(item);
            if (pair.getLeft() == null && pair.getRight() == null) {
                return Optional.empty();
            }
            return Optional.of(pair);
        }
        MaLiLib.LOGGER.warn("CachedItemTags#matchPair(RegistryEntry): Invalid tag list '{}'", (Object)key.toString());
        return Optional.empty();
    }

    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        this.entries.forEach((key, entry) -> obj.add(key.toString(), entry.toJson()));
        return obj;
    }

    public void fromJson(JsonObject obj) {
        this.entries.clear();
        for (String key : obj.keySet()) {
            if (!obj.isJsonArray()) continue;
            Entry entry = Entry.fromJson(obj.get(key));
            CachedTagKey tagKey = CachedTagKey.fromString(key);
            if (entry == null) continue;
            this.entries.put(tagKey, entry);
        }
    }

    public static class Entry {
        private final HashSet<Holder<Item>> items = new HashSet();
        private final HashSet<HolderSet<Item>> tags = new HashSet();

        public Entry() {
        }

        public Entry(List<String> list) {
            this();
            this.insertFromList(list);
        }

        public void insertItem(Item item) {
            this.items.add((Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)item));
        }

        public void insertItem(Holder<Item> item) {
            this.items.add(item);
        }

        public void insertTag(TagKey<Item> tag) {
            if (Minecraft.getInstance().level != null) {
                Registry wrapper = Minecraft.getInstance().level.registryAccess().lookupOrThrow(BuiltInRegistries.ITEM.key());
                wrapper.get(tag).ifPresent(this.tags::add);
            }
        }

        public void insertFromString(String entry) {
            if (entry.startsWith("#")) {
                ResourceLocation id = ResourceLocation.tryParse((String)entry.substring(1));
                if (id != null) {
                    TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id);
                    if (tag != null) {
                        this.insertTag((TagKey<Item>)tag);
                    } else {
                        MaLiLib.LOGGER.warn("CachedItemTags.Entry#insertFromString: Invalid block tag '{}'", (Object)entry);
                    }
                } else {
                    MaLiLib.LOGGER.warn("CachedItemTags.Entry#insertFromString: Invalid block tag id '{}'", (Object)entry);
                }
            } else {
                ResourceLocation id = ResourceLocation.tryParse((String)entry);
                if (id != null) {
                    Item item = (Item)BuiltInRegistries.ITEM.getValue(id);
                    if (item != null) {
                        this.insertItem(item);
                    } else {
                        MaLiLib.LOGGER.warn("CachedItemTags.Entry#insertFromString: Invalid block '{}'", (Object)entry);
                    }
                } else {
                    MaLiLib.LOGGER.warn("CachedItemTags.Entry#insertFromString: Invalid block id '{}'", (Object)entry);
                }
            }
        }

        public void insertFromList(List<String> list) {
            if (list.isEmpty()) {
                MaLiLib.LOGGER.warn("CachedItemTags.Entry#insertFromList: List is empty.");
                return;
            }
            for (String entry : list) {
                this.insertFromString(entry);
            }
        }

        public boolean contains(Item item) {
            Holder entry = BuiltInRegistries.ITEM.wrapAsHolder((Object)item);
            for (HolderSet<Item> listEntry : this.tags) {
                if (!listEntry.contains(entry)) continue;
                return true;
            }
            return this.items.contains(entry);
        }

        public boolean contains(Holder<Item> item) {
            return this.contains((Item)item.value());
        }

        public List<String> toList() {
            ArrayList<String> list = new ArrayList<String>();
            this.items.forEach(entry -> list.add(entry.getRegisteredName()));
            this.tags.forEach(entry -> list.add("#" + entry.unwrapKey().toString()));
            return list;
        }

        public Pair<HolderSet<Item>, Holder<Item>> matchPair(Holder<Item> entry) {
            for (HolderSet<Item> listEntry : this.tags) {
                if (!listEntry.contains(entry)) continue;
                return Pair.of(listEntry, null);
            }
            if (this.items.contains(entry)) {
                return Pair.of(null, entry);
            }
            return Pair.of(null, null);
        }

        public Pair<HolderSet<Item>, Holder<Item>> matchPair(Item item) {
            return this.matchPair((Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)item));
        }

        public JsonElement toJson() {
            JsonArray arr = new JsonArray();
            this.items.forEach(entry -> arr.add((JsonElement)new JsonPrimitive(entry.getRegisteredName())));
            this.tags.forEach(entry -> arr.add((JsonElement)new JsonPrimitive("#" + entry.unwrapKey().toString())));
            return arr;
        }

        @Nullable
        public static Entry fromJson(JsonElement element) {
            if (element.isJsonArray()) {
                JsonArray arr = element.getAsJsonArray();
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < arr.size(); ++i) {
                    list.add(arr.get(i).getAsString());
                }
                Entry entry = new Entry();
                entry.insertFromList(list);
                return entry;
            }
            return null;
        }

        public void clear() {
            this.items.clear();
            this.tags.clear();
        }
    }
}

