/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.data;

import fi.dy.masa.malilib.data.CachedBlockTags;
import fi.dy.masa.malilib.data.CachedItemTags;
import fi.dy.masa.malilib.data.CachedTagKey;
import fi.dy.masa.malilib.data.CachedTagManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class CachedTagUtils {
    public static boolean matchBlockTag(CachedTagKey key, Holder<Block> block) {
        return CachedBlockTags.getInstance().match(key, block);
    }

    public static boolean matchBlockTag(CachedTagKey key, Block block) {
        return CachedBlockTags.getInstance().match(key, block);
    }

    public static boolean matchBlockTag(CachedTagKey key, BlockState state) {
        return CachedBlockTags.getInstance().match(key, state);
    }

    public static boolean matchItemTag(CachedTagKey key, Holder<Item> item) {
        return CachedItemTags.getInstance().match(key, item);
    }

    public static boolean matchItemTag(CachedTagKey key, Item item) {
        return CachedItemTags.getInstance().match(key, item);
    }

    public static boolean matchBlockTagMulti(List<CachedTagKey> keys, Holder<Block> block) {
        for (CachedTagKey key : keys) {
            if (!CachedBlockTags.getInstance().match(key, block)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchBlockTagMulti(List<CachedTagKey> keys, Block block) {
        for (CachedTagKey key : keys) {
            if (!CachedBlockTags.getInstance().match(key, block)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchBlockTagMulti(List<CachedTagKey> keys, BlockState state) {
        for (CachedTagKey key : keys) {
            if (!CachedBlockTags.getInstance().match(key, state)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchItemTagMulti(List<CachedTagKey> keys, Holder<Item> item) {
        for (CachedTagKey key : keys) {
            if (!CachedItemTags.getInstance().match(key, item)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchItemTagMulti(List<CachedTagKey> keys, Item item) {
        for (CachedTagKey key : keys) {
            if (!CachedItemTags.getInstance().match(key, item)) continue;
            return true;
        }
        return false;
    }

    public static Pair<HolderSet<Block>, Holder<Block>> matchReplaceableBlockTag(Holder<Block> block) {
        Optional<Pair<HolderSet<Block>, Holder<Block>>> pair = CachedBlockTags.getInstance().matchPair(CachedTagManager.REPLACEABLE_BLOCKS_KEY, block);
        if (pair.isPresent()) {
            return pair.get();
        }
        pair = CachedBlockTags.getInstance().matchPair(CachedTagManager.CONCRETE_BLOCKS_KEY, block);
        if (pair.isPresent()) {
            return pair.get();
        }
        pair = CachedBlockTags.getInstance().matchPair(CachedTagManager.CORAL_FANS_KEY, block);
        if (pair.isPresent()) {
            return pair.get();
        }
        pair = CachedBlockTags.getInstance().matchPair(CachedTagManager.GLASS_PANES_KEY, block);
        if (pair.isPresent()) {
            return pair.get();
        }
        pair = CachedBlockTags.getInstance().matchPair(CachedTagManager.GLAZED_TERRACOTTA_BLOCKS_KEY, block);
        return pair.orElseGet(() -> Pair.of(null, null));
    }

    public static Pair<HolderSet<Block>, Holder<Block>> matchReplaceableBlockTag(Block block) {
        Optional<Pair<HolderSet<Block>, Holder<Block>>> pair = CachedBlockTags.getInstance().matchPair(CachedTagManager.REPLACEABLE_BLOCKS_KEY, block);
        if (pair.isPresent()) {
            return pair.get();
        }
        pair = CachedBlockTags.getInstance().matchPair(CachedTagManager.CONCRETE_BLOCKS_KEY, block);
        if (pair.isPresent()) {
            return pair.get();
        }
        pair = CachedBlockTags.getInstance().matchPair(CachedTagManager.CORAL_FANS_KEY, block);
        if (pair.isPresent()) {
            return pair.get();
        }
        pair = CachedBlockTags.getInstance().matchPair(CachedTagManager.GLASS_PANES_KEY, block);
        if (pair.isPresent()) {
            return pair.get();
        }
        pair = CachedBlockTags.getInstance().matchPair(CachedTagManager.GLAZED_TERRACOTTA_BLOCKS_KEY, block);
        return pair.orElseGet(() -> Pair.of(null, null));
    }

    public static Pair<HolderSet<Block>, Holder<Block>> matchReplaceableBlockTag(BlockState state) {
        Optional<Pair<HolderSet<Block>, Holder<Block>>> pair = CachedBlockTags.getInstance().matchPair(CachedTagManager.REPLACEABLE_BLOCKS_KEY, state);
        if (pair.isPresent()) {
            return pair.get();
        }
        pair = CachedBlockTags.getInstance().matchPair(CachedTagManager.CONCRETE_BLOCKS_KEY, state);
        if (pair.isPresent()) {
            return pair.get();
        }
        pair = CachedBlockTags.getInstance().matchPair(CachedTagManager.CORAL_FANS_KEY, state);
        if (pair.isPresent()) {
            return pair.get();
        }
        pair = CachedBlockTags.getInstance().matchPair(CachedTagManager.GLASS_PANES_KEY, state);
        if (pair.isPresent()) {
            return pair.get();
        }
        pair = CachedBlockTags.getInstance().matchPair(CachedTagManager.GLAZED_TERRACOTTA_BLOCKS_KEY, state);
        return pair.orElseGet(() -> Pair.of(null, null));
    }
}

