/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.wrappers;

import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;

public class TextFieldWrapper<T extends GuiTextFieldGeneric> {
    private final T textField;
    private final ITextFieldListener<T> listener;

    public TextFieldWrapper(T textField, ITextFieldListener<T> listener) {
        this.textField = textField;
        this.listener = listener;
    }

    public T getTextField() {
        return this.textField;
    }

    public ITextFieldListener<T> getListener() {
        return this.listener;
    }

    public boolean isFocused() {
        return this.textField.isFocused();
    }

    public void setFocused(boolean isFocused) {
        this.textField.setFocused(isFocused);
    }

    public void onGuiClosed() {
        if (this.listener != null) {
            this.listener.onGuiClosed(this.textField);
        }
    }

    public void draw(GuiGraphics drawContext, int mouseX, int mouseY) {
        this.textField.render(drawContext, mouseX, mouseY, 0.0f);
    }

    public boolean mouseClicked(MouseButtonEvent click, boolean doubleClick) {
        if (((GuiTextFieldGeneric)((Object)this.textField)).mouseClicked(click, doubleClick)) {
            return true;
        }
        if (!this.textField.isMouseOver(click.x(), click.y())) {
            this.textField.setFocused(false);
        }
        return false;
    }

    public boolean onKeyTyped(KeyEvent input) {
        String textPre = this.textField.getValue();
        if (this.textField.isFocused() && this.textField.keyPressed(input)) {
            if (!(this.listener == null || input.key() != 257 && input.key() != 258 && this.textField.getValue().equals(textPre))) {
                this.listener.onTextChange(this.textField);
            }
            return true;
        }
        return false;
    }

    public boolean onCharTyped(CharacterEvent input) {
        String textPre = this.textField.getValue();
        if (this.textField.isFocused() && this.textField.charTyped(input)) {
            if (this.listener != null && !this.textField.getValue().equals(textPre)) {
                this.listener.onTextChange(this.textField);
            }
            return true;
        }
        return false;
    }
}

